/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.components.border.JETALineBorder;
import com.jeta.forms.store.properties.BorderProperty;
import com.jeta.forms.store.properties.ColorProperty;
import com.jeta.forms.store.properties.ColorProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.border.Border;

public class LineBorderProperty
extends BorderProperty
implements Externalizable {
    static final long serialVersionUID = -2679973957505795245L;
    private static final int VERSION = 3;
    private int m_line_thickness = 1;
    private ColorProperty m_line_color = new ColorProperty(Color.black);
    private boolean m_curved = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Border createBorder(Component component) {
        JETALineBorder jETALineBorder = new JETALineBorder(new ColorProxy(this.m_line_color), this.getLineThickness(), this.isCurved(), this.isTopPainted(), this.isLeftPainted(), this.isBottomPainted(), this.isRightPainted());
        return this.createTitle(jETALineBorder);
    }

    public int getLineThickness() {
        return this.m_line_thickness;
    }

    public Color getLineColor() {
        return this.m_line_color.getColor();
    }

    public ColorProperty getLineColorProperty() {
        return this.m_line_color;
    }

    public boolean isCurved() {
        return this.m_curved;
    }

    public void setCurved(boolean bl) {
        this.m_curved = bl;
    }

    public void setLineThickness(int n) {
        this.m_line_thickness = n;
    }

    public void setLineColorProperty(ColorProperty colorProperty) {
        this.m_line_color = colorProperty;
    }

    public void setValue(Object object) {
        super.setValue(object);
        if (object instanceof LineBorderProperty) {
            LineBorderProperty lineBorderProperty = (LineBorderProperty)object;
            this.m_line_color.setValue(lineBorderProperty.m_line_color);
            this.m_line_thickness = lineBorderProperty.m_line_thickness;
            this.m_curved = lineBorderProperty.m_curved;
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_line_thickness = objectInput.readInt();
        Object object = objectInput.readObject();
        if (n > 1) {
            this.m_curved = objectInput.readBoolean();
        }
        this.m_line_color = object instanceof Color ? new ColorProperty((Color)object) : (ColorProperty)object;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(3);
        objectOutput.writeInt(this.m_line_thickness);
        objectOutput.writeObject(this.m_line_color);
        objectOutput.writeBoolean(this.m_curved);
    }

    public String toString() {
        return "LINE";
    }

    static {
        $assertionsDisabled = !LineBorderProperty.class.desiredAssertionStatus();
    }
}

