/* AVB support */
/* SPDX-FileCopyrightText: Copyright © 2022 Wim Taymans */
/* SPDX-FileCopyrightText: Copyright © 2025 Kebag-Logic */
/* SPDX-FileCopyrightText: Copyright © 2025 Alex Malki <alexandre.malki@kebag-logic.com> */
/* SPDX-FileCopyrightText: Copyright © 2025 Simon Gapp <simon.gapp@kebag-logic.com> */
/* SPDX-License-Identifier: MIT  */

#ifndef __AVB_AECP_AEM_TYPES_H__
#define __AVB_AECP_AEM_TYPES_H__

/*
* IEEE 1722.1-2021, Table 7-141 - status field
*/
#define AVB_AECP_AEM_STATUS_SUCCESS			0
#define AVB_AECP_AEM_STATUS_NOT_IMPLEMENTED		1
#define AVB_AECP_AEM_STATUS_NO_SUCH_DESCRIPTOR		2
#define AVB_AECP_AEM_STATUS_ENTITY_LOCKED		3
#define AVB_AECP_AEM_STATUS_ENTITY_ACQUIRED		4
#define AVB_AECP_AEM_STATUS_NOT_AUTHENTICATED		5
#define AVB_AECP_AEM_STATUS_AUTHENTICATION_DISABLED	6
#define AVB_AECP_AEM_STATUS_BAD_ARGUMENTS		7
#define AVB_AECP_AEM_STATUS_NO_RESOURCES		8
#define AVB_AECP_AEM_STATUS_IN_PROGRESS			9
#define AVB_AECP_AEM_STATUS_ENTITY_MISBEHAVING		10
#define AVB_AECP_AEM_STATUS_NOT_SUPPORTED		11
#define AVB_AECP_AEM_STATUS_STREAM_IS_RUNNING		12

#define AECP_AEM_STRLEN_MAX                     (64)

/** IEEE 1722.1-2021, Table 7-140 - Command Codes */
// TODO: Update me
#define AVB_AECP_AEM_CMD_ACQUIRE_ENTITY				0x0000
#define AVB_AECP_AEM_CMD_LOCK_ENTITY				0x0001
#define AVB_AECP_AEM_CMD_ENTITY_AVAILABLE			0x0002
#define AVB_AECP_AEM_CMD_CONTROLLER_AVAILABLE			0x0003
#define AVB_AECP_AEM_CMD_READ_DESCRIPTOR			0x0004
#define AVB_AECP_AEM_CMD_WRITE_DESCRIPTOR			0x0005
#define AVB_AECP_AEM_CMD_SET_CONFIGURATION			0x0006
#define AVB_AECP_AEM_CMD_GET_CONFIGURATION			0x0007
#define AVB_AECP_AEM_CMD_SET_STREAM_FORMAT			0x0008
#define AVB_AECP_AEM_CMD_GET_STREAM_FORMAT			0x0009
#define AVB_AECP_AEM_CMD_SET_VIDEO_FORMAT			0x000a
#define AVB_AECP_AEM_CMD_GET_VIDEO_FORMAT			0x000b
#define AVB_AECP_AEM_CMD_SET_SENSOR_FORMAT			0x000c
#define AVB_AECP_AEM_CMD_GET_SENSOR_FORMAT			0x000d
#define AVB_AECP_AEM_CMD_SET_STREAM_INFO			0x000e
#define AVB_AECP_AEM_CMD_GET_STREAM_INFO			0x000f
#define AVB_AECP_AEM_CMD_SET_NAME				0x0010
#define AVB_AECP_AEM_CMD_GET_NAME				0x0011
#define AVB_AECP_AEM_CMD_SET_ASSOCIATION_ID			0x0012
#define AVB_AECP_AEM_CMD_GET_ASSOCIATION_ID			0x0013
#define AVB_AECP_AEM_CMD_SET_SAMPLING_RATE			0x0014
#define AVB_AECP_AEM_CMD_GET_SAMPLING_RATE			0x0015
#define AVB_AECP_AEM_CMD_SET_CLOCK_SOURCE			0x0016
#define AVB_AECP_AEM_CMD_GET_CLOCK_SOURCE			0x0017
#define AVB_AECP_AEM_CMD_SET_CONTROL				0x0018
#define AVB_AECP_AEM_CMD_GET_CONTROL				0x0019
#define AVB_AECP_AEM_CMD_INCREMENT_CONTROL			0x001a
#define AVB_AECP_AEM_CMD_DECREMENT_CONTROL			0x001b
#define AVB_AECP_AEM_CMD_SET_SIGNAL_SELECTOR			0x001c
#define AVB_AECP_AEM_CMD_GET_SIGNAL_SELECTOR			0x001d
#define AVB_AECP_AEM_CMD_SET_MIXER				0x001e
#define AVB_AECP_AEM_CMD_GET_MIXER				0x001f
#define AVB_AECP_AEM_CMD_SET_MATRIX				0x0020
#define AVB_AECP_AEM_CMD_GET_MATRIX				0x0021
#define AVB_AECP_AEM_CMD_START_STREAMING			0x0022
#define AVB_AECP_AEM_CMD_STOP_STREAMING				0x0023
#define AVB_AECP_AEM_CMD_REGISTER_UNSOLICITED_NOTIFICATION	0x0024
#define AVB_AECP_AEM_CMD_DEREGISTER_UNSOLICITED_NOTIFICATION	0x0025
#define AVB_AECP_AEM_CMD_IDENTIFY_NOTIFICATION			0x0026
#define AVB_AECP_AEM_CMD_GET_AVB_INFO				0x0027
#define AVB_AECP_AEM_CMD_GET_AS_PATH				0x0028
#define AVB_AECP_AEM_CMD_GET_COUNTERS				0x0029
#define AVB_AECP_AEM_CMD_REBOOT					0x002a
#define AVB_AECP_AEM_CMD_GET_AUDIO_MAP				0x002b
#define AVB_AECP_AEM_CMD_ADD_AUDIO_MAPPINGS			0x002c
#define AVB_AECP_AEM_CMD_REMOVE_AUDIO_MAPPINGS			0x002d
#define AVB_AECP_AEM_CMD_GET_VIDEO_MAP				0x002e
#define AVB_AECP_AEM_CMD_ADD_VIDEO_MAPPINGS			0x002f
#define AVB_AECP_AEM_CMD_REMOVE_VIDEO_MAPPINGS			0x0030
#define AVB_AECP_AEM_CMD_GET_SENSOR_MAP				0x0031
#define AVB_AECP_AEM_CMD_ADD_SENSOR_MAPPINGS			0x0032
#define AVB_AECP_AEM_CMD_REMOVE_SENSOR_MAPPINGS			0x0033
#define AVB_AECP_AEM_CMD_START_OPERATION			0x0034
#define AVB_AECP_AEM_CMD_ABORT_OPERATION			0x0035
#define AVB_AECP_AEM_CMD_OPERATION_STATUS			0x0036
#define AVB_AECP_AEM_CMD_AUTH_ADD_KEY				0x0037
#define AVB_AECP_AEM_CMD_AUTH_DELETE_KEY			0x0038
#define AVB_AECP_AEM_CMD_AUTH_GET_KEY_LIST			0x0039
#define AVB_AECP_AEM_CMD_AUTH_GET_KEY				0x003a
#define AVB_AECP_AEM_CMD_AUTH_ADD_KEY_TO_CHAIN			0x003b
#define AVB_AECP_AEM_CMD_AUTH_DELETE_KEY_FROM_CHAIN		0x003c
#define AVB_AECP_AEM_CMD_AUTH_GET_KEYCHAIN_LIST			0x003d
#define AVB_AECP_AEM_CMD_AUTH_GET_IDENTITY			0x003e
#define AVB_AECP_AEM_CMD_AUTH_ADD_TOKEN				0x003f
#define AVB_AECP_AEM_CMD_AUTH_DELETE_TOKEN			0x0040
#define AVB_AECP_AEM_CMD_AUTHENTICATE				0x0041
#define AVB_AECP_AEM_CMD_DEAUTHENTICATE				0x0042
#define AVB_AECP_AEM_CMD_ENABLE_TRANSPORT_SECURITY		0x0043
#define AVB_AECP_AEM_CMD_DISABLE_TRANSPORT_SECURITY		0x0044
#define AVB_AECP_AEM_CMD_ENABLE_STREAM_ENCRYPTION		0x0045
#define AVB_AECP_AEM_CMD_DISABLE_STREAM_ENCRYPTION		0x0046
#define AVB_AECP_AEM_CMD_SET_MEMORY_OBJECT_LENGTH		0x0047
#define AVB_AECP_AEM_CMD_GET_MEMORY_OBJECT_LENGTH		0x0048
#define AVB_AECP_AEM_CMD_SET_STREAM_BACKUP			0x0049
#define AVB_AECP_AEM_CMD_GET_STREAM_BACKUP			0x004a
#define AVB_AECP_AEM_CMD_GET_DYNAMIC_INFO			0x004b
#define AVB_AECP_AEM_CMD_EXPANSION				0x7fff

#define AVB_AEM_ACQUIRE_ENTITY_PERSISTENT_FLAG			(1<<0)

#endif //__AVB_AECP_AEM_TYPES_H__