/* valaerrorcode.c generated by valac, the Vala compiler
 * generated from valaerrorcode.vala, do not modify */

/* valaerrorcode.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ValaErrorCodePrivate {
	ValaExpression* _value;
	ValaConstant* _code;
	gchar* _nick;
};

static gint ValaErrorCode_private_offset;
static gpointer vala_error_code_parent_class = NULL;

static void vala_error_code_set_code (ValaErrorCode* self,
                               ValaConstant* value);
static void vala_error_code_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor);
static void vala_error_code_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor);
static gboolean vala_error_code_real_check (ValaCodeNode* base,
                                     ValaCodeContext* context);
static void vala_error_code_finalize (ValaCodeNode * obj);
static GType vala_error_code_get_type_once (void);

static inline gpointer
vala_error_code_get_instance_private (ValaErrorCode* self)
{
	return G_STRUCT_MEMBER_P (self, ValaErrorCode_private_offset);
}

ValaExpression*
vala_error_code_get_value (ValaErrorCode* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_error_code_set_value (ValaErrorCode* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	_tmp1_ = self->priv->_value;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_value;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

ValaConstant*
vala_error_code_get_code (ValaErrorCode* self)
{
	ValaConstant* result;
	ValaConstant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_code;
	result = _tmp0_;
	return result;
}

static void
vala_error_code_set_code (ValaErrorCode* self,
                          ValaConstant* value)
{
	ValaConstant* _tmp0_;
	ValaConstant* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_code);
	self->priv->_code = _tmp0_;
	_tmp1_ = self->priv->_code;
	if (_tmp1_ != NULL) {
		ValaConstant* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_code;
		_tmp3_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

const gchar*
vala_error_code_get_nick (ValaErrorCode* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nick;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "nick", NULL);
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
		_tmp2_ = self->priv->_nick;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
			_tmp6_ = _tmp5_;
			_tmp7_ = string_replace (_tmp6_, "_", "-");
			_g_free0 (self->priv->_nick);
			self->priv->_nick = _tmp7_;
			_g_free0 (_tmp6_);
		}
	}
	_tmp8_ = self->priv->_nick;
	result = _tmp8_;
	return result;
}

/**
 * Creates a new enum value.
 *
 * @param name enum value name
 * @return     newly created enum value
 */
ValaErrorCode*
vala_error_code_construct (GType object_type,
                           const gchar* name,
                           ValaSourceReference* source_reference,
                           ValaComment* comment)
{
	ValaErrorCode* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaErrorCode*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaErrorCode*
vala_error_code_new (const gchar* name,
                     ValaSourceReference* source_reference,
                     ValaComment* comment)
{
	return vala_error_code_construct (VALA_TYPE_ERROR_CODE, name, source_reference, comment);
}

/**
 * Creates a new enum value with the specified numerical representation.
 *
 * @param name  enum value name
 * @param value numerical representation
 * @return      newly created enum value
 */
ValaErrorCode*
vala_error_code_construct_with_value (GType object_type,
                                      const gchar* name,
                                      ValaExpression* value,
                                      ValaSourceReference* source_reference)
{
	ValaErrorCode* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = (ValaErrorCode*) vala_error_code_construct (object_type, name, source_reference, NULL);
	vala_error_code_set_value (self, value);
	return self;
}

ValaErrorCode*
vala_error_code_new_with_value (const gchar* name,
                                ValaExpression* value,
                                ValaSourceReference* source_reference)
{
	return vala_error_code_construct_with_value (VALA_TYPE_ERROR_CODE, name, value, source_reference);
}

static void
vala_error_code_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor)
{
	ValaErrorCode * self;
	self = (ValaErrorCode*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_error_code (visitor, self);
}

static void
vala_error_code_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor)
{
	ValaErrorCode * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaErrorCode*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_error_code_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_error_code_get_value (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
}

static gboolean
vala_error_code_real_check (ValaCodeNode* base,
                            ValaCodeContext* context)
{
	ValaErrorCode * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaComment* _tmp17_;
	ValaComment* _tmp18_;
	ValaConstant* _tmp19_;
	ValaConstant* _tmp20_;
	ValaConstant* _tmp21_;
	ValaConstant* _tmp22_;
	ValaConstant* _tmp23_;
	ValaConstant* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean result;
	self = (ValaErrorCode*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_error_code_get_value (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_error_code_get_value (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_context_get_analyzer (context);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->int_type;
	_tmp13_ = vala_data_type_copy (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_symbol_get_comment ((ValaSymbol*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_constant_new (_tmp9_, _tmp14_, NULL, _tmp16_, _tmp18_);
	_tmp20_ = _tmp19_;
	vala_error_code_set_code (self, _tmp20_);
	_vala_code_node_unref0 (_tmp20_);
	_vala_code_node_unref0 (_tmp14_);
	_tmp21_ = vala_error_code_get_code (self);
	_tmp22_ = _tmp21_;
	vala_symbol_set_external ((ValaSymbol*) _tmp22_, TRUE);
	_tmp23_ = vala_error_code_get_code (self);
	_tmp24_ = _tmp23_;
	vala_code_node_check ((ValaCodeNode*) _tmp24_, context);
	_tmp25_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp26_ = _tmp25_;
	result = !_tmp26_;
	return result;
}

static void
vala_error_code_class_init (ValaErrorCodeClass * klass,
                            gpointer klass_data)
{
	vala_error_code_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_error_code_finalize;
	g_type_class_adjust_private_offset (klass, &ValaErrorCode_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_error_code_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_error_code_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_error_code_real_check;
}

static void
vala_error_code_instance_init (ValaErrorCode * self,
                               gpointer klass)
{
	self->priv = vala_error_code_get_instance_private (self);
	self->priv->_nick = NULL;
}

static void
vala_error_code_finalize (ValaCodeNode * obj)
{
	ValaErrorCode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ERROR_CODE, ValaErrorCode);
	_vala_code_node_unref0 (self->priv->_value);
	_vala_code_node_unref0 (self->priv->_code);
	_g_free0 (self->priv->_nick);
	VALA_CODE_NODE_CLASS (vala_error_code_parent_class)->finalize (obj);
}

/**
 * Represents an error value member in the source code.
 */
static GType
vala_error_code_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaErrorCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorCode), 0, (GInstanceInitFunc) vala_error_code_instance_init, NULL };
	GType vala_error_code_type_id;
	vala_error_code_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaErrorCode", &g_define_type_info, 0);
	ValaErrorCode_private_offset = g_type_add_instance_private (vala_error_code_type_id, sizeof (ValaErrorCodePrivate));
	return vala_error_code_type_id;
}

GType
vala_error_code_get_type (void)
{
	static volatile gsize vala_error_code_type_id__once = 0;
	if (g_once_init_enter (&vala_error_code_type_id__once)) {
		GType vala_error_code_type_id;
		vala_error_code_type_id = vala_error_code_get_type_once ();
		g_once_init_leave (&vala_error_code_type_id__once, vala_error_code_type_id);
	}
	return vala_error_code_type_id__once;
}

