/* mw.h -- a table of precomputed Mann Whitney coefficients (for bam2bcf.c)

   The MIT License

   Copyright (C) 2016 Genome Research Ltd.

   Author: James Bonfield <jkb@sanger.ac.uk>

   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.
*/

// Code to build this table is below
#ifdef BUILD_MW
#include <stdio.h>

double mann_whitney_1947(int n, int m, int U)
{
    if (U<0) return 0;
    if (n==0||m==0) return U==0 ? 1 : 0;
    return (double)n/(n+m)*mann_whitney_1947(n-1,m,U-m) + (double)m/(n+m)*mann_whitney_1947(n,m-1,U);
}

int main(void) {
    int i, j, k;
    printf("static double mw[6][6][50] = // [2-7][2-7][0-49]\n{\n");
    for (i = 2; i < 8; i++) {
	printf("    {\n");
	for (j = 2; j < 8; j++) {
	    printf("        {\n");
	    for (k = 0; k < 50; k++) {
		printf("            %.17f,\n", mann_whitney_1947(i,j,k));
	    }
	    printf("        },\n");
	}
	printf("    },\n");
    }
    printf("};\n");
    return 0;
}
#endif

static double mw[6][6][50] = // [2-7][2-7][0-49]
{
    {
        {
            0.16666666666666666,
            0.16666666666666666,
            0.33333333333333331,
            0.16666666666666666,
            0.16666666666666666,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.09999999999999999,
            0.09999999999999999,
            0.19999999999999998,
            0.20000000000000001,
            0.20000000000000001,
            0.10000000000000001,
            0.10000000000000001,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.06666666666666665,
            0.06666666666666665,
            0.13333333333333330,
            0.13333333333333333,
            0.20000000000000001,
            0.13333333333333333,
            0.13333333333333333,
            0.06666666666666667,
            0.06666666666666667,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.04761904761904761,
            0.04761904761904761,
            0.09523809523809522,
            0.09523809523809523,
            0.14285714285714288,
            0.14285714285714285,
            0.14285714285714285,
            0.09523809523809523,
            0.09523809523809523,
            0.04761904761904762,
            0.04761904761904762,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.03571428571428571,
            0.03571428571428571,
            0.07142857142857141,
            0.07142857142857142,
            0.10714285714285715,
            0.10714285714285714,
            0.14285714285714285,
            0.10714285714285715,
            0.10714285714285715,
            0.07142857142857144,
            0.07142857142857142,
            0.03571428571428571,
            0.03571428571428571,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.02777777777777777,
            0.02777777777777777,
            0.05555555555555555,
            0.05555555555555555,
            0.08333333333333334,
            0.08333333333333333,
            0.11111111111111110,
            0.11111111111111113,
            0.11111111111111113,
            0.08333333333333334,
            0.08333333333333334,
            0.05555555555555556,
            0.05555555555555555,
            0.02777777777777778,
            0.02777777777777778,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
    },
    {
        {
            0.10000000000000001,
            0.10000000000000001,
            0.20000000000000001,
            0.20000000000000001,
            0.19999999999999998,
            0.09999999999999999,
            0.09999999999999999,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.05000000000000000,
            0.05000000000000000,
            0.10000000000000001,
            0.14999999999999999,
            0.14999999999999999,
            0.14999999999999999,
            0.14999999999999999,
            0.10000000000000001,
            0.05000000000000000,
            0.05000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.02857142857142857,
            0.02857142857142857,
            0.05714285714285714,
            0.08571428571428570,
            0.11428571428571427,
            0.11428571428571427,
            0.14285714285714282,
            0.11428571428571428,
            0.11428571428571428,
            0.08571428571428572,
            0.05714285714285714,
            0.02857142857142857,
            0.02857142857142857,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.01785714285714286,
            0.01785714285714286,
            0.03571428571428571,
            0.05357142857142856,
            0.07142857142857142,
            0.08928571428571427,
            0.10714285714285711,
            0.10714285714285712,
            0.10714285714285714,
            0.10714285714285715,
            0.08928571428571427,
            0.07142857142857142,
            0.05357142857142857,
            0.03571428571428571,
            0.01785714285714286,
            0.01785714285714286,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.01190476190476190,
            0.01190476190476190,
            0.02380952380952381,
            0.03571428571428571,
            0.04761904761904762,
            0.05952380952380951,
            0.08333333333333330,
            0.08333333333333331,
            0.09523809523809523,
            0.09523809523809523,
            0.09523809523809523,
            0.08333333333333333,
            0.08333333333333333,
            0.05952380952380952,
            0.04761904761904762,
            0.03571428571428571,
            0.02380952380952381,
            0.01190476190476190,
            0.01190476190476190,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00833333333333333,
            0.00833333333333333,
            0.01666666666666666,
            0.02499999999999999,
            0.03333333333333333,
            0.04166666666666666,
            0.05833333333333331,
            0.06666666666666665,
            0.07499999999999998,
            0.08333333333333331,
            0.08333333333333331,
            0.08333333333333333,
            0.08333333333333333,
            0.07500000000000000,
            0.06666666666666667,
            0.05833333333333333,
            0.04166666666666666,
            0.03333333333333333,
            0.02500000000000000,
            0.01666666666666667,
            0.00833333333333333,
            0.00833333333333333,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
    },
    {
        {
            0.06666666666666667,
            0.06666666666666667,
            0.13333333333333333,
            0.13333333333333333,
            0.20000000000000001,
            0.13333333333333333,
            0.13333333333333330,
            0.06666666666666665,
            0.06666666666666665,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.02857142857142857,
            0.02857142857142857,
            0.05714285714285714,
            0.08571428571428572,
            0.11428571428571428,
            0.11428571428571428,
            0.14285714285714282,
            0.11428571428571427,
            0.11428571428571427,
            0.08571428571428570,
            0.05714285714285714,
            0.02857142857142857,
            0.02857142857142857,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.01428571428571429,
            0.01428571428571429,
            0.02857142857142857,
            0.04285714285714286,
            0.07142857142857142,
            0.07142857142857142,
            0.09999999999999998,
            0.09999999999999998,
            0.11428571428571427,
            0.09999999999999998,
            0.09999999999999998,
            0.07142857142857142,
            0.07142857142857142,
            0.04285714285714286,
            0.02857142857142857,
            0.01428571428571429,
            0.01428571428571429,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00793650793650794,
            0.00793650793650794,
            0.01587301587301587,
            0.02380952380952381,
            0.03968253968253968,
            0.04761904761904762,
            0.06349206349206349,
            0.07142857142857142,
            0.08730158730158730,
            0.08730158730158730,
            0.09523809523809522,
            0.08730158730158728,
            0.08730158730158730,
            0.07142857142857142,
            0.06349206349206349,
            0.04761904761904761,
            0.03968253968253968,
            0.02380952380952381,
            0.01587301587301587,
            0.00793650793650794,
            0.00793650793650794,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00476190476190476,
            0.00476190476190476,
            0.00952380952380952,
            0.01428571428571429,
            0.02380952380952381,
            0.02857142857142857,
            0.04285714285714286,
            0.04761904761904762,
            0.06190476190476190,
            0.06666666666666665,
            0.07619047619047617,
            0.07619047619047617,
            0.08571428571428569,
            0.07619047619047617,
            0.07619047619047620,
            0.06666666666666667,
            0.06190476190476191,
            0.04761904761904762,
            0.04285714285714286,
            0.02857142857142857,
            0.02380952380952381,
            0.01428571428571429,
            0.00952380952380952,
            0.00476190476190476,
            0.00476190476190476,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00303030303030303,
            0.00303030303030303,
            0.00606060606060606,
            0.00909090909090909,
            0.01515151515151515,
            0.01818181818181818,
            0.02727272727272727,
            0.03333333333333333,
            0.04242424242424242,
            0.04848484848484847,
            0.05757575757575756,
            0.06060606060606059,
            0.06969696969696967,
            0.06969696969696967,
            0.07272727272727272,
            0.06969696969696969,
            0.06969696969696970,
            0.06060606060606059,
            0.05757575757575757,
            0.04848484848484848,
            0.04242424242424242,
            0.03333333333333333,
            0.02727272727272727,
            0.01818181818181818,
            0.01515151515151515,
            0.00909090909090909,
            0.00606060606060606,
            0.00303030303030303,
            0.00303030303030303,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
    },
    {
        {
            0.04761904761904762,
            0.04761904761904762,
            0.09523809523809523,
            0.09523809523809523,
            0.14285714285714285,
            0.14285714285714285,
            0.14285714285714288,
            0.09523809523809523,
            0.09523809523809522,
            0.04761904761904761,
            0.04761904761904761,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.01785714285714286,
            0.01785714285714286,
            0.03571428571428571,
            0.05357142857142857,
            0.07142857142857142,
            0.08928571428571427,
            0.10714285714285715,
            0.10714285714285714,
            0.10714285714285712,
            0.10714285714285711,
            0.08928571428571427,
            0.07142857142857142,
            0.05357142857142856,
            0.03571428571428571,
            0.01785714285714286,
            0.01785714285714286,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00793650793650794,
            0.00793650793650794,
            0.01587301587301587,
            0.02380952380952381,
            0.03968253968253968,
            0.04761904761904761,
            0.06349206349206349,
            0.07142857142857142,
            0.08730158730158730,
            0.08730158730158728,
            0.09523809523809522,
            0.08730158730158730,
            0.08730158730158730,
            0.07142857142857142,
            0.06349206349206349,
            0.04761904761904762,
            0.03968253968253968,
            0.02380952380952381,
            0.01587301587301587,
            0.00793650793650794,
            0.00793650793650794,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00396825396825397,
            0.00396825396825397,
            0.00793650793650794,
            0.01190476190476190,
            0.01984126984126984,
            0.02777777777777777,
            0.03571428571428571,
            0.04365079365079365,
            0.05555555555555555,
            0.06349206349206349,
            0.07142857142857142,
            0.07539682539682539,
            0.07936507936507936,
            0.07936507936507936,
            0.07539682539682539,
            0.07142857142857142,
            0.06349206349206349,
            0.05555555555555555,
            0.04365079365079365,
            0.03571428571428571,
            0.02777777777777777,
            0.01984126984126984,
            0.01190476190476190,
            0.00793650793650794,
            0.00396825396825397,
            0.00396825396825397,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00216450216450216,
            0.00216450216450216,
            0.00432900432900433,
            0.00649350649350649,
            0.01082251082251082,
            0.01515151515151515,
            0.02164502164502164,
            0.02597402597402597,
            0.03463203463203463,
            0.04112554112554112,
            0.04978354978354978,
            0.05411255411255411,
            0.06277056277056275,
            0.06493506493506493,
            0.06926406926406925,
            0.06926406926406925,
            0.06926406926406925,
            0.06493506493506492,
            0.06277056277056275,
            0.05411255411255410,
            0.04978354978354978,
            0.04112554112554112,
            0.03463203463203463,
            0.02597402597402597,
            0.02164502164502164,
            0.01515151515151515,
            0.01082251082251082,
            0.00649350649350649,
            0.00432900432900433,
            0.00216450216450216,
            0.00216450216450216,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00126262626262626,
            0.00126262626262626,
            0.00252525252525253,
            0.00378787878787879,
            0.00631313131313131,
            0.00883838383838384,
            0.01262626262626262,
            0.01641414141414141,
            0.02146464646464646,
            0.02651515151515151,
            0.03282828282828283,
            0.03787878787878787,
            0.04419191919191919,
            0.04924242424242424,
            0.05429292929292929,
            0.05808080808080808,
            0.06060606060606059,
            0.06186868686868686,
            0.06186868686868686,
            0.06060606060606059,
            0.05808080808080807,
            0.05429292929292930,
            0.04924242424242424,
            0.04419191919191920,
            0.03787878787878787,
            0.03282828282828282,
            0.02651515151515152,
            0.02146464646464646,
            0.01641414141414142,
            0.01262626262626263,
            0.00883838383838384,
            0.00631313131313131,
            0.00378787878787879,
            0.00252525252525253,
            0.00126262626262626,
            0.00126262626262626,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
    },
    {
        {
            0.03571428571428571,
            0.03571428571428571,
            0.07142857142857142,
            0.07142857142857144,
            0.10714285714285715,
            0.10714285714285715,
            0.14285714285714285,
            0.10714285714285714,
            0.10714285714285715,
            0.07142857142857142,
            0.07142857142857141,
            0.03571428571428571,
            0.03571428571428571,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.01190476190476190,
            0.01190476190476190,
            0.02380952380952381,
            0.03571428571428571,
            0.04761904761904762,
            0.05952380952380952,
            0.08333333333333333,
            0.08333333333333333,
            0.09523809523809523,
            0.09523809523809523,
            0.09523809523809523,
            0.08333333333333331,
            0.08333333333333330,
            0.05952380952380951,
            0.04761904761904762,
            0.03571428571428571,
            0.02380952380952381,
            0.01190476190476190,
            0.01190476190476190,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00476190476190476,
            0.00476190476190476,
            0.00952380952380952,
            0.01428571428571429,
            0.02380952380952381,
            0.02857142857142857,
            0.04285714285714286,
            0.04761904761904762,
            0.06190476190476191,
            0.06666666666666667,
            0.07619047619047620,
            0.07619047619047617,
            0.08571428571428569,
            0.07619047619047617,
            0.07619047619047617,
            0.06666666666666665,
            0.06190476190476190,
            0.04761904761904762,
            0.04285714285714286,
            0.02857142857142857,
            0.02380952380952381,
            0.01428571428571429,
            0.00952380952380952,
            0.00476190476190476,
            0.00476190476190476,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00216450216450216,
            0.00216450216450216,
            0.00432900432900433,
            0.00649350649350649,
            0.01082251082251082,
            0.01515151515151515,
            0.02164502164502164,
            0.02597402597402597,
            0.03463203463203463,
            0.04112554112554112,
            0.04978354978354978,
            0.05411255411255410,
            0.06277056277056275,
            0.06493506493506492,
            0.06926406926406925,
            0.06926406926406925,
            0.06926406926406925,
            0.06493506493506493,
            0.06277056277056275,
            0.05411255411255411,
            0.04978354978354978,
            0.04112554112554112,
            0.03463203463203463,
            0.02597402597402597,
            0.02164502164502164,
            0.01515151515151515,
            0.01082251082251082,
            0.00649350649350649,
            0.00432900432900433,
            0.00216450216450216,
            0.00216450216450216,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00108225108225108,
            0.00108225108225108,
            0.00216450216450216,
            0.00324675324675325,
            0.00541125541125541,
            0.00757575757575758,
            0.01190476190476190,
            0.01406926406926407,
            0.01948051948051948,
            0.02380952380952381,
            0.03030303030303030,
            0.03463203463203463,
            0.04220779220779219,
            0.04545454545454544,
            0.05194805194805194,
            0.05519480519480519,
            0.05952380952380951,
            0.05952380952380952,
            0.06277056277056275,
            0.05952380952380952,
            0.05952380952380951,
            0.05519480519480519,
            0.05194805194805194,
            0.04545454545454544,
            0.04220779220779219,
            0.03463203463203463,
            0.03030303030303030,
            0.02380952380952381,
            0.01948051948051948,
            0.01406926406926407,
            0.01190476190476190,
            0.00757575757575758,
            0.00541125541125541,
            0.00324675324675325,
            0.00216450216450216,
            0.00108225108225108,
            0.00108225108225108,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00058275058275058,
            0.00058275058275058,
            0.00116550116550117,
            0.00174825174825175,
            0.00291375291375291,
            0.00407925407925408,
            0.00641025641025641,
            0.00815850815850816,
            0.01107226107226107,
            0.01398601398601398,
            0.01806526806526806,
            0.02156177156177156,
            0.02680652680652679,
            0.03030303030303030,
            0.03554778554778554,
            0.03962703962703962,
            0.04428904428904428,
            0.04720279720279720,
            0.05128205128205127,
            0.05244755244755244,
            0.05477855477855477,
            0.05477855477855477,
            0.05477855477855477,
            0.05244755244755243,
            0.05128205128205127,
            0.04720279720279720,
            0.04428904428904428,
            0.03962703962703962,
            0.03554778554778555,
            0.03030303030303030,
            0.02680652680652681,
            0.02156177156177156,
            0.01806526806526806,
            0.01398601398601399,
            0.01107226107226107,
            0.00815850815850816,
            0.00641025641025641,
            0.00407925407925408,
            0.00291375291375291,
            0.00174825174825175,
            0.00116550116550117,
            0.00058275058275058,
            0.00058275058275058,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
    },
    {
        {
            0.02777777777777778,
            0.02777777777777778,
            0.05555555555555555,
            0.05555555555555556,
            0.08333333333333334,
            0.08333333333333334,
            0.11111111111111113,
            0.11111111111111113,
            0.11111111111111110,
            0.08333333333333333,
            0.08333333333333334,
            0.05555555555555555,
            0.05555555555555555,
            0.02777777777777777,
            0.02777777777777777,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00833333333333333,
            0.00833333333333333,
            0.01666666666666667,
            0.02500000000000000,
            0.03333333333333333,
            0.04166666666666666,
            0.05833333333333333,
            0.06666666666666667,
            0.07500000000000000,
            0.08333333333333333,
            0.08333333333333333,
            0.08333333333333331,
            0.08333333333333331,
            0.07499999999999998,
            0.06666666666666665,
            0.05833333333333331,
            0.04166666666666666,
            0.03333333333333333,
            0.02499999999999999,
            0.01666666666666666,
            0.00833333333333333,
            0.00833333333333333,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00303030303030303,
            0.00303030303030303,
            0.00606060606060606,
            0.00909090909090909,
            0.01515151515151515,
            0.01818181818181818,
            0.02727272727272727,
            0.03333333333333333,
            0.04242424242424242,
            0.04848484848484848,
            0.05757575757575757,
            0.06060606060606059,
            0.06969696969696970,
            0.06969696969696969,
            0.07272727272727272,
            0.06969696969696967,
            0.06969696969696967,
            0.06060606060606059,
            0.05757575757575756,
            0.04848484848484847,
            0.04242424242424242,
            0.03333333333333333,
            0.02727272727272727,
            0.01818181818181818,
            0.01515151515151515,
            0.00909090909090909,
            0.00606060606060606,
            0.00303030303030303,
            0.00303030303030303,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00126262626262626,
            0.00126262626262626,
            0.00252525252525253,
            0.00378787878787879,
            0.00631313131313131,
            0.00883838383838384,
            0.01262626262626263,
            0.01641414141414142,
            0.02146464646464646,
            0.02651515151515152,
            0.03282828282828282,
            0.03787878787878787,
            0.04419191919191920,
            0.04924242424242424,
            0.05429292929292930,
            0.05808080808080807,
            0.06060606060606059,
            0.06186868686868686,
            0.06186868686868686,
            0.06060606060606059,
            0.05808080808080808,
            0.05429292929292929,
            0.04924242424242424,
            0.04419191919191919,
            0.03787878787878787,
            0.03282828282828283,
            0.02651515151515151,
            0.02146464646464646,
            0.01641414141414141,
            0.01262626262626262,
            0.00883838383838384,
            0.00631313131313131,
            0.00378787878787879,
            0.00252525252525253,
            0.00126262626262626,
            0.00126262626262626,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00058275058275058,
            0.00058275058275058,
            0.00116550116550117,
            0.00174825174825175,
            0.00291375291375291,
            0.00407925407925408,
            0.00641025641025641,
            0.00815850815850816,
            0.01107226107226107,
            0.01398601398601399,
            0.01806526806526806,
            0.02156177156177156,
            0.02680652680652681,
            0.03030303030303030,
            0.03554778554778555,
            0.03962703962703962,
            0.04428904428904428,
            0.04720279720279720,
            0.05128205128205127,
            0.05244755244755243,
            0.05477855477855477,
            0.05477855477855477,
            0.05477855477855477,
            0.05244755244755244,
            0.05128205128205127,
            0.04720279720279720,
            0.04428904428904428,
            0.03962703962703962,
            0.03554778554778554,
            0.03030303030303030,
            0.02680652680652679,
            0.02156177156177156,
            0.01806526806526806,
            0.01398601398601398,
            0.01107226107226107,
            0.00815850815850816,
            0.00641025641025641,
            0.00407925407925408,
            0.00291375291375291,
            0.00174825174825175,
            0.00116550116550117,
            0.00058275058275058,
            0.00058275058275058,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
            0.00000000000000000,
        },
        {
            0.00029137529137529,
            0.00029137529137529,
            0.00058275058275058,
            0.00087412587412587,
            0.00145687645687646,
            0.00203962703962704,
            0.00320512820512821,
            0.00437062937062937,
            0.00582750582750583,
            0.00757575757575758,
            0.00990675990675991,
            0.01223776223776224,
            0.01544289044289044,
            0.01835664335664336,
            0.02185314685314686,
            0.02534965034965035,
            0.02913752913752913,
            0.03263403263403263,
            0.03642191142191141,
            0.03962703962703962,
            0.04254079254079253,
            0.04516317016317015,
            0.04720279720279719,
            0.04836829836829836,
            0.04924242424242423,
            0.04924242424242423,
            0.04836829836829836,
            0.04720279720279719,
            0.04516317016317015,
            0.04254079254079253,
            0.03962703962703962,
            0.03642191142191141,
            0.03263403263403263,
            0.02913752913752913,
            0.02534965034965035,
            0.02185314685314686,
            0.01835664335664336,
            0.01544289044289044,
            0.01223776223776224,
            0.00990675990675991,
            0.00757575757575758,
            0.00582750582750583,
            0.00437062937062937,
            0.00320512820512821,
            0.00203962703962704,
            0.00145687645687646,
            0.00087412587412587,
            0.00058275058275058,
            0.00029137529137529,
            0.00029137529137529,
        },
    },
};
