#! /usr/bin/env perl
# -*- mode: perl -*-

package configdata;

use strict;
use warnings;

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw(
    %config %target %disabled %withargs %unified_info
    @disablables @disablables_int
);

our %config = (
    "AR" => "ar",
    "ARFLAGS" => [
        "qc"
    ],
    "ASFLAGS" => [],
    "CC" => "gcc",
    "CFLAGS" => [
        "-Wall -O3"
    ],
    "CPPDEFINES" => [],
    "CPPFLAGS" => [],
    "CPPINCLUDES" => [],
    "CXX" => "g++",
    "CXXFLAGS" => [
        "-Wall -O3"
    ],
    "FIPSKEY" => "f4556650ac31d35461610bac4ed81b1a181b2d8a43ea2854cbae22ca74560813",
    "FIPS_VENDOR" => "OpenSSL non-compliant FIPS Provider",
    "HASHBANGPERL" => "/usr/bin/env perl",
    "LDFLAGS" => [],
    "LDLIBS" => [],
    "OBJCOPY" => "objcopy",
    "PERL" => "/usr/bin/perl",
    "RANLIB" => "ranlib",
    "RC" => "windres",
    "RCFLAGS" => [],
    "afalgeng" => "",
    "api" => "10101",
    "b32" => "0",
    "b64" => "0",
    "b64l" => "1",
    "bn_ll" => "0",
    "build_file" => "Makefile",
    "build_file_templates" => [
        "Configurations/common0.tmpl",
        "Configurations/unix-Makefile.tmpl"
    ],
    "build_infos" => [
        "./build.info",
        "crypto/build.info",
        "ssl/build.info",
        "apps/build.info",
        "util/build.info",
        "tools/build.info",
        "fuzz/build.info",
        "providers/build.info",
        "doc/build.info",
        "test/build.info",
        "engines/build.info",
        "exporters/build.info",
        "crypto/objects/build.info",
        "crypto/buffer/build.info",
        "crypto/bio/build.info",
        "crypto/stack/build.info",
        "crypto/lhash/build.info",
        "crypto/hashtable/build.info",
        "crypto/rand/build.info",
        "crypto/evp/build.info",
        "crypto/asn1/build.info",
        "crypto/pem/build.info",
        "crypto/x509/build.info",
        "crypto/conf/build.info",
        "crypto/txt_db/build.info",
        "crypto/pkcs7/build.info",
        "crypto/pkcs12/build.info",
        "crypto/ui/build.info",
        "crypto/kdf/build.info",
        "crypto/store/build.info",
        "crypto/property/build.info",
        "crypto/md2/build.info",
        "crypto/md5/build.info",
        "crypto/sha/build.info",
        "crypto/mdc2/build.info",
        "crypto/hmac/build.info",
        "crypto/poly1305/build.info",
        "crypto/siphash/build.info",
        "crypto/sm3/build.info",
        "crypto/des/build.info",
        "crypto/aes/build.info",
        "crypto/rc4/build.info",
        "crypto/aria/build.info",
        "crypto/bf/build.info",
        "crypto/cast/build.info",
        "crypto/camellia/build.info",
        "crypto/seed/build.info",
        "crypto/chacha/build.info",
        "crypto/modes/build.info",
        "crypto/bn/build.info",
        "crypto/ec/build.info",
        "crypto/rsa/build.info",
        "crypto/dsa/build.info",
        "crypto/dh/build.info",
        "crypto/dso/build.info",
        "crypto/engine/build.info",
        "crypto/err/build.info",
        "crypto/comp/build.info",
        "crypto/http/build.info",
        "crypto/ocsp/build.info",
        "crypto/cms/build.info",
        "crypto/ts/build.info",
        "crypto/srp/build.info",
        "crypto/cmac/build.info",
        "crypto/ct/build.info",
        "crypto/async/build.info",
        "crypto/ess/build.info",
        "crypto/crmf/build.info",
        "crypto/cmp/build.info",
        "crypto/encode_decode/build.info",
        "crypto/ffc/build.info",
        "crypto/hpke/build.info",
        "crypto/thread/build.info",
        "ssl/record/build.info",
        "ssl/rio/build.info",
        "ssl/quic/build.info",
        "apps/lib/build.info",
        "providers/common/build.info",
        "providers/implementations/build.info",
        "doc/man1/build.info",
        "ssl/record/methods/build.info",
        "providers/common/der/build.info",
        "providers/implementations/digests/build.info",
        "providers/implementations/ciphers/build.info",
        "providers/implementations/rands/build.info",
        "providers/implementations/macs/build.info",
        "providers/implementations/kdfs/build.info",
        "providers/implementations/exchange/build.info",
        "providers/implementations/keymgmt/build.info",
        "providers/implementations/signature/build.info",
        "providers/implementations/asymciphers/build.info",
        "providers/implementations/encode_decode/build.info",
        "providers/implementations/storemgmt/build.info",
        "providers/implementations/kem/build.info",
        "providers/implementations/rands/seeding/build.info"
    ],
    "build_metadata" => "",
    "build_type" => "release",
    "builddir" => ".",
    "cflags" => [
        "-Wa,--noexecstack"
    ],
    "conf_files" => [
        "Configurations/00-base-templates.conf",
        "Configurations/10-main.conf"
    ],
    "cppflags" => [],
    "cxxflags" => [],
    "defines" => [
        "NDEBUG"
    ],
    "dynamic_engines" => "1",
    "engdirs" => [
        "afalg"
    ],
    "ex_libs" => [],
    "full_version" => "3.4.1",
    "includes" => [],
    "lflags" => [],
    "lib_defines" => [
        "OPENSSL_PIC"
    ],
    "libdir" => "",
    "major" => "3",
    "makedep_scheme" => "gcc",
    "minor" => "4",
    "openssl_api_defines" => [
        "OPENSSL_CONFIGURED_API=10101"
    ],
    "openssl_feature_defines" => [
        "OPENSSL_RAND_SEED_OS",
        "OPENSSL_THREADS",
        "OPENSSL_NO_ACVP_TESTS",
        "OPENSSL_NO_ASAN",
        "OPENSSL_NO_BROTLI",
        "OPENSSL_NO_BROTLI_DYNAMIC",
        "OPENSSL_NO_CRYPTO_MDEBUG",
        "OPENSSL_NO_CRYPTO_MDEBUG_BACKTRACE",
        "OPENSSL_NO_DEFAULT_THREAD_POOL",
        "OPENSSL_NO_DEMOS",
        "OPENSSL_NO_DEVCRYPTOENG",
        "OPENSSL_NO_EC_NISTP_64_GCC_128",
        "OPENSSL_NO_ECDH",
        "OPENSSL_NO_ECDSA",
        "OPENSSL_NO_EGD",
        "OPENSSL_NO_EXTERNAL_TESTS",
        "OPENSSL_NO_FIPS_POST",
        "OPENSSL_NO_FIPS_SECURITYCHECKS",
        "OPENSSL_NO_FUZZ_AFL",
        "OPENSSL_NO_FUZZ_LIBFUZZER",
        "OPENSSL_NO_H3DEMO",
        "OPENSSL_NO_IDEA",
        "OPENSSL_NO_JITTER",
        "OPENSSL_NO_KTLS",
        "OPENSSL_NO_MD4",
        "OPENSSL_NO_MSAN",
        "OPENSSL_NO_PIE",
        "OPENSSL_NO_RC2",
        "OPENSSL_NO_RC5",
        "OPENSSL_NO_RMD160",
        "OPENSSL_NO_SCTP",
        "OPENSSL_NO_SM2",
        "OPENSSL_NO_SM4",
        "OPENSSL_NO_SSL3",
        "OPENSSL_NO_SSL3_METHOD",
        "OPENSSL_NO_TFO",
        "OPENSSL_NO_THREAD_POOL",
        "OPENSSL_NO_TRACE",
        "OPENSSL_NO_UBSAN",
        "OPENSSL_NO_UNIT_TEST",
        "OPENSSL_NO_UPLINK",
        "OPENSSL_NO_WEAK_SSL_CIPHERS",
        "OPENSSL_NO_WHIRLPOOL",
        "OPENSSL_NO_WINSTORE",
        "OPENSSL_NO_ZLIB",
        "OPENSSL_NO_ZLIB_DYNAMIC",
        "OPENSSL_NO_ZSTD",
        "OPENSSL_NO_ZSTD_DYNAMIC",
        "OPENSSL_NO_STATIC_ENGINE"
    ],
    "openssl_other_defines" => [
        "OPENSSL_NO_KTLS"
    ],
    "openssl_sys_defines" => [],
    "openssldir" => "",
    "options" => "--api=1.1.1 enable-md2 no-acvp-tests no-asan no-brotli no-brotli-dynamic no-buildtest-c++ no-crypto-mdebug no-crypto-mdebug-backtrace no-default-thread-pool no-demos no-devcryptoeng no-ec_nistp_64_gcc_128 no-ecdh no-ecdsa no-egd no-external-tests no-fips no-fips-post no-fips-securitychecks no-fuzz-afl no-fuzz-libfuzzer no-h3demo no-idea no-jitter no-ktls no-md4 no-msan no-pie no-rc2 no-rc5 no-rmd160 no-sctp no-sm2 no-sm4 no-ssl3 no-ssl3-method no-tfo no-thread-pool no-trace no-ubsan no-unit-test no-uplink no-weak-ssl-ciphers no-whirlpool no-winstore no-zlib no-zlib-dynamic no-zstd no-zstd-dynamic",
    "patch" => "1",
    "perl_archname" => "x86_64-linux-gnu-thread-multi",
    "perl_cmd" => "/usr/bin/perl",
    "perl_version" => "5.38.2",
    "perlargv" => [
        "--api=1.1.1",
        "no-ecdh",
        "no-ecdsa",
        "no-idea",
        "no-rc2",
        "no-rmd160",
        "enable-md2",
        "no-md4",
        "no-ssl3",
        "no-whirlpool",
        "no-thread-pool",
        "no-fips",
        "no-sm2",
        "no-sm4"
    ],
    "perlenv" => {
        "AR" => undef,
        "ARFLAGS" => undef,
        "AS" => undef,
        "ASFLAGS" => undef,
        "BUILDFILE" => undef,
        "CC" => undef,
        "CFLAGS" => undef,
        "CPP" => undef,
        "CPPDEFINES" => undef,
        "CPPFLAGS" => undef,
        "CPPINCLUDES" => undef,
        "CROSS_COMPILE" => undef,
        "CXX" => undef,
        "CXXFLAGS" => undef,
        "HASHBANGPERL" => undef,
        "LD" => undef,
        "LDFLAGS" => undef,
        "LDLIBS" => undef,
        "MT" => undef,
        "MTFLAGS" => undef,
        "OBJCOPY" => undef,
        "OPENSSL_LOCAL_CONFIG_DIR" => undef,
        "PERL" => undef,
        "RANLIB" => undef,
        "RC" => undef,
        "RCFLAGS" => undef,
        "RM" => undef,
        "WINDRES" => undef,
        "__CNF_CFLAGS" => undef,
        "__CNF_CPPDEFINES" => undef,
        "__CNF_CPPFLAGS" => undef,
        "__CNF_CPPINCLUDES" => undef,
        "__CNF_CXXFLAGS" => undef,
        "__CNF_LDFLAGS" => undef,
        "__CNF_LDLIBS" => undef
    },
    "prefix" => "",
    "prerelease" => "",
    "processor" => "",
    "rc4_int" => "unsigned int",
    "release_date" => "11 Feb 2025",
    "shlib_version" => "3",
    "sourcedir" => ".",
    "target" => "linux-x86_64",
    "version" => "3.4.1"
);
our %target = (
    "AR" => "ar",
    "ARFLAGS" => "qc",
    "CC" => "gcc",
    "CFLAGS" => "-Wall -O3",
    "CXX" => "g++",
    "CXXFLAGS" => "-Wall -O3",
    "HASHBANGPERL" => "/usr/bin/env perl",
    "OBJCOPY" => "objcopy",
    "RANLIB" => "ranlib",
    "RC" => "windres",
    "_conf_fname_int" => [
        "Configurations/00-base-templates.conf",
        "Configurations/00-base-templates.conf",
        "Configurations/10-main.conf",
        "Configurations/10-main.conf",
        "Configurations/10-main.conf",
        "Configurations/shared-info.pl"
    ],
    "asm_arch" => "x86_64",
    "bin_cflags" => "",
    "bin_lflags" => "",
    "bn_ops" => "SIXTY_FOUR_BIT_LONG",
    "build_file" => "Makefile",
    "build_scheme" => [
        "unified",
        "unix"
    ],
    "cflags" => "-pthread -m64",
    "cppflags" => "",
    "cxxflags" => "-std=c++11 -pthread -m64",
    "defines" => [
        "OPENSSL_BUILDING_OPENSSL"
    ],
    "disable" => [],
    "dso_ldflags" => "-Wl,-z,defs",
    "dso_scheme" => "dlfcn",
    "enable" => [
        "afalgeng"
    ],
    "ex_libs" => "-ldl -pthread",
    "includes" => [],
    "lflags" => "",
    "lib_cflags" => "",
    "lib_cppflags" => "-DOPENSSL_USE_NODELETE -DL_ENDIAN",
    "lib_defines" => [],
    "module_cflags" => "-fPIC",
    "module_cxxflags" => undef,
    "module_ldflags" => "-Wl,-znodelete -shared -Wl,-Bsymbolic",
    "multilib" => "64",
    "perl_platform" => "Unix",
    "perlasm_scheme" => "elf",
    "shared_cflag" => "-fPIC",
    "shared_defflag" => "-Wl,--version-script=",
    "shared_defines" => [],
    "shared_ldflag" => "-Wl,-znodelete -shared -Wl,-Bsymbolic",
    "shared_rcflag" => "",
    "shared_sonameflag" => "-Wl,-soname=",
    "shared_target" => "linux-shared",
    "template" => "1",
    "thread_defines" => [],
    "thread_scheme" => "pthreads",
    "unistd" => "<unistd.h>"
);
our @disablables = (
    "acvp-tests",
    "afalgeng",
    "apps",
    "argon2",
    "aria",
    "asan",
    "asm",
    "async",
    "atexit",
    "autoalginit",
    "autoerrinit",
    "autoload-config",
    "bf",
    "blake2",
    "brotli",
    "brotli-dynamic",
    "buildtest-c++",
    "bulk",
    "cached-fetch",
    "camellia",
    "capieng",
    "winstore",
    "cast",
    "chacha",
    "cmac",
    "cmp",
    "cms",
    "comp",
    "crypto-mdebug",
    "ct",
    "default-thread-pool",
    "demos",
    "h3demo",
    "deprecated",
    "des",
    "devcryptoeng",
    "dgram",
    "dh",
    "docs",
    "dsa",
    "dso",
    "dtls",
    "dynamic-engine",
    "ec",
    "ec2m",
    "ec_nistp_64_gcc_128",
    "ecdh",
    "ecdsa",
    "ecx",
    "egd",
    "engine",
    "err",
    "external-tests",
    "filenames",
    "fips",
    "fips-securitychecks",
    "fips-post",
    "fuzz-afl",
    "fuzz-libfuzzer",
    "gost",
    "http",
    "idea",
    "jitter",
    "ktls",
    "legacy",
    "loadereng",
    "makedepend",
    "md2",
    "md4",
    "mdc2",
    "module",
    "msan",
    "multiblock",
    "nextprotoneg",
    "ocb",
    "ocsp",
    "padlockeng",
    "pic",
    "pie",
    "pinshared",
    "poly1305",
    "posix-io",
    "psk",
    "quic",
    "unstable-qlog",
    "rc2",
    "rc4",
    "rc5",
    "rdrand",
    "rfc3779",
    "rmd160",
    "scrypt",
    "sctp",
    "secure-memory",
    "seed",
    "shared",
    "siphash",
    "siv",
    "sm2",
    "sm2-precomp",
    "sm3",
    "sm4",
    "sock",
    "srp",
    "srtp",
    "sse2",
    "ssl",
    "ssl-trace",
    "static-engine",
    "stdio",
    "tests",
    "tfo",
    "thread-pool",
    "threads",
    "tls",
    "integrity-only-ciphers",
    "trace",
    "ts",
    "ubsan",
    "ui-console",
    "unit-test",
    "uplink",
    "weak-ssl-ciphers",
    "whirlpool",
    "zlib",
    "zlib-dynamic",
    "zstd",
    "zstd-dynamic",
    "ssl3",
    "ssl3-method",
    "tls1",
    "tls1-method",
    "tls1_1",
    "tls1_1-method",
    "tls1_2",
    "tls1_2-method",
    "tls1_3",
    "dtls1",
    "dtls1-method",
    "dtls1_2",
    "dtls1_2-method"
);
our @disablables_int = (
    "crmf"
);
our %disabled = (
    "acvp-tests" => "cascade",
    "asan" => "default",
    "brotli" => "default",
    "brotli-dynamic" => "default",
    "buildtest-c++" => "default",
    "crypto-mdebug" => "default",
    "crypto-mdebug-backtrace" => "default",
    "default-thread-pool" => "cascade",
    "demos" => "default",
    "devcryptoeng" => "default",
    "ec_nistp_64_gcc_128" => "default",
    "ecdh" => "option",
    "ecdsa" => "option",
    "egd" => "default",
    "external-tests" => "default",
    "fips" => "option",
    "fips-post" => "cascade",
    "fips-securitychecks" => "cascade",
    "fuzz-afl" => "default",
    "fuzz-libfuzzer" => "default",
    "h3demo" => "default",
    "idea" => "option",
    "jitter" => "default",
    "ktls" => "default",
    "md4" => "option",
    "msan" => "default",
    "pie" => "default",
    "rc2" => "option",
    "rc5" => "default",
    "rmd160" => "option",
    "sctp" => "default",
    "sm2" => "option",
    "sm4" => "option",
    "ssl3" => "option",
    "ssl3-method" => "default",
    "tfo" => "default",
    "thread-pool" => "option",
    "trace" => "default",
    "ubsan" => "default",
    "unit-test" => "default",
    "uplink" => "no uplink_arch",
    "weak-ssl-ciphers" => "default",
    "whirlpool" => "option",
    "winstore" => "not-windows",
    "zlib" => "default",
    "zlib-dynamic" => "default",
    "zstd" => "default",
    "zstd-dynamic" => "default"
);
