// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// RuntimeServer Runtime Server
//
// Runtime transient server properties
// Example: {"address":"127.0.0.5","admin_state":"ready","operational_state":"up","port":80,"server_id":1,"server_name":"web_server"}
//
// swagger:model runtime_server
type RuntimeServer struct {
	// address
	// Read Only: true
	// Pattern: ^[^\s]+$
	// +kubebuilder:validation:Pattern=`^[^\s]+$`
	Address string `json:"address,omitempty"`

	// admin state
	// Enum: ["ready","maint","drain"]
	// +kubebuilder:validation:Enum="ready","maint","drain";
	AdminState string `json:"admin_state,omitempty"`

	// id
	// Read Only: true
	ID string `json:"id,omitempty"`

	// name
	// Read Only: true
	Name string `json:"name,omitempty"`

	// operational state
	// Enum: ["up","down","stopping"]
	// +kubebuilder:validation:Enum="up","down","stopping";
	OperationalState string `json:"operational_state,omitempty"`

	// port
	// Read Only: true
	// Maximum: 65535
	// Minimum: 1
	// +kubebuilder:validation:Maximum=65535
	// +kubebuilder:validation:Minimum=1
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this runtime server
func (m *RuntimeServer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdminState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperationalState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RuntimeServer) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if err := validate.Pattern("address", "body", m.Address, `^[^\s]+$`); err != nil {
		return err
	}

	return nil
}

var runtimeServerTypeAdminStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ready","maint","drain"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeServerTypeAdminStatePropEnum = append(runtimeServerTypeAdminStatePropEnum, v)
	}
}

const (

	// RuntimeServerAdminStateReady captures enum value "ready"
	RuntimeServerAdminStateReady string = "ready"

	// RuntimeServerAdminStateMaint captures enum value "maint"
	RuntimeServerAdminStateMaint string = "maint"

	// RuntimeServerAdminStateDrain captures enum value "drain"
	RuntimeServerAdminStateDrain string = "drain"
)

// prop value enum
func (m *RuntimeServer) validateAdminStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeServerTypeAdminStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeServer) validateAdminState(formats strfmt.Registry) error {
	if swag.IsZero(m.AdminState) { // not required
		return nil
	}

	// value enum
	if err := m.validateAdminStateEnum("admin_state", "body", m.AdminState); err != nil {
		return err
	}

	return nil
}

var runtimeServerTypeOperationalStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","stopping"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		runtimeServerTypeOperationalStatePropEnum = append(runtimeServerTypeOperationalStatePropEnum, v)
	}
}

const (

	// RuntimeServerOperationalStateUp captures enum value "up"
	RuntimeServerOperationalStateUp string = "up"

	// RuntimeServerOperationalStateDown captures enum value "down"
	RuntimeServerOperationalStateDown string = "down"

	// RuntimeServerOperationalStateStopping captures enum value "stopping"
	RuntimeServerOperationalStateStopping string = "stopping"
)

// prop value enum
func (m *RuntimeServer) validateOperationalStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, runtimeServerTypeOperationalStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *RuntimeServer) validateOperationalState(formats strfmt.Registry) error {
	if swag.IsZero(m.OperationalState) { // not required
		return nil
	}

	// value enum
	if err := m.validateOperationalStateEnum("operational_state", "body", m.OperationalState); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeServer) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this runtime server based on the context it is used
func (m *RuntimeServer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePort(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *RuntimeServer) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "address", "body", string(m.Address)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeServer) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", string(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeServer) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", string(m.Name)); err != nil {
		return err
	}

	return nil
}

func (m *RuntimeServer) contextValidatePort(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "port", "body", m.Port); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *RuntimeServer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *RuntimeServer) UnmarshalBinary(b []byte) error {
	var res RuntimeServer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
