// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TuneBufferOptions tune buffer options
//
// swagger:model tune_buffer_options
type TuneBufferOptions struct {

	// buffers limit
	BuffersLimit *int64 `json:"buffers_limit,omitempty"`

	// buffers reserve
	// Minimum: 2
	// +kubebuilder:validation:Minimum=2
	BuffersReserve int64 `json:"buffers_reserve,omitempty"`

	// bufsize
	Bufsize int64 `json:"bufsize,omitempty"`

	// pipesize
	Pipesize int64 `json:"pipesize,omitempty"`

	// rcvbuf backend
	RcvbufBackend *int64 `json:"rcvbuf_backend,omitempty"`

	// rcvbuf client
	RcvbufClient *int64 `json:"rcvbuf_client,omitempty"`

	// rcvbuf frontend
	RcvbufFrontend *int64 `json:"rcvbuf_frontend,omitempty"`

	// rcvbuf server
	RcvbufServer *int64 `json:"rcvbuf_server,omitempty"`

	// recv enough
	RecvEnough int64 `json:"recv_enough,omitempty"`

	// sndbuf backend
	SndbufBackend *int64 `json:"sndbuf_backend,omitempty"`

	// sndbuf client
	SndbufClient *int64 `json:"sndbuf_client,omitempty"`

	// sndbuf frontend
	SndbufFrontend *int64 `json:"sndbuf_frontend,omitempty"`

	// sndbuf server
	SndbufServer *int64 `json:"sndbuf_server,omitempty"`
}

// Validate validates this tune buffer options
func (m *TuneBufferOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBuffersReserve(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TuneBufferOptions) validateBuffersReserve(formats strfmt.Registry) error {
	if swag.IsZero(m.BuffersReserve) { // not required
		return nil
	}

	if err := validate.MinimumInt("buffers_reserve", "body", m.BuffersReserve, 2, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this tune buffer options based on context it is used
func (m *TuneBufferOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *TuneBufferOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TuneBufferOptions) UnmarshalBinary(b []byte) error {
	var res TuneBufferOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
