//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// The Core Image class that defines a color object.
    ///
    /// Use `CIColor` instances in conjunction with other Core Image classes, such as ``CIFilter-class`` and ``CIKernel``.
    /// Many of the built-in Core Image filters have one or more `CIColor` inputs that you can set to affect the filter's
    /// behavior.
    ///
    /// ### Color Model
    ///
    /// A color is defined as a N-dimensional model where each dimension's color component is represented
    /// by intensity values. A color component may also be referred to as a color channel. An RGB color model, for example,
    /// is three-dimensional and the red, green, and blue component intensities define each unique color.
    ///
    /// ### Color Space
    ///
    /// A color is also defined by a color space that locates the axes of N-dimensional model within the greater
    /// volume of human perceivable colors.  Core Image uses `CGColorSpace` instances to specify a variety of different
    /// color spaces such as sRGB, P3, BT.2020, etc. The `CGColorSpace` also defines if the color space is coded
    /// linearly or in a non-linear perceptual curve.
    /// (For more information on `CGColorSpace` see
    /// <doc
    /// ://com.apple.documentation/documentation/coregraphics/cgcolorspace>)
    ///
    /// ### Color Range
    ///
    /// Standard dynamic range (SDR) color color component values range from `0.0` to `1.0`, with `0.0`
    /// representing an 0% of that component and `1.0` representing 100%. In contrast, high dynamic range (HDR) color values
    /// can be less than `0.0` (for more saturation) or greater than `1.0` (for more brightness).
    ///
    /// ### Color Opacity
    ///
    /// `CIColor` instances also have an alpha component, which represents the opacity of the color, with 0.0 meaning completely
    /// transparent and 1.0 meaning completely opaque. If a color does not have an explicit alpha component, Core Image
    /// assumes that the alpha component equals 1.0. With `CIColor` that color components values are not premultiplied.
    /// So for example, a semi-transparent pure red `CIColor` is represented by RGB `1.0,0.0,0.0` and A `0.5`.  In contrast
    /// color components values in ``CIImage`` buffers or read in ``CIKernel`` samplers are premultiplied by default.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/coreimage/cicolor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CIColor;
);

unsafe impl Send for CIColor {}

unsafe impl Sync for CIColor {}

extern_conformance!(
    unsafe impl NSCoding for CIColor {}
);

extern_conformance!(
    unsafe impl NSCopying for CIColor {}
);

unsafe impl CopyingHelper for CIColor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CIColor {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CIColor {}
);

impl CIColor {
    extern_methods!(
        #[cfg(feature = "objc2-core-graphics")]
        /// Create a Core Image color object with a Core Graphics color object.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithCGColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithCGColor(color: &CGColor) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image color object in the sRGB color space
        /// with the specified red, green, blue, and alpha component values.
        ///
        /// On macOS before 10.10, the CIColor's color space will be Generic RGB.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value between 0 and 1.
        /// - green: The color's unpremultiplied green component value between 0 and 1.
        /// - blue: The color's unpremultiplied blue component value between 0 and 1.
        /// - alpha: The color's alpha (opacity) value between 0 and 1.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithRed:green:blue:alpha:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithRed_green_blue_alpha(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Create a Core Image color object in the sRGB color space
        /// with the specified red, green, and blue component values.
        ///
        /// On macOS before 10.10, the CIColor's color space will be Generic RGB.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value between 0 and 1.
        /// - green: The color's unpremultiplied green component value between 0 and 1.
        /// - blue: The color's unpremultiplied blue component value between 0 and 1.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithRed:green:blue:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithRed_green_blue(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
        ) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        /// Create a Core Image color object
        /// with the specified red, green, blue, and alpha component values
        /// as measured in the specified color space.
        ///
        /// This will return `null` if the `CGColorSpace` is not `kCGColorSpaceModelRGB`.
        ///
        /// The RGB values can be outside the `0...1` range if the `CGColorSpace` is unclamped.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value.
        /// - green: The color's unpremultiplied green component value.
        /// - blue: The color's unpremultiplied blue component value.
        /// - alpha: The color's alpha (opacity) value between 0 and 1.
        /// - colorSpace: The color's `CGColorSpace` which must have `kCGColorSpaceModelRGB`.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithRed:green:blue:alpha:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithRed_green_blue_alpha_colorSpace(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
            color_space: &CGColorSpace,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        /// Create a Core Image color object
        /// with the specified red, green, and blue component values
        /// as measured in the specified color space.
        ///
        /// This will return `null` if the `CGColorSpace` is not `kCGColorSpaceModelRGB`.
        ///
        /// The RGB values can be outside the `0...1` range if the `CGColorSpace` is unclamped.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value.
        /// - green: The color's unpremultiplied green component value.
        /// - blue: The color's unpremultiplied blue component value.
        /// - colorSpace: The color's `CGColorSpace` which must have `kCGColorSpaceModelRGB`.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithRed:green:blue:colorSpace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithRed_green_blue_colorSpace(
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            color_space: &CGColorSpace,
        ) -> Option<Retained<Self>>;

        /// Create a Core Image color object in the sRGB color space using a string containing the RGBA color component values.
        ///
        /// On macOS before 10.10, the CIColor's color space will be Generic RGB.
        ///
        /// - Parameters:
        /// - representation: A string that contains color and alpha float values.
        /// For example, the string: `"0.5 0.7 0.3 1.0"` indicates an RGB color whose components
        /// are 50% red, 70% green, 30% blue, and 100% opaque.
        /// If the string contains only 3 float values, the alpha component will be `1.0`
        /// If the string contains no float values, then ``/CIColor/clearColor`` will be returned.
        /// - Returns:
        /// An autoreleased ``CIColor`` instance.
        #[unsafe(method(colorWithString:))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorWithString(representation: &NSString) -> Retained<Self>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Create a Core Image color object with a Core Graphics color object.
        /// - Returns:
        /// An initialized ``CIColor`` instance.
        #[unsafe(method(initWithCGColor:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCGColor(this: Allocated<Self>, color: &CGColor) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image color object in the sRGB color space
        /// with the specified red, green, blue, and alpha component values.
        ///
        /// On macOS before 10.10, the CIColor's color space will be Generic RGB.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value between 0 and 1.
        /// - green: The color's unpremultiplied green component value between 0 and 1.
        /// - blue: The color's unpremultiplied blue component value between 0 and 1.
        /// - alpha: The color's alpha (opacity) value between 0 and 1.
        /// - Returns:
        /// An initialized ``CIColor`` instance.
        #[unsafe(method(initWithRed:green:blue:alpha:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRed_green_blue_alpha(
            this: Allocated<Self>,
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Initialize a Core Image color object in the sRGB color space
        /// with the specified red, green, and blue component values.
        ///
        /// On macOS before 10.10, the CIColor's color space will be Generic RGB.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value between 0 and 1.
        /// - green: The color's unpremultiplied green component value between 0 and 1.
        /// - blue: The color's unpremultiplied blue component value between 0 and 1.
        /// - Returns:
        /// An initialized ``CIColor`` instance.
        #[unsafe(method(initWithRed:green:blue:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRed_green_blue(
            this: Allocated<Self>,
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
        ) -> Retained<Self>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        /// Initialize a Core Image color object
        /// with the specified red, green, and blue component values
        /// as measured in the specified color space.
        ///
        /// This will return null if the `CGColorSpace` is not `kCGColorSpaceModelRGB`.
        /// The RGB values can be outside the `0...1` range if the `CGColorSpace` is unclamped.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value.
        /// - green: The color's unpremultiplied green component value.
        /// - blue: The color's unpremultiplied blue component value.
        /// - alpha: The color's alpha (opacity) value between 0 and 1.
        /// - colorSpace: The color's `CGColorSpace` which must have `kCGColorSpaceModelRGB`.
        /// - Returns:
        /// An initialized ``CIColor`` instance.
        #[unsafe(method(initWithRed:green:blue:alpha:colorSpace:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRed_green_blue_alpha_colorSpace(
            this: Allocated<Self>,
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            alpha: CGFloat,
            color_space: &CGColorSpace,
        ) -> Option<Retained<Self>>;

        #[cfg(all(feature = "objc2-core-foundation", feature = "objc2-core-graphics"))]
        /// Initialize a Core Image color object
        /// with the specified red, green, and blue component values
        /// as measured in the specified color space.
        ///
        /// This will return null if the `CGColorSpace` is not `kCGColorSpaceModelRGB`.
        /// The RGB values can be outside the `0...1` range if the `CGColorSpace` is unclamped.
        /// - Parameters:
        /// - red: The color's unpremultiplied red component value.
        /// - green: The color's unpremultiplied green component value.
        /// - blue: The color's unpremultiplied blue component value.
        /// - colorSpace: The color's `CGColorSpace` which must have `kCGColorSpaceModelRGB`.
        /// - Returns:
        /// An initialized ``CIColor`` instance.
        #[unsafe(method(initWithRed:green:blue:colorSpace:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRed_green_blue_colorSpace(
            this: Allocated<Self>,
            red: CGFloat,
            green: CGFloat,
            blue: CGFloat,
            color_space: &CGColorSpace,
        ) -> Option<Retained<Self>>;

        /// Returns the color components of the color including alpha.
        ///
        /// This number includes the alpha component if the color contains one.
        ///
        /// Typically this number will be `4` for red, green, blue, and alpha.
        /// If the ``CIColor`` was initialized with a `CGColor` then the number
        /// will be the same as calling `CGColorGetNumberOfComponents()`
        #[unsafe(method(numberOfComponents))]
        #[unsafe(method_family = none)]
        pub unsafe fn numberOfComponents(&self) -> usize;

        #[cfg(feature = "objc2-core-foundation")]
        /// Return a pointer to an array of `CGFloat` values including alpha.
        ///
        /// Typically this array will contain `4` `CGFloat` values for red, green, blue, and alpha.
        /// If the ``CIColor`` was initialized with a `CGColor` then returned pointer
        /// will be the same as calling `CGColorGetComponents()`
        #[unsafe(method(components))]
        #[unsafe(method_family = none)]
        pub unsafe fn components(&self) -> NonNull<CGFloat>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the alpha value of the color.
        #[unsafe(method(alpha))]
        #[unsafe(method_family = none)]
        pub unsafe fn alpha(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-graphics")]
        /// Returns the `CGColorSpace` associated with the color
        #[unsafe(method(colorSpace))]
        #[unsafe(method_family = none)]
        pub unsafe fn colorSpace(&self) -> Retained<CGColorSpace>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the unpremultiplied red component of the color.
        ///
        /// If the ``CIColor`` was initialized with a `CGColor` in a non-RGB `CGColorSpace`
        /// then it will be converted to sRGB to get the red component.
        #[unsafe(method(red))]
        #[unsafe(method_family = none)]
        pub unsafe fn red(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the unpremultiplied green component of the color.
        ///
        /// If the ``CIColor`` was initialized with a `CGColor` in a non-RGB `CGColorSpace`
        /// then it will be converted to sRGB to get the green component.
        #[unsafe(method(green))]
        #[unsafe(method_family = none)]
        pub unsafe fn green(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Returns the unpremultiplied blue component of the color.
        ///
        /// If the ``CIColor`` was initialized with a `CGColor` in a non-RGB `CGColorSpace`
        /// then it will be converted to sRGB to get the green component.
        #[unsafe(method(blue))]
        #[unsafe(method_family = none)]
        pub unsafe fn blue(&self) -> CGFloat;

        /// Returns a formatted string with the unpremultiplied color and alpha components of the color.
        ///
        /// The string representation always has four components: red, green, blue, and alpha.
        ///
        /// Some example string representations of colors:
        ///
        /// `CIColor`                                       | `stringRepresentation`
        /// ----------------------------------------------- | --------------
        /// `[CIColor colorWithRed:0.2 green:0.4 blue:0.6]` | `"0.2 0.4 0.6 1.0"`
        /// ``/CIColor/yellowColor``                        | `"1.0 1.0 0.0 1.0"`
        ///
        /// To create a ``CIColor`` instance from a string representation, use the ``colorWithString:`` method.
        ///
        /// If the ``CIColor`` was initialized with a `CGColor` in a non-RGB `CGColorSpace`
        /// then it will be converted to sRGB to get the red, green, and blue components.
        ///
        /// This property is not KVO-safe because it returns a new `NSString` instance each time.
        /// The value of the `NSString` will be the same each time it is called.
        #[unsafe(method(stringRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn stringRepresentation(&self) -> Retained<NSString>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0,0,0` and alpha value `1`.
        #[unsafe(method(blackColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn blackColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `1,1,1` and alpha value `1`.
        #[unsafe(method(whiteColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn whiteColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0.5,0.5,0.5` and alpha value `1`.
        #[unsafe(method(grayColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn grayColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `1,0,0` and alpha value `1`.
        #[unsafe(method(redColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn redColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0,1,0` and alpha value `1`.
        #[unsafe(method(greenColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn greenColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0,0,1` and alpha value `1`.
        #[unsafe(method(blueColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn blueColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0,1,1` and alpha value `1`.
        #[unsafe(method(cyanColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn cyanColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `1,0,1` and alpha value `1`.
        #[unsafe(method(magentaColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn magentaColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `1,1,0` and alpha value `1`.
        #[unsafe(method(yellowColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn yellowColor() -> Retained<CIColor>;

        /// Returns a singleton Core Image color instance in the sRGB color space with RGB values `0,0,0` and alpha value `0`.
        #[unsafe(method(clearColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn clearColor() -> Retained<CIColor>;
    );
}

/// Methods declared on superclass `NSObject`.
impl CIColor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
