//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2_core_foundation::*;
#[cfg(feature = "objc2-open-gl")]
#[cfg(target_os = "macos")]
use objc2_open_gl::*;

use crate::*;

/// OpenGL texture based image buffer
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvopengltexture?language=objc)
#[doc(alias = "CVOpenGLTextureRef")]
#[cfg(all(feature = "CVBuffer", feature = "CVImageBuffer"))]
pub type CVOpenGLTexture = CVImageBuffer;

#[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
#[inline]
pub extern "C-unwind" fn CVOpenGLTextureGetTypeID() -> CFTypeID {
    extern "C-unwind" {
        fn CVOpenGLTextureGetTypeID() -> CFTypeID;
    }
    unsafe { CVOpenGLTextureGetTypeID() }
}

/// Returns the texture target (eg. 2D vs. rect texture extension) of the CVOpenGLTexture
///
/// Parameter `image`: Target CVOpenGLTexture
///
/// Returns: OpenGL texture target
#[cfg(all(
    feature = "CVBuffer",
    feature = "CVImageBuffer",
    feature = "objc2-open-gl"
))]
#[cfg(target_os = "macos")]
#[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
#[inline]
pub extern "C-unwind" fn CVOpenGLTextureGetTarget(image: &CVOpenGLTexture) -> GLenum {
    extern "C-unwind" {
        fn CVOpenGLTextureGetTarget(image: &CVOpenGLTexture) -> GLenum;
    }
    unsafe { CVOpenGLTextureGetTarget(image) }
}

/// Returns the texture target name of the CVOpenGLTexture
///
/// Parameter `image`: Target CVOpenGLTexture
///
/// Returns: OpenGL texture target name
#[cfg(all(
    feature = "CVBuffer",
    feature = "CVImageBuffer",
    feature = "objc2-open-gl"
))]
#[cfg(target_os = "macos")]
#[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
#[inline]
pub extern "C-unwind" fn CVOpenGLTextureGetName(image: &CVOpenGLTexture) -> GLuint {
    extern "C-unwind" {
        fn CVOpenGLTextureGetName(image: &CVOpenGLTexture) -> GLuint;
    }
    unsafe { CVOpenGLTextureGetName(image) }
}

/// Returns whether the image is flipped vertically or not.
///
/// Parameter `image`: Target CVOpenGLTexture
///
/// Returns: True if 0,0 in the texture is upper left, false if 0,0 is lower left
#[cfg(all(feature = "CVBuffer", feature = "CVImageBuffer"))]
#[deprecated = "OpenGL/OpenGLES is no longer supported. Use Metal APIs instead. (Define COREVIDEO_SILENCE_GL_DEPRECATION to silence these warnings)"]
#[inline]
pub extern "C-unwind" fn CVOpenGLTextureIsFlipped(image: &CVOpenGLTexture) -> bool {
    extern "C-unwind" {
        fn CVOpenGLTextureIsFlipped(image: &CVOpenGLTexture) -> Boolean;
    }
    let ret = unsafe { CVOpenGLTextureIsFlipped(image) };
    ret != 0
}
