/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.orthogonalsupport;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.EmbeddedPlanarGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.Face;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.MGraph;
import org.netbeans.modules.visual.graph.layout.orthogonalsupport.OrthogonalRepresentation;

public class DirectionalGraph<N, E> {
    private OrthogonalRepresentation<N, E> or;
    private MGraph.Edge.Direction direction;
    private MGraph.Edge.Direction barDirection;
    private List<Bar> bars;
    private Map<MGraph.Vertex<?>, Bar> barMap;
    private Set<MGraph.Edge<?>> visitedEdges;
    private Map<MGraph.Vertex<?>, MGraph.Edge<?>> forwardEdges;
    private Map<MGraph.Vertex<?>, MGraph.Edge<?>> reverseEdges;

    public static <N, E> DirectionalGraph<N, E> createGraph(OrthogonalRepresentation<N, E> orthogonalRepresentation, MGraph.Edge.Direction direction) {
        DirectionalGraph<N, E> directionalGraph = new DirectionalGraph<N, E>(orthogonalRepresentation, direction);
        super.createGraph();
        return directionalGraph;
    }

    private DirectionalGraph(OrthogonalRepresentation<N, E> orthogonalRepresentation, MGraph.Edge.Direction direction) {
        this.or = orthogonalRepresentation;
        this.barMap = new HashMap();
        this.bars = new ArrayList<Bar>();
        this.visitedEdges = new HashSet();
        this.forwardEdges = new HashMap();
        this.reverseEdges = new HashMap();
        this.direction = direction;
        this.barDirection = direction == MGraph.Edge.Direction.HORIZONTAL ? MGraph.Edge.Direction.VERTICAL : MGraph.Edge.Direction.HORIZONTAL;
    }

    private void createGraph() {
        MGraph.Vertex<?> vertex = this.getCornerVertex();
        Collection<MGraph.Vertex<?>> collection = this.getRootVertices(vertex);
        this.assignEdgeDirections(collection, new HashSet());
        this.visitedEdges.clear();
        this.createBar(vertex, null);
        this.computeTopologicalNumbering();
    }

    private void assignEdgeDirections(Collection<MGraph.Vertex<?>> collection, Set<MGraph.Vertex<?>> set) {
        Object object;
        ArrayList arrayList = new ArrayList();
        for (MGraph.Vertex<?> object3 : collection) {
            Collection<MGraph.Edge<?>> collection2 = object3.getEdges();
            for (MGraph.Edge<?> edge : collection2) {
                if (edge.getDirection() != this.direction || this.reverseEdges.get(object3) == edge) continue;
                this.forwardEdges.put(object3, edge);
                object = edge.getOppositeVertex(object3);
                this.reverseEdges.put((MGraph.Vertex<?>)object, edge);
                arrayList.add((MGraph.Vertex<?>)object);
            }
        }
        if (!arrayList.isEmpty()) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            block2: for (MGraph.Vertex vertex : arrayList) {
                MGraph.Edge<?> edge;
                ArrayList arrayList2 = new ArrayList();
                edge = this.computeParentVertices(vertex);
                object = vertex.getEdges();
                Iterator<MGraph.Edge<?>> iterator = object.iterator();
                while (iterator.hasNext()) {
                    MGraph.Edge<?> edge2 = iterator.next();
                    if (edge2.getDirection() != this.barDirection) continue;
                    MGraph.Vertex<?> vertex2 = edge2.getOppositeVertex(vertex);
                    MGraph.Edge<?> edge3 = edge2;
                    boolean bl = false;
                    while (!(arrayList.contains(vertex2) || linkedHashSet.contains(vertex2) || set.contains(vertex2))) {
                        if (!this.containsReverseEdge(vertex2, new HashSet()) && !this.reachableToParentVertex(vertex2, (Set<MGraph.Vertex<?>>)((Object)edge), new HashSet())) {
                            linkedHashSet.add(vertex2);
                            arrayList2.add(vertex2);
                            boolean bl2 = false;
                            Collection<MGraph.Edge<?>> collection3 = vertex2.getEdges();
                            for (MGraph.Edge<?> edge4 : collection3) {
                                if (edge4 == edge3 || edge4.getDirection() != this.barDirection) continue;
                                vertex2 = edge4.getOppositeVertex(vertex2);
                                edge3 = edge4;
                                bl2 = true;
                                break;
                            }
                            if (bl2) continue;
                            break;
                        }
                        linkedHashSet.removeAll(arrayList2);
                        set.add(vertex);
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                    continue block2;
                }
            }
            arrayList.addAll(linkedHashSet);
            this.assignEdgeDirections(arrayList, set);
        }
    }

    private Set<MGraph.Vertex<?>> computeParentVertices(MGraph.Vertex<?> vertex) {
        HashSet hashSet = new HashSet();
        MGraph.Edge<?> edge = this.reverseEdges.get(vertex);
        MGraph.Vertex<?> vertex2 = vertex;
        while (edge != null) {
            MGraph.Vertex<?> vertex3 = edge.getOppositeVertex(vertex2);
            hashSet.add(vertex3);
            vertex2 = vertex3;
            edge = this.reverseEdges.get(vertex2);
        }
        return hashSet;
    }

    private boolean containsReverseEdge(MGraph.Vertex<?> vertex, Set<MGraph.Edge<?>> set) {
        Collection<MGraph.Edge<?>> collection = vertex.getEdges();
        for (MGraph.Edge<?> edge : collection) {
            if (edge.getDirection() != this.direction || set.contains(edge)) continue;
            set.add(edge);
            if (this.reverseEdges.get(vertex) == edge) {
                return true;
            }
            if (!this.containsReverseEdge(edge.getOppositeVertex(vertex), set)) continue;
            return true;
        }
        return false;
    }

    private boolean reachableToParentVertex(MGraph.Vertex<?> vertex, Set<MGraph.Vertex<?>> set, Set<MGraph.Edge<?>> set2) {
        Collection<MGraph.Edge<?>> collection = vertex.getEdges();
        for (MGraph.Edge<?> edge : collection) {
            if (edge.getDirection() != this.direction || set2.contains(edge)) continue;
            set2.add(edge);
            MGraph.Vertex<?> vertex2 = edge.getOppositeVertex(vertex);
            if (!this.checkSideway(vertex2, set, set2) && !this.reachableToParentVertex(vertex2, set, set2)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSideway(MGraph.Vertex<?> vertex, Set<MGraph.Vertex<?>> set, Set<MGraph.Edge<?>> set2) {
        Collection<MGraph.Edge<?>> collection = vertex.getEdges();
        block0: for (MGraph.Edge<?> edge : collection) {
            if (edge.getDirection() != this.barDirection || set2.contains(edge)) continue;
            set2.add(edge);
            MGraph.Vertex<?> vertex2 = edge.getOppositeVertex(vertex);
            while (!set.contains(vertex2)) {
                MGraph.Edge<?> edge2 = null;
                Collection<MGraph.Edge<?>> collection2 = vertex2.getEdges();
                for (MGraph.Edge<?> edge3 : collection2) {
                    if (edge3.getDirection() != this.barDirection || set2.contains(edge3)) continue;
                    set2.add(edge3);
                    edge2 = edge3;
                    break;
                }
                if (edge2 == null) continue block0;
                vertex2 = edge2.getOppositeVertex(vertex2);
            }
            return true;
        }
        return false;
    }

    private Bar createBar(MGraph.Vertex<?> vertex, Bar bar) {
        Bar bar2 = this.barMap.get(vertex);
        if (bar2 == null) {
            Object object;
            MGraph.Edge<?> edge;
            Object object2;
            MGraph.Vertex<?> vertex2;
            bar2 = new Bar(this.barDirection);
            this.bars.add(bar2);
            bar2.addVertex(vertex);
            this.barMap.put(vertex, bar2);
            Collection<MGraph.Edge<?>> collection = vertex.getEdges();
            block0: for (MGraph.Edge<?> object3 : collection) {
                if (object3.getDirection() != this.barDirection) continue;
                vertex2 = object3.getOppositeVertex(vertex);
                object2 = object3;
                while (true) {
                    bar2.addVertex(vertex2);
                    this.barMap.put(vertex2, bar2);
                    edge = null;
                    object = vertex2.getEdges();
                    Iterator<MGraph.Edge<?>> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        MGraph.Edge<?> edge2 = iterator.next();
                        if (edge2 == object2 || edge2.getDirection() != this.barDirection) continue;
                        edge = edge2;
                        break;
                    }
                    if (edge == null) continue block0;
                    object2 = edge;
                    vertex2 = edge.getOppositeVertex(vertex2);
                }
            }
            for (MGraph.Vertex vertex3 : bar2.getVertices()) {
                vertex2 = vertex3.getEdges();
                object2 = vertex2.iterator();
                while (object2.hasNext()) {
                    edge = (MGraph.Edge<?>)object2.next();
                    if (edge.getDirection() != this.direction || this.forwardEdges.get(vertex3) != edge || this.visitedEdges.contains(edge)) continue;
                    this.visitedEdges.add(edge);
                    object = this.createBar(edge.getOppositeVertex(vertex3), bar2);
                    if (object == bar) continue;
                    bar2.addNeighbor((Bar)object);
                }
            }
        }
        return bar2;
    }

    public Collection<Bar> getBars() {
        return this.bars;
    }

    private Collection<MGraph.Vertex<?>> getRootVertices(MGraph.Vertex<?> vertex) {
        ArrayList arrayList = new ArrayList();
        MGraph.Vertex<?> vertex2 = vertex;
        MGraph.Edge<?> edge = null;
        arrayList.add(vertex);
        while (true) {
            MGraph.Edge<?> edge2 = null;
            Collection<MGraph.Edge<?>> collection = vertex2.getEdges();
            for (MGraph.Edge<?> edge3 : collection) {
                if (edge3 == edge || edge3.getDirection() != this.barDirection) continue;
                edge2 = edge3;
                break;
            }
            if (edge2 == null) break;
            edge = edge2;
            vertex2 = edge2.getOppositeVertex(vertex2);
            arrayList.add(vertex2);
        }
        return arrayList;
    }

    private MGraph.Vertex<?> getCornerVertex() {
        MGraph.Vertex<N> vertex = this.or.getCornerVertex();
        if (vertex != null) {
            return vertex;
        }
        EmbeddedPlanarGraph<N, E> embeddedPlanarGraph = this.or.getOriginalGraph();
        Face face = embeddedPlanarGraph.getOuterFace();
        List<MGraph.Vertex<?>> list = face.getVertices();
        MGraph.Vertex<?> vertex2 = null;
        MGraph.Vertex<?> vertex3 = null;
        MGraph.Vertex<?> vertex4 = null;
        for (MGraph.Vertex<?> vertex5 : list) {
            int n = 0;
            int n2 = 0;
            Collection<MGraph.Edge<?>> collection = vertex5.getEdges();
            for (MGraph.Edge<?> edge : collection) {
                MGraph.Edge.Direction direction = edge.getDirection();
                if (direction == MGraph.Edge.Direction.HORIZONTAL) {
                    ++n;
                    continue;
                }
                ++n2;
            }
            if (n == 1 && n2 == 1) {
                if (vertex2 != null) continue;
                vertex2 = vertex5;
                continue;
            }
            if (n == 1 && n2 == 0 && this.direction == MGraph.Edge.Direction.HORIZONTAL || n == 0 && n2 == 1 && this.direction == MGraph.Edge.Direction.VERTICAL) {
                if (vertex3 != null) continue;
                vertex3 = vertex5;
                continue;
            }
            if ((n != 1 || n2 != 0) && (n != 0 || n2 != 1)) continue;
            vertex4 = vertex5;
        }
        if (vertex2 != null) {
            return vertex2;
        }
        if (vertex3 != null) {
            return vertex3;
        }
        if (vertex4 != null) {
            return vertex4;
        }
        return null;
    }

    public void computeTopologicalNumbering() {
        int n = 0;
        if (this.or.getCornerVertex() != null) {
            n = -1;
        }
        Bar bar = this.bars.get(0);
        bar.setNumber(n);
        for (Bar bar2 : this.bars) {
            if (bar2 == bar) continue;
            int n2 = this.computeLongestPathLength(bar, bar2);
            bar2.setNumber(n2 + n);
        }
    }

    private int computeLongestPathLength(Bar bar, Bar bar2) {
        if (bar == bar2) {
            return 0;
        }
        int n = -1;
        for (Bar bar3 : bar.getNeighbors()) {
            int n2;
            if (bar3.equals(bar) || (n2 = this.computeLongestPathLength(bar3, bar2)) == -1 || ++n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public String toString() {
        String string = (Object)((Object)this.direction) + " Graph:\n";
        for (Bar bar : this.getBars()) {
            string = string + bar;
        }
        return string;
    }

    public static class Bar
    implements Comparable<Object> {
        private Collection<MGraph.Vertex<?>> vertices;
        private Collection<Bar> neighbors;
        private MGraph.Edge.Direction direction;
        private int number;

        public Bar(MGraph.Edge.Direction direction) {
            this.direction = direction;
            this.vertices = new ArrayList();
            this.neighbors = new HashSet<Bar>();
        }

        public void addVertex(MGraph.Vertex<?> vertex) {
            this.vertices.add(vertex);
            Dimension dimension = vertex.getSize();
            this.checkMaximumSize(dimension);
        }

        private void checkMaximumSize(Dimension dimension) {
            if (this.direction.equals((Object)MGraph.Edge.Direction.HORIZONTAL)) {
                // empty if block
            }
        }

        public void resolveGrid() {
        }

        public Collection<MGraph.Vertex<?>> getVertices() {
            return this.vertices;
        }

        public void addNeighbor(Bar bar) {
            this.neighbors.add(bar);
        }

        public Collection<Bar> getNeighbors() {
            return this.neighbors;
        }

        public void setNumber(int n) {
            this.number = n;
        }

        public int getNumber() {
            return this.number;
        }

        public String toString() {
            String string = "\t" + (Object)((Object)this.direction) + " Bar:\n";
            string = string + "\t\tNumber = " + this.number + "\n";
            string = string + "\t\tVertices:\n";
            for (MGraph.Vertex<?> object : this.vertices) {
                string = string + "\t\t\t" + object + "\n";
            }
            string = string + "\t\tNeighbors =" + this.neighbors.size() + "\n";
            for (Bar bar : this.neighbors) {
                string = string + "\t\t\t Bar " + bar.getNumber() + "\n";
            }
            return string;
        }

        @Override
        public int compareTo(Object object) {
            if (!(object instanceof Bar)) {
                return 0;
            }
            Bar bar = (Bar)object;
            return this.number > bar.getNumber() ? 1 : -1;
        }
    }
}

