﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bcm-pricing-calculator/model/HistoricalUsageEntity.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace BCMPricingCalculator {
namespace Model {

HistoricalUsageEntity::HistoricalUsageEntity(JsonView jsonValue) { *this = jsonValue; }

HistoricalUsageEntity& HistoricalUsageEntity::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("serviceCode")) {
    m_serviceCode = jsonValue.GetString("serviceCode");
    m_serviceCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("usageType")) {
    m_usageType = jsonValue.GetString("usageType");
    m_usageTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("operation")) {
    m_operation = jsonValue.GetString("operation");
    m_operationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("location")) {
    m_location = jsonValue.GetString("location");
    m_locationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("usageAccountId")) {
    m_usageAccountId = jsonValue.GetString("usageAccountId");
    m_usageAccountIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("billInterval")) {
    m_billInterval = jsonValue.GetObject("billInterval");
    m_billIntervalHasBeenSet = true;
  }
  if (jsonValue.ValueExists("filterExpression")) {
    m_filterExpression = jsonValue.GetObject("filterExpression");
    m_filterExpressionHasBeenSet = true;
  }
  return *this;
}

JsonValue HistoricalUsageEntity::Jsonize() const {
  JsonValue payload;

  if (m_serviceCodeHasBeenSet) {
    payload.WithString("serviceCode", m_serviceCode);
  }

  if (m_usageTypeHasBeenSet) {
    payload.WithString("usageType", m_usageType);
  }

  if (m_operationHasBeenSet) {
    payload.WithString("operation", m_operation);
  }

  if (m_locationHasBeenSet) {
    payload.WithString("location", m_location);
  }

  if (m_usageAccountIdHasBeenSet) {
    payload.WithString("usageAccountId", m_usageAccountId);
  }

  if (m_billIntervalHasBeenSet) {
    payload.WithObject("billInterval", m_billInterval.Jsonize());
  }

  if (m_filterExpressionHasBeenSet) {
    payload.WithObject("filterExpression", m_filterExpression.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace BCMPricingCalculator
}  // namespace Aws
