﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-agent-runtime/BedrockAgentRuntime_EXPORTS.h>
#include <aws/bedrock-agent-runtime/model/Metadata.h>
#include <aws/bedrock-agent-runtime/model/RawResponse.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace BedrockAgentRuntime {
namespace Model {

/**
 * <p>Invocation output from a routing classifier model.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-agent-runtime-2023-07-26/RoutingClassifierModelInvocationOutput">AWS
 * API Reference</a></p>
 */
class RoutingClassifierModelInvocationOutput {
 public:
  AWS_BEDROCKAGENTRUNTIME_API RoutingClassifierModelInvocationOutput() = default;
  AWS_BEDROCKAGENTRUNTIME_API RoutingClassifierModelInvocationOutput(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API RoutingClassifierModelInvocationOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCKAGENTRUNTIME_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The invocation's trace ID.</p>
   */
  inline const Aws::String& GetTraceId() const { return m_traceId; }
  inline bool TraceIdHasBeenSet() const { return m_traceIdHasBeenSet; }
  template <typename TraceIdT = Aws::String>
  void SetTraceId(TraceIdT&& value) {
    m_traceIdHasBeenSet = true;
    m_traceId = std::forward<TraceIdT>(value);
  }
  template <typename TraceIdT = Aws::String>
  RoutingClassifierModelInvocationOutput& WithTraceId(TraceIdT&& value) {
    SetTraceId(std::forward<TraceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's raw response.</p>
   */
  inline const RawResponse& GetRawResponse() const { return m_rawResponse; }
  inline bool RawResponseHasBeenSet() const { return m_rawResponseHasBeenSet; }
  template <typename RawResponseT = RawResponse>
  void SetRawResponse(RawResponseT&& value) {
    m_rawResponseHasBeenSet = true;
    m_rawResponse = std::forward<RawResponseT>(value);
  }
  template <typename RawResponseT = RawResponse>
  RoutingClassifierModelInvocationOutput& WithRawResponse(RawResponseT&& value) {
    SetRawResponse(std::forward<RawResponseT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The invocation's metadata.</p>
   */
  inline const Metadata& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Metadata>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Metadata>
  RoutingClassifierModelInvocationOutput& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_traceId;
  bool m_traceIdHasBeenSet = false;

  RawResponse m_rawResponse;
  bool m_rawResponseHasBeenSet = false;

  Metadata m_metadata;
  bool m_metadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace BedrockAgentRuntime
}  // namespace Aws
