//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// An XML element
    ///
    /// Note: Trying to add a document, namespace, attribute, or node with a parent throws an exception. To add a node with a parent first detach or create a copy of it.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmlelement?language=objc)
    #[unsafe(super(NSXMLNode, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSXMLNode")]
    pub struct NSXMLElement;
);

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
unsafe impl NSCopying for NSXMLElement {}

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
unsafe impl CopyingHelper for NSXMLElement {
    type Result = Self;
}

#[cfg(feature = "NSXMLNode")]
unsafe impl NSObjectProtocol for NSXMLElement {}

#[cfg(feature = "NSXMLNode")]
impl NSXMLElement {
    extern_methods!(
        #[cfg(feature = "NSString")]
        /// Returns an element
        /// <tt>
        /// <
        /// name>
        /// <
        /// /name>
        /// </tt>
        /// .
        #[unsafe(method(initWithName:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName(this: Allocated<Self>, name: &NSString) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        /// Returns an element whose full QName is specified.
        #[unsafe(method(initWithName:URI:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_URI(
            this: Allocated<Self>,
            name: &NSString,
            uri: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        /// Returns an element with a single text node child
        /// <tt>
        /// <
        /// name>string
        /// <
        /// /name>
        /// </tt>
        /// .
        #[unsafe(method(initWithName:stringValue:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithName_stringValue(
            this: Allocated<Self>,
            name: &NSString,
            string: Option<&NSString>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSError", feature = "NSString"))]
        /// Returns an element created from a string. Parse errors are collected in
        /// <tt>
        /// error
        /// </tt>
        /// .
        #[unsafe(method(initWithXMLString:error:_))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithXMLString_error(
            this: Allocated<Self>,
            string: &NSString,
        ) -> Result<Retained<Self>, Retained<NSError>>;

        #[cfg(feature = "NSXMLNodeOptions")]
        #[unsafe(method(initWithKind:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithKind_options(
            this: Allocated<Self>,
            kind: NSXMLNodeKind,
            options: NSXMLNodeOptions,
        ) -> Retained<Self>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        /// Returns all of the child elements that match this name.
        #[unsafe(method(elementsForName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementsForName(&self, name: &NSString) -> Retained<NSArray<NSXMLElement>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        /// Returns all of the child elements that match this localname URI pair.
        #[unsafe(method(elementsForLocalName:URI:))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementsForLocalName_URI(
            &self,
            local_name: &NSString,
            uri: Option<&NSString>,
        ) -> Retained<NSArray<NSXMLElement>>;

        /// Adds an attribute. Attributes with duplicate names are not added.
        #[unsafe(method(addAttribute:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addAttribute(&self, attribute: &NSXMLNode);

        #[cfg(feature = "NSString")]
        /// Removes an attribute based on its name.
        #[unsafe(method(removeAttributeForName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAttributeForName(&self, name: &NSString);

        #[cfg(feature = "NSArray")]
        /// Set the attributes. In the case of duplicate names, the first attribute with the name is used.
        #[unsafe(method(attributes))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributes(&self) -> Option<Retained<NSArray<NSXMLNode>>>;

        #[cfg(feature = "NSArray")]
        /// Setter for [`attributes`][Self::attributes].
        #[unsafe(method(setAttributes:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributes(&self, attributes: Option<&NSArray<NSXMLNode>>);

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        /// Set the attributes based on a name-value dictionary.
        #[unsafe(method(setAttributesWithDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributesWithDictionary(
            &self,
            attributes: &NSDictionary<NSString, NSString>,
        );

        #[cfg(feature = "NSString")]
        /// Returns an attribute matching this name.
        #[unsafe(method(attributeForName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributeForName(&self, name: &NSString) -> Option<Retained<NSXMLNode>>;

        #[cfg(feature = "NSString")]
        /// Returns an attribute matching this localname URI pair.
        #[unsafe(method(attributeForLocalName:URI:))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributeForLocalName_URI(
            &self,
            local_name: &NSString,
            uri: Option<&NSString>,
        ) -> Option<Retained<NSXMLNode>>;

        /// Adds a namespace. Namespaces with duplicate names are not added.
        #[unsafe(method(addNamespace:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addNamespace(&self, a_namespace: &NSXMLNode);

        #[cfg(feature = "NSString")]
        /// Removes a namespace with a particular name.
        #[unsafe(method(removeNamespaceForPrefix:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeNamespaceForPrefix(&self, name: &NSString);

        #[cfg(feature = "NSArray")]
        /// Set the namespaces. In the case of duplicate names, the first namespace with the name is used.
        #[unsafe(method(namespaces))]
        #[unsafe(method_family = none)]
        pub unsafe fn namespaces(&self) -> Option<Retained<NSArray<NSXMLNode>>>;

        #[cfg(feature = "NSArray")]
        /// Setter for [`namespaces`][Self::namespaces].
        #[unsafe(method(setNamespaces:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNamespaces(&self, namespaces: Option<&NSArray<NSXMLNode>>);

        #[cfg(feature = "NSString")]
        /// Returns the namespace matching this prefix.
        #[unsafe(method(namespaceForPrefix:))]
        #[unsafe(method_family = none)]
        pub unsafe fn namespaceForPrefix(&self, name: &NSString) -> Option<Retained<NSXMLNode>>;

        #[cfg(feature = "NSString")]
        /// Returns the namespace who matches the prefix of the name given. Looks in the entire namespace chain.
        #[unsafe(method(resolveNamespaceForName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resolveNamespaceForName(
            &self,
            name: &NSString,
        ) -> Option<Retained<NSXMLNode>>;

        #[cfg(feature = "NSString")]
        /// Returns the URI of this prefix. Looks in the entire namespace chain.
        #[unsafe(method(resolvePrefixForNamespaceURI:))]
        #[unsafe(method_family = none)]
        pub unsafe fn resolvePrefixForNamespaceURI(
            &self,
            namespace_uri: &NSString,
        ) -> Option<Retained<NSString>>;

        /// Inserts a child at a particular index.
        #[unsafe(method(insertChild:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertChild_atIndex(&self, child: &NSXMLNode, index: NSUInteger);

        #[cfg(feature = "NSArray")]
        /// Insert several children at a particular index.
        #[unsafe(method(insertChildren:atIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn insertChildren_atIndex(
            &self,
            children: &NSArray<NSXMLNode>,
            index: NSUInteger,
        );

        /// Removes a child at a particular index.
        #[unsafe(method(removeChildAtIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeChildAtIndex(&self, index: NSUInteger);

        #[cfg(feature = "NSArray")]
        /// Removes all existing children and replaces them with the new children. Set children to nil to simply remove all children.
        #[unsafe(method(setChildren:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setChildren(&self, children: Option<&NSArray<NSXMLNode>>);

        /// Adds a child to the end of the existing children.
        #[unsafe(method(addChild:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addChild(&self, child: &NSXMLNode);

        /// Replaces a child at a particular index with another child.
        #[unsafe(method(replaceChildAtIndex:withNode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceChildAtIndex_withNode(&self, index: NSUInteger, node: &NSXMLNode);

        /// Adjacent text nodes are coalesced. If the node's value is the empty string, it is removed. This should be called with a value of NO before using XQuery or XPath.
        #[unsafe(method(normalizeAdjacentTextNodesPreservingCDATA:))]
        #[unsafe(method_family = none)]
        pub unsafe fn normalizeAdjacentTextNodesPreservingCDATA(&self, preserve: bool);
    );
}

/// Methods declared on superclass `NSXMLNode`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLElement {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Invokes
        ///
        /// ```text
        ///  initWithKind:options:
        /// ```
        ///
        /// with options set to NSXMLNodeOptionsNone
        #[unsafe(method(initWithKind:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithKind(this: Allocated<Self>, kind: NSXMLNodeKind) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLElement {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

/// NSDeprecated.
#[cfg(feature = "NSXMLNode")]
impl NSXMLElement {
    extern_methods!(
        #[cfg(feature = "NSDictionary")]
        /// Set the attributes base on a name-value dictionary.
        ///
        /// This method is deprecated and does not function correctly. Use -setAttributesWithDictionary: instead.
        #[deprecated]
        #[unsafe(method(setAttributesAsDictionary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributesAsDictionary(&self, attributes: &NSDictionary);
    );
}
