package RMITYPESHelper;

# ************************************************************
# Description   : Command helper for OSPL rmipp generated files. Required
#                 because it's basically the idlpp output file naming convention
#                 (which was complicated enough) but multiplied by two, with extras,
#                 because you apparently can't *ever* have too many generated files.
#
#                 The command helper factory get() method converts the define
#                 custom type provided to uppercase, removes the '_FILES' portion
#                 and adds 'Helper' to the end.  If a module is found matching
#                 that name, it will be used to assist the ProjectCreator
#                 in determining which output files will be generated by
#                 the command given the file name and command options.
#                 This therefore is the helper for the OpenSplice
#                 RMITypes_Files entries in .mpc files.
# $Id:$
# ************************************************************

use strict;
use File::Basename;
# RedHat EL 4/5 uses perl 5.8.x/Getopt::Long v2.34/5
# Redhat EL 6 uses perl 5.10/Getopt::Long >= v2.36 which is
# earliest GetOptionsFromString is available...
#use Getopt::Long qw(GetOptionsFromString);
use Getopt::Long;

## Got to spec this override because this tool does its
## options in a funky way with single '-' on long options
Getopt::Long::Configure ("bundling_override");
Getopt::Long::Configure ("pass_through");

my $dcps_types_helper;

# ... (see above) so we have to roll our own 'GetOptionsFromString'
sub _GetOptionsFromString(@) {
    my ($string) = shift;
    require Text::ParseWords;
    my @temp=@ARGV;
    @ARGV = Text::ParseWords::shellwords($string);
    my $ret = GetOptions(@_);
    my @args=@ARGV;
    @ARGV=@temp;
    return ( $ret, \@args );
}

sub new {
  my $class = shift;
  return bless {}, $class;
}

sub get_output {
  ## This method is called with the filename and command options and
  ## expects an array reference containing filenames that will be
  ## generated, but can not be described using the normal Define_Custom
  ## syntax.
  my ($self, $types_idl_file, $rmipp_args)  = @_;
  my $original_idl_file = "$types_idl_file";

  ## Remove file name extension from the IDL file
  $types_idl_file =~ s/\.[^\.]+$//;
  my $base;
  my @filenames;

  ## Correctly deal with pre filename and directories if they exist
  if ($types_idl_file =~ /(.*[\/\\])([^\/\\]+)$/) {
      ## Split off the base name of the file.
      $base = $2;
  }
  else {
      $base = $types_idl_file;
  }

  ## Need to know what to generate now
  my $language = '';
  my $output_dir = '';
  my $topics_file = '';
  my $left_over_args = '';
  my $ret = '';
  ($ret, $left_over_args) = _GetOptionsFromString($rmipp_args,
                                                'd=s' => \$output_dir,
                                                'l=s' => \$language,
                                                'topics=s' => \$topics_file);

  my $idlpp_dir_out = '';
  if ($output_dir ne '')
  {
    $idlpp_dir_out = "-d $output_dir";
    if ($output_dir !~ /\/$/ )
    {
        $output_dir = "$output_dir/";
    }
  }

  if (uc($language) eq 'CPP' || uc($language) eq 'C++')
  {
    push @filenames, "$output_dir$base" . "_Interface.cpp";
    push @filenames, "$output_dir$base" . "_Interface.h";
    require "TYPESUPPORTHelper.pm";
    $dcps_types_helper = TYPESUPPORTHelper->new() unless defined $dcps_types_helper;
    push @filenames, @{$dcps_types_helper->get_output($original_idl_file, "-l cpp -S $idlpp_dir_out")};
    push @filenames, @{$dcps_types_helper->get_output("$base" . "_Topics.idl", "-l cpp -S $idlpp_dir_out")};
    # push @filenames, "$output_dir/$base" . "_Topics.idl";
  }
  return \@filenames;
}

sub get_outputexts {
  ## This method is expected to return an array reference containing the
  ## extensions for files returned by the get_output() method.  They will
  ## be used as regular expressions so regular expression characters
  ## (such as '.', '[', ']', etc.) must be escaped.  This can be done by
  ## calling $self->Parser::escape_regex_special($str);
  my $self = shift;
  my @exts = ($self->Parser::escape_regex_special(".cpp"),
              $self->Parser::escape_regex_special(".idl"),
           $self->Parser::escape_regex_special(".h"));
  return \@exts;
}

sub get_tied {
  ## This method is called with a file name and an array reference of
  ## files.  The first expected return value is an array reference of those
  ## files listed in the passed array reference that are in some way tied
  ## to the file name passed in.  The second is a component name to help
  ## MPC figure out a way to tie the files together.  The result of "tied"
  ## files is that they may be compiled after the file name passed in.
  return [], undef;
}

1;
