/*
 *                         Vortex OpenSplice
 *
 *   This software and documentation are Copyright 2006 to TO_YEAR ADLINK
 *   Technology Limited, its affiliated companies and licensors. All rights
 *   reserved.
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
#ifndef OSPL_ORG_OPENSPLICE_CORE_DETAIL_MODULE_DOCS_HPP_
#define OSPL_ORG_OPENSPLICE_CORE_DETAIL_MODULE_DOCS_HPP_

/**
 * @file
 * This file exists only to be fed to doxygen. There is quite
 * literally nothing else to see here.
 */

/**
 * @addtogroup isocpp_streams ISO/IEC C++ Streams API for DDS Data-centric Publish-Subscribe (DCPS)
 */
/** @{*/
/** @dir dds */
/** @}*/

/**
 * @addtogroup isocpp_streams_domain Domain Module - ::dds::streams::domain
 * @ingroup isocpp_streams */
/** @{*/
/** @dir dds/streams/domain */
/** @}*/


/**
 * @addtogroup isocpp_streams_topic Topic Module- ::dds::streams::topic
 * @ingroup isocpp_streams */
/** @{*/
/** @dir dds/streams/topic */
/** @}*/

/**
 * @addtogroup isocpp_streams_pub Publication Module - ::dds::streams::pub
 * @ingroup isocpp_streams */
/** @{*/
/** @dir dds/streams/pub */
/** @}*/


/**
 * @addtogroup isocpp_streams_sub Subscription Module - ::dds::streams::sub
 * @ingroup isocpp_streams */
/** @{*/
/** @dir dds/streams/sub */
/** @}*/

/**
 * @addtogroup isocpp_streams_core Core / Common Module - ::dds::streams::core
 * @ingroup isocpp_streams */
/** @{*/
/** @dir dds/streams/core */
/** @}*/

/**
 * @addtogroup examplesstreamsisocpp ISO/IEC C++ Streams DCPS PSM Examples
 */
/** @{*/
/** @dir examples/common */
/** @}*/

/**
 * @ingroup isocpp_streams
 */
namespace dds
{
namespace streams
{
/**
 * @ingroup isocpp_streams_pub
 * @ingroup isocpp_streams */
namespace pub
{
/** @ingroup isocpp_streams_pub
 * @ingroup isocpp_streams */
namespace qos
{
namespace detail {}
}
namespace detail {}
}
/**
 * @ingroup isocpp_streams_sub
 * @ingroup isocpp_streams */
namespace sub
{
/** @ingroup isocpp_streams_sub
 * @ingroup isocpp_streams */
namespace cond
{
namespace detail {}
}
/** @ingroup isocpp_streams_sub
 * @ingroup isocpp_streams */
namespace functors
{
namespace detail {}
}
/** @ingroup isocpp_streams_sub
 * @ingroup isocpp_streams */
namespace qos
{
namespace detail {}
}
}
/**
 * @ingroup isocpp_streams_core
 * @ingroup isocpp_streams */
namespace core
{
/** @ingroup isocpp_streams_core
 * @ingroup isocpp_streams */
namespace policy
{
namespace detail {}
}
}
}
}

#endif /* OSPL_ORG_OPENSPLICE_CORE_DETAIL_MODULE_DOCS_HPP_ */
