


#include <config.h>

#include "ephy-type-builtins.h"


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-link.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-link.h"
GType
ephy_link_flags_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _ephy_link_flags_values[] = {
      { EPHY_LINK_NEW_WINDOW, "EPHY_LINK_NEW_WINDOW", "new-window" },
      { EPHY_LINK_NEW_TAB, "EPHY_LINK_NEW_TAB", "new-tab" },
      { EPHY_LINK_JUMP_TO, "EPHY_LINK_JUMP_TO", "jump-to" },
      { EPHY_LINK_NEW_TAB_APPEND_AFTER, "EPHY_LINK_NEW_TAB_APPEND_AFTER", "new-tab-append-after" },
      { EPHY_LINK_HOME_PAGE, "EPHY_LINK_HOME_PAGE", "home-page" },
      { EPHY_LINK_TYPED, "EPHY_LINK_TYPED", "typed" },
      { EPHY_LINK_BOOKMARK, "EPHY_LINK_BOOKMARK", "bookmark" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("EphyLinkFlags", _ephy_link_flags_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-session.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-session.h"
GType
ephy_session_command_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_session_command_values[] = {
      { EPHY_SESSION_CMD_LAST, "EPHY_SESSION_CMD_LAST", "last" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphySessionCommand", _ephy_session_command_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-shell.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-shell.h"
GType
ephy_new_tab_flags_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _ephy_new_tab_flags_values[] = {
      { EPHY_NEW_TAB_HOME_PAGE, "EPHY_NEW_TAB_HOME_PAGE", "home-page" },
      { EPHY_NEW_TAB_NEW_PAGE, "EPHY_NEW_TAB_NEW_PAGE", "new-page" },
      { EPHY_NEW_TAB_OPEN_PAGE, "EPHY_NEW_TAB_OPEN_PAGE", "open-page" },
      { EPHY_NEW_TAB_DELAYED_OPEN_PAGE, "EPHY_NEW_TAB_DELAYED_OPEN_PAGE", "delayed-open-page" },
      { EPHY_NEW_TAB_FULLSCREEN_MODE, "EPHY_NEW_TAB_FULLSCREEN_MODE", "fullscreen-mode" },
      { EPHY_NEW_TAB_DONT_SHOW_WINDOW, "EPHY_NEW_TAB_DONT_SHOW_WINDOW", "dont-show-window" },
      { EPHY_NEW_TAB_PRESENT_WINDOW, "EPHY_NEW_TAB_PRESENT_WINDOW", "present-window" },
      { EPHY_NEW_TAB_FIRST, "EPHY_NEW_TAB_FIRST", "first" },
      { EPHY_NEW_TAB_APPEND_LAST, "EPHY_NEW_TAB_APPEND_LAST", "append-last" },
      { EPHY_NEW_TAB_APPEND_AFTER, "EPHY_NEW_TAB_APPEND_AFTER", "append-after" },
      { EPHY_NEW_TAB_JUMP, "EPHY_NEW_TAB_JUMP", "jump" },
      { EPHY_NEW_TAB_IN_NEW_WINDOW, "EPHY_NEW_TAB_IN_NEW_WINDOW", "in-new-window" },
      { EPHY_NEW_TAB_IN_EXISTING_WINDOW, "EPHY_NEW_TAB_IN_EXISTING_WINDOW", "in-existing-window" },
      { EPHY_NEW_TAB_FROM_EXTERNAL, "EPHY_NEW_TAB_FROM_EXTERNAL", "from-external" },
      { EPHY_NEW_TAB_DONT_COPY_HISTORY, "EPHY_NEW_TAB_DONT_COPY_HISTORY", "dont-copy-history" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("EphyNewTabFlags", _ephy_new_tab_flags_values);
  }

  return type;
}

GType
ephy_startup_flags_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _ephy_startup_flags_values[] = {
      { EPHY_STARTUP_NEW_TAB, "EPHY_STARTUP_NEW_TAB", "tab" },
      { EPHY_STARTUP_NEW_WINDOW, "EPHY_STARTUP_NEW_WINDOW", "window" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("EphyStartupFlags", _ephy_startup_flags_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-navigation-history-action.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/ephy-navigation-history-action.h"
GType
ephy_navigation_history_direction_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GEnumValue _ephy_navigation_history_direction_values[] = {
      { EPHY_NAVIGATION_HISTORY_DIRECTION_BACK, "EPHY_NAVIGATION_HISTORY_DIRECTION_BACK", "back" },
      { EPHY_NAVIGATION_HISTORY_DIRECTION_FORWARD, "EPHY_NAVIGATION_HISTORY_DIRECTION_FORWARD", "forward" },
      { 0, NULL, NULL }
    };

    type = g_enum_register_static ("EphyNavigationHistoryDirection", _ephy_navigation_history_direction_values);
  }

  return type;
}


/* enumerations from "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/pdm-dialog.h" */
#include "/usr/src/ports/epiphany/epiphany-3.8.2-3.i686/src/epiphany-3.8.2/src/pdm-dialog.h"
GType
pdm_clear_all_dialog_flags_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
  {
    static const GFlagsValue _pdm_clear_all_dialog_flags_values[] = {
      { CLEAR_ALL_NONE, "CLEAR_ALL_NONE", "none" },
      { CLEAR_ALL_CACHE, "CLEAR_ALL_CACHE", "cache" },
      { CLEAR_ALL_PASSWORDS, "CLEAR_ALL_PASSWORDS", "passwords" },
      { CLEAR_ALL_HISTORY, "CLEAR_ALL_HISTORY", "history" },
      { CLEAR_ALL_COOKIES, "CLEAR_ALL_COOKIES", "cookies" },
      { 0, NULL, NULL }
    };

    type = g_flags_register_static ("PdmClearAllDialogFlags", _pdm_clear_all_dialog_flags_values);
  }

  return type;
}




