/* helper.c generated by valac 0.36.4, the Vala compiler
 * generated from helper.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include "backends/vala/libvalashared.h"
#include <gee.h>
#include <gio/gio.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_HELPER (helper_get_type ())
#define HELPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELPER, Helper))
#define HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELPER, HelperClass))
#define IS_HELPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELPER))
#define IS_HELPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELPER))
#define HELPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELPER, HelperClass))

typedef struct _Helper Helper;
typedef struct _HelperClass HelperClass;
typedef struct _HelperPrivate HelperPrivate;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PARSER_OPTIONS (parser_options_get_type ())
typedef struct _ParserOptions ParserOptions;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define TYPE_DIAGNOSTICS (diagnostics_get_type ())
#define DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIAGNOSTICS, Diagnostics))
#define DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIAGNOSTICS, DiagnosticsClass))
#define IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIAGNOSTICS))
#define IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIAGNOSTICS))
#define DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIAGNOSTICS, DiagnosticsClass))

typedef struct _Diagnostics Diagnostics;
typedef struct _DiagnosticsClass DiagnosticsClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_OpenDocument_free0(var) ((var == NULL) ? NULL : (var = (_vala_OpenDocument_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ParamSpecHelper ParamSpecHelper;

struct _Helper {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HelperPrivate * priv;
};

struct _HelperClass {
	GTypeClass parent_class;
	void (*finalize) (Helper *self);
};

struct _ParserOptions {
	ValaCodeContext* context;
	gboolean fatal_warnings;
};

struct _ParamSpecHelper {
	GParamSpec parent_instance;
};


static gpointer helper_parent_class = NULL;

gpointer helper_ref (gpointer instance);
void helper_unref (gpointer instance);
GParamSpec* param_spec_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_helper (GValue* value, gpointer v_object);
void value_take_helper (GValue* value, gpointer v_object);
gpointer value_get_helper (const GValue* value);
GType helper_get_type (void) G_GNUC_CONST;
enum  {
	HELPER_DUMMY_PROPERTY
};
static void helper_add_to_context (ValaCodeContext* context, const gchar* path, const gchar* data_path);
GType parser_options_get_type (void) G_GNUC_CONST;
ParserOptions* parser_options_dup (const ParserOptions* self);
void parser_options_free (ParserOptions* self);
void parser_options_copy (const ParserOptions* self, ParserOptions* dest);
void parser_options_destroy (ParserOptions* self);
static gboolean helper_has_errors (ParserOptions* opts);
static void helper_parse (ParserOptions* opts);
static void helper_extract_diagnostics (ParserOptions* opts, RpcDocument* docs, int docs_length1);
GType diagnostics_get_type (void) G_GNUC_CONST;
Diagnostic* diagnostics_diagnostics_for_path (Diagnostics* self, const gchar* path, int* result_length1);
static void _vala_Diagnostic_array_free (Diagnostic * array, gint array_length);
static void helper_create_context (RpcParse* parse, RpcDocument** rpcdocs, int* rpcdocs_length1, ParserOptions* result);
void option_parser_parse_and_apply (const gchar* wd, gchar** args, int args_length1, ParserOptions* result);
gchar** option_parser_real_sources (const gchar* wd, int* result_length1);
static guint _hash_utils_file_hash_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _hash_utils_file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static OpenDocument* _open_document_dup (OpenDocument* self);
static void _vala_OpenDocument_free (OpenDocument* self);
static void _vala_array_add2 (RpcDocument* * array, int* length, int* size, const RpcDocument* value);
static RpcDocument* _vala_array_dup2 (RpcDocument* self, int length);
static void _vala_RpcDocument_array_free (RpcDocument * array, gint array_length);
static void helper_run (RpcParse* cmd, RpcReply* result);
static RpcDocument* _vala_array_dup3 (RpcDocument* self, int length);
static guint8* helper_read_all (int* result_length1);
static void _vala_array_add3 (guint8* * array, int* length, int* size, guint8 value);
void helper_main (gchar** args, int args_length1);
static GVariant* _variant_new1 (RpcParse value);
static void _variant_get2 (GVariant* value, RpcParse * result);
static GVariant* _variant_new3 (RpcReply value);
Helper* helper_new (void);
Helper* helper_construct (GType object_type);
static void helper_finalize (Helper * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void helper_add_to_context (ValaCodeContext* context, const gchar* path, const gchar* data_path) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSourceFile* sf = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp8_;
	ValaSourceFile* _tmp32_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (context != NULL);
	g_return_if_fail (path != NULL);
	_tmp1_ = data_path;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = data_path;
		_tmp3_ = path;
		_tmp0_ = g_strcmp0 (_tmp2_, _tmp3_) == 0;
	}
	if (_tmp0_) {
		ValaCodeContext* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = context;
		_tmp5_ = path;
		vala_code_context_add_source_filename (_tmp4_, _tmp5_, FALSE, FALSE);
		return;
	}
	sf = NULL;
	_tmp7_ = path;
	_tmp8_ = g_str_has_suffix (_tmp7_, ".vala");
	if (_tmp8_) {
		_tmp6_ = TRUE;
	} else {
		const gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = path;
		_tmp10_ = g_str_has_suffix (_tmp9_, ".gs");
		_tmp6_ = _tmp10_;
	}
	if (_tmp6_) {
		ValaCodeContext* _tmp11_;
		const gchar* _tmp12_;
		ValaSourceFile* _tmp13_;
		ValaUsingDirective* nsref = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaUsingDirective* _tmp16_;
		ValaUsingDirective* _tmp17_;
		ValaSourceFile* _tmp18_;
		ValaUsingDirective* _tmp19_;
		ValaCodeContext* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaUsingDirective* _tmp23_;
		_tmp11_ = context;
		_tmp12_ = path;
		_tmp13_ = vala_source_file_new (_tmp11_, VALA_SOURCE_FILE_TYPE_SOURCE, _tmp12_, NULL, FALSE);
		_vala_source_file_unref0 (sf);
		sf = _tmp13_;
		_tmp14_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_using_directive_new ((ValaSymbol*) _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		_vala_code_node_unref0 (_tmp15_);
		nsref = _tmp17_;
		_tmp18_ = sf;
		_tmp19_ = nsref;
		vala_source_file_add_using_directive (_tmp18_, _tmp19_);
		_tmp20_ = context;
		_tmp21_ = vala_code_context_get_root (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = nsref;
		vala_namespace_add_using_directive (_tmp22_, _tmp23_);
		_vala_code_node_unref0 (nsref);
	} else {
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_;
		gboolean _tmp26_;
		_tmp25_ = path;
		_tmp26_ = g_str_has_suffix (_tmp25_, ".vapi");
		if (_tmp26_) {
			_tmp24_ = TRUE;
		} else {
			const gchar* _tmp27_;
			gboolean _tmp28_;
			_tmp27_ = path;
			_tmp28_ = g_str_has_suffix (_tmp27_, ".gir");
			_tmp24_ = _tmp28_;
		}
		if (_tmp24_) {
			ValaCodeContext* _tmp29_;
			const gchar* _tmp30_;
			ValaSourceFile* _tmp31_;
			_tmp29_ = context;
			_tmp30_ = path;
			_tmp31_ = vala_source_file_new (_tmp29_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp30_, NULL, FALSE);
			_vala_source_file_unref0 (sf);
			sf = _tmp31_;
		}
	}
	_tmp32_ = sf;
	if (_tmp32_ != NULL) {
		ValaCodeContext* _tmp37_;
		ValaSourceFile* _tmp38_;
		{
			gchar* c = NULL;
			const gchar* _tmp33_;
			gchar* _tmp34_ = NULL;
			ValaSourceFile* _tmp35_;
			const gchar* _tmp36_;
			_tmp33_ = data_path;
			g_file_get_contents (_tmp33_, &_tmp34_, NULL, &_inner_error_);
			_g_free0 (c);
			c = _tmp34_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (c);
				goto __catch1_g_error;
			}
			_tmp35_ = sf;
			_tmp36_ = c;
			vala_source_file_set_content (_tmp35_, _tmp36_);
			_g_free0 (c);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_vala_source_file_unref0 (sf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp37_ = context;
		_tmp38_ = sf;
		vala_code_context_add_source_file (_tmp37_, _tmp38_);
	}
	_vala_source_file_unref0 (sf);
}


static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


static gboolean helper_has_errors (ParserOptions* opts) {
	gboolean result = FALSE;
	ValaCodeContext* c = NULL;
	ParserOptions _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaCodeContext* _tmp4_;
	ValaReport* _tmp5_;
	ValaReport* _tmp6_;
	gint _tmp7_;
	g_return_val_if_fail (opts != NULL, FALSE);
	_tmp0_ = *opts;
	_tmp1_ = _tmp0_.context;
	_tmp2_ = _vala_code_context_ref0 (_tmp1_);
	c = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_code_context_get_report (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_report_get_errors (_tmp6_);
	if (_tmp7_ > 0) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		ParserOptions _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = *opts;
		_tmp10_ = _tmp9_.fatal_warnings;
		if (_tmp10_) {
			ValaCodeContext* _tmp11_;
			ValaReport* _tmp12_;
			ValaReport* _tmp13_;
			gint _tmp14_;
			_tmp11_ = c;
			_tmp12_ = vala_code_context_get_report (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_report_get_warnings (_tmp13_);
			_tmp8_ = _tmp14_ > 0;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp3_ = _tmp8_;
	}
	result = _tmp3_;
	_vala_code_context_unref0 (c);
	return result;
}


static void helper_parse (ParserOptions* opts) {
	ParserOptions _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaParser* parser = NULL;
	ValaParser* _tmp2_;
	ValaParser* _tmp3_;
	ParserOptions _tmp4_;
	ValaCodeContext* _tmp5_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp6_;
	ValaGenieParser* _tmp7_;
	ParserOptions _tmp8_;
	ValaCodeContext* _tmp9_;
	ParserOptions _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (opts != NULL);
	_tmp0_ = *opts;
	_tmp1_ = _tmp0_.context;
	vala_code_context_push (_tmp1_);
	_tmp2_ = vala_parser_new ();
	parser = _tmp2_;
	_tmp3_ = parser;
	_tmp4_ = *opts;
	_tmp5_ = _tmp4_.context;
	vala_parser_parse (_tmp3_, _tmp5_);
	_tmp6_ = vala_genie_parser_new ();
	genie_parser = _tmp6_;
	_tmp7_ = genie_parser;
	_tmp8_ = *opts;
	_tmp9_ = _tmp8_.context;
	vala_genie_parser_parse (_tmp7_, _tmp9_);
	_tmp10_ = *opts;
	_tmp11_ = helper_has_errors (&_tmp10_);
	if (!_tmp11_) {
		ParserOptions _tmp12_;
		ValaCodeContext* _tmp13_;
		_tmp12_ = *opts;
		_tmp13_ = _tmp12_.context;
		vala_code_context_check (_tmp13_);
	}
	vala_code_context_pop ();
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_Diagnostic_array_free (Diagnostic * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			diagnostic_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void helper_extract_diagnostics (ParserOptions* opts, RpcDocument* docs, int docs_length1) {
	Diagnostics* d = NULL;
	ParserOptions _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	Diagnostics* _tmp4_;
	g_return_if_fail (opts != NULL);
	_tmp0_ = *opts;
	_tmp1_ = _tmp0_.context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_DIAGNOSTICS) ? ((Diagnostics*) _tmp3_) : NULL);
	d = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				RpcDocument* _tmp8_;
				gint _tmp8__length1;
				RpcDocument* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				Diagnostics* _tmp11_;
				RpcDocument* _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				RpcDocument _tmp14_;
				const gchar* _tmp15_;
				gint _tmp16_;
				Diagnostic* _tmp17_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = docs;
				_tmp8__length1 = docs_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = docs;
				_tmp9__length1 = docs_length1;
				_tmp10_ = i;
				_tmp11_ = d;
				_tmp12_ = docs;
				_tmp12__length1 = docs_length1;
				_tmp13_ = i;
				_tmp14_ = _tmp12_[_tmp13_];
				_tmp15_ = _tmp14_.path;
				_tmp17_ = diagnostics_diagnostics_for_path (_tmp11_, _tmp15_, &_tmp16_);
				_tmp9_[_tmp10_].diagnostics = (_vala_Diagnostic_array_free (_tmp9_[_tmp10_].diagnostics, _tmp9_[_tmp10_].diagnostics_length1), NULL);
				_tmp9_[_tmp10_].diagnostics = _tmp17_;
				_tmp9_[_tmp10_].diagnostics_length1 = _tmp16_;
			}
		}
	}
	_g_object_unref0 (d);
}


static guint _hash_utils_file_hash_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = hash_utils_file_hash ((GFile*) v);
	return result;
}


static gboolean _hash_utils_file_equal_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = hash_utils_file_equal ((GFile*) a, (GFile*) b);
	return result;
}


static OpenDocument* _open_document_dup (OpenDocument* self) {
	OpenDocument* dup;
	dup = g_new0 (OpenDocument, 1);
	open_document_copy (self, dup);
	return dup;
}


static void _vala_OpenDocument_free (OpenDocument* self) {
	open_document_destroy (self);
	g_free (self);
}


static void _vala_array_add2 (RpcDocument* * array, int* length, int* size, const RpcDocument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (RpcDocument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static RpcDocument* _vala_array_dup2 (RpcDocument* self, int length) {
	RpcDocument* result;
	int i;
	result = g_new0 (RpcDocument, length);
	for (i = 0; i < length; i++) {
		RpcDocument _tmp0_ = {0};
		rpc_document_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_RpcDocument_array_free (RpcDocument * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			rpc_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void helper_create_context (RpcParse* parse, RpcDocument** rpcdocs, int* rpcdocs_length1, ParserOptions* result) {
	RpcDocument* _vala_rpcdocs = NULL;
	int _vala_rpcdocs_length1 = 0;
	ParserOptions opts = {0};
	RpcParse _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	ParserOptions _tmp2_ = {0};
	gchar** sources = NULL;
	gint _tmp3_;
	gchar** _tmp4_;
	gint sources_length1;
	gint _sources_size_;
	ValaCodeContext* c = NULL;
	ParserOptions _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaCodeContext* _tmp7_;
	ValaCodeContext* _tmp8_;
	GeeHashMap* docs = NULL;
	GeeHashMap* _tmp9_;
	RpcDocument* retdocs = NULL;
	RpcDocument* _tmp10_;
	gint retdocs_length1;
	gint _retdocs_size_;
	RpcParse _tmp11_;
	OpenDocument* _tmp12_;
	gint _tmp12__length1;
	gchar** _tmp20_;
	gint _tmp20__length1;
	RpcDocument* _tmp40_;
	gint _tmp40__length1;
	RpcDocument* _tmp41_;
	gint _tmp41__length1;
	g_return_if_fail (parse != NULL);
	_tmp0_ = *parse;
	_tmp1_ = _tmp0_.args;
	_tmp1__length1 = _tmp0_.args_length1;
	option_parser_parse_and_apply (".", _tmp1_, _tmp1__length1, &_tmp2_);
	opts = _tmp2_;
	_tmp4_ = option_parser_real_sources (".", &_tmp3_);
	sources = _tmp4_;
	sources_length1 = _tmp3_;
	_sources_size_ = sources_length1;
	_tmp5_ = opts;
	_tmp6_ = _tmp5_.context;
	_tmp7_ = _vala_code_context_ref0 (_tmp6_);
	c = _tmp7_;
	_tmp8_ = c;
	vala_code_context_push (_tmp8_);
	_tmp9_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_OPEN_DOCUMENT, (GBoxedCopyFunc) _open_document_dup, (GDestroyNotify) _vala_OpenDocument_free, _hash_utils_file_hash_gee_hash_data_func, NULL, NULL, _hash_utils_file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	docs = _tmp9_;
	_tmp10_ = g_new0 (RpcDocument, 0);
	retdocs = _tmp10_;
	retdocs_length1 = 0;
	_retdocs_size_ = retdocs_length1;
	_tmp11_ = *parse;
	_tmp12_ = _tmp11_.documents;
	_tmp12__length1 = _tmp11_.documents_length1;
	{
		OpenDocument* doc_collection = NULL;
		gint doc_collection_length1 = 0;
		gint _doc_collection_size_ = 0;
		gint doc_it = 0;
		doc_collection = _tmp12_;
		doc_collection_length1 = _tmp12__length1;
		for (doc_it = 0; doc_it < _tmp12__length1; doc_it = doc_it + 1) {
			OpenDocument _tmp13_ = {0};
			OpenDocument doc = {0};
			open_document_copy (&doc_collection[doc_it], &_tmp13_);
			doc = _tmp13_;
			{
				GFile* f = NULL;
				OpenDocument _tmp14_;
				const gchar* _tmp15_;
				GFile* _tmp16_;
				GeeHashMap* _tmp17_;
				GFile* _tmp18_;
				OpenDocument _tmp19_;
				_tmp14_ = doc;
				_tmp15_ = _tmp14_.path;
				_tmp16_ = g_file_new_for_path (_tmp15_);
				f = _tmp16_;
				_tmp17_ = docs;
				_tmp18_ = f;
				_tmp19_ = doc;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, _tmp18_, &_tmp19_);
				_g_object_unref0 (f);
				open_document_destroy (&doc);
			}
		}
	}
	_tmp20_ = sources;
	_tmp20__length1 = sources_length1;
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp20_;
		source_collection_length1 = _tmp20__length1;
		for (source_it = 0; source_it < _tmp20__length1; source_it = source_it + 1) {
			gchar* _tmp21_;
			gchar* source = NULL;
			_tmp21_ = g_strdup (source_collection[source_it]);
			source = _tmp21_;
			{
				GFile* f = NULL;
				const gchar* _tmp22_;
				GFile* _tmp23_;
				OpenDocument* doc = NULL;
				GeeHashMap* _tmp24_;
				GFile* _tmp25_;
				gpointer _tmp26_;
				OpenDocument* _tmp27_;
				_tmp22_ = source;
				_tmp23_ = g_file_new_for_path (_tmp22_);
				f = _tmp23_;
				_tmp24_ = docs;
				_tmp25_ = f;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
				doc = (OpenDocument*) _tmp26_;
				_tmp27_ = doc;
				if (_tmp27_ != NULL) {
					ValaCodeContext* _tmp28_;
					OpenDocument* _tmp29_;
					const gchar* _tmp30_;
					OpenDocument* _tmp31_;
					const gchar* _tmp32_;
					RpcDocument* _tmp33_;
					gint _tmp33__length1;
					OpenDocument* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					RpcDocument _tmp37_ = {0};
					_tmp28_ = c;
					_tmp29_ = doc;
					_tmp30_ = (*_tmp29_).path;
					_tmp31_ = doc;
					_tmp32_ = (*_tmp31_).data_path;
					helper_add_to_context (_tmp28_, _tmp30_, _tmp32_);
					_tmp33_ = retdocs;
					_tmp33__length1 = retdocs_length1;
					_tmp34_ = doc;
					_tmp35_ = (*_tmp34_).path;
					_tmp36_ = g_strdup (_tmp35_);
					memset (&_tmp37_, 0, sizeof (RpcDocument));
					_g_free0 (_tmp37_.path);
					_tmp37_.path = _tmp36_;
					_vala_array_add2 (&retdocs, &retdocs_length1, &_retdocs_size_, &_tmp37_);
				} else {
					ValaCodeContext* _tmp38_;
					const gchar* _tmp39_;
					_tmp38_ = c;
					_tmp39_ = source;
					helper_add_to_context (_tmp38_, _tmp39_, NULL);
				}
				__vala_OpenDocument_free0 (doc);
				_g_object_unref0 (f);
				_g_free0 (source);
			}
		}
	}
	vala_code_context_pop ();
	_tmp40_ = retdocs;
	_tmp40__length1 = retdocs_length1;
	_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup2 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
	_tmp41__length1 = _tmp40__length1;
	_vala_rpcdocs = (_vala_RpcDocument_array_free (_vala_rpcdocs, _vala_rpcdocs_length1), NULL);
	_vala_rpcdocs = _tmp41_;
	_vala_rpcdocs_length1 = _tmp41__length1;
	*result = opts;
	retdocs = (_vala_RpcDocument_array_free (retdocs, retdocs_length1), NULL);
	_g_object_unref0 (docs);
	_vala_code_context_unref0 (c);
	sources = (_vala_array_free (sources, sources_length1, (GDestroyNotify) g_free), NULL);
	if (rpcdocs) {
		*rpcdocs = _vala_rpcdocs;
	} else {
		_vala_rpcdocs = (_vala_RpcDocument_array_free (_vala_rpcdocs, _vala_rpcdocs_length1), NULL);
	}
	if (rpcdocs_length1) {
		*rpcdocs_length1 = _vala_rpcdocs_length1;
	}
	return;
}


static RpcDocument* _vala_array_dup3 (RpcDocument* self, int length) {
	RpcDocument* result;
	int i;
	result = g_new0 (RpcDocument, length);
	for (i = 0; i < length; i++) {
		RpcDocument _tmp0_ = {0};
		rpc_document_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void helper_run (RpcParse* cmd, RpcReply* result) {
	RpcDocument* docs = NULL;
	gint docs_length1 = 0;
	gint _docs_size_ = 0;
	ParserOptions opts = {0};
	RpcParse _tmp0_;
	RpcDocument* _tmp1_ = NULL;
	gint _tmp2_;
	ParserOptions _tmp3_ = {0};
	ParserOptions _tmp4_;
	ParserOptions _tmp5_;
	RpcDocument* _tmp6_;
	gint _tmp6__length1;
	RpcReply _tmp7_ = {0};
	g_return_if_fail (cmd != NULL);
	_tmp0_ = *cmd;
	helper_create_context (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	docs = (_vala_RpcDocument_array_free (docs, docs_length1), NULL);
	docs = _tmp1_;
	docs_length1 = _tmp2_;
	_docs_size_ = docs_length1;
	opts = _tmp3_;
	_tmp4_ = opts;
	helper_parse (&_tmp4_);
	_tmp5_ = opts;
	helper_extract_diagnostics (&_tmp5_, docs, docs_length1);
	_tmp6_ = (docs != NULL) ? _vala_array_dup3 (docs, docs_length1) : ((gpointer) docs);
	_tmp6__length1 = docs_length1;
	memset (&_tmp7_, 0, sizeof (RpcReply));
	_tmp7_.documents = (_vala_RpcDocument_array_free (_tmp7_.documents, _tmp7_.documents_length1), NULL);
	_tmp7_.documents = _tmp6_;
	_tmp7_.documents_length1 = _tmp6__length1;
	*result = _tmp7_;
	parser_options_destroy (&opts);
	docs = (_vala_RpcDocument_array_free (docs, docs_length1), NULL);
	return;
}


static void _vala_array_add3 (guint8* * array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static guint8* helper_read_all (int* result_length1) {
	guint8* result = NULL;
	guint8* buffer = NULL;
	guint8* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* ret = NULL;
	guint8* _tmp1_;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp2_;
	guint8* _tmp16_;
	gint _tmp16__length1;
	_tmp0_ = g_new0 (guint8, 4096);
	buffer = _tmp0_;
	buffer_length1 = 4096;
	_buffer_size_ = buffer_length1;
	_tmp1_ = g_new0 (guint8, 4096);
	ret = _tmp1_;
	ret_length1 = 4096;
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	_tmp2_ = ret_length1;
	while (TRUE) {
		FILE* _tmp3_;
		gboolean _tmp4_;
		gsize n = 0UL;
		FILE* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		gsize _tmp7_;
		_tmp3_ = stdin;
		_tmp4_ = feof (_tmp3_);
		if (!(!_tmp4_)) {
			break;
		}
		_tmp5_ = stdin;
		_tmp6_ = buffer;
		_tmp6__length1 = buffer_length1;
		_tmp7_ = fread (_tmp6_, (gsize) 1, _tmp6__length1, _tmp5_);
		n = _tmp7_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gint _tmp10_;
					gsize _tmp11_;
					guint8* _tmp12_;
					gint _tmp12__length1;
					guint8* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					guint8 _tmp15_;
					if (!_tmp8_) {
						gint _tmp9_;
						_tmp9_ = i;
						i = _tmp9_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp10_ = i;
					_tmp11_ = n;
					if (!(((gsize) _tmp10_) < _tmp11_)) {
						break;
					}
					_tmp12_ = ret;
					_tmp12__length1 = ret_length1;
					_tmp13_ = buffer;
					_tmp13__length1 = buffer_length1;
					_tmp14_ = i;
					_tmp15_ = _tmp13_[_tmp14_];
					_vala_array_add3 (&ret, &ret_length1, &_ret_size_, _tmp15_);
				}
			}
		}
	}
	_tmp16_ = ret;
	_tmp16__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static GVariant* _variant_new1 (RpcParse value) {
	GVariantBuilder _tmp1_;
	gchar** _tmp2_;
	GVariantBuilder _tmp3_;
	int _tmp4_;
	OpenDocument* _tmp5_;
	GVariantBuilder _tmp6_;
	int _tmp7_;
	g_variant_builder_init (&_tmp1_, G_VARIANT_TYPE_TUPLE);
	_tmp2_ = value.args;
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("as"));
	for (_tmp4_ = 0; _tmp4_ < value.args_length1; _tmp4_++) {
		g_variant_builder_add_value (&_tmp3_, g_variant_new_string (*_tmp2_));
		_tmp2_++;
	}
	g_variant_builder_add_value (&_tmp1_, g_variant_builder_end (&_tmp3_));
	_tmp5_ = value.documents;
	g_variant_builder_init (&_tmp6_, G_VARIANT_TYPE ("a(ss)"));
	for (_tmp7_ = 0; _tmp7_ < value.documents_length1; _tmp7_++) {
		GVariantBuilder _tmp8_;
		g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp8_, g_variant_new_string ((*_tmp5_).path));
		g_variant_builder_add_value (&_tmp8_, g_variant_new_string ((*_tmp5_).data_path));
		g_variant_builder_add_value (&_tmp6_, g_variant_builder_end (&_tmp8_));
		_tmp5_++;
	}
	g_variant_builder_add_value (&_tmp1_, g_variant_builder_end (&_tmp6_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp1_));
}


static void _variant_get2 (GVariant* value, RpcParse * result) {
	RpcParse _tmp15_;
	GVariantIter _tmp16_;
	GVariant* _tmp17_;
	gchar** _tmp18_;
	int _tmp18__length;
	int _tmp18__size;
	int _tmp18__length1;
	GVariantIter _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	OpenDocument* _tmp22_;
	int _tmp22__length;
	int _tmp22__size;
	int _tmp22__length1;
	GVariantIter _tmp23_;
	GVariant* _tmp24_;
	g_variant_iter_init (&_tmp16_, value);
	_tmp17_ = g_variant_iter_next_value (&_tmp16_);
	_tmp18_ = g_new (gchar*, 5);
	_tmp18__length = 0;
	_tmp18__size = 4;
	_tmp18__length1 = 0;
	g_variant_iter_init (&_tmp19_, _tmp17_);
	for (; (_tmp20_ = g_variant_iter_next_value (&_tmp19_)) != NULL; _tmp18__length1++) {
		if (_tmp18__size == _tmp18__length) {
			_tmp18__size = 2 * _tmp18__size;
			_tmp18_ = g_renew (gchar*, _tmp18_, _tmp18__size + 1);
		}
		_tmp18_[_tmp18__length++] = g_variant_dup_string (_tmp20_, NULL);
		g_variant_unref (_tmp20_);
	}
	_tmp15_.args_length1 = _tmp18__length1;
	_tmp18_[_tmp18__length] = NULL;
	_tmp15_.args = _tmp18_;
	g_variant_unref (_tmp17_);
	_tmp21_ = g_variant_iter_next_value (&_tmp16_);
	_tmp22_ = g_new (OpenDocument, 5);
	_tmp22__length = 0;
	_tmp22__size = 4;
	_tmp22__length1 = 0;
	g_variant_iter_init (&_tmp23_, _tmp21_);
	for (; (_tmp24_ = g_variant_iter_next_value (&_tmp23_)) != NULL; _tmp22__length1++) {
		OpenDocument _tmp25_;
		GVariantIter _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		if (_tmp22__size == _tmp22__length) {
			_tmp22__size = 2 * _tmp22__size;
			_tmp22_ = g_renew (OpenDocument, _tmp22_, _tmp22__size + 1);
		}
		g_variant_iter_init (&_tmp26_, _tmp24_);
		_tmp27_ = g_variant_iter_next_value (&_tmp26_);
		_tmp25_.path = g_variant_dup_string (_tmp27_, NULL);
		g_variant_unref (_tmp27_);
		_tmp28_ = g_variant_iter_next_value (&_tmp26_);
		_tmp25_.data_path = g_variant_dup_string (_tmp28_, NULL);
		g_variant_unref (_tmp28_);
		_tmp22_[_tmp22__length++] = _tmp25_;
		g_variant_unref (_tmp24_);
	}
	_tmp15_.documents_length1 = _tmp22__length1;
	_tmp15_.documents = _tmp22_;
	g_variant_unref (_tmp21_);
	*result = _tmp15_;
}


static GVariant* _variant_new3 (RpcReply value) {
	GVariantBuilder _tmp32_;
	RpcDocument* _tmp33_;
	GVariantBuilder _tmp34_;
	int _tmp35_;
	g_variant_builder_init (&_tmp32_, G_VARIANT_TYPE_TUPLE);
	_tmp33_ = value.documents;
	g_variant_builder_init (&_tmp34_, G_VARIANT_TYPE ("a(sa(ua((x(xx)(xx))s)a(x(xx)(xx))s))"));
	for (_tmp35_ = 0; _tmp35_ < value.documents_length1; _tmp35_++) {
		GVariantBuilder _tmp36_;
		Diagnostic* _tmp37_;
		GVariantBuilder _tmp38_;
		int _tmp39_;
		g_variant_builder_init (&_tmp36_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp36_, g_variant_new_string ((*_tmp33_).path));
		_tmp37_ = (*_tmp33_).diagnostics;
		g_variant_builder_init (&_tmp38_, G_VARIANT_TYPE ("a(ua((x(xx)(xx))s)a(x(xx)(xx))s)"));
		for (_tmp39_ = 0; _tmp39_ < (*_tmp33_).diagnostics_length1; _tmp39_++) {
			GVariantBuilder _tmp40_;
			Fixit* _tmp41_;
			GVariantBuilder _tmp42_;
			int _tmp43_;
			SourceRange* _tmp48_;
			GVariantBuilder _tmp49_;
			int _tmp50_;
			g_variant_builder_init (&_tmp40_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp40_, g_variant_new_uint32 ((*_tmp37_).severity));
			_tmp41_ = (*_tmp37_).fixits;
			g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE ("a((x(xx)(xx))s)"));
			for (_tmp43_ = 0; _tmp43_ < (*_tmp37_).fixits_length1; _tmp43_++) {
				GVariantBuilder _tmp44_;
				GVariantBuilder _tmp45_;
				GVariantBuilder _tmp46_;
				GVariantBuilder _tmp47_;
				g_variant_builder_init (&_tmp44_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp45_, g_variant_new_int64 ((*_tmp41_).location.file));
				g_variant_builder_init (&_tmp46_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp46_, g_variant_new_int64 ((*_tmp41_).location.start.line));
				g_variant_builder_add_value (&_tmp46_, g_variant_new_int64 ((*_tmp41_).location.start.column));
				g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp46_));
				g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp47_, g_variant_new_int64 ((*_tmp41_).location.end.line));
				g_variant_builder_add_value (&_tmp47_, g_variant_new_int64 ((*_tmp41_).location.end.column));
				g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp47_));
				g_variant_builder_add_value (&_tmp44_, g_variant_builder_end (&_tmp45_));
				g_variant_builder_add_value (&_tmp44_, g_variant_new_string ((*_tmp41_).replacement));
				g_variant_builder_add_value (&_tmp42_, g_variant_builder_end (&_tmp44_));
				_tmp41_++;
			}
			g_variant_builder_add_value (&_tmp40_, g_variant_builder_end (&_tmp42_));
			_tmp48_ = (*_tmp37_).locations;
			g_variant_builder_init (&_tmp49_, G_VARIANT_TYPE ("a(x(xx)(xx))"));
			for (_tmp50_ = 0; _tmp50_ < (*_tmp37_).locations_length1; _tmp50_++) {
				GVariantBuilder _tmp51_;
				GVariantBuilder _tmp52_;
				GVariantBuilder _tmp53_;
				g_variant_builder_init (&_tmp51_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp51_, g_variant_new_int64 ((*_tmp48_).file));
				g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp52_, g_variant_new_int64 ((*_tmp48_).start.line));
				g_variant_builder_add_value (&_tmp52_, g_variant_new_int64 ((*_tmp48_).start.column));
				g_variant_builder_add_value (&_tmp51_, g_variant_builder_end (&_tmp52_));
				g_variant_builder_init (&_tmp53_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp53_, g_variant_new_int64 ((*_tmp48_).end.line));
				g_variant_builder_add_value (&_tmp53_, g_variant_new_int64 ((*_tmp48_).end.column));
				g_variant_builder_add_value (&_tmp51_, g_variant_builder_end (&_tmp53_));
				g_variant_builder_add_value (&_tmp49_, g_variant_builder_end (&_tmp51_));
				_tmp48_++;
			}
			g_variant_builder_add_value (&_tmp40_, g_variant_builder_end (&_tmp49_));
			g_variant_builder_add_value (&_tmp40_, g_variant_new_string ((*_tmp37_).message));
			g_variant_builder_add_value (&_tmp38_, g_variant_builder_end (&_tmp40_));
			_tmp37_++;
		}
		g_variant_builder_add_value (&_tmp36_, g_variant_builder_end (&_tmp38_));
		g_variant_builder_add_value (&_tmp34_, g_variant_builder_end (&_tmp36_));
		_tmp33_++;
	}
	g_variant_builder_add_value (&_tmp32_, g_variant_builder_end (&_tmp34_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp32_));
}


void helper_main (gchar** args, int args_length1) {
	RpcParse p = {0};
	GVariant* dummy = NULL;
	RpcParse _tmp0_;
	GVariant* _tmp9_;
	guint8* inp = NULL;
	gint _tmp10_;
	guint8* _tmp11_;
	gint inp_length1;
	gint _inp_size_;
	GVariant* parse = NULL;
	const GVariantType* _tmp12_;
	GVariant* _tmp13_;
	RpcParse _tmp14_;
	RpcReply reply = {0};
	RpcParse _tmp29_;
	RpcReply _tmp30_ = {0};
	GVariant* ret = NULL;
	RpcReply _tmp31_;
	GVariant* _tmp54_;
	guint8* data = NULL;
	gsize _tmp55_;
	guint8* _tmp56_;
	gint data_length1;
	gint _data_size_;
	FILE* _tmp57_;
	memset (&p, 0, sizeof (RpcParse));
	_tmp0_ = p;
	_tmp9_ = _variant_new1 (_tmp0_);
	dummy = _tmp9_;
	_tmp11_ = helper_read_all (&_tmp10_);
	inp = _tmp11_;
	inp_length1 = _tmp10_;
	_inp_size_ = inp_length1;
	_tmp12_ = g_variant_get_type (dummy);
	_tmp13_ = g_variant_new_from_data (_tmp12_, inp, inp_length1, TRUE, NULL, NULL);
	g_variant_ref_sink (_tmp13_);
	parse = _tmp13_;
	_variant_get2 (parse, &_tmp14_);
	rpc_parse_destroy (&p);
	p = _tmp14_;
	_tmp29_ = p;
	helper_run (&_tmp29_, &_tmp30_);
	reply = _tmp30_;
	_tmp31_ = reply;
	_tmp54_ = _variant_new3 (_tmp31_);
	ret = _tmp54_;
	_tmp55_ = g_variant_get_size (ret);
	_tmp56_ = g_new0 (guint8, (gint) _tmp55_);
	data = _tmp56_;
	data_length1 = (gint) _tmp55_;
	_data_size_ = data_length1;
	g_variant_store (ret, (void*) data);
	_tmp57_ = stdout;
	fwrite (data, (gsize) 1, data_length1, _tmp57_);
	data = (g_free (data), NULL);
	_g_variant_unref0 (ret);
	rpc_reply_destroy (&reply);
	_g_variant_unref0 (parse);
	inp = (g_free (inp), NULL);
	_g_variant_unref0 (dummy);
	rpc_parse_destroy (&p);
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	helper_main (argv, argc);
	return 0;
}


Helper* helper_construct (GType object_type) {
	Helper* self = NULL;
	self = (Helper*) g_type_create_instance (object_type);
	return self;
}


Helper* helper_new (void) {
	return helper_construct (TYPE_HELPER);
}


static void value_helper_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_helper_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		helper_unref (value->data[0].v_pointer);
	}
}


static void value_helper_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = helper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_helper_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_helper_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Helper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = helper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_helper_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Helper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = helper_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_helper (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecHelper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HELPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_helper (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HELPER), NULL);
	return value->data[0].v_pointer;
}


void value_set_helper (GValue* value, gpointer v_object) {
	Helper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		helper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		helper_unref (old);
	}
}


void value_take_helper (GValue* value, gpointer v_object) {
	Helper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HELPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HELPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		helper_unref (old);
	}
}


static void helper_class_init (HelperClass * klass) {
	helper_parent_class = g_type_class_peek_parent (klass);
	((HelperClass *) klass)->finalize = helper_finalize;
}


static void helper_instance_init (Helper * self) {
	self->ref_count = 1;
}


static void helper_finalize (Helper * obj) {
	Helper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HELPER, Helper);
	g_signal_handlers_destroy (self);
}


GType helper_get_type (void) {
	static volatile gsize helper_type_id__volatile = 0;
	if (g_once_init_enter (&helper_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_helper_init, value_helper_free_value, value_helper_copy_value, value_helper_peek_pointer, "p", value_helper_collect_value, "p", value_helper_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (HelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Helper), 0, (GInstanceInitFunc) helper_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType helper_type_id;
		helper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Helper", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&helper_type_id__volatile, helper_type_id);
	}
	return helper_type_id__volatile;
}


gpointer helper_ref (gpointer instance) {
	Helper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void helper_unref (gpointer instance) {
	Helper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HELPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



