/* FilterPage.c generated by valac 0.34.6, the Vala compiler
 * generated from FilterPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <glib/gi18n-lib.h>
#include "CbFilter.h"
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include <gio/gio.h>
#include <rest/rest-proxy-call.h>
#include <rest/rest-proxy.h>
#include <gdk/gdk.h>


#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_FILTER_PAGE (filter_page_get_type ())
#define FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_PAGE, FilterPage))
#define FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_PAGE, FilterPageClass))
#define IS_FILTER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_PAGE))
#define IS_FILTER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_PAGE))
#define FILTER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_PAGE, FilterPageClass))

typedef struct _FilterPage FilterPage;
typedef struct _FilterPageClass FilterPageClass;
typedef struct _FilterPagePrivate FilterPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block34Data Block34Data;

#define TYPE_ADD_LIST_ENTRY (add_list_entry_get_type ())
#define ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_LIST_ENTRY, AddListEntry))
#define ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_LIST_ENTRY, AddListEntryClass))
#define IS_ADD_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_LIST_ENTRY))
#define IS_ADD_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_LIST_ENTRY))
#define ADD_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_LIST_ENTRY, AddListEntryClass))

typedef struct _AddListEntry AddListEntry;
typedef struct _AddListEntryClass AddListEntryClass;

#define TYPE_MODIFY_FILTER_DIALOG (modify_filter_dialog_get_type ())
#define MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialog))
#define MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))
#define IS_MODIFY_FILTER_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MODIFY_FILTER_DIALOG))
#define IS_MODIFY_FILTER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MODIFY_FILTER_DIALOG))
#define MODIFY_FILTER_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MODIFY_FILTER_DIALOG, ModifyFilterDialogClass))

typedef struct _ModifyFilterDialog ModifyFilterDialog;
typedef struct _ModifyFilterDialogClass ModifyFilterDialogClass;

#define TYPE_FILTER_LIST_ENTRY (filter_list_entry_get_type ())
#define FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntry))
#define FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))
#define IS_FILTER_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER_LIST_ENTRY))
#define IS_FILTER_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER_LIST_ENTRY))
#define FILTER_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER_LIST_ENTRY, FilterListEntryClass))

typedef struct _FilterListEntry FilterListEntry;
typedef struct _FilterListEntryClass FilterListEntryClass;

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block35Data Block35Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

#define TYPE_USER_FILTER_ENTRY (user_filter_entry_get_type ())
#define USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntry))
#define USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))
#define IS_USER_FILTER_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_FILTER_ENTRY))
#define IS_USER_FILTER_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_FILTER_ENTRY))
#define USER_FILTER_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_FILTER_ENTRY, UserFilterEntryClass))

typedef struct _UserFilterEntry UserFilterEntry;
typedef struct _UserFilterEntryClass UserFilterEntryClass;
typedef struct _Block36Data Block36Data;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _UserFilterEntryPrivate UserFilterEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block37Data Block37Data;
typedef struct _Block38Data Block38Data;

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _FilterPage {
	GtkScrolledWindow parent_instance;
	FilterPagePrivate * priv;
	Account* account;
};

struct _FilterPageClass {
	GtkScrolledWindowClass parent_class;
};

struct _FilterPagePrivate {
	gint _id;
	MainWindow* main_window;
	BadgeRadioButton* radio_button;
	GtkListBox* filter_list;
	GtkListBox* user_list;
	GtkFrame* user_list_frame;
	GtkRevealer* user_list_revealer;
	gboolean filters_loaded;
	gboolean users_loaded;
};

struct _Block34Data {
	int _ref_count_;
	FilterPage* self;
	Account* account;
};

struct _Block35Data {
	int _ref_count_;
	FilterPage* self;
	Collect* collect_obj;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block36Data {
	int _ref_count_;
	FilterPage* self;
	UserFilterEntry* entry;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _UserFilterEntry {
	GtkListBoxRow parent_instance;
	UserFilterEntryPrivate * priv;
	gint64 user_id;
	gboolean muted;
	gboolean blocked;
};

struct _UserFilterEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _Block37Data {
	int _ref_count_;
	FilterPage* self;
	RestProxyCall* call;
};

struct _Block38Data {
	int _ref_count_;
	FilterPage* self;
	RestProxyCall* call;
};


static gpointer filter_page_parent_class = NULL;
static IPageIface* filter_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* filter_page_imessage_receiver_parent_iface = NULL;

GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType filter_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
#define FILTER_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_FILTER_PAGE, FilterPagePrivate))
enum  {
	FILTER_PAGE_DUMMY_PROPERTY,
	FILTER_PAGE_ID,
	FILTER_PAGE_WINDOW
};
FilterPage* filter_page_new (gint id, Account* account);
FilterPage* filter_page_construct (GType object_type, gint id, Account* account);
static Block34Data* block34_data_ref (Block34Data* _data34_);
static void block34_data_unref (void * _userdata_);
void ipage_set_id (IPage* self, gint value);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
AddListEntry* add_list_entry_new (const gchar* label);
AddListEntry* add_list_entry_construct (GType object_type, const gchar* label);
GType add_list_entry_get_type (void) G_GNUC_CONST;
static void __lambda121_ (Block34Data* _data34_, GtkListBoxRow* row);
GType modify_filter_dialog_get_type (void) G_GNUC_CONST;
ModifyFilterDialog* modify_filter_dialog_new (MainWindow* parent, Account* account, CbFilter* filter);
ModifyFilterDialog* modify_filter_dialog_construct (GType object_type, MainWindow* parent, Account* account, CbFilter* filter);
static void filter_page_filter_added_cb (FilterPage* self, CbFilter* f, gboolean created);
static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, CbFilter* filter, gboolean created, gpointer self);
GType filter_list_entry_get_type (void) G_GNUC_CONST;
CbFilter* filter_list_entry_get_filter (FilterListEntry* self);
static void ___lambda121__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void filter_page_real_on_join (IPage* base, gint page_id, Bundle* args);
GType collect_get_type (void) G_GNUC_CONST;
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
FilterListEntry* filter_list_entry_new (CbFilter* f, Account* account, MainWindow* main_window);
FilterListEntry* filter_list_entry_construct (GType object_type, CbFilter* f, Account* account, MainWindow* main_window);
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda123_ (FilterPage* self);
static void ___lambda123__collect_finished (Collect* _sender, GError* _error_, gpointer self);
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda124_ (Block35Data* _data35_, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
void collect_emit (Collect* self, GError* _error_);
static void __lambda125_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node);
static void filter_page_add_user (FilterPage* self, JsonObject* user_obj, gboolean muted);
static void ___lambda125__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda124__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda130_ (Block35Data* _data35_, GObject* _, GAsyncResult* res);
static void __lambda131_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda131__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda130__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void filter_list_entry_set_content (FilterListEntry* self, const gchar* value);
static void filter_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node);
static void filter_page_remove_user (FilterPage* self, gint64 id, gboolean muted);
GType user_filter_entry_get_type (void) G_GNUC_CONST;
static Block36Data* block36_data_ref (Block36Data* _data36_);
static void block36_data_unref (void * _userdata_);
GType itwitter_item_get_type (void) G_GNUC_CONST;
UserFilterEntry* user_filter_entry_new (void);
UserFilterEntry* user_filter_entry_construct (GType object_type);
void user_filter_entry_set_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_screen_name (UserFilterEntry* self, const gchar* value);
void user_filter_entry_set_avatar_url (UserFilterEntry* self, const gchar* value);
static void __lambda127_ (Block36Data* _data36_, gint64 id);
static void filter_page_unmute_user (FilterPage* self, gint64 id);
static void filter_page_unblock_user (FilterPage* self, gint64 id);
static void ___lambda127__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self);
static Block37Data* block37_data_ref (Block37Data* _data37_);
static void block37_data_unref (void * _userdata_);
static void __lambda129_ (Block37Data* _data37_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda129__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block38Data* block38_data_ref (Block38Data* _data38_);
static void block38_data_unref (void * _userdata_);
static void __lambda128_ (Block38Data* _data38_, GObject* o, GAsyncResult* res);
static void ___lambda128__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction);
static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static void filter_page_real_on_leave (IPage* base);
static void filter_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
static GtkRadioButton* filter_page_real_get_radio_button (IPage* base);
static gchar* filter_page_real_get_title (IPage* base);
static void filter_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block34Data* block34_data_ref (Block34Data* _data34_) {
	g_atomic_int_inc (&_data34_->_ref_count_);
	return _data34_;
}


static void block34_data_unref (void * _userdata_) {
	Block34Data* _data34_;
	_data34_ = (Block34Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data34_->_ref_count_)) {
		FilterPage* self;
		self = _data34_->self;
		_g_object_unref0 (_data34_->account);
		_g_object_unref0 (self);
		g_slice_free (Block34Data, _data34_);
	}
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static void _filter_page_filter_added_cb_modify_filter_dialog_filter_added (ModifyFilterDialog* _sender, CbFilter* filter, gboolean created, gpointer self) {
	filter_page_filter_added_cb ((FilterPage*) self, filter, created);
}


static void __lambda121_ (Block34Data* _data34_, GtkListBoxRow* row) {
	FilterPage* self;
	GtkListBoxRow* _tmp0_ = NULL;
	self = _data34_->self;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_ADD_LIST_ENTRY)) {
		ModifyFilterDialog* dialog = NULL;
		MainWindow* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		ModifyFilterDialog* _tmp3_ = NULL;
		ModifyFilterDialog* _tmp4_ = NULL;
		ModifyFilterDialog* _tmp5_ = NULL;
		_tmp1_ = self->priv->main_window;
		_tmp2_ = _data34_->account;
		_tmp3_ = modify_filter_dialog_new (_tmp1_, _tmp2_, NULL);
		g_object_ref_sink (_tmp3_);
		dialog = _tmp3_;
		_tmp4_ = dialog;
		g_signal_connect_object (_tmp4_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
		_tmp5_ = dialog;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (dialog);
	} else {
		GtkListBoxRow* _tmp6_ = NULL;
		_tmp6_ = row;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_FILTER_LIST_ENTRY)) {
			FilterListEntry* filter_row = NULL;
			GtkListBoxRow* _tmp7_ = NULL;
			FilterListEntry* _tmp8_ = NULL;
			ModifyFilterDialog* dialog = NULL;
			MainWindow* _tmp9_ = NULL;
			Account* _tmp10_ = NULL;
			FilterListEntry* _tmp11_ = NULL;
			CbFilter* _tmp12_ = NULL;
			CbFilter* _tmp13_ = NULL;
			ModifyFilterDialog* _tmp14_ = NULL;
			ModifyFilterDialog* _tmp15_ = NULL;
			ModifyFilterDialog* _tmp16_ = NULL;
			_tmp7_ = row;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
			filter_row = _tmp8_;
			_tmp9_ = self->priv->main_window;
			_tmp10_ = _data34_->account;
			_tmp11_ = filter_row;
			_tmp12_ = filter_list_entry_get_filter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = modify_filter_dialog_new (_tmp9_, _tmp10_, _tmp13_);
			g_object_ref_sink (_tmp14_);
			dialog = _tmp14_;
			_tmp15_ = dialog;
			g_signal_connect_object (_tmp15_, "filter-added", (GCallback) _filter_page_filter_added_cb_modify_filter_dialog_filter_added, self, 0);
			_tmp16_ = dialog;
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
			_g_object_unref0 (dialog);
			_g_object_unref0 (filter_row);
		}
	}
}


static void ___lambda121__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda121_ (self, row);
}


FilterPage* filter_page_construct (GType object_type, gint id, Account* account) {
	FilterPage * self = NULL;
	Block34Data* _data34_;
	Account* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Account* _tmp3_ = NULL;
	GtkListBox* _tmp4_ = NULL;
	GtkListBox* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	AddListEntry* _tmp7_ = NULL;
	AddListEntry* _tmp8_ = NULL;
	GtkListBox* _tmp9_ = NULL;
	GtkListBox* _tmp10_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_data34_ = g_slice_new0 (Block34Data);
	_data34_->_ref_count_ = 1;
	_tmp0_ = account;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data34_->account);
	_data34_->account = _tmp1_;
	self = (FilterPage*) g_object_new (object_type, NULL);
	_data34_->self = g_object_ref (self);
	_tmp2_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp2_);
	_tmp3_ = _data34_->account;
	self->account = _tmp3_;
	_tmp4_ = self->priv->filter_list;
	gtk_list_box_set_header_func (_tmp4_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp5_ = self->priv->filter_list;
	_tmp6_ = _ ("Add new Filter");
	_tmp7_ = add_list_entry_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->filter_list;
	g_signal_connect_data (_tmp9_, "row-activated", (GCallback) ___lambda121__gtk_list_box_row_activated, block34_data_ref (_data34_), (GClosureNotify) block34_data_unref, 0);
	_tmp10_ = self->priv->user_list;
	gtk_list_box_set_header_func (_tmp10_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	block34_data_unref (_data34_);
	_data34_ = NULL;
	return self;
}


FilterPage* filter_page_new (gint id, Account* account) {
	return filter_page_construct (TYPE_FILTER_PAGE, id, account);
}


static Block35Data* block35_data_ref (Block35Data* _data35_) {
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}


static void block35_data_unref (void * _userdata_) {
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		FilterPage* self;
		self = _data35_->self;
		_g_object_unref0 (_data35_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block35Data, _data35_);
	}
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static void __lambda123_ (FilterPage* self) {
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	_tmp0_ = self->priv->user_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = _tmp3_ > ((guint) 0);
	_g_list_free0 (_tmp2_);
	if (_tmp4_) {
		GtkFrame* _tmp5_ = NULL;
		GtkRevealer* _tmp6_ = NULL;
		_tmp5_ = self->priv->user_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
		_tmp6_ = self->priv->user_list_revealer;
		gtk_revealer_set_reveal_child (_tmp6_, TRUE);
	}
}


static void ___lambda123__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda123_ ((FilterPage*) self);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda125_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	filter_page_add_user (self, obj, FALSE);
	_json_object_unref0 (obj);
}


static void ___lambda125__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda125_ ((FilterPage*) self, array, index_, element_node);
}


static void __lambda124_ (Block35Data* _data35_, GObject* _, GAsyncResult* res) {
	FilterPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonArray* users = NULL;
	JsonNode* _tmp8_ = NULL;
	JsonObject* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	JsonArray* _tmp11_ = NULL;
	JsonArray* _tmp12_ = NULL;
	Collect* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data35_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch36_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("FilterPage.vala:101: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally36:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		Collect* _tmp7_ = NULL;
		_tmp7_ = _data35_->collect_obj;
		collect_emit (_tmp7_, NULL);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = json_object_get_array_member (_tmp9_, "users");
	_tmp11_ = _json_array_ref0 (_tmp10_);
	users = _tmp11_;
	_tmp12_ = users;
	json_array_foreach_element (_tmp12_, ___lambda125__json_array_foreach, self);
	_tmp13_ = _data35_->collect_obj;
	collect_emit (_tmp13_, NULL);
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda124__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda124_ (self, source_object, res);
	block35_data_unref (self);
}


static void __lambda131_ (FilterPage* self, JsonArray* arr, guint index, JsonNode* node) {
	JsonObject* obj = NULL;
	JsonNode* _tmp0_ = NULL;
	JsonObject* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	filter_page_add_user (self, obj, TRUE);
	_json_object_unref0 (obj);
}


static void ___lambda131__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda131_ ((FilterPage*) self, array, index_, element_node);
}


static void __lambda130_ (Block35Data* _data35_, GObject* _, GAsyncResult* res) {
	FilterPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonArray* users = NULL;
	JsonNode* _tmp8_ = NULL;
	JsonObject* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	JsonArray* _tmp11_ = NULL;
	JsonArray* _tmp12_ = NULL;
	Collect* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data35_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch37_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("FilterPage.vala:129: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally37:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		Collect* _tmp7_ = NULL;
		_tmp7_ = _data35_->collect_obj;
		collect_emit (_tmp7_, NULL);
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp8_ = root;
	_tmp9_ = json_node_get_object (_tmp8_);
	_tmp10_ = json_object_get_array_member (_tmp9_, "users");
	_tmp11_ = _json_array_ref0 (_tmp10_);
	users = _tmp11_;
	_tmp12_ = users;
	json_array_foreach_element (_tmp12_, ___lambda131__json_array_foreach, self);
	_tmp13_ = _data35_->collect_obj;
	collect_emit (_tmp13_, NULL);
	_json_array_unref0 (users);
	__vala_JsonNode_free0 (root);
}


static void ___lambda130__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda130_ (self, source_object, res);
	block35_data_unref (self);
}


static void filter_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	FilterPage * self;
	Block35Data* _data35_;
	gboolean _tmp0_ = FALSE;
	GNetworkMonitor* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	Collect* _tmp22_ = NULL;
	Collect* _tmp23_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp24_ = NULL;
	OAuthProxy* _tmp25_ = NULL;
	RestProxyCall* _tmp26_ = NULL;
	RestProxyCall* _tmp27_ = NULL;
	RestProxyCall* _tmp28_ = NULL;
	RestProxyCall* _tmp29_ = NULL;
	RestProxyCall* _tmp30_ = NULL;
	RestProxyCall* _tmp31_ = NULL;
	RestProxyCall* call2 = NULL;
	Account* _tmp32_ = NULL;
	OAuthProxy* _tmp33_ = NULL;
	RestProxyCall* _tmp34_ = NULL;
	RestProxyCall* _tmp35_ = NULL;
	RestProxyCall* _tmp36_ = NULL;
	RestProxyCall* _tmp37_ = NULL;
	RestProxyCall* _tmp38_ = NULL;
	RestProxyCall* _tmp39_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_data35_->self = g_object_ref (self);
	_tmp0_ = self->priv->filters_loaded;
	if (!_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					gint _tmp3_ = 0;
					Account* _tmp4_ = NULL;
					GPtrArray* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					CbFilter* f = NULL;
					Account* _tmp8_ = NULL;
					GPtrArray* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gconstpointer _tmp11_ = NULL;
					CbFilter* _tmp12_ = NULL;
					FilterListEntry* entry = NULL;
					CbFilter* _tmp13_ = NULL;
					Account* _tmp14_ = NULL;
					MainWindow* _tmp15_ = NULL;
					FilterListEntry* _tmp16_ = NULL;
					GtkListBox* _tmp17_ = NULL;
					FilterListEntry* _tmp18_ = NULL;
					if (!_tmp1_) {
						gint _tmp2_ = 0;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					_tmp3_ = i;
					_tmp4_ = self->account;
					_tmp5_ = _tmp4_->filters;
					_tmp6_ = g_ptr_array_get_length (_tmp5_);
					_tmp7_ = _tmp6_;
					if (!(_tmp3_ < _tmp7_)) {
						break;
					}
					_tmp8_ = self->account;
					_tmp9_ = _tmp8_->filters;
					_tmp10_ = i;
					_tmp11_ = g_ptr_array_index (_tmp9_, (guint) _tmp10_);
					_tmp12_ = _g_object_ref0 ((CbFilter*) _tmp11_);
					f = _tmp12_;
					_tmp13_ = f;
					_tmp14_ = self->account;
					_tmp15_ = self->priv->main_window;
					_tmp16_ = filter_list_entry_new (_tmp13_, _tmp14_, _tmp15_);
					g_object_ref_sink (_tmp16_);
					entry = _tmp16_;
					_tmp17_ = self->priv->filter_list;
					_tmp18_ = entry;
					gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
					_g_object_unref0 (entry);
					_g_object_unref0 (f);
				}
			}
		}
		self->priv->filters_loaded = TRUE;
	}
	_tmp19_ = g_network_monitor_get_default ();
	_tmp20_ = g_network_monitor_get_network_available (_tmp19_);
	if (!_tmp20_) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	_tmp21_ = self->priv->users_loaded;
	if (_tmp21_) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	self->priv->users_loaded = TRUE;
	_tmp22_ = collect_new (2);
	_data35_->collect_obj = _tmp22_;
	_tmp23_ = _data35_->collect_obj;
	g_signal_connect_object (_tmp23_, "finished", (GCallback) ___lambda123__collect_finished, self, 0);
	_tmp24_ = self->account;
	_tmp25_ = _tmp24_->proxy;
	_tmp26_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, rest_proxy_get_type (), RestProxy));
	call = _tmp26_;
	_tmp27_ = call;
	rest_proxy_call_set_function (_tmp27_, "1.1/blocks/list.json");
	_tmp28_ = call;
	rest_proxy_call_set_method (_tmp28_, "GET");
	_tmp29_ = call;
	rest_proxy_call_add_param (_tmp29_, "include_entities", "false");
	_tmp30_ = call;
	rest_proxy_call_add_param (_tmp30_, "skip_status", "true");
	_tmp31_ = call;
	tweet_utils_load_threaded (_tmp31_, NULL, ___lambda124__gasync_ready_callback, block35_data_ref (_data35_));
	_tmp32_ = self->account;
	_tmp33_ = _tmp32_->proxy;
	_tmp34_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, rest_proxy_get_type (), RestProxy));
	call2 = _tmp34_;
	_tmp35_ = call2;
	rest_proxy_call_set_function (_tmp35_, "1.1/mutes/users/list.json");
	_tmp36_ = call2;
	rest_proxy_call_set_method (_tmp36_, "GET");
	_tmp37_ = call2;
	rest_proxy_call_add_param (_tmp37_, "include_entities", "false");
	_tmp38_ = call2;
	rest_proxy_call_add_param (_tmp38_, "skip_status", "true");
	_tmp39_ = call2;
	tweet_utils_load_threaded (_tmp39_, NULL, ___lambda130__gasync_ready_callback, block35_data_ref (_data35_));
	_g_object_unref0 (call2);
	_g_object_unref0 (call);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}


/**
   * Called when the user adds a new Cb.Filter via the AddFilterDialog
   *
   **/
static void filter_page_filter_added_cb (FilterPage* self, CbFilter* f, gboolean created) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (CB_IS_FILTER (f));
	_tmp0_ = created;
	if (_tmp0_) {
		FilterListEntry* entry = NULL;
		CbFilter* _tmp1_ = NULL;
		Account* _tmp2_ = NULL;
		MainWindow* _tmp3_ = NULL;
		FilterListEntry* _tmp4_ = NULL;
		GtkListBox* _tmp5_ = NULL;
		FilterListEntry* _tmp6_ = NULL;
		_tmp1_ = f;
		_tmp2_ = self->account;
		_tmp3_ = self->priv->main_window;
		_tmp4_ = filter_list_entry_new (_tmp1_, _tmp2_, _tmp3_);
		g_object_ref_sink (_tmp4_);
		entry = _tmp4_;
		_tmp5_ = self->priv->filter_list;
		_tmp6_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (entry);
	} else {
		GList* children = NULL;
		GtkListBox* _tmp7_ = NULL;
		GList* _tmp8_ = NULL;
		GList* _tmp9_ = NULL;
		_tmp7_ = self->priv->filter_list;
		_tmp8_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer));
		children = _tmp8_;
		_tmp9_ = children;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp9_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp10_ = NULL;
				GtkWidget* w = NULL;
				_tmp10_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp10_;
				{
					GtkWidget* _tmp11_ = NULL;
					FilterListEntry* le = NULL;
					GtkWidget* _tmp12_ = NULL;
					FilterListEntry* _tmp13_ = NULL;
					FilterListEntry* _tmp14_ = NULL;
					CbFilter* _tmp15_ = NULL;
					CbFilter* _tmp16_ = NULL;
					gint _tmp17_ = 0;
					CbFilter* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					_tmp11_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_FILTER_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp12_ = w;
					_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_FILTER_LIST_ENTRY, FilterListEntry));
					le = _tmp13_;
					_tmp14_ = le;
					_tmp15_ = filter_list_entry_get_filter (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = cb_filter_get_id (_tmp16_);
					_tmp18_ = f;
					_tmp19_ = cb_filter_get_id (_tmp18_);
					if (_tmp17_ == _tmp19_) {
						FilterListEntry* _tmp20_ = NULL;
						CbFilter* _tmp21_ = NULL;
						const gchar* _tmp22_ = NULL;
						_tmp20_ = le;
						_tmp21_ = f;
						_tmp22_ = cb_filter_get_contents (_tmp21_);
						filter_list_entry_set_content (_tmp20_, _tmp22_);
						_g_object_unref0 (le);
						_g_object_unref0 (w);
						break;
					}
					_g_object_unref0 (le);
					_g_object_unref0 (w);
				}
			}
		}
		_g_list_free0 (children);
	}
}


static void filter_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root_node) {
	FilterPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail (root_node != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_EVENT_BLOCK) {
		JsonObject* obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		JsonObject* _tmp5_ = NULL;
		_tmp1_ = root_node;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = json_object_get_object_member (_tmp2_, "target");
		_tmp4_ = _json_object_ref0 (_tmp3_);
		obj = _tmp4_;
		_tmp5_ = obj;
		filter_page_add_user (self, _tmp5_, FALSE);
		_json_object_unref0 (obj);
	} else {
		StreamMessageType _tmp6_ = 0;
		_tmp6_ = type;
		if (_tmp6_ == STREAM_MESSAGE_TYPE_EVENT_UNBLOCK) {
			JsonObject* obj = NULL;
			JsonNode* _tmp7_ = NULL;
			JsonObject* _tmp8_ = NULL;
			JsonObject* _tmp9_ = NULL;
			JsonObject* _tmp10_ = NULL;
			gint64 user_id = 0LL;
			JsonObject* _tmp11_ = NULL;
			gint64 _tmp12_ = 0LL;
			gint64 _tmp13_ = 0LL;
			_tmp7_ = root_node;
			_tmp8_ = json_node_get_object (_tmp7_);
			_tmp9_ = json_object_get_object_member (_tmp8_, "target");
			_tmp10_ = _json_object_ref0 (_tmp9_);
			obj = _tmp10_;
			_tmp11_ = obj;
			_tmp12_ = json_object_get_int_member (_tmp11_, "id");
			user_id = _tmp12_;
			_tmp13_ = user_id;
			filter_page_remove_user (self, _tmp13_, FALSE);
			_json_object_unref0 (obj);
		} else {
			StreamMessageType _tmp14_ = 0;
			_tmp14_ = type;
			if (_tmp14_ == STREAM_MESSAGE_TYPE_EVENT_MUTE) {
				JsonObject* obj = NULL;
				JsonNode* _tmp15_ = NULL;
				JsonObject* _tmp16_ = NULL;
				JsonObject* _tmp17_ = NULL;
				JsonObject* _tmp18_ = NULL;
				JsonObject* _tmp19_ = NULL;
				_tmp15_ = root_node;
				_tmp16_ = json_node_get_object (_tmp15_);
				_tmp17_ = json_object_get_object_member (_tmp16_, "target");
				_tmp18_ = _json_object_ref0 (_tmp17_);
				obj = _tmp18_;
				_tmp19_ = obj;
				filter_page_add_user (self, _tmp19_, TRUE);
				_json_object_unref0 (obj);
			} else {
				StreamMessageType _tmp20_ = 0;
				_tmp20_ = type;
				if (_tmp20_ == STREAM_MESSAGE_TYPE_EVENT_UNMUTE) {
					JsonObject* obj = NULL;
					JsonNode* _tmp21_ = NULL;
					JsonObject* _tmp22_ = NULL;
					JsonObject* _tmp23_ = NULL;
					JsonObject* _tmp24_ = NULL;
					gint64 user_id = 0LL;
					JsonObject* _tmp25_ = NULL;
					gint64 _tmp26_ = 0LL;
					gint64 _tmp27_ = 0LL;
					_tmp21_ = root_node;
					_tmp22_ = json_node_get_object (_tmp21_);
					_tmp23_ = json_object_get_object_member (_tmp22_, "target");
					_tmp24_ = _json_object_ref0 (_tmp23_);
					obj = _tmp24_;
					_tmp25_ = obj;
					_tmp26_ = json_object_get_int_member (_tmp25_, "id");
					user_id = _tmp26_;
					_tmp27_ = user_id;
					filter_page_remove_user (self, _tmp27_, TRUE);
					_json_object_unref0 (obj);
				}
			}
		}
	}
}


static Block36Data* block36_data_ref (Block36Data* _data36_) {
	g_atomic_int_inc (&_data36_->_ref_count_);
	return _data36_;
}


static void block36_data_unref (void * _userdata_) {
	Block36Data* _data36_;
	_data36_ = (Block36Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data36_->_ref_count_)) {
		FilterPage* self;
		self = _data36_->self;
		_g_object_unref0 (_data36_->entry);
		_g_object_unref0 (self);
		g_slice_free (Block36Data, _data36_);
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch38_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally38;
	__catch38_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally38:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void __lambda127_ (Block36Data* _data36_, gint64 id) {
	FilterPage* self;
	UserFilterEntry* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	UserFilterEntry* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	self = _data36_->self;
	_tmp0_ = _data36_->entry;
	_tmp1_ = _tmp0_->muted;
	if (_tmp1_) {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = id;
		filter_page_unmute_user (self, _tmp2_);
	}
	_tmp3_ = _data36_->entry;
	_tmp4_ = _tmp3_->blocked;
	if (_tmp4_) {
		gint64 _tmp5_ = 0LL;
		_tmp5_ = id;
		filter_page_unblock_user (self, _tmp5_);
	}
}


static void ___lambda127__user_filter_entry_deleted (UserFilterEntry* _sender, gint64 id, gpointer self) {
	__lambda127_ (self, id);
}


static void filter_page_add_user (FilterPage* self, JsonObject* user_obj, gboolean muted) {
	Block36Data* _data36_;
	gint64 id = 0LL;
	JsonObject* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	GtkListBox* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gchar* avatar_url = NULL;
	JsonObject* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	UserFilterEntry* _tmp20_ = NULL;
	UserFilterEntry* _tmp21_ = NULL;
	gint64 _tmp22_ = 0LL;
	UserFilterEntry* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	UserFilterEntry* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	UserFilterEntry* _tmp27_ = NULL;
	JsonObject* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	UserFilterEntry* _tmp30_ = NULL;
	JsonObject* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	UserFilterEntry* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	UserFilterEntry* _tmp35_ = NULL;
	GtkListBox* _tmp36_ = NULL;
	UserFilterEntry* _tmp37_ = NULL;
	GtkFrame* _tmp38_ = NULL;
	g_return_if_fail (IS_FILTER_PAGE (self));
	g_return_if_fail (user_obj != NULL);
	_data36_ = g_slice_new0 (Block36Data);
	_data36_->_ref_count_ = 1;
	_data36_->self = g_object_ref (self);
	_tmp0_ = user_obj;
	_tmp1_ = json_object_get_int_member (_tmp0_, "id");
	id = _tmp1_;
	_tmp2_ = self->priv->user_list;
	_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp3_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp4_ = NULL;
			GtkWidget* w = NULL;
			_tmp4_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp4_;
			{
				GtkWidget* _tmp5_ = NULL;
				UserFilterEntry* ufe = NULL;
				GtkWidget* _tmp6_ = NULL;
				UserFilterEntry* _tmp7_ = NULL;
				UserFilterEntry* _tmp8_ = NULL;
				gint64 _tmp9_ = 0LL;
				gint64 _tmp10_ = 0LL;
				_tmp5_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_USER_FILTER_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp6_ = w;
				_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_USER_FILTER_ENTRY, UserFilterEntry));
				ufe = _tmp7_;
				_tmp8_ = ufe;
				_tmp9_ = _tmp8_->user_id;
				_tmp10_ = id;
				if (_tmp9_ == _tmp10_) {
					gboolean _tmp11_ = FALSE;
					_tmp11_ = muted;
					if (_tmp11_) {
						UserFilterEntry* _tmp12_ = NULL;
						_tmp12_ = ufe;
						_tmp12_->muted = TRUE;
					} else {
						UserFilterEntry* _tmp13_ = NULL;
						_tmp13_ = ufe;
						_tmp13_->blocked = TRUE;
					}
					_g_object_unref0 (ufe);
					_g_object_unref0 (w);
					_g_list_free0 (w_collection);
					block36_data_unref (_data36_);
					_data36_ = NULL;
					return;
				}
				_g_object_unref0 (ufe);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp14_ = user_obj;
	_tmp15_ = json_object_get_string_member (_tmp14_, "profile_image_url");
	_tmp16_ = g_strdup (_tmp15_);
	avatar_url = _tmp16_;
	_tmp17_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp17_ == 2) {
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp18_ = avatar_url;
		_tmp19_ = string_replace (_tmp18_, "_normal", "_bigger");
		_g_free0 (avatar_url);
		avatar_url = _tmp19_;
	}
	_tmp20_ = user_filter_entry_new ();
	g_object_ref_sink (_tmp20_);
	_data36_->entry = _tmp20_;
	_tmp21_ = _data36_->entry;
	_tmp22_ = id;
	_tmp21_->user_id = _tmp22_;
	_tmp23_ = _data36_->entry;
	_tmp24_ = muted;
	_tmp23_->muted = _tmp24_;
	_tmp25_ = _data36_->entry;
	_tmp26_ = muted;
	_tmp25_->blocked = !_tmp26_;
	_tmp27_ = _data36_->entry;
	_tmp28_ = user_obj;
	_tmp29_ = json_object_get_string_member (_tmp28_, "name");
	user_filter_entry_set_name (_tmp27_, _tmp29_);
	_tmp30_ = _data36_->entry;
	_tmp31_ = user_obj;
	_tmp32_ = json_object_get_string_member (_tmp31_, "screen_name");
	user_filter_entry_set_screen_name (_tmp30_, _tmp32_);
	_tmp33_ = _data36_->entry;
	_tmp34_ = avatar_url;
	user_filter_entry_set_avatar_url (_tmp33_, _tmp34_);
	_tmp35_ = _data36_->entry;
	g_signal_connect_data (_tmp35_, "deleted", (GCallback) ___lambda127__user_filter_entry_deleted, block36_data_ref (_data36_), (GClosureNotify) block36_data_unref, 0);
	_tmp36_ = self->priv->user_list;
	_tmp37_ = _data36_->entry;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget));
	_tmp38_ = self->priv->user_list_frame;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_widget_get_type (), GtkWidget));
	_g_free0 (avatar_url);
	block36_data_unref (_data36_);
	_data36_ = NULL;
}


static void filter_page_remove_user (FilterPage* self, gint64 id, gboolean muted) {
	GtkListBox* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GtkListBox* _tmp19_ = NULL;
	GList* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	guint _tmp22_ = 0U;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_tmp0_ = self->priv->user_list;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp1_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp2_ = NULL;
			GtkWidget* w = NULL;
			_tmp2_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp2_;
			{
				GtkWidget* _tmp3_ = NULL;
				UserFilterEntry* ufe = NULL;
				GtkWidget* _tmp4_ = NULL;
				UserFilterEntry* _tmp5_ = NULL;
				UserFilterEntry* _tmp6_ = NULL;
				gint64 _tmp7_ = 0LL;
				gint64 _tmp8_ = 0LL;
				_tmp3_ = w;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_USER_FILTER_ENTRY)) {
					_g_object_unref0 (w);
					continue;
				}
				_tmp4_ = w;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_USER_FILTER_ENTRY, UserFilterEntry));
				ufe = _tmp5_;
				_tmp6_ = ufe;
				_tmp7_ = _tmp6_->user_id;
				_tmp8_ = id;
				if (_tmp7_ == _tmp8_) {
					gboolean _tmp9_ = FALSE;
					gboolean _tmp12_ = FALSE;
					UserFilterEntry* _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					_tmp9_ = muted;
					if (_tmp9_) {
						UserFilterEntry* _tmp10_ = NULL;
						_tmp10_ = ufe;
						_tmp10_->muted = FALSE;
					} else {
						UserFilterEntry* _tmp11_ = NULL;
						_tmp11_ = ufe;
						_tmp11_->blocked = FALSE;
					}
					_tmp13_ = ufe;
					_tmp14_ = _tmp13_->blocked;
					if (!_tmp14_) {
						UserFilterEntry* _tmp15_ = NULL;
						gboolean _tmp16_ = FALSE;
						_tmp15_ = ufe;
						_tmp16_ = _tmp15_->muted;
						_tmp12_ = !_tmp16_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						GtkListBox* _tmp17_ = NULL;
						GtkWidget* _tmp18_ = NULL;
						_tmp17_ = self->priv->user_list;
						_tmp18_ = w;
						gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_container_get_type (), GtkContainer), _tmp18_);
					}
					_g_object_unref0 (ufe);
					_g_object_unref0 (w);
					break;
				}
				_g_object_unref0 (ufe);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp19_ = self->priv->user_list;
	_tmp20_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_container_get_type (), GtkContainer));
	_tmp21_ = _tmp20_;
	_tmp22_ = g_list_length (_tmp21_);
	_tmp23_ = _tmp22_ == ((guint) 0);
	_g_list_free0 (_tmp21_);
	if (_tmp23_) {
		GtkFrame* _tmp24_ = NULL;
		_tmp24_ = self->priv->user_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
	}
}


static Block37Data* block37_data_ref (Block37Data* _data37_) {
	g_atomic_int_inc (&_data37_->_ref_count_);
	return _data37_;
}


static void block37_data_unref (void * _userdata_) {
	Block37Data* _data37_;
	_data37_ = (Block37Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data37_->_ref_count_)) {
		FilterPage* self;
		self = _data37_->self;
		_g_object_unref0 (_data37_->call);
		_g_object_unref0 (self);
		g_slice_free (Block37Data, _data37_);
	}
}


static void __lambda129_ (Block37Data* _data37_, GObject* o, GAsyncResult* res) {
	FilterPage* self;
	GError * _inner_error_ = NULL;
	self = _data37_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data37_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch39_g_error;
		}
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data37_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 265, "FilterPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("FilterPage.vala:266: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally39:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda129__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda129_ (self, source_object, res);
	block37_data_unref (self);
}


static void filter_page_unblock_user (FilterPage* self, gint64 id) {
	Block37Data* _data37_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_data37_ = g_slice_new0 (Block37Data);
	_data37_->_ref_count_ = 1;
	_data37_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data37_->call = _tmp2_;
	rest_proxy_call_set_method (_data37_->call, "POST");
	rest_proxy_call_set_function (_data37_->call, "1.1/blocks/destroy.json");
	rest_proxy_call_add_param (_data37_->call, "include_entities", "false");
	rest_proxy_call_add_param (_data37_->call, "skip_status", "true");
	_tmp3_ = id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data37_->call, "user_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data37_->call, NULL, ___lambda129__gasync_ready_callback, block37_data_ref (_data37_));
	_tmp6_ = id;
	filter_page_remove_user (self, _tmp6_, FALSE);
	block37_data_unref (_data37_);
	_data37_ = NULL;
}


static Block38Data* block38_data_ref (Block38Data* _data38_) {
	g_atomic_int_inc (&_data38_->_ref_count_);
	return _data38_;
}


static void block38_data_unref (void * _userdata_) {
	Block38Data* _data38_;
	_data38_ = (Block38Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data38_->_ref_count_)) {
		FilterPage* self;
		self = _data38_->self;
		_g_object_unref0 (_data38_->call);
		_g_object_unref0 (self);
		g_slice_free (Block38Data, _data38_);
	}
}


static void __lambda128_ (Block38Data* _data38_, GObject* o, GAsyncResult* res) {
	FilterPage* self;
	GError * _inner_error_ = NULL;
	self = _data38_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data38_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch40_g_error;
		}
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data38_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 285, "FilterPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("FilterPage.vala:286: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally40:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda128__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda128_ (self, source_object, res);
	block38_data_unref (self);
}


static void filter_page_unmute_user (FilterPage* self, gint64 id) {
	Block38Data* _data38_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint64 _tmp6_ = 0LL;
	g_return_if_fail (IS_FILTER_PAGE (self));
	_data38_ = g_slice_new0 (Block38Data);
	_data38_->_ref_count_ = 1;
	_data38_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data38_->call = _tmp2_;
	rest_proxy_call_set_method (_data38_->call, "POST");
	rest_proxy_call_set_function (_data38_->call, "1.1/mutes/users/destroy.json");
	rest_proxy_call_add_param (_data38_->call, "include_entities", "false");
	rest_proxy_call_add_param (_data38_->call, "skip_status", "true");
	_tmp3_ = id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data38_->call, "user_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_invoke_async (_data38_->call, NULL, ___lambda128__gasync_ready_callback, block38_data_ref (_data38_));
	_tmp6_ = id;
	filter_page_remove_user (self, _tmp6_, TRUE);
	block38_data_unref (_data38_);
	_data38_ = NULL;
}


static gboolean filter_page_filter_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_ = 0;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_DOWN) {
		GtkListBox* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->user_list;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_ = NULL;
			GtkDirectionType _tmp5_ = 0;
			_tmp4_ = self->priv->user_list;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
		}
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_filter_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static gboolean filter_page_user_list_keynav_failed_cb (FilterPage* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_ = 0;
	g_return_val_if_fail (IS_FILTER_PAGE (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_ = NULL;
		GtkDirectionType _tmp2_ = 0;
		_tmp1_ = self->priv->filter_list;
		_tmp2_ = direction;
		gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp2_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = filter_page_user_list_keynav_failed_cb ((FilterPage*) self, direction);
	return result;
}


static void filter_page_real_on_leave (IPage* base) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
}


static void filter_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	FilterPage * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Filters");
	_tmp2_ = badge_radio_button_new (_tmp0_, "corebird-filter-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->radio_button);
	self->priv->radio_button = _tmp2_;
}


static GtkRadioButton* filter_page_real_get_radio_button (IPage* base) {
	FilterPage * self;
	GtkRadioButton* result = NULL;
	BadgeRadioButton* _tmp0_ = NULL;
	GtkRadioButton* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->radio_button;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_radio_button_get_type (), GtkRadioButton));
	result = _tmp1_;
	return result;
}


static gchar* filter_page_real_get_title (IPage* base) {
	FilterPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = _ ("Filters");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint filter_page_real_get_id (IPage* base) {
	gint result;
	FilterPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void filter_page_real_set_id (IPage* base, gint value) {
	FilterPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void filter_page_real_set_window (IPage* base, MainWindow* value) {
	FilterPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FILTER_PAGE, FilterPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void filter_page_class_init (FilterPageClass * klass) {
	gint FilterPage_private_offset;
	filter_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FilterPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_filter_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_filter_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = filter_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILTER_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	FilterPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/filter-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "filter_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, filter_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_frame", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_revealer", FALSE, FilterPage_private_offset + G_STRUCT_OFFSET (FilterPagePrivate, user_list_revealer));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "filter_list_keynav_failed_cb", G_CALLBACK(_filter_page_filter_list_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "user_list_keynav_failed_cb", G_CALLBACK(_filter_page_user_list_keynav_failed_cb_gtk_widget_keynav_failed));
}


static void filter_page_ipage_interface_init (IPageIface * iface) {
	filter_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) filter_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) filter_page_real_on_leave;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) filter_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) filter_page_real_get_radio_button;
	iface->get_title = (gchar* (*)(IPage*)) filter_page_real_get_title;
	iface->get_id = filter_page_real_get_id;
	iface->set_id = filter_page_real_set_id;
	iface->set_window = filter_page_real_set_window;
}


static void filter_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	filter_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) filter_page_real_stream_message_received;
}


static void filter_page_instance_init (FilterPage * self) {
	self->priv = FILTER_PAGE_GET_PRIVATE (self);
	self->priv->filters_loaded = FALSE;
	self->priv->users_loaded = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void filter_page_finalize (GObject* obj) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILTER_PAGE, FilterPage);
	_g_object_unref0 (self->priv->radio_button);
	_g_object_unref0 (self->priv->filter_list);
	_g_object_unref0 (self->priv->user_list);
	_g_object_unref0 (self->priv->user_list_frame);
	_g_object_unref0 (self->priv->user_list_revealer);
	G_OBJECT_CLASS (filter_page_parent_class)->finalize (obj);
}


GType filter_page_get_type (void) {
	static volatile gsize filter_page_type_id__volatile = 0;
	if (g_once_init_enter (&filter_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FilterPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) filter_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilterPage), 0, (GInstanceInitFunc) filter_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) filter_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) filter_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType filter_page_type_id;
		filter_page_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "FilterPage", &g_define_type_info, 0);
		g_type_add_interface_static (filter_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (filter_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&filter_page_type_id__volatile, filter_page_type_id);
	}
	return filter_page_type_id__volatile;
}


static void _vala_filter_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_filter_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FilterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_FILTER_PAGE, FilterPage);
	switch (property_id) {
		case FILTER_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case FILTER_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



