/* ListStatusesPage.c generated by valac 0.34.6, the Vala compiler
 * generated from ListStatusesPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy.h>
#include <json-glib/json-glib.h>
#include "CbTweet.h"
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_LIST_STATUSES_PAGE (list_statuses_page_get_type ())
#define LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPage))
#define LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))
#define IS_LIST_STATUSES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_STATUSES_PAGE))
#define IS_LIST_STATUSES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_STATUSES_PAGE))
#define LIST_STATUSES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_STATUSES_PAGE, ListStatusesPageClass))

typedef struct _ListStatusesPage ListStatusesPage;
typedef struct _ListStatusesPageClass ListStatusesPageClass;
typedef struct _ListStatusesPagePrivate ListStatusesPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _ListStatusesPageLoadNewestData ListStatusesPageLoadNewestData;
typedef struct _ListStatusesPageLoadOlderData ListStatusesPageLoadOlderData;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _ListStatusesPageLoadNewerData ListStatusesPageLoadNewerData;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _ListStatusesPage {
	ScrollWidget parent_instance;
	ListStatusesPagePrivate * priv;
	Account* account;
};

struct _ListStatusesPageClass {
	ScrollWidgetClass parent_class;
};

struct _ListStatusesPagePrivate {
	gint _id;
	MainWindow* main_window;
	gint64 list_id;
	guint tweet_remove_timeout;
	TweetListBox* tweet_list;
	MaxSizeContainer* max_size_container;
	GtkMenuButton* delete_button;
	GtkButton* edit_button;
	GtkLabel* description_label;
	GtkLabel* name_label;
	GtkLabel* creator_label;
	GtkLabel* subscribers_label;
	GtkLabel* members_label;
	GtkLabel* created_at_label;
	GtkStack* name_stack;
	GtkEntry* name_entry;
	GtkStack* description_stack;
	GtkEntry* description_entry;
	GtkStack* delete_stack;
	GtkButton* cancel_button;
	GtkStack* edit_stack;
	GtkButton* save_button;
	GtkStack* mode_stack;
	GtkLabel* mode_label;
	GtkComboBoxText* mode_combo_box;
	GtkButton* refresh_button;
	gboolean loading;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _ListStatusesPageLoadNewestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	TweetListBox* _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* _tmp10_;
	gint64 _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	guint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	JsonNode* root;
	JsonNode* _tmp18_;
	RestProxyCall* _tmp19_;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	GError* e;
	GError* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	TweetListBox* _tmp27_;
	GError* _tmp28_;
	const gchar* _tmp29_;
	JsonArray* root_array;
	JsonNode* _tmp30_;
	JsonArray* _tmp31_;
	JsonArray* _tmp32_;
	JsonArray* _tmp33_;
	guint _tmp34_;
	TweetListBox* _tmp35_;
	JsonArray* _tmp36_;
	TweetListBox* _tmp37_;
	Account* _tmp38_;
	GError * _inner_error_;
};

struct _ListStatusesPageLoadOlderData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	gboolean _tmp0_;
	guint requested_tweet_count;
	RestProxyCall* call;
	Account* _tmp1_;
	OAuthProxy* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	RestProxyCall* _tmp6_;
	RestProxyCall* _tmp7_;
	gint64 _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	RestProxyCall* _tmp11_;
	TweetListBox* _tmp12_;
	TweetModel* _tmp13_;
	gint64 _tmp14_;
	gint64 _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	RestProxyCall* _tmp18_;
	guint _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	JsonNode* root;
	JsonNode* _tmp22_;
	RestProxyCall* _tmp23_;
	JsonNode* _tmp24_;
	JsonNode* _tmp25_;
	GError* e;
	GError* _tmp26_;
	const gchar* _tmp27_;
	JsonArray* root_array;
	JsonNode* _tmp28_;
	JsonArray* _tmp29_;
	JsonArray* _tmp30_;
	JsonArray* _tmp31_;
	TweetListBox* _tmp32_;
	Account* _tmp33_;
	GError * _inner_error_;
};

struct _Block32Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _Block33Data {
	int _ref_count_;
	ListStatusesPage* self;
	RestProxyCall* call;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _ListStatusesPageLoadNewerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	ListStatusesPage* self;
	RestProxyCall* call;
	Account* _tmp0_;
	OAuthProxy* _tmp1_;
	RestProxyCall* _tmp2_;
	RestProxyCall* _tmp3_;
	RestProxyCall* _tmp4_;
	RestProxyCall* _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	RestProxyCall* _tmp9_;
	gint64 since_id;
	TweetListBox* _tmp10_;
	TweetModel* _tmp11_;
	gint64 _tmp12_;
	gint64 _tmp13_;
	gint64 _tmp14_;
	RestProxyCall* _tmp15_;
	gint64 _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint64 _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint64 _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	JsonNode* root;
	JsonNode* _tmp25_;
	RestProxyCall* _tmp26_;
	JsonNode* _tmp27_;
	JsonNode* _tmp28_;
	GError* e;
	GError* _tmp29_;
	const gchar* _tmp30_;
	JsonArray* root_array;
	JsonNode* _tmp31_;
	JsonArray* _tmp32_;
	JsonArray* _tmp33_;
	JsonArray* _tmp34_;
	guint _tmp35_;
	JsonArray* _tmp36_;
	TweetListBox* _tmp37_;
	Account* _tmp38_;
	GError * _inner_error_;
};


static gpointer list_statuses_page_parent_class = NULL;
static IPageIface* list_statuses_page_ipage_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType list_statuses_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
#define LIST_STATUSES_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LIST_STATUSES_PAGE, ListStatusesPagePrivate))
enum  {
	LIST_STATUSES_PAGE_DUMMY_PROPERTY,
	LIST_STATUSES_PAGE_ID,
	LIST_STATUSES_PAGE_WINDOW
};
GType delta_updater_get_type (void) G_GNUC_CONST;
ListStatusesPage* list_statuses_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
GType tweet_model_get_type (void) G_GNUC_CONST;
static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt);
static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self);
void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self);
static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static void list_statuses_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
gboolean bundle_get_bool (Bundle* self, const gchar* key, gboolean _default_);
gint bundle_get_int (Bundle* self, const gchar* key);
gchar* utils_capitalize (const gchar* s);
static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_);
void tweet_model_clear (TweetModel* self);
static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_);
static void list_statuses_page_real_on_leave (IPage* base);
static void list_statuses_page_load_newest_data_free (gpointer _data);
static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_);
void tweet_list_box_set_unempty (TweetListBox* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
void tweet_list_box_set_empty (TweetListBox* self);
void tweet_utils_work_array (JsonArray* json_array, TweetListBox* tweet_list, Account* account);
static void list_statuses_page_load_older_data_free (gpointer _data);
static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_);
gint64 tweet_model_get_lowest_id (TweetModel* self);
static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self);
static gchar* list_statuses_page_real_list_name (ListStatusesPage* self);
static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self);
static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void __lambda180_ (Block32Data* _data32_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda180__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void __lambda181_ (Block33Data* _data33_, GObject* o, GAsyncResult* res);
static void ___lambda181__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
#define LISTS_PAGE_MODE_DELETE 1
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self);
static void __lambda182_ (ListStatusesPage* self);
static void ___lambda182__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_BY_INSTANCE 1
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType itwitter_item_get_type (void) G_GNUC_CONST;
static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void list_statuses_page_load_newer_data_free (gpointer _data);
static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_);
gint64 tweet_model_get_greatest_id (TweetModel* self);
static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
#define DEFAULT_TIMELINE_REST 25
static gboolean ___lambda179_ (ListStatusesPage* self);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
void tweet_model_remove_last_n_visible (TweetModel* self, guint amount);
static gboolean ____lambda179__gsource_func (gpointer self);
static gchar* list_statuses_page_real_get_title (IPage* base);
static void list_statuses_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* list_statuses_page_real_get_radio_button (IPage* base);
static void list_statuses_page_finalize (GObject* obj);
gint ipage_get_id (IPage* self);
static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = list_statuses_page_scroll_event_cb ((ListStatusesPage*) self, event);
	return result;
}


static void _list_statuses_page_load_older_scroll_widget_scrolled_to_end (ScrollWidget* _sender, gpointer self) {
	list_statuses_page_load_older ((ListStatusesPage*) self, NULL, NULL);
}


static void _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start (ScrollWidget* _sender, gdouble value, gpointer self) {
	list_statuses_page_handle_scrolled_to_start ((ListStatusesPage*) self);
}


ListStatusesPage* list_statuses_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater) {
	ListStatusesPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	DeltaUpdater* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	GtkAdjustment* _tmp7_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_DELTA_UPDATER (delta_updater), NULL);
	self = (ListStatusesPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = delta_updater;
	_tmp4_->delta_updater = _tmp5_;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) _list_statuses_page_scroll_event_cb_gtk_widget_scroll_event, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-end", (GCallback) _list_statuses_page_load_older_scroll_widget_scrolled_to_end, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), "scrolled-to-start", (GCallback) _list_statuses_page_handle_scrolled_to_start_scroll_widget_scrolled_to_start, self, 0);
	_tmp6_ = self->priv->tweet_list;
	_tmp7_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	gtk_list_box_set_adjustment (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_list_box_get_type (), GtkListBox), _tmp7_);
	return self;
}


ListStatusesPage* list_statuses_page_new (gint id, Account* account, DeltaUpdater* delta_updater) {
	return list_statuses_page_construct (TYPE_LIST_STATUSES_PAGE, id, account, delta_updater);
}


static gboolean list_statuses_page_scroll_event_cb (ListStatusesPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventScroll* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp1_ = evt;
	_tmp2_ = _tmp1_->delta_y;
	if (_tmp2_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp3_ = NULL;
		GtkAdjustment* _tmp4_ = NULL;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp3_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_adjustment_get_value (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == ((gdouble) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp7_ = NULL;
		GtkAdjustment* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		GdkEventScroll* _tmp11_ = NULL;
		gdouble _tmp12_ = 0.0;
		MaxSizeContainer* _tmp13_ = NULL;
		MaxSizeContainer* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		_tmp7_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp8_ = _tmp7_;
		_tmp9_ = gtk_adjustment_get_step_increment (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = evt;
		_tmp12_ = _tmp11_->delta_y;
		inc = (gint) (_tmp10_ * (-_tmp12_));
		_tmp13_ = self->priv->max_size_container;
		_tmp14_ = self->priv->max_size_container;
		_tmp15_ = max_size_container_get_max_size (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = inc;
		max_size_container_set_max_size (_tmp14_, _tmp16_ + _tmp17_);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


/**
   * va_list params:
   *  - int64 list_id - The id of the list to show
   *  - string name - The lists's name
   *  - bool user_list - true if the list belongs to the user, false otherwise
   *  - string description - the lists's description
   *  - string creator
   *  - int subscribers_count
   *  - int memebers_count
   *  - int64 created_at
   *  - string mode
   */
static void list_statuses_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	ListStatusesPage * self;
	gint64 list_id = 0LL;
	Bundle* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gchar* list_name = NULL;
	Bundle* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint64 _tmp49_ = 0LL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	gint64 _tmp54_ = 0LL;
	gint64 _tmp55_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int64 (_tmp0_, "list_id");
	list_id = _tmp1_;
	_tmp2_ = list_id;
	if (_tmp2_ == ((gint64) 0)) {
		gint64 _tmp3_ = 0LL;
		_tmp3_ = self->priv->list_id;
		list_id = _tmp3_;
		return;
	}
	_tmp4_ = args;
	_tmp5_ = bundle_get_string (_tmp4_, "name");
	list_name = _tmp5_;
	_tmp6_ = list_name;
	if (_tmp6_ != NULL) {
		gboolean user_list = FALSE;
		Bundle* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gchar* description = NULL;
		Bundle* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* creator = NULL;
		Bundle* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gint n_subscribers = 0;
		Bundle* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gint n_members = 0;
		Bundle* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint64 created_at = 0LL;
		Bundle* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gchar* mode = NULL;
		Bundle* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GtkMenuButton* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		GtkButton* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		GtkLabel* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		GtkLabel* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		GtkLabel* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		GtkLabel* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		GtkLabel* _tmp39_ = NULL;
		gint64 _tmp40_ = 0LL;
		GDateTime* _tmp41_ = NULL;
		GDateTime* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		GtkLabel* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		_tmp7_ = args;
		_tmp8_ = bundle_get_bool (_tmp7_, "user_list", FALSE);
		user_list = _tmp8_;
		_tmp9_ = args;
		_tmp10_ = bundle_get_string (_tmp9_, "description");
		description = _tmp10_;
		_tmp11_ = args;
		_tmp12_ = bundle_get_string (_tmp11_, "creator");
		creator = _tmp12_;
		_tmp13_ = args;
		_tmp14_ = bundle_get_int (_tmp13_, "n_subscribers");
		n_subscribers = _tmp14_;
		_tmp15_ = args;
		_tmp16_ = bundle_get_int (_tmp15_, "n_members");
		n_members = _tmp16_;
		_tmp17_ = args;
		_tmp18_ = bundle_get_int64 (_tmp17_, "created_at");
		created_at = _tmp18_;
		_tmp19_ = args;
		_tmp20_ = bundle_get_string (_tmp19_, "mode");
		mode = _tmp20_;
		_tmp21_ = self->priv->delete_button;
		_tmp22_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), _tmp22_);
		_tmp23_ = self->priv->edit_button;
		_tmp24_ = user_list;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), _tmp24_);
		_tmp25_ = self->priv->name_label;
		_tmp26_ = list_name;
		gtk_label_set_label (_tmp25_, _tmp26_);
		_tmp27_ = self->priv->description_label;
		_tmp28_ = description;
		gtk_label_set_label (_tmp27_, _tmp28_);
		_tmp29_ = self->priv->creator_label;
		_tmp30_ = creator;
		gtk_label_set_label (_tmp29_, _tmp30_);
		_tmp31_ = self->priv->members_label;
		_tmp32_ = n_members;
		_tmp33_ = g_strdup_printf ("%'d", _tmp32_);
		_tmp34_ = _tmp33_;
		gtk_label_set_label (_tmp31_, _tmp34_);
		_g_free0 (_tmp34_);
		_tmp35_ = self->priv->subscribers_label;
		_tmp36_ = n_subscribers;
		_tmp37_ = g_strdup_printf ("%'d", _tmp36_);
		_tmp38_ = _tmp37_;
		gtk_label_set_label (_tmp35_, _tmp38_);
		_g_free0 (_tmp38_);
		_tmp39_ = self->priv->created_at_label;
		_tmp40_ = created_at;
		_tmp41_ = g_date_time_new_from_unix_local (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_date_time_format (_tmp42_, "%x, %X");
		_tmp44_ = _tmp43_;
		gtk_label_set_label (_tmp39_, _tmp44_);
		_g_free0 (_tmp44_);
		_g_date_time_unref0 (_tmp42_);
		_tmp45_ = self->priv->mode_label;
		_tmp46_ = mode;
		_tmp47_ = utils_capitalize (_tmp46_);
		_tmp48_ = _tmp47_;
		gtk_label_set_label (_tmp45_, _tmp48_);
		_g_free0 (_tmp48_);
		_g_free0 (mode);
		_g_free0 (creator);
		_g_free0 (description);
	}
	_tmp49_ = list_id;
	_tmp50_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat ("Showing list with id ", _tmp51_, NULL);
	_tmp53_ = _tmp52_;
	g_debug ("ListStatusesPage.vala:139: %s", _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp54_ = list_id;
	_tmp55_ = self->priv->list_id;
	if (_tmp54_ == _tmp55_) {
		gint64 _tmp56_ = 0LL;
		_tmp56_ = list_id;
		self->priv->list_id = _tmp56_;
		list_statuses_page_load_newer (self, NULL, NULL);
	} else {
		MaxSizeContainer* _tmp57_ = NULL;
		gint64 _tmp58_ = 0LL;
		TweetListBox* _tmp59_ = NULL;
		TweetModel* _tmp60_ = NULL;
		_tmp57_ = self->priv->max_size_container;
		max_size_container_set_max_size (_tmp57_, 0);
		_tmp58_ = list_id;
		self->priv->list_id = _tmp58_;
		_tmp59_ = self->priv->tweet_list;
		_tmp60_ = _tmp59_->model;
		tweet_model_clear (_tmp60_);
		list_statuses_page_load_newest (self, NULL, NULL);
	}
	_g_free0 (list_name);
}


static void list_statuses_page_real_on_leave (IPage* base) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
}


static void list_statuses_page_load_newest_data_free (gpointer _data) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewestData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void list_statuses_page_load_newest (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_newest);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_newest_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newest_co (_data_);
}


static void list_statuses_page_load_newest_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void list_statuses_page_load_newest_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewestData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newest_co (_data_);
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gboolean list_statuses_page_load_newest_co (ListStatusesPageLoadNewestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->loading = TRUE;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->tweet_list;
	tweet_list_box_set_unempty (_data_->_tmp0_);
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/lists/statuses.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp5_, "tweet_mode", "extended");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = 0LL;
	_data_->_tmp7_ = _data_->self->priv->list_id;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	g_debug ("ListStatusesPage.vala:162: USING LIST ID %s", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->call;
	_data_->_tmp11_ = 0LL;
	_data_->_tmp11_ = _data_->self->priv->list_id;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp11_);
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_;
	rest_proxy_call_add_param (_data_->_tmp10_, "list_id", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = _data_->call;
	_data_->_tmp15_ = 0U;
	_data_->_tmp15_ = _data_->requested_tweet_count;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup_printf ("%u", _data_->_tmp15_);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp14_, "count", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->root = NULL;
	{
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp19_, NULL, list_statuses_page_load_newest_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp18_ = _data_->_tmp20_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch31_g_error;
		}
		_data_->_tmp21_ = NULL;
		_data_->_tmp21_ = _data_->_tmp18_;
		_data_->_tmp18_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp21_;
		__vala_JsonNode_free0 (_data_->_tmp18_);
	}
	goto __finally31;
	__catch31_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = _data_->e;
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->_tmp22_->message;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = g_utf8_strdown (_data_->_tmp23_, (gssize) -1);
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = FALSE;
		_data_->_tmp26_ = g_strcmp0 (_data_->_tmp25_, "not found") == 0;
		_g_free0 (_data_->_tmp25_);
		if (_data_->_tmp26_) {
			_data_->_tmp27_ = NULL;
			_data_->_tmp27_ = _data_->self->priv->tweet_list;
			tweet_list_box_set_empty (_data_->_tmp27_);
		}
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->e;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning ("ListStatusesPage.vala:173: %s", _data_->_tmp29_);
		_data_->self->priv->loading = FALSE;
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally31:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->root;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = json_node_get_array (_data_->_tmp30_);
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _json_array_ref0 (_data_->_tmp31_);
	_data_->root_array = _data_->_tmp32_;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->root_array;
	_data_->_tmp34_ = 0U;
	_data_->_tmp34_ = json_array_get_length (_data_->_tmp33_);
	if (_data_->_tmp34_ == ((guint) 0)) {
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->self->priv->tweet_list;
		tweet_list_box_set_empty (_data_->_tmp35_);
		_data_->self->priv->loading = FALSE;
		_json_array_unref0 (_data_->root_array);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = NULL;
	_data_->_tmp36_ = _data_->root_array;
	_data_->_tmp37_ = NULL;
	_data_->_tmp37_ = _data_->self->priv->tweet_list;
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_);
	_data_->self->priv->loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_load_older_data_free (gpointer _data) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadOlderData, _data_);
}


static void list_statuses_page_load_older (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadOlderData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_older);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_older_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_older_co (_data_);
}


static void list_statuses_page_load_older_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void list_statuses_page_load_older_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadOlderData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_older_co (_data_);
}


static gboolean list_statuses_page_load_older_co (ListStatusesPageLoadOlderData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = FALSE;
	_data_->_tmp0_ = _data_->self->priv->loading;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->loading = TRUE;
	_data_->requested_tweet_count = (guint) 25;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->account;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_->proxy;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp4_, "1.1/lists/statuses.json");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp5_, "tweet_mode", "extended");
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp6_, "GET");
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->call;
	_data_->_tmp8_ = 0LL;
	_data_->_tmp8_ = _data_->self->priv->list_id;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp8_);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->_tmp9_;
	rest_proxy_call_add_param (_data_->_tmp7_, "list_id", _data_->_tmp10_);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->call;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->tweet_list;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->_tmp12_->model;
	_data_->_tmp14_ = 0LL;
	_data_->_tmp14_ = tweet_model_get_lowest_id (_data_->_tmp13_);
	_data_->_tmp15_ = 0LL;
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp15_ - 1);
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = _data_->_tmp16_;
	rest_proxy_call_add_param (_data_->_tmp11_, "max_id", _data_->_tmp17_);
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->call;
	_data_->_tmp19_ = 0U;
	_data_->_tmp19_ = _data_->requested_tweet_count;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_strdup_printf ("%u", _data_->_tmp19_);
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_tmp20_;
	rest_proxy_call_add_param (_data_->_tmp18_, "count", _data_->_tmp21_);
	_g_free0 (_data_->_tmp21_);
	_data_->root = NULL;
	{
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp23_, NULL, list_statuses_page_load_older_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp22_ = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch32_g_error;
		}
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp22_;
		_data_->_tmp22_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp25_;
		__vala_JsonNode_free0 (_data_->_tmp22_);
	}
	goto __finally32;
	__catch32_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->e;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_warning ("ListStatusesPage.vala:209: %s", _data_->_tmp27_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally32:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->root;
	_data_->_tmp29_ = NULL;
	_data_->_tmp29_ = json_node_get_array (_data_->_tmp28_);
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _json_array_ref0 (_data_->_tmp29_);
	_data_->root_array = _data_->_tmp30_;
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->root_array;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = _data_->self->priv->tweet_list;
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _data_->self->account;
	tweet_utils_work_array (_data_->_tmp31_, _data_->_tmp32_, _data_->_tmp33_);
	_data_->self->priv->loading = FALSE;
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void list_statuses_page_edit_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_ = NULL;
	GtkEntry* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkEntry* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkComboBoxText* _tmp9_ = NULL;
	GtkEntry* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GtkEntry* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkComboBoxText* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_entry;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_entry;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->cancel_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->save_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_combo_box;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = list_statuses_page_real_list_name (self);
	_tmp12_ = _tmp11_;
	gtk_entry_set_text (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->description_entry;
	_tmp14_ = self->priv->description_label;
	_tmp15_ = gtk_label_get_label (_tmp14_);
	_tmp16_ = _tmp15_;
	gtk_entry_set_text (_tmp13_, _tmp16_);
	_tmp17_ = self->priv->mode_combo_box;
	_tmp18_ = self->priv->mode_label;
	_tmp19_ = gtk_label_get_label (_tmp18_);
	_tmp20_ = _tmp19_;
	gtk_combo_box_set_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_combo_box_get_type (), GtkComboBox), _tmp20_);
}


static void _list_statuses_page_edit_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_edit_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_cancel_button_clicked_cb (ListStatusesPage* self) {
	GtkStack* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	GtkStack* _tmp4_ = NULL;
	GtkMenuButton* _tmp5_ = NULL;
	GtkStack* _tmp6_ = NULL;
	GtkButton* _tmp7_ = NULL;
	GtkStack* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->name_stack;
	_tmp1_ = self->priv->name_label;
	gtk_stack_set_visible_child (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->priv->description_stack;
	_tmp3_ = self->priv->description_label;
	gtk_stack_set_visible_child (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget));
	_tmp4_ = self->priv->delete_stack;
	_tmp5_ = self->priv->delete_button;
	gtk_stack_set_visible_child (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	_tmp6_ = self->priv->edit_stack;
	_tmp7_ = self->priv->edit_button;
	gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	_tmp8_ = self->priv->mode_stack;
	_tmp9_ = self->priv->mode_label;
	gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
}


static void _list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_cancel_button_clicked_cb ((ListStatusesPage*) self);
}


static Block32Data* block32_data_ref (Block32Data* _data32_) {
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}


static void block32_data_unref (void * _userdata_) {
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->call);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}


static void __lambda180_ (Block32Data* _data32_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GtkButton* _tmp5_ = NULL;
	GtkMenuButton* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data32_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data32_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data32_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 264, "ListStatusesPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally33:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp5_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp6_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda180__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda180_ (self, source_object, res);
	block32_data_unref (self);
}


static void list_statuses_page_save_button_clicked_cb (ListStatusesPage* self) {
	Block32Data* _data32_;
	GtkLabel* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GtkEntry* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkEntry* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkComboBoxText* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	GtkButton* _tmp16_ = NULL;
	GtkMenuButton* _tmp17_ = NULL;
	Account* _tmp18_ = NULL;
	OAuthProxy* _tmp19_ = NULL;
	RestProxyCall* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GtkLabel* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = self->priv->creator_label;
	_tmp2_ = gtk_label_get_label (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->name_entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup_printf ("@%s/%s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_label_set_label (_tmp0_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->description_label;
	_tmp9_ = self->priv->description_entry;
	_tmp10_ = gtk_entry_get_text (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp8_, _tmp11_);
	_tmp12_ = self->priv->mode_label;
	_tmp13_ = self->priv->mode_combo_box;
	_tmp14_ = gtk_combo_box_get_active_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_combo_box_get_type (), GtkComboBox));
	_tmp15_ = _tmp14_;
	gtk_label_set_label (_tmp12_, _tmp15_);
	list_statuses_page_cancel_button_clicked_cb (self);
	_tmp16_ = self->priv->edit_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp17_ = self->priv->delete_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp18_ = self->account;
	_tmp19_ = _tmp18_->proxy;
	_tmp20_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, rest_proxy_get_type (), RestProxy));
	_data32_->call = _tmp20_;
	rest_proxy_call_set_function (_data32_->call, "1.1/lists/update.json");
	rest_proxy_call_set_method (_data32_->call, "POST");
	_tmp21_ = self->priv->list_id;
	_tmp22_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp21_);
	_tmp23_ = _tmp22_;
	rest_proxy_call_add_param (_data32_->call, "list_id", _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = list_statuses_page_real_list_name (self);
	_tmp25_ = _tmp24_;
	rest_proxy_call_add_param (_data32_->call, "name", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->mode_label;
	_tmp27_ = gtk_label_get_label (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_utf8_strdown (_tmp28_, (gssize) -1);
	_tmp30_ = _tmp29_;
	rest_proxy_call_add_param (_data32_->call, "mode", _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->description_label;
	_tmp32_ = gtk_label_get_label (_tmp31_);
	_tmp33_ = _tmp32_;
	rest_proxy_call_add_param (_data32_->call, "description", _tmp33_);
	rest_proxy_call_invoke_async (_data32_->call, NULL, ___lambda180__gasync_ready_callback, block32_data_ref (_data32_));
	block32_data_unref (_data32_);
	_data32_ = NULL;
}


static void _list_statuses_page_save_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_save_button_clicked_cb ((ListStatusesPage*) self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* list_statuses_page_real_list_name (ListStatusesPage* self) {
	gchar* result = NULL;
	gchar* cur_name = NULL;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint slash_index = 0;
	gint _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (IS_LIST_STATUSES_PAGE (self), NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	cur_name = _tmp3_;
	_tmp4_ = string_index_of (cur_name, "/", 0);
	slash_index = _tmp4_;
	_tmp5_ = string_substring (cur_name, (glong) (slash_index + 1), (glong) -1);
	result = _tmp5_;
	_g_free0 (cur_name);
	return result;
}


static Block33Data* block33_data_ref (Block33Data* _data33_) {
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}


static void block33_data_unref (void * _userdata_) {
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ListStatusesPage* self;
		self = _data33_->self;
		_g_object_unref0 (_data33_->call);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}


static void __lambda181_ (Block33Data* _data33_, GObject* o, GAsyncResult* res) {
	ListStatusesPage* self;
	GError * _inner_error_ = NULL;
	self = _data33_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		GAsyncResult* _tmp0_ = NULL;
		_tmp0_ = res;
		rest_proxy_call_invoke_finish (_data33_->call, _tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch34_g_error;
		}
	}
	goto __finally34;
	__catch34_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		MainWindow* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = rest_proxy_call_get_payload (_data33_->call);
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = self->priv->main_window;
		utils_show_error_object (_tmp1_, _tmp3_, 288, "ListStatusesPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow));
		_g_error_free0 (e);
	}
	__finally34:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda181__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda181_ (self, source_object, res);
	block33_data_unref (self);
}


static void list_statuses_page_delete_confirmation_item_clicked_cb (ListStatusesPage* self) {
	Block33Data* _data33_;
	Account* _tmp0_ = NULL;
	OAuthProxy* _tmp1_ = NULL;
	RestProxyCall* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp6_ = NULL;
	gint64 _tmp7_ = 0LL;
	MainWindow* _tmp8_ = NULL;
	MainWidget* _tmp9_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_data33_ = g_slice_new0 (Block33Data);
	_data33_->_ref_count_ = 1;
	_data33_->self = g_object_ref (self);
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->proxy;
	_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, rest_proxy_get_type (), RestProxy));
	_data33_->call = _tmp2_;
	rest_proxy_call_set_function (_data33_->call, "1.1/lists/destroy.json");
	_tmp3_ = self->priv->list_id;
	_tmp4_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp3_);
	_tmp5_ = _tmp4_;
	rest_proxy_call_add_param (_data33_->call, "list_id", _tmp5_);
	_g_free0 (_tmp5_);
	rest_proxy_call_set_method (_data33_->call, "POST");
	rest_proxy_call_invoke_async (_data33_->call, NULL, ___lambda181__gasync_ready_callback, block33_data_ref (_data33_));
	_tmp6_ = bundle_new ();
	bundle = _tmp6_;
	bundle_put_int (bundle, "mode", LISTS_PAGE_MODE_DELETE);
	_tmp7_ = self->priv->list_id;
	bundle_put_int64 (bundle, "list_id", _tmp7_);
	_tmp8_ = self->priv->main_window;
	_tmp9_ = _tmp8_->main_widget;
	main_widget_switch_page (_tmp9_, (gint) PAGE_LISTS, bundle);
	_g_object_unref0 (bundle);
	block33_data_unref (_data33_);
	_data33_ = NULL;
}


static void _list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	list_statuses_page_delete_confirmation_item_clicked_cb ((ListStatusesPage*) self);
}


static void __lambda182_ (ListStatusesPage* self) {
	GtkButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda182__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda182_ ((ListStatusesPage*) self);
	g_object_unref (self);
}


static void list_statuses_page_refresh_button_clicked_cb (ListStatusesPage* self) {
	GtkButton* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->refresh_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), FALSE);
	list_statuses_page_load_newer (self, ___lambda182__gasync_ready_callback, g_object_ref (self));
}


static void _list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	list_statuses_page_refresh_button_clicked_cb ((ListStatusesPage*) self);
}


static void list_statuses_page_tweet_activated_cb (ListStatusesPage* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_ = NULL;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_TWEET_LIST_ENTRY)) {
		Bundle* bundle = NULL;
		Bundle* _tmp1_ = NULL;
		Bundle* _tmp2_ = NULL;
		Bundle* _tmp3_ = NULL;
		GtkListBoxRow* _tmp4_ = NULL;
		CbTweet* _tmp5_ = NULL;
		MainWindow* _tmp6_ = NULL;
		MainWidget* _tmp7_ = NULL;
		Bundle* _tmp8_ = NULL;
		_tmp1_ = bundle_new ();
		bundle = _tmp1_;
		_tmp2_ = bundle;
		bundle_put_int (_tmp2_, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
		_tmp3_ = bundle;
		_tmp4_ = row;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
		bundle_put_object (_tmp3_, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, G_TYPE_OBJECT, GObject));
		_tmp6_ = self->priv->main_window;
		_tmp7_ = _tmp6_->main_widget;
		_tmp8_ = bundle;
		main_widget_switch_page (_tmp7_, (gint) PAGE_TWEET_INFO, _tmp8_);
		_g_object_unref0 (bundle);
	} else {
		g_warning ("ListStatusesPage.vala:314: row is of unknown type");
	}
}


static void _list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	list_statuses_page_tweet_activated_cb ((ListStatusesPage*) self, row);
}


static void list_statuses_page_load_newer_data_free (gpointer _data) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ListStatusesPageLoadNewerData, _data_);
}


static void list_statuses_page_load_newer (ListStatusesPage* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	ListStatusesPage* _tmp0_ = NULL;
	_data_ = g_slice_new0 (ListStatusesPageLoadNewerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, list_statuses_page_load_newer);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, list_statuses_page_load_newer_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	list_statuses_page_load_newer_co (_data_);
}


static void list_statuses_page_load_newer_finish (ListStatusesPage* self, GAsyncResult* _res_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void list_statuses_page_load_newer_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ListStatusesPageLoadNewerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	list_statuses_page_load_newer_co (_data_);
}


static gboolean list_statuses_page_load_newer_co (ListStatusesPageLoadNewerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_->proxy;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp1_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->call;
	rest_proxy_call_set_function (_data_->_tmp3_, "1.1/lists/statuses.json");
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->call;
	rest_proxy_call_set_method (_data_->_tmp4_, "GET");
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->call;
	_data_->_tmp6_ = 0LL;
	_data_->_tmp6_ = _data_->self->priv->list_id;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	rest_proxy_call_add_param (_data_->_tmp5_, "list_id", _data_->_tmp8_);
	_g_free0 (_data_->_tmp8_);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->call;
	rest_proxy_call_add_param (_data_->_tmp9_, "count", "30");
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->self->priv->tweet_list;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_->model;
	_data_->_tmp12_ = 0LL;
	_data_->_tmp12_ = tweet_model_get_greatest_id (_data_->_tmp11_);
	_data_->_tmp13_ = 0LL;
	_data_->_tmp13_ = _data_->_tmp12_;
	_data_->since_id = _data_->_tmp13_;
	_data_->_tmp14_ = 0LL;
	_data_->_tmp14_ = _data_->since_id;
	if (_data_->_tmp14_ < ((gint64) 0)) {
		_data_->since_id = (gint64) 1;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _data_->call;
	_data_->_tmp16_ = 0LL;
	_data_->_tmp16_ = _data_->since_id;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp16_);
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->_tmp17_;
	rest_proxy_call_add_param (_data_->_tmp15_, "since_id", _data_->_tmp18_);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = 0LL;
	_data_->_tmp19_ = _data_->since_id;
	_data_->_tmp20_ = NULL;
	_data_->_tmp20_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp19_);
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->_tmp20_;
	_data_->_tmp22_ = 0LL;
	_data_->_tmp22_ = _data_->self->priv->list_id;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp22_);
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->_tmp23_;
	g_debug ("ListStatusesPage.vala:328: Getting statuses since %s for list_id %s", _data_->_tmp21_, _data_->_tmp24_);
	_g_free0 (_data_->_tmp24_);
	_g_free0 (_data_->_tmp21_);
	_data_->root = NULL;
	{
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = _data_->call;
		_data_->_state_ = 1;
		tweet_utils_load_threaded (_data_->_tmp26_, NULL, list_statuses_page_load_newer_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = tweet_utils_load_threaded_finish (_data_->_res_, &_data_->_inner_error_);
		_data_->_tmp25_ = _data_->_tmp27_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch35_g_error;
		}
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp25_;
		_data_->_tmp25_ = NULL;
		__vala_JsonNode_free0 (_data_->root);
		_data_->root = _data_->_tmp28_;
		__vala_JsonNode_free0 (_data_->_tmp25_);
	}
	goto __finally35;
	__catch35_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->e;
		_data_->_tmp30_ = NULL;
		_data_->_tmp30_ = _data_->_tmp29_->message;
		g_warning ("ListStatusesPage.vala:335: %s", _data_->_tmp30_);
		_g_error_free0 (_data_->e);
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally35:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (_data_->root);
		_g_object_unref0 (_data_->call);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp31_ = NULL;
	_data_->_tmp31_ = _data_->root;
	_data_->_tmp32_ = NULL;
	_data_->_tmp32_ = json_node_get_array (_data_->_tmp31_);
	_data_->_tmp33_ = NULL;
	_data_->_tmp33_ = _json_array_ref0 (_data_->_tmp32_);
	_data_->root_array = _data_->_tmp33_;
	_data_->_tmp34_ = NULL;
	_data_->_tmp34_ = _data_->root_array;
	_data_->_tmp35_ = 0U;
	_data_->_tmp35_ = json_array_get_length (_data_->_tmp34_);
	if (_data_->_tmp35_ > ((guint) 0)) {
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->root_array;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = _data_->self->priv->tweet_list;
		_data_->_tmp38_ = NULL;
		_data_->_tmp38_ = _data_->self->account;
		tweet_utils_work_array (_data_->_tmp36_, _data_->_tmp37_, _data_->_tmp38_);
	}
	_json_array_unref0 (_data_->root_array);
	__vala_JsonNode_free0 (_data_->root);
	_g_object_unref0 (_data_->call);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean ___lambda179_ (ListStatusesPage* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	TweetListBox* _tmp2_ = NULL;
	TweetModel* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	TweetModel* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	_tmp0_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		self->priv->tweet_remove_timeout = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->tweet_list;
	_tmp3_ = _tmp2_->model;
	_tmp4_ = self->priv->tweet_list;
	_tmp5_ = _tmp4_->model;
	_tmp6_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_list_model_get_type (), GListModel));
	tweet_model_remove_last_n_visible (_tmp3_, _tmp6_ - DEFAULT_TIMELINE_REST);
	self->priv->tweet_remove_timeout = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}


static gboolean ____lambda179__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda179_ ((ListStatusesPage*) self);
	return result;
}


void list_statuses_page_handle_scrolled_to_start (ListStatusesPage* self) {
	guint _tmp0_ = 0U;
	TweetListBox* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (IS_LIST_STATUSES_PAGE (self));
	_tmp0_ = self->priv->tweet_remove_timeout;
	if (_tmp0_ != ((guint) 0)) {
		return;
	}
	_tmp1_ = self->priv->tweet_list;
	_tmp2_ = _tmp1_->model;
	_tmp3_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_list_model_get_type (), GListModel));
	if (_tmp3_ > ((guint) DEFAULT_TIMELINE_REST)) {
		guint _tmp4_ = 0U;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, ____lambda179__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->tweet_remove_timeout = _tmp4_;
	} else {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->tweet_remove_timeout;
		if (_tmp5_ != ((guint) 0)) {
			guint _tmp6_ = 0U;
			_tmp6_ = self->priv->tweet_remove_timeout;
			g_source_remove (_tmp6_);
			self->priv->tweet_remove_timeout = (guint) 0;
		}
	}
}


static gchar* list_statuses_page_real_get_title (IPage* base) {
	ListStatusesPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = _ ("List");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void list_statuses_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* list_statuses_page_real_get_radio_button (IPage* base) {
	ListStatusesPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	result = NULL;
	return result;
}


static gint list_statuses_page_real_get_id (IPage* base) {
	gint result;
	ListStatusesPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void list_statuses_page_real_set_id (IPage* base, gint value) {
	ListStatusesPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void list_statuses_page_real_set_window (IPage* base, MainWindow* value) {
	ListStatusesPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void list_statuses_page_class_init (ListStatusesPageClass * klass) {
	gint ListStatusesPage_private_offset;
	list_statuses_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ListStatusesPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_list_statuses_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_list_statuses_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = list_statuses_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), LIST_STATUSES_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	ListStatusesPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/list-statuses-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_list", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, tweet_list));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "creator_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, creator_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribers_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, subscribers_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "members_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, members_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "created_at_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, created_at_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, name_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "description_entry", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, description_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delete_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, delete_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "edit_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, edit_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "save_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, save_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_stack", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_label", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mode_combo_box", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, mode_combo_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "refresh_button", FALSE, ListStatusesPage_private_offset + G_STRUCT_OFFSET (ListStatusesPagePrivate, refresh_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "edit_button_clicked_cb", G_CALLBACK(_list_statuses_page_edit_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_button_clicked_cb", G_CALLBACK(_list_statuses_page_cancel_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "save_button_clicked_cb", G_CALLBACK(_list_statuses_page_save_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "delete_confirmation_item_clicked_cb", G_CALLBACK(_list_statuses_page_delete_confirmation_item_clicked_cb_gtk_menu_item_activate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "refresh_button_clicked_cb", G_CALLBACK(_list_statuses_page_refresh_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "tweet_activated_cb", G_CALLBACK(_list_statuses_page_tweet_activated_cb_gtk_list_box_row_activated));
}


static void list_statuses_page_ipage_interface_init (IPageIface * iface) {
	list_statuses_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) list_statuses_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) list_statuses_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) list_statuses_page_real_get_title;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) list_statuses_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) list_statuses_page_real_get_radio_button;
	iface->get_id = list_statuses_page_real_get_id;
	iface->set_id = list_statuses_page_real_set_id;
	iface->set_window = list_statuses_page_real_set_window;
}


static void list_statuses_page_instance_init (ListStatusesPage * self) {
	self->priv = LIST_STATUSES_PAGE_GET_PRIVATE (self);
	self->priv->tweet_remove_timeout = (guint) 0;
	self->priv->loading = FALSE;
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void list_statuses_page_finalize (GObject* obj) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	_g_object_unref0 (self->priv->tweet_list);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->description_label);
	_g_object_unref0 (self->priv->name_label);
	_g_object_unref0 (self->priv->creator_label);
	_g_object_unref0 (self->priv->subscribers_label);
	_g_object_unref0 (self->priv->members_label);
	_g_object_unref0 (self->priv->created_at_label);
	_g_object_unref0 (self->priv->name_stack);
	_g_object_unref0 (self->priv->name_entry);
	_g_object_unref0 (self->priv->description_stack);
	_g_object_unref0 (self->priv->description_entry);
	_g_object_unref0 (self->priv->delete_stack);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->edit_stack);
	_g_object_unref0 (self->priv->save_button);
	_g_object_unref0 (self->priv->mode_stack);
	_g_object_unref0 (self->priv->mode_label);
	_g_object_unref0 (self->priv->mode_combo_box);
	_g_object_unref0 (self->priv->refresh_button);
	G_OBJECT_CLASS (list_statuses_page_parent_class)->finalize (obj);
}


GType list_statuses_page_get_type (void) {
	static volatile gsize list_statuses_page_type_id__volatile = 0;
	if (g_once_init_enter (&list_statuses_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ListStatusesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) list_statuses_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ListStatusesPage), 0, (GInstanceInitFunc) list_statuses_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) list_statuses_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType list_statuses_page_type_id;
		list_statuses_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "ListStatusesPage", &g_define_type_info, 0);
		g_type_add_interface_static (list_statuses_page_type_id, TYPE_IPAGE, &ipage_info);
		g_once_init_leave (&list_statuses_page_type_id__volatile, list_statuses_page_type_id);
	}
	return list_statuses_page_type_id__volatile;
}


static void _vala_list_statuses_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_list_statuses_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ListStatusesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_LIST_STATUSES_PAGE, ListStatusesPage);
	switch (property_id) {
		case LIST_STATUSES_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case LIST_STATUSES_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



