/* TweetInfoPage.c generated by valac 0.34.6, the Vala compiler
 * generated from TweetInfoPage.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include "CbTweet.h"
#include <gio/gio.h>
#include "CbMedia.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <rest/rest-proxy-call.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <rest/rest-proxy.h>
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_TWEET_INFO_PAGE (tweet_info_page_get_type ())
#define TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPage))
#define TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))
#define IS_TWEET_INFO_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_INFO_PAGE))
#define IS_TWEET_INFO_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_INFO_PAGE))
#define TWEET_INFO_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_INFO_PAGE, TweetInfoPageClass))

typedef struct _TweetInfoPage TweetInfoPage;
typedef struct _TweetInfoPageClass TweetInfoPageClass;
typedef struct _TweetInfoPagePrivate TweetInfoPagePrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_MAX_SIZE_CONTAINER (max_size_container_get_type ())
#define MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainer))
#define MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))
#define IS_MAX_SIZE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAX_SIZE_CONTAINER))
#define IS_MAX_SIZE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAX_SIZE_CONTAINER))
#define MAX_SIZE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAX_SIZE_CONTAINER, MaxSizeContainerClass))

typedef struct _MaxSizeContainer MaxSizeContainer;
typedef struct _MaxSizeContainerClass MaxSizeContainerClass;

#define TYPE_REPLY_INDICATOR (reply_indicator_get_type ())
#define REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPLY_INDICATOR, ReplyIndicator))
#define REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))
#define IS_REPLY_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPLY_INDICATOR))
#define IS_REPLY_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPLY_INDICATOR))
#define REPLY_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPLY_INDICATOR, ReplyIndicatorClass))

typedef struct _ReplyIndicator ReplyIndicator;
typedef struct _ReplyIndicatorClass ReplyIndicatorClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_MEDIA_VISIBILITY (media_visibility_get_type ())

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block28Data Block28Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block30Data Block30Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
typedef struct _Block31Data Block31Data;

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _TweetInfoPage {
	ScrollWidget parent_instance;
	TweetInfoPagePrivate * priv;
	Account* account;
};

struct _TweetInfoPageClass {
	ScrollWidgetClass parent_class;
};

struct _TweetInfoPagePrivate {
	gint _id;
	gint64 tweet_id;
	gchar* screen_name;
	gboolean values_set;
	CbTweet* tweet;
	GSimpleActionGroup* actions;
	MainWindow* main_window;
	GCancellable* cancellable;
	GtkGrid* grid;
	MultiMediaWidget* mm_widget;
	GtkLabel* text_label;
	TextButton* name_button;
	GtkLabel* screen_name_label;
	AvatarWidget* avatar_image;
	GtkLabel* rt_label;
	GtkLabel* fav_label;
	TweetListBox* bottom_list_box;
	TweetListBox* top_list_box;
	GtkToggleButton* favorite_button;
	GtkToggleButton* retweet_button;
	GtkLabel* time_label;
	GtkLabel* source_label;
	MaxSizeContainer* max_size_container;
	ReplyIndicator* reply_indicator;
	GtkStack* main_stack;
	GtkLabel* error_label;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	CbTweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	MEDIA_VISIBILITY_SHOW = 1,
	MEDIA_VISIBILITY_HIDE = 2,
	MEDIA_VISIBILITY_HIDE_IN_TIMELINES = 3
} MediaVisibility;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block28Data {
	int _ref_count_;
	TweetInfoPage* self;
	GDateTime* now;
	gboolean existing;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block29Data {
	int _ref_count_;
	Block28Data * _data28_;
	gint64 previous_tweet_id;
	gint n_replies;
};

struct _Block30Data {
	int _ref_count_;
	TweetInfoPage* self;
	RestProxyCall* call;
};

struct _Block31Data {
	int _ref_count_;
	TweetInfoPage* self;
	gboolean favoriting;
};


static gpointer tweet_info_page_parent_class = NULL;
static IPageIface* tweet_info_page_ipage_parent_iface = NULL;
static IMessageReceiverIface* tweet_info_page_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType tweet_info_page_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType max_size_container_get_type (void) G_GNUC_CONST;
GType reply_indicator_get_type (void) G_GNUC_CONST;
#define TWEET_INFO_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_INFO_PAGE, TweetInfoPagePrivate))
enum  {
	TWEET_INFO_PAGE_DUMMY_PROPERTY,
	TWEET_INFO_PAGE_UNREAD_COUNT,
	TWEET_INFO_PAGE_ID,
	TWEET_INFO_PAGE_WINDOW
};
#define TWEET_INFO_PAGE_BY_INSTANCE 1
#define TWEET_INFO_PAGE_BY_ID 2
static void tweet_info_page_quote_activated (TweetInfoPage* self);
static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_reply_activated (TweetInfoPage* self);
static void _tweet_info_page_reply_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_favorite_activated (TweetInfoPage* self);
static void _tweet_info_page_favorite_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_info_page_delete_activated (TweetInfoPage* self);
static void _tweet_info_page_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
GType delta_updater_get_type (void) G_GNUC_CONST;
TweetInfoPage* tweet_info_page_new (gint id, Account* account, DeltaUpdater* delta_updater);
TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater);
ScrollWidget* scroll_widget_new (void);
ScrollWidget* scroll_widget_construct (GType object_type);
void ipage_set_id (IPage* self, gint value);
GType tweet_model_get_type (void) G_GNUC_CONST;
static void __lambda59_ (TweetInfoPage* self, CbMedia* m, gint i);
void tweet_utils_handle_media_click (CbTweet* t, MainWindow* window, gint index);
static void ___lambda59__multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gpointer self);
static gboolean __lambda62_ (TweetInfoPage* self, GdkEventScroll* evt);
gboolean reply_indicator_get_replies_available (ReplyIndicator* self);
gint max_size_container_get_max_size (MaxSizeContainer* self);
void max_size_container_set_max_size (MaxSizeContainer* self, gint value);
static gboolean ___lambda62__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self);
static void __lambda63_ (TweetInfoPage* self, GtkListBoxRow* row);
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int (Bundle* self, const gchar* key, gint value);
void bundle_put_object (Bundle* self, const gchar* key, GObject* object);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType itwitter_item_get_type (void) G_GNUC_CONST;
void bundle_put_bool (Bundle* self, const gchar* key, gboolean value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void ___lambda63__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void __lambda64_ (TweetInfoPage* self, GtkListBoxRow* row);
static void ___lambda64__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
GSettings* settings_get (void);
static void tweet_info_page_media_visiblity_changed_cb (TweetInfoPage* self);
static void _tweet_info_page_media_visiblity_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
GType media_visibility_get_type (void) G_GNUC_CONST;
MediaVisibility settings_get_media_visiblity (void);
static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args);
gint bundle_get_int (Bundle* self, const gchar* key);
gboolean bundle_get_bool (Bundle* self, const gchar* key, gboolean _default_);
void reply_indicator_set_replies_available (ReplyIndicator* self, gboolean value);
GObject* bundle_get_object (Bundle* self, const gchar* key);
static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id);
void tweet_model_clear (TweetModel* self);
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, CbTweet* tweet, const gchar* with);
gint64 bundle_get_int64 (Bundle* self, const gchar* key);
gchar* bundle_get_string (Bundle* self, const gchar* key);
static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing);
gboolean tweet_model_contains_id (TweetModel* self, gint64 tweet_id);
void tweet_model_add (TweetModel* self, CbTweet* tweet);
CbTweet* tweet_model_get_from_id (TweetModel* self, gint64 id, gint diff);
void tweet_model_remove_tweets_above (TweetModel* self, gint64 id);
static void tweet_info_page_real_on_leave (IPage* base);
static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self);
static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self);
void tweet_utils_set_favorite_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_favorite_status_finish (GAsyncResult* _res_);
static void __lambda71_ (TweetInfoPage* self);
static void ___lambda71__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self);
void tweet_utils_set_retweet_status (Account* account, CbTweet* tweet, gboolean status, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_set_retweet_status_finish (GAsyncResult* _res_);
static void __lambda73_ (TweetInfoPage* self);
static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void tweet_utils_load_threaded (RestProxyCall* call, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
JsonNode* tweet_utils_load_threaded_finish (GAsyncResult* _res_, GError** error);
static void __lambda67_ (Block28Data* _data28_, GObject* __, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str);
static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id);
static void ___lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda69_ (Block28Data* _data28_, GObject* _, GAsyncResult* res);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static void __lambda70_ (Block29Data* _data29_, JsonArray* arr, guint index, JsonNode* node);
static void ___lambda70__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
static void ___lambda69__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void __lambda68_ (Block30Data* _data30_, GObject* obj, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda68__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void text_button_set_markup (TextButton* self, const gchar* text);
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_get_avatar (Twitter* self, gint64 user_id, const gchar* url, AvatarWidget* dest_widget, gint size, gboolean force_download, GAsyncReadyCallback _callback_, gpointer _user_data_);
void twitter_get_avatar_finish (Twitter* self, GAsyncResult* _res_);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name);
void multi_media_widget_set_all_media (MultiMediaWidget* self, CbMedia** medias, int medias_length1);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda56_ (Block31Data* _data31_);
static void ___lambda56__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void main_widget_remove_current_page (MainWidget* self);
void tweet_utils_delete_tweet (Account* account, CbTweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void __lambda58_ (TweetInfoPage* self);
static void ___lambda58__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* tweet_info_page_real_get_title (IPage* base);
static void tweet_info_page_real_create_radio_button (IPage* base, GtkRadioButton* group);
static GtkRadioButton* tweet_info_page_real_get_radio_button (IPage* base);
static void tweet_info_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
gboolean utils_usable_json_value (JsonObject* node, const gchar* value_name);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
gint tweet_info_page_get_unread_count (TweetInfoPage* self);
static void tweet_info_page_finalize (GObject* obj);
static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void ipage_set_window (IPage* self, MainWindow* value);
static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_INFO_PAGE_action_entries[4] = {{"quote", _tweet_info_page_quote_activated_gsimple_action_activate_callback}, {"reply", _tweet_info_page_reply_activated_gsimple_action_activate_callback}, {"favorite", _tweet_info_page_favorite_activated_gsimple_action_activate_callback}, {"delete", _tweet_info_page_delete_activated_gsimple_action_activate_callback}};

static void _tweet_info_page_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_quote_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_reply_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_reply_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_favorite_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_favorite_activated ((TweetInfoPage*) self);
}


static void _tweet_info_page_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_info_page_delete_activated ((TweetInfoPage*) self);
}


static void __lambda59_ (TweetInfoPage* self, CbMedia* m, gint i) {
	CbTweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (CB_IS_MEDIA (m));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = i;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda59__multi_media_widget_media_clicked (MultiMediaWidget* _sender, CbMedia* m, gint index, gpointer self) {
	__lambda59_ ((TweetInfoPage*) self, m, index);
}


static gboolean __lambda62_ (TweetInfoPage* self, GdkEventScroll* evt) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GdkEventScroll* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_val_if_fail (evt != NULL, FALSE);
	_tmp2_ = evt;
	_tmp3_ = _tmp2_->delta_y;
	if (_tmp3_ < ((gdouble) 0)) {
		GtkAdjustment* _tmp4_ = NULL;
		GtkAdjustment* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		_tmp4_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp5_ = _tmp4_;
		_tmp6_ = gtk_adjustment_get_value (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ == ((gdouble) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ReplyIndicator* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp8_ = self->priv->reply_indicator;
		_tmp9_ = reply_indicator_get_replies_available (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint inc = 0;
		GtkAdjustment* _tmp11_ = NULL;
		GtkAdjustment* _tmp12_ = NULL;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		GdkEventScroll* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		MaxSizeContainer* _tmp17_ = NULL;
		MaxSizeContainer* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp11_ = gtk_scrolled_window_get_vadjustment (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow));
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_adjustment_get_step_increment (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = evt;
		_tmp16_ = _tmp15_->delta_y;
		inc = (gint) (_tmp14_ * (-_tmp16_));
		_tmp17_ = self->priv->max_size_container;
		_tmp18_ = self->priv->max_size_container;
		_tmp19_ = max_size_container_get_max_size (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = inc;
		max_size_container_set_max_size (_tmp18_, _tmp20_ + _tmp21_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda62__gtk_widget_scroll_event (GtkWidget* _sender, GdkEventScroll* event, gpointer self) {
	gboolean result;
	result = __lambda62_ ((TweetInfoPage*) self, event);
	return result;
}


static void __lambda63_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWidget* _tmp4_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	bundle_put_bool (bundle, "existing", TRUE);
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda63__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda63_ ((TweetInfoPage*) self, row);
}


static void __lambda64_ (TweetInfoPage* self, GtkListBoxRow* row) {
	Bundle* bundle = NULL;
	Bundle* _tmp0_ = NULL;
	GtkListBoxRow* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	MainWidget* _tmp4_ = NULL;
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = bundle_new ();
	bundle = _tmp0_;
	bundle_put_int (bundle, "mode", TWEET_INFO_PAGE_BY_INSTANCE);
	_tmp1_ = row;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_LIST_ENTRY, TweetListEntry)->tweet;
	bundle_put_object (bundle, "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, G_TYPE_OBJECT, GObject));
	bundle_put_bool (bundle, "existing", TRUE);
	_tmp3_ = self->priv->main_window;
	_tmp4_ = _tmp3_->main_widget;
	main_widget_switch_page (_tmp4_, (gint) PAGE_TWEET_INFO, bundle);
	_g_object_unref0 (bundle);
}


static void ___lambda64__gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	__lambda64_ ((TweetInfoPage*) self, row);
}


static void _tweet_info_page_media_visiblity_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_info_page_media_visiblity_changed_cb ((TweetInfoPage*) self);
}


TweetInfoPage* tweet_info_page_construct (GType object_type, gint id, Account* account, DeltaUpdater* delta_updater) {
	TweetInfoPage * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	TweetListBox* _tmp4_ = NULL;
	Account* _tmp5_ = NULL;
	TweetListBox* _tmp6_ = NULL;
	DeltaUpdater* _tmp7_ = NULL;
	TweetListBox* _tmp8_ = NULL;
	DeltaUpdater* _tmp9_ = NULL;
	MultiMediaWidget* _tmp10_ = NULL;
	TweetListBox* _tmp11_ = NULL;
	TweetListBox* _tmp12_ = NULL;
	GSimpleActionGroup* _tmp13_ = NULL;
	GSimpleActionGroup* _tmp14_ = NULL;
	GSimpleActionGroup* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	GSettings* _tmp17_ = NULL;
	MultiMediaWidget* _tmp18_ = NULL;
	MediaVisibility _tmp19_ = 0;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	g_return_val_if_fail (IS_DELTA_UPDATER (delta_updater), NULL);
	self = (TweetInfoPage*) scroll_widget_construct (object_type);
	_tmp0_ = id;
	ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), _tmp0_);
	_tmp1_ = account;
	self->account = _tmp1_;
	_tmp2_ = self->priv->top_list_box;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	_tmp4_ = self->priv->bottom_list_box;
	_tmp5_ = account;
	_tmp4_->account = _tmp5_;
	_tmp6_ = self->priv->top_list_box;
	_tmp7_ = delta_updater;
	_tmp6_->delta_updater = _tmp7_;
	_tmp8_ = self->priv->bottom_list_box;
	_tmp9_ = delta_updater;
	_tmp8_->delta_updater = _tmp9_;
	_tmp10_ = self->priv->mm_widget;
	g_signal_connect_object (_tmp10_, "media-clicked", (GCallback) ___lambda59__multi_media_widget_media_clicked, self, 0);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "scroll-event", (GCallback) ___lambda62__gtk_widget_scroll_event, self, 0);
	_tmp11_ = self->priv->bottom_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda63__gtk_list_box_row_activated, self, 0);
	_tmp12_ = self->priv->top_list_box;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_list_box_get_type (), GtkListBox), "row-activated", (GCallback) ___lambda64__gtk_list_box_row_activated, self, 0);
	_tmp13_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->actions);
	self->priv->actions = _tmp13_;
	_tmp14_ = self->priv->actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_action_map_get_type (), GActionMap), TWEET_INFO_PAGE_action_entries, G_N_ELEMENTS (TWEET_INFO_PAGE_action_entries), self);
	_tmp15_ = self->priv->actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_action_group_get_type (), GActionGroup));
	_tmp16_ = settings_get ();
	_tmp17_ = _tmp16_;
	g_signal_connect_object (_tmp17_, "changed::media-visibility", (GCallback) _tweet_info_page_media_visiblity_changed_cb_g_settings_changed, self, 0);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->mm_widget;
	_tmp19_ = settings_get_media_visiblity ();
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), _tmp19_ != MEDIA_VISIBILITY_HIDE);
	return self;
}


TweetInfoPage* tweet_info_page_new (gint id, Account* account, DeltaUpdater* delta_updater) {
	return tweet_info_page_construct (TYPE_TWEET_INFO_PAGE, id, account, delta_updater);
}


static void tweet_info_page_media_visiblity_changed_cb (TweetInfoPage* self) {
	MediaVisibility _tmp0_ = 0;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = settings_get_media_visiblity ();
	if (_tmp0_ == MEDIA_VISIBILITY_HIDE) {
		MultiMediaWidget* _tmp1_ = NULL;
		_tmp1_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	} else {
		MultiMediaWidget* _tmp2_ = NULL;
		_tmp2_ = self->priv->mm_widget;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tweet_info_page_real_on_join (IPage* base, gint page_id, Bundle* args) {
	TweetInfoPage * self;
	gint mode = 0;
	Bundle* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean existing = FALSE;
	Bundle* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	ReplyIndicator* _tmp5_ = NULL;
	MaxSizeContainer* _tmp6_ = NULL;
	GtkStack* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gint _tmp20_ = 0;
	gboolean _tmp41_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((args == NULL) || IS_BUNDLE (args));
	_tmp0_ = args;
	_tmp1_ = bundle_get_int (_tmp0_, "mode");
	mode = _tmp1_;
	_tmp2_ = mode;
	if (_tmp2_ == 0) {
		return;
	}
	self->priv->values_set = FALSE;
	_tmp3_ = args;
	_tmp4_ = bundle_get_bool (_tmp3_, "existing", FALSE);
	existing = _tmp4_;
	_tmp5_ = self->priv->reply_indicator;
	reply_indicator_set_replies_available (_tmp5_, FALSE);
	_tmp6_ = self->priv->max_size_container;
	max_size_container_set_max_size (_tmp6_, 0);
	_tmp7_ = self->priv->main_stack;
	_tmp8_ = self->priv->grid;
	gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = existing;
	if (_tmp9_) {
		CbTweet* tweet = NULL;
		Bundle* _tmp10_ = NULL;
		GObject* _tmp11_ = NULL;
		CbTweet* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp10_ = args;
		_tmp11_ = bundle_get_object (_tmp10_, "tweet");
		tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, CB_TYPE_TWEET, CbTweet);
		_tmp12_ = tweet;
		_tmp13_ = _tmp12_->id;
		tweet_info_page_rearrange_tweets (self, _tmp13_);
		_g_object_unref0 (tweet);
	} else {
		TweetListBox* _tmp14_ = NULL;
		TweetModel* _tmp15_ = NULL;
		TweetListBox* _tmp16_ = NULL;
		TweetListBox* _tmp17_ = NULL;
		TweetModel* _tmp18_ = NULL;
		TweetListBox* _tmp19_ = NULL;
		_tmp14_ = self->priv->bottom_list_box;
		_tmp15_ = _tmp14_->model;
		tweet_model_clear (_tmp15_);
		_tmp16_ = self->priv->bottom_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
		_tmp17_ = self->priv->top_list_box;
		_tmp18_ = _tmp17_->model;
		tweet_model_clear (_tmp18_);
		_tmp19_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp20_ = mode;
	if (_tmp20_ == TWEET_INFO_PAGE_BY_INSTANCE) {
		CbTweet* tweet = NULL;
		Bundle* _tmp21_ = NULL;
		GObject* _tmp22_ = NULL;
		CbTweet* _tmp23_ = NULL;
		CbMiniTweet* _tmp24_ = NULL;
		CbTweet* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		CbTweet* _tmp33_ = NULL;
		CbTweet* _tmp34_ = NULL;
		CbTweet* _tmp35_ = NULL;
		_tmp21_ = args;
		_tmp22_ = bundle_get_object (_tmp21_, "tweet");
		tweet = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, CB_TYPE_TWEET, CbTweet);
		_tmp23_ = tweet;
		_tmp24_ = _tmp23_->retweeted_tweet;
		if (_tmp24_ != NULL) {
			CbTweet* _tmp25_ = NULL;
			CbMiniTweet* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			_tmp25_ = tweet;
			_tmp26_ = _tmp25_->retweeted_tweet;
			_tmp27_ = (*_tmp26_).id;
			self->priv->tweet_id = _tmp27_;
		} else {
			CbTweet* _tmp28_ = NULL;
			gint64 _tmp29_ = 0LL;
			_tmp28_ = tweet;
			_tmp29_ = _tmp28_->id;
			self->priv->tweet_id = _tmp29_;
		}
		_tmp30_ = tweet;
		_tmp31_ = cb_tweet_get_screen_name (_tmp30_);
		_tmp32_ = g_strdup (_tmp31_);
		_g_free0 (self->priv->screen_name);
		self->priv->screen_name = _tmp32_;
		_tmp33_ = tweet;
		_tmp34_ = _g_object_ref0 (_tmp33_);
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp34_;
		_tmp35_ = tweet;
		tweet_info_page_set_tweet_data (self, _tmp35_, NULL);
		_g_object_unref0 (tweet);
	} else {
		gint _tmp36_ = 0;
		_tmp36_ = mode;
		if (_tmp36_ == TWEET_INFO_PAGE_BY_ID) {
			Bundle* _tmp37_ = NULL;
			gint64 _tmp38_ = 0LL;
			Bundle* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			_g_object_unref0 (self->priv->tweet);
			self->priv->tweet = NULL;
			_tmp37_ = args;
			_tmp38_ = bundle_get_int64 (_tmp37_, "tweet_id");
			self->priv->tweet_id = _tmp38_;
			_tmp39_ = args;
			_tmp40_ = bundle_get_string (_tmp39_, "screen_name");
			_g_free0 (self->priv->screen_name);
			self->priv->screen_name = _tmp40_;
		}
	}
	_tmp41_ = existing;
	tweet_info_page_query_tweet_info (self, _tmp41_);
}


static void tweet_info_page_rearrange_tweets (TweetInfoPage* self, gint64 new_id) {
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->top_list_box;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = new_id;
	_tmp3_ = tweet_model_contains_id (_tmp1_, _tmp2_);
	if (_tmp3_) {
		TweetListBox* _tmp4_ = NULL;
		TweetModel* _tmp5_ = NULL;
		CbTweet* _tmp6_ = NULL;
		TweetListBox* _tmp7_ = NULL;
		TweetListBox* _tmp8_ = NULL;
		TweetModel* _tmp9_ = NULL;
		TweetListBox* _tmp10_ = NULL;
		_tmp4_ = self->priv->bottom_list_box;
		_tmp5_ = _tmp4_->model;
		_tmp6_ = self->priv->tweet;
		tweet_model_add (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->bottom_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->top_list_box;
		_tmp9_ = _tmp8_->model;
		tweet_model_clear (_tmp9_);
		_tmp10_ = self->priv->top_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
	} else {
		TweetListBox* _tmp11_ = NULL;
		TweetModel* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = self->priv->bottom_list_box;
		_tmp12_ = _tmp11_->model;
		_tmp13_ = new_id;
		_tmp14_ = tweet_model_contains_id (_tmp12_, _tmp13_);
		if (_tmp14_) {
			TweetListBox* _tmp15_ = NULL;
			TweetModel* _tmp16_ = NULL;
			TweetListBox* _tmp17_ = NULL;
			CbTweet* t = NULL;
			TweetListBox* _tmp18_ = NULL;
			TweetModel* _tmp19_ = NULL;
			gint64 _tmp20_ = 0LL;
			CbTweet* _tmp21_ = NULL;
			CbTweet* _tmp22_ = NULL;
			ReplyIndicator* _tmp29_ = NULL;
			TweetListBox* _tmp30_ = NULL;
			TweetModel* _tmp31_ = NULL;
			gint64 _tmp32_ = 0LL;
			TweetListBox* _tmp33_ = NULL;
			TweetModel* _tmp34_ = NULL;
			guint _tmp35_ = 0U;
			_tmp15_ = self->priv->top_list_box;
			_tmp16_ = _tmp15_->model;
			tweet_model_clear (_tmp16_);
			_tmp17_ = self->priv->top_list_box;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget));
			_tmp18_ = self->priv->bottom_list_box;
			_tmp19_ = _tmp18_->model;
			_tmp20_ = new_id;
			_tmp21_ = tweet_model_get_from_id (_tmp19_, _tmp20_, -1);
			t = _tmp21_;
			_tmp22_ = t;
			if (_tmp22_ != NULL) {
				TweetListBox* _tmp23_ = NULL;
				TweetModel* _tmp24_ = NULL;
				CbTweet* _tmp25_ = NULL;
				_tmp23_ = self->priv->top_list_box;
				_tmp24_ = _tmp23_->model;
				_tmp25_ = t;
				tweet_model_add (_tmp24_, _tmp25_);
			} else {
				TweetListBox* _tmp26_ = NULL;
				TweetModel* _tmp27_ = NULL;
				CbTweet* _tmp28_ = NULL;
				_tmp26_ = self->priv->top_list_box;
				_tmp27_ = _tmp26_->model;
				_tmp28_ = self->priv->tweet;
				tweet_model_add (_tmp27_, _tmp28_);
			}
			_tmp29_ = self->priv->reply_indicator;
			reply_indicator_set_replies_available (_tmp29_, TRUE);
			_tmp30_ = self->priv->bottom_list_box;
			_tmp31_ = _tmp30_->model;
			_tmp32_ = new_id;
			tweet_model_remove_tweets_above (_tmp31_, _tmp32_);
			_tmp33_ = self->priv->bottom_list_box;
			_tmp34_ = _tmp33_->model;
			_tmp35_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_list_model_get_type (), GListModel));
			if (_tmp35_ == ((guint) 0)) {
				TweetListBox* _tmp36_ = NULL;
				_tmp36_ = self->priv->bottom_list_box;
				gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget));
			}
			_g_object_unref0 (t);
		}
	}
}


static void tweet_info_page_real_on_leave (IPage* base) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
}


static void __lambda71_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda71__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda71_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_favorite_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	CbTweet* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp2_ = self->account;
	_tmp3_ = self->priv->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_set_favorite_status (_tmp2_, _tmp3_, _tmp6_, ___lambda71__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_favorite_button_toggled_cb ((TweetInfoPage*) self);
}


static void __lambda73_ (TweetInfoPage* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda73__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda73_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_retweet_button_toggled_cb (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	GtkToggleButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Account* _tmp9_ = NULL;
	CbTweet* _tmp10_ = NULL;
	GtkToggleButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->retweet_button;
	_tmp3_ = gtk_toggle_button_get_active (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		CbTweet* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp5_ = self->priv->tweet;
		_tmp6_ = _tmp5_->retweet_count;
		_tmp5_->retweet_count = _tmp6_ + 1;
	} else {
		CbTweet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		_tmp7_ = self->priv->tweet;
		_tmp8_ = _tmp7_->retweet_count;
		_tmp7_->retweet_count = _tmp8_ - 1;
	}
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = self->account;
	_tmp10_ = self->priv->tweet;
	_tmp11_ = self->priv->retweet_button;
	_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
	_tmp13_ = _tmp12_;
	tweet_utils_set_retweet_status (_tmp9_, _tmp10_, _tmp13_, ___lambda73__gasync_ready_callback, g_object_ref (self));
}


static void _tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_info_page_retweet_button_toggled_cb ((TweetInfoPage*) self);
}


static void tweet_info_page_reply_button_clicked_cb (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void _tweet_info_page_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_reply_button_clicked_cb ((TweetInfoPage*) self);
}


static gboolean tweet_info_page_link_activated_cb (TweetInfoPage* self, const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = tweet_utils_activate_link (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gboolean _tweet_info_page_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_info_page_link_activated_cb ((TweetInfoPage*) self, uri);
	return result;
}


static void tweet_info_page_name_button_clicked_cb (TweetInfoPage* self) {
	gint64 id = 0LL;
	gchar* screen_name = NULL;
	CbTweet* _tmp0_ = NULL;
	CbMiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	const gchar* _tmp22_ = NULL;
	MainWindow* _tmp23_ = NULL;
	MainWidget* _tmp24_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		CbTweet* _tmp2_ = NULL;
		CbMiniTweet* _tmp3_ = NULL;
		CbUserIdentity _tmp4_ = {0};
		gint64 _tmp5_ = 0LL;
		CbTweet* _tmp6_ = NULL;
		CbMiniTweet* _tmp7_ = NULL;
		CbUserIdentity _tmp8_ = {0};
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = (*_tmp3_).author;
		_tmp5_ = _tmp4_.id;
		id = _tmp5_;
		_tmp6_ = self->priv->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = (*_tmp7_).author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		CbTweet* _tmp11_ = NULL;
		CbMiniTweet _tmp12_ = {0};
		CbUserIdentity _tmp13_ = {0};
		gint64 _tmp14_ = 0LL;
		CbTweet* _tmp15_ = NULL;
		CbMiniTweet _tmp16_ = {0};
		CbUserIdentity _tmp17_ = {0};
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp11_ = self->priv->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_.author;
		_tmp14_ = _tmp13_.id;
		id = _tmp14_;
		_tmp15_ = self->priv->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_.author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = id;
	bundle_put_int64 (bundle, "user_id", _tmp21_);
	_tmp22_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp22_);
	_tmp23_ = self->priv->main_window;
	_tmp24_ = _tmp23_->main_widget;
	main_widget_switch_page (_tmp24_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_info_page_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_info_page_name_button_clicked_cb ((TweetInfoPage*) self);
}


static Block28Data* block28_data_ref (Block28Data* _data28_) {
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}


static void block28_data_unref (void * _userdata_) {
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data28_->self;
		_g_date_time_unref0 (_data28_->now);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda67_ (Block28Data* _data28_, GObject* __, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonNode* root = NULL;
	JsonNode* _tmp12_ = NULL;
	JsonObject* root_object = NULL;
	JsonNode* _tmp13_ = NULL;
	JsonObject* _tmp14_ = NULL;
	JsonObject* _tmp15_ = NULL;
	CbTweet* _tmp16_ = NULL;
	gchar* with = NULL;
	JsonObject* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	CbTweet* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data28_->self;
	g_return_if_fail ((__ == NULL) || G_IS_OBJECT (__));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch27_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GtkLabel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		GtkStack* _tmp10_ = NULL;
		GtkLabel* _tmp11_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->error_label;
		_tmp5_ = _ ("Could not show tweet");
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup_printf ("%s: %s", _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		gtk_label_set_label (_tmp4_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->main_stack;
		_tmp11_ = self->priv->error_label;
		gtk_stack_set_visible_child (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		return;
	}
	__finally27:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp12_ = root;
	if (_tmp12_ == NULL) {
		__vala_JsonNode_free0 (root);
		return;
	}
	_tmp13_ = root;
	_tmp14_ = json_node_get_object (_tmp13_);
	_tmp15_ = _json_object_ref0 (_tmp14_);
	root_object = _tmp15_;
	_tmp16_ = self->priv->tweet;
	if (_tmp16_ != NULL) {
		gint n_retweets = 0;
		JsonObject* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		gint n_favorites = 0;
		JsonObject* _tmp19_ = NULL;
		gint64 _tmp20_ = 0LL;
		CbTweet* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		CbTweet* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp17_ = root_object;
		_tmp18_ = json_object_get_int_member (_tmp17_, "retweet_count");
		n_retweets = (gint) _tmp18_;
		_tmp19_ = root_object;
		_tmp20_ = json_object_get_int_member (_tmp19_, "favorite_count");
		n_favorites = (gint) _tmp20_;
		_tmp21_ = self->priv->tweet;
		_tmp22_ = n_retweets;
		_tmp21_->retweet_count = _tmp22_;
		_tmp23_ = self->priv->tweet;
		_tmp24_ = n_favorites;
		_tmp23_->favorite_count = _tmp24_;
	} else {
		CbTweet* _tmp25_ = NULL;
		CbTweet* _tmp26_ = NULL;
		JsonNode* _tmp27_ = NULL;
		Account* _tmp28_ = NULL;
		gint64 _tmp29_ = 0LL;
		_tmp25_ = cb_tweet_new ();
		_g_object_unref0 (self->priv->tweet);
		self->priv->tweet = _tmp25_;
		_tmp26_ = self->priv->tweet;
		_tmp27_ = root;
		_tmp28_ = self->account;
		_tmp29_ = _tmp28_->id;
		cb_tweet_load_from_json (_tmp26_, _tmp27_, _tmp29_, _data28_->now);
	}
	_tmp30_ = root_object;
	_tmp31_ = json_object_get_string_member (_tmp30_, "source");
	_tmp32_ = g_strdup (_tmp31_);
	with = _tmp32_;
	_tmp33_ = with;
	_tmp34_ = tweet_info_page_extract_source (self, _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strconcat ("<span underline='none'>", _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat (_tmp37_, "</span>", NULL);
	_g_free0 (with);
	with = _tmp38_;
	_g_free0 (_tmp37_);
	_g_free0 (_tmp35_);
	_tmp39_ = self->priv->tweet;
	_tmp40_ = with;
	tweet_info_page_set_tweet_data (self, _tmp39_, _tmp40_);
	_tmp41_ = _data28_->existing;
	if (!_tmp41_) {
		CbTweet* _tmp42_ = NULL;
		gint64 _tmp43_ = 0LL;
		_tmp42_ = self->priv->tweet;
		_tmp43_ = _tmp42_->reply_id;
		tweet_info_page_load_replied_to_tweet (self, _tmp43_);
	}
	self->priv->values_set = TRUE;
	_g_free0 (with);
	_json_object_unref0 (root_object);
	__vala_JsonNode_free0 (root);
}


static void ___lambda67__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda67_ (self, source_object, res);
	block28_data_unref (self);
}


static Block29Data* block29_data_ref (Block29Data* _data29_) {
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}


static void block29_data_unref (void * _userdata_) {
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data29_->_data28_->self;
		block28_data_unref (_data29_->_data28_);
		_data29_->_data28_ = NULL;
		g_slice_free (Block29Data, _data29_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static void __lambda70_ (Block29Data* _data29_, JsonArray* arr, guint index, JsonNode* node) {
	Block28Data* _data28_;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	JsonObject* obj = NULL;
	JsonNode* _tmp1_ = NULL;
	JsonObject* _tmp2_ = NULL;
	JsonObject* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	JsonObject* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint64 reply_id = 0LL;
	JsonObject* _tmp9_ = NULL;
	gint64 _tmp10_ = 0LL;
	gint64 _tmp11_ = 0LL;
	gint64 _tmp12_ = 0LL;
	CbTweet* t = NULL;
	CbTweet* _tmp13_ = NULL;
	CbTweet* _tmp14_ = NULL;
	JsonNode* _tmp15_ = NULL;
	Account* _tmp16_ = NULL;
	gint64 _tmp17_ = 0LL;
	CbTweet* _tmp18_ = NULL;
	gint64 _tmp19_ = 0LL;
	gint64 _tmp20_ = 0LL;
	_data28_ = _data29_->_data28_;
	self = _data28_->self;
	g_return_if_fail (arr != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = _data29_->n_replies;
	if (_tmp0_ >= 5) {
		return;
	}
	_tmp1_ = node;
	_tmp2_ = json_node_get_object (_tmp1_);
	_tmp3_ = _json_object_ref0 (_tmp2_);
	obj = _tmp3_;
	_tmp5_ = obj;
	_tmp6_ = json_object_has_member (_tmp5_, "in_reply_to_status_id");
	if (!_tmp6_) {
		_tmp4_ = TRUE;
	} else {
		JsonObject* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = obj;
		_tmp8_ = json_object_get_null_member (_tmp7_, "in_reply_to_status_id");
		_tmp4_ = _tmp8_;
	}
	if (_tmp4_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp9_ = obj;
	_tmp10_ = json_object_get_int_member (_tmp9_, "in_reply_to_status_id");
	reply_id = _tmp10_;
	_tmp11_ = reply_id;
	_tmp12_ = self->priv->tweet_id;
	if (_tmp11_ != _tmp12_) {
		_json_object_unref0 (obj);
		return;
	}
	_tmp13_ = cb_tweet_new ();
	t = _tmp13_;
	_tmp14_ = t;
	_tmp15_ = node;
	_tmp16_ = self->account;
	_tmp17_ = _tmp16_->id;
	cb_tweet_load_from_json (_tmp14_, _tmp15_, _tmp17_, _data28_->now);
	_tmp18_ = t;
	_tmp19_ = _tmp18_->id;
	_tmp20_ = _data29_->previous_tweet_id;
	if (_tmp19_ != _tmp20_) {
		TweetListBox* _tmp21_ = NULL;
		TweetModel* _tmp22_ = NULL;
		CbTweet* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		_tmp21_ = self->priv->top_list_box;
		_tmp22_ = _tmp21_->model;
		_tmp23_ = t;
		tweet_model_add (_tmp22_, _tmp23_);
		_tmp24_ = _data29_->n_replies;
		_data29_->n_replies = _tmp24_ + 1;
	}
	_g_object_unref0 (t);
	_json_object_unref0 (obj);
}


static void ___lambda70__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda70_ (self, array, index_, element_node);
}


static void __lambda69_ (Block28Data* _data28_, GObject* _, GAsyncResult* res) {
	TweetInfoPage* self;
	Block29Data* _data29_;
	JsonNode* root = NULL;
	JsonNode* _tmp6_ = NULL;
	JsonArray* statuses_node = NULL;
	JsonNode* _tmp7_ = NULL;
	JsonObject* _tmp8_ = NULL;
	JsonArray* _tmp9_ = NULL;
	JsonArray* _tmp10_ = NULL;
	TweetListBox* _tmp11_ = NULL;
	TweetModel* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	JsonArray* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	GError * _inner_error_ = NULL;
	self = _data28_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->_data28_ = block28_data_ref (_data28_);
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		JsonNode* _tmp2_ = NULL;
		JsonNode* _tmp3_ = NULL;
		_tmp1_ = res;
		_tmp2_ = tweet_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("TweetInfoPage.vala:339: %s", _tmp5_);
		_g_error_free0 (e);
		__vala_JsonNode_free0 (root);
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		block29_data_unref (_data29_);
		_data29_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	if (_tmp6_ == NULL) {
		__vala_JsonNode_free0 (root);
		block29_data_unref (_data29_);
		_data29_ = NULL;
		return;
	}
	_tmp7_ = root;
	_tmp8_ = json_node_get_object (_tmp7_);
	_tmp9_ = json_object_get_array_member (_tmp8_, "statuses");
	_tmp10_ = _json_array_ref0 (_tmp9_);
	statuses_node = _tmp10_;
	_data29_->previous_tweet_id = (gint64) -1;
	_tmp11_ = self->priv->top_list_box;
	_tmp12_ = _tmp11_->model;
	_tmp13_ = g_list_model_get_n_items (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_list_model_get_type (), GListModel));
	if (_tmp13_ > ((guint) 0)) {
		TweetListBox* _tmp14_ = NULL;
		TweetModel* _tmp15_ = NULL;
		GObject* _tmp16_ = NULL;
		CbTweet* _tmp17_ = NULL;
		gint64 _tmp18_ = 0LL;
		_tmp14_ = self->priv->top_list_box;
		_tmp15_ = _tmp14_->model;
		_tmp16_ = g_list_model_get_item (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_list_model_get_type (), GListModel), (guint) 0);
		_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, CB_TYPE_TWEET, CbTweet);
		_tmp18_ = _tmp17_->id;
		_data29_->previous_tweet_id = _tmp18_;
		_g_object_unref0 (_tmp17_);
	}
	_data29_->n_replies = 0;
	_tmp19_ = statuses_node;
	json_array_foreach_element (_tmp19_, ___lambda70__json_array_foreach, _data29_);
	_tmp20_ = _data29_->n_replies;
	if (_tmp20_ > 0) {
		TweetListBox* _tmp21_ = NULL;
		ReplyIndicator* _tmp22_ = NULL;
		_tmp21_ = self->priv->top_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_tmp22_ = self->priv->reply_indicator;
		reply_indicator_set_replies_available (_tmp22_, TRUE);
	} else {
	}
	_json_array_unref0 (statuses_node);
	__vala_JsonNode_free0 (root);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}


static void ___lambda69__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda69_ (self, source_object, res);
	block28_data_unref (self);
}


static void tweet_info_page_query_tweet_info (TweetInfoPage* self, gboolean existing) {
	Block28Data* _data28_;
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_ = NULL;
	GCancellable* _tmp3_ = NULL;
	GDateTime* _tmp4_ = NULL;
	RestProxyCall* call = NULL;
	Account* _tmp5_ = NULL;
	OAuthProxy* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GCancellable* _tmp11_ = NULL;
	RestProxyCall* reply_call = NULL;
	Account* _tmp12_ = NULL;
	OAuthProxy* _tmp13_ = NULL;
	RestProxyCall* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gint64 _tmp18_ = 0LL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GCancellable* _tmp21_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = existing;
	_data28_->existing = _tmp0_;
	_tmp1_ = self->priv->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_ = NULL;
		_tmp2_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp2_);
	}
	_tmp3_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp3_;
	_tmp4_ = g_date_time_new_now_local ();
	_data28_->now = _tmp4_;
	_tmp5_ = self->account;
	_tmp6_ = _tmp5_->proxy;
	_tmp7_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, rest_proxy_get_type (), RestProxy));
	call = _tmp7_;
	rest_proxy_call_set_method (call, "GET");
	rest_proxy_call_set_function (call, "1.1/statuses/show.json");
	_tmp8_ = self->priv->tweet_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (call, "id", _tmp10_);
	_g_free0 (_tmp10_);
	rest_proxy_call_add_param (call, "include_my_retweet", "true");
	rest_proxy_call_add_param (call, "tweet_mode", "extended");
	_tmp11_ = self->priv->cancellable;
	tweet_utils_load_threaded (call, _tmp11_, ___lambda67__gasync_ready_callback, block28_data_ref (_data28_));
	_tmp12_ = self->account;
	_tmp13_ = _tmp12_->proxy;
	_tmp14_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, rest_proxy_get_type (), RestProxy));
	reply_call = _tmp14_;
	rest_proxy_call_set_method (reply_call, "GET");
	rest_proxy_call_set_function (reply_call, "1.1/search/tweets.json");
	_tmp15_ = self->priv->screen_name;
	_tmp16_ = g_strconcat ("to:", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	rest_proxy_call_add_param (reply_call, "q", _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = self->priv->tweet_id;
	_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp18_);
	_tmp20_ = _tmp19_;
	rest_proxy_call_add_param (reply_call, "since_id", _tmp20_);
	_g_free0 (_tmp20_);
	rest_proxy_call_add_param (reply_call, "count", "200");
	rest_proxy_call_add_param (reply_call, "tweet_mode", "extended");
	_tmp21_ = self->priv->cancellable;
	tweet_utils_load_threaded (reply_call, _tmp21_, ___lambda69__gasync_ready_callback, block28_data_ref (_data28_));
	_g_object_unref0 (reply_call);
	_g_object_unref0 (call);
	block28_data_unref (_data28_);
	_data28_ = NULL;
}


/**
   * Loads the tweet this tweet is a reply to.
   * This will recursively call itself until the end of the chain is reached.
   *
   * @param reply_id The id of the tweet the previous tweet was a reply to.
   */
static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->call);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda68_ (Block30Data* _data30_, GObject* obj, GAsyncResult* res) {
	TweetInfoPage* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp26_ = NULL;
	CbTweet* tweet = NULL;
	CbTweet* _tmp32_ = NULL;
	CbTweet* _tmp33_ = NULL;
	JsonParser* _tmp34_ = NULL;
	JsonNode* _tmp35_ = NULL;
	Account* _tmp36_ = NULL;
	gint64 _tmp37_ = 0LL;
	GDateTime* _tmp38_ = NULL;
	GDateTime* _tmp39_ = NULL;
	TweetListBox* _tmp40_ = NULL;
	TweetModel* _tmp41_ = NULL;
	CbTweet* _tmp42_ = NULL;
	CbTweet* _tmp43_ = NULL;
	gint64 _tmp44_ = 0LL;
	GError * _inner_error_ = NULL;
	self = _data30_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		_tmp0_ = _data30_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch29_g_error;
		}
	}
	goto __finally29;
	__catch29_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		TweetListBox* _tmp21_ = NULL;
		TweetListBox* _tmp22_ = NULL;
		GList* _tmp23_ = NULL;
		GList* _tmp24_ = NULL;
		guint _tmp25_ = 0U;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("TweetInfoPage.vala:407: %s", _tmp3_);
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_strip (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strcmp0 (_tmp8_, "Forbidden") != 0;
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			_tmp12_ = string_strip (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
			_tmp15_ = _tmp14_;
			_tmp4_ = g_strcmp0 (_tmp15_, "not found") != 0;
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			RestProxyCall* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GError* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			MainWindow* _tmp20_ = NULL;
			_tmp16_ = _data30_->call;
			_tmp17_ = rest_proxy_call_get_payload (_tmp16_);
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			_tmp20_ = self->priv->main_window;
			utils_show_error_object (_tmp17_, _tmp19_, 411, "TweetInfoPage.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_window_get_type (), GtkWindow));
		}
		_tmp21_ = self->priv->bottom_list_box;
		_tmp22_ = self->priv->bottom_list_box;
		_tmp23_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_container_get_type (), GtkContainer));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_list_length (_tmp24_);
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget), _tmp25_ > ((guint) 0));
		_g_list_free0 (_tmp24_);
		_g_error_free0 (e);
		return;
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp26_ = json_parser_new ();
	parser = _tmp26_;
	{
		JsonParser* _tmp27_ = NULL;
		RestProxyCall* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp27_ = parser;
		_tmp28_ = _data30_->call;
		_tmp29_ = rest_proxy_call_get_payload (_tmp28_);
		json_parser_load_from_data (_tmp27_, _tmp29_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch30_g_error;
		}
	}
	goto __finally30;
	__catch30_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_critical ("TweetInfoPage.vala:421: %s", _tmp31_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally30:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp32_ = cb_tweet_new ();
	tweet = _tmp32_;
	_tmp33_ = tweet;
	_tmp34_ = parser;
	_tmp35_ = json_parser_get_root (_tmp34_);
	_tmp36_ = self->account;
	_tmp37_ = _tmp36_->id;
	_tmp38_ = g_date_time_new_now_local ();
	_tmp39_ = _tmp38_;
	cb_tweet_load_from_json (_tmp33_, _tmp35_, _tmp37_, _tmp39_);
	_g_date_time_unref0 (_tmp39_);
	_tmp40_ = self->priv->bottom_list_box;
	_tmp41_ = _tmp40_->model;
	_tmp42_ = tweet;
	tweet_model_add (_tmp41_, _tmp42_);
	_tmp43_ = tweet;
	_tmp44_ = _tmp43_->reply_id;
	tweet_info_page_load_replied_to_tweet (self, _tmp44_);
	_g_object_unref0 (tweet);
	_g_object_unref0 (parser);
}


static void ___lambda68__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda68_ (self, source_object, res);
	block30_data_unref (self);
}


static void tweet_info_page_load_replied_to_tweet (TweetInfoPage* self, gint64 reply_id) {
	Block30Data* _data30_;
	gint64 _tmp0_ = 0LL;
	TweetListBox* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	OAuthProxy* _tmp3_ = NULL;
	RestProxyCall* _tmp4_ = NULL;
	RestProxyCall* _tmp5_ = NULL;
	RestProxyCall* _tmp6_ = NULL;
	RestProxyCall* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	RestProxyCall* _tmp11_ = NULL;
	RestProxyCall* _tmp12_ = NULL;
	GCancellable* _tmp13_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = reply_id;
	if (_tmp0_ == ((gint64) 0)) {
		block30_data_unref (_data30_);
		_data30_ = NULL;
		return;
	}
	_tmp1_ = self->priv->bottom_list_box;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = self->account;
	_tmp3_ = _tmp2_->proxy;
	_tmp4_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, rest_proxy_get_type (), RestProxy));
	_data30_->call = _tmp4_;
	_tmp5_ = _data30_->call;
	rest_proxy_call_set_function (_tmp5_, "1.1/statuses/show.json");
	_tmp6_ = _data30_->call;
	rest_proxy_call_set_method (_tmp6_, "GET");
	_tmp7_ = _data30_->call;
	_tmp8_ = reply_id;
	_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp8_);
	_tmp10_ = _tmp9_;
	rest_proxy_call_add_param (_tmp7_, "id", _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = _data30_->call;
	rest_proxy_call_add_param (_tmp11_, "tweet_mode", "extended");
	_tmp12_ = _data30_->call;
	_tmp13_ = self->priv->cancellable;
	rest_proxy_call_invoke_async (_tmp12_, _tmp13_, ___lambda68__gasync_ready_callback, block30_data_ref (_data30_));
	block30_data_unref (_data30_);
	_data30_ = NULL;
}


/**
   *
   */
static void tweet_info_page_set_tweet_data (TweetInfoPage* self, CbTweet* tweet, const gchar* with) {
	Account* _tmp0_ = NULL;
	CbUserCounter* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	CbTweet* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	CbTweet* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gint64 _tmp8_ = 0LL;
	CbTweet* _tmp9_ = NULL;
	CbMiniTweet* _tmp10_ = NULL;
	GDateTime* created_at = NULL;
	GDateTime* _tmp17_ = NULL;
	gchar* time_format = NULL;
	GDateTime* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GtkLabel* _tmp26_ = NULL;
	CbTweet* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	TextButton* _tmp30_ = NULL;
	CbTweet* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	GtkLabel* _tmp33_ = NULL;
	CbTweet* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	Twitter* _tmp38_ = NULL;
	Twitter* _tmp39_ = NULL;
	CbTweet* _tmp40_ = NULL;
	gint64 _tmp41_ = 0LL;
	CbTweet* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	AvatarWidget* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	GtkToggleButton* _tmp47_ = NULL;
	CbTweet* _tmp48_ = NULL;
	gboolean _tmp49_ = FALSE;
	GtkToggleButton* _tmp50_ = NULL;
	CbTweet* _tmp51_ = NULL;
	gboolean _tmp52_ = FALSE;
	AvatarWidget* _tmp53_ = NULL;
	CbTweet* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	CbTweet* _tmp56_ = NULL;
	gint64 _tmp57_ = 0LL;
	CbTweet* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	CbTweet* _tmp60_ = NULL;
	gboolean _tmp61_ = FALSE;
	GSimpleActionGroup* _tmp69_ = NULL;
	GAction* _tmp70_ = NULL;
	CbTweet* _tmp71_ = NULL;
	gint64 _tmp72_ = 0LL;
	Account* _tmp73_ = NULL;
	gint64 _tmp74_ = 0LL;
	CbTweet* _tmp75_ = NULL;
	gboolean _tmp76_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (CB_IS_TWEET (tweet));
	_tmp0_ = self->account;
	_tmp1_ = _tmp0_->user_counter;
	_tmp2_ = tweet;
	_tmp3_ = cb_tweet_get_user_id (_tmp2_);
	_tmp4_ = tweet;
	_tmp5_ = cb_tweet_get_screen_name (_tmp4_);
	_tmp6_ = tweet;
	_tmp7_ = cb_tweet_get_user_name (_tmp6_);
	cb_user_counter_user_seen (_tmp1_, _tmp3_, _tmp5_, _tmp7_);
	_tmp9_ = tweet;
	_tmp10_ = _tmp9_->retweeted_tweet;
	if (_tmp10_ != NULL) {
		CbTweet* _tmp11_ = NULL;
		CbMiniTweet* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp11_ = tweet;
		_tmp12_ = _tmp11_->retweeted_tweet;
		_tmp13_ = (*_tmp12_).created_at;
		_tmp8_ = _tmp13_;
	} else {
		CbTweet* _tmp14_ = NULL;
		CbMiniTweet _tmp15_ = {0};
		gint64 _tmp16_ = 0LL;
		_tmp14_ = tweet;
		_tmp15_ = _tmp14_->source_tweet;
		_tmp16_ = _tmp15_.created_at;
		_tmp8_ = _tmp16_;
	}
	_tmp17_ = g_date_time_new_from_unix_local (_tmp8_);
	created_at = _tmp17_;
	_tmp18_ = created_at;
	_tmp19_ = g_date_time_format (_tmp18_, "%x, %X");
	time_format = _tmp19_;
	_tmp20_ = with;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		_tmp21_ = time_format;
		_tmp22_ = with;
		_tmp23_ = g_strconcat (" via ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp21_, _tmp24_, NULL);
		_g_free0 (time_format);
		time_format = _tmp25_;
		_g_free0 (_tmp24_);
	}
	_tmp26_ = self->priv->text_label;
	_tmp27_ = tweet;
	_tmp28_ = cb_tweet_get_formatted_text (_tmp27_);
	_tmp29_ = _tmp28_;
	gtk_label_set_label (_tmp26_, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp30_ = self->priv->name_button;
	_tmp31_ = tweet;
	_tmp32_ = cb_tweet_get_user_name (_tmp31_);
	text_button_set_markup (_tmp30_, _tmp32_);
	_tmp33_ = self->priv->screen_name_label;
	_tmp34_ = tweet;
	_tmp35_ = cb_tweet_get_screen_name (_tmp34_);
	_tmp36_ = g_strconcat ("@", _tmp35_, NULL);
	_tmp37_ = _tmp36_;
	gtk_label_set_label (_tmp33_, _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = twitter_get ();
	_tmp39_ = _tmp38_;
	_tmp40_ = tweet;
	_tmp41_ = cb_tweet_get_user_id (_tmp40_);
	_tmp42_ = tweet;
	_tmp43_ = _tmp42_->avatar_url;
	_tmp44_ = self->priv->avatar_image;
	twitter_get_avatar (_tmp39_, _tmp41_, _tmp43_, _tmp44_, 48, FALSE, NULL, NULL);
	_g_object_unref0 (_tmp39_);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp45_ = self->priv->time_label;
	_tmp46_ = time_format;
	gtk_label_set_label (_tmp45_, _tmp46_);
	_tmp47_ = self->priv->retweet_button;
	_tmp48_ = tweet;
	_tmp49_ = cb_tweet_is_flag_set (_tmp48_, (guint) CB_TWEET_STATE_RETWEETED);
	gtk_toggle_button_set_active (_tmp47_, _tmp49_);
	_tmp50_ = self->priv->favorite_button;
	_tmp51_ = tweet;
	_tmp52_ = cb_tweet_is_flag_set (_tmp51_, (guint) CB_TWEET_STATE_FAVORITED);
	gtk_toggle_button_set_active (_tmp50_, _tmp52_);
	_tmp53_ = self->priv->avatar_image;
	_tmp54_ = tweet;
	_tmp55_ = cb_tweet_is_flag_set (_tmp54_, (guint) CB_TWEET_STATE_VERIFIED);
	avatar_widget_set_verified (_tmp53_, _tmp55_);
	_tmp56_ = tweet;
	_tmp57_ = _tmp56_->id;
	_tmp58_ = tweet;
	_tmp59_ = cb_tweet_get_screen_name (_tmp58_);
	tweet_info_page_set_source_link (self, _tmp57_, _tmp59_);
	_tmp60_ = tweet;
	_tmp61_ = cb_tweet_has_inline_media (_tmp60_);
	if (_tmp61_) {
		MultiMediaWidget* _tmp62_ = NULL;
		MediaVisibility _tmp63_ = 0;
		MultiMediaWidget* _tmp64_ = NULL;
		CbTweet* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		CbMedia** _tmp67_ = NULL;
		_tmp62_ = self->priv->mm_widget;
		_tmp63_ = settings_get_media_visiblity ();
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget), _tmp63_ != MEDIA_VISIBILITY_HIDE);
		_tmp64_ = self->priv->mm_widget;
		_tmp65_ = tweet;
		_tmp67_ = cb_tweet_get_medias (_tmp65_, &_tmp66_);
		multi_media_widget_set_all_media (_tmp64_, _tmp67_, _tmp66_);
	} else {
		MultiMediaWidget* _tmp68_ = NULL;
		_tmp68_ = self->priv->mm_widget;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp69_ = self->priv->actions;
	_tmp70_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_action_map_get_type (), GActionMap), "delete");
	_tmp71_ = tweet;
	_tmp72_ = cb_tweet_get_user_id (_tmp71_);
	_tmp73_ = self->account;
	_tmp74_ = _tmp73_->id;
	g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, g_simple_action_get_type (), GSimpleAction), _tmp72_ == _tmp74_);
	_tmp75_ = tweet;
	_tmp76_ = cb_tweet_is_flag_set (_tmp75_, (guint) CB_TWEET_STATE_PROTECTED);
	if (_tmp76_) {
		GtkToggleButton* _tmp77_ = NULL;
		GSimpleActionGroup* _tmp78_ = NULL;
		GAction* _tmp79_ = NULL;
		_tmp77_ = self->priv->retweet_button;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_widget_get_type (), GtkWidget));
		_tmp78_ = self->priv->actions;
		_tmp79_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, g_simple_action_get_type (), GSimpleAction), FALSE);
	} else {
		GtkToggleButton* _tmp80_ = NULL;
		GSimpleActionGroup* _tmp81_ = NULL;
		GAction* _tmp82_ = NULL;
		_tmp80_ = self->priv->retweet_button;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, gtk_widget_get_type (), GtkWidget));
		_tmp81_ = self->priv->actions;
		_tmp82_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, g_simple_action_get_type (), GSimpleAction), TRUE);
	}
	_g_free0 (time_format);
	_g_date_time_unref0 (created_at);
}


static void tweet_info_page_update_rt_fav_labels (TweetInfoPage* self) {
	GtkLabel* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	CbTweet* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->rt_label;
	_tmp1_ = self->priv->tweet;
	_tmp2_ = _tmp1_->retweet_count;
	_tmp3_ = _ ("Retweets");
	_tmp4_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->fav_label;
	_tmp7_ = self->priv->tweet;
	_tmp8_ = _tmp7_->favorite_count;
	_tmp9_ = _ ("Favorites");
	_tmp10_ = g_strdup_printf ("<big><b>%'d</b></big> %s", _tmp8_, _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp6_, _tmp11_);
	_g_free0 (_tmp11_);
}


static void tweet_info_page_set_source_link (TweetInfoPage* self, gint64 id, const gchar* screen_name) {
	gchar* link = NULL;
	const gchar* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	g_return_if_fail (screen_name != NULL);
	_tmp0_ = screen_name;
	_tmp1_ = id;
	_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("https://twitter.com/%s/status/%s", _tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	link = _tmp5_;
	_tmp6_ = self->priv->source_label;
	_tmp7_ = _ ("Open in Browser");
	_tmp8_ = _ ("Source");
	_tmp9_ = g_strdup_printf ("<span underline='none'><a href='%s' title='%s'>%s</a></span>", link, _tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	gtk_label_set_label (_tmp6_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (link);
}


static void tweet_info_page_quote_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_info_page_reply_activated (TweetInfoPage* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->account;
	_tmp2_ = self->priv->tweet;
	_tmp3_ = compose_tweet_window_new (_tmp0_, _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		TweetInfoPage* self;
		self = _data31_->self;
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}


static void __lambda56_ (Block31Data* _data31_) {
	TweetInfoPage* self;
	GtkToggleButton* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	self = _data31_->self;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
	self->priv->values_set = FALSE;
	_tmp1_ = self->priv->favorite_button;
	_tmp2_ = _data31_->favoriting;
	gtk_toggle_button_set_active (_tmp1_, _tmp2_);
	self->priv->values_set = TRUE;
}


static void ___lambda56__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda56_ (self);
	block31_data_unref (self);
}


static void tweet_info_page_favorite_activated (TweetInfoPage* self) {
	Block31Data* _data31_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkToggleButton* _tmp8_ = NULL;
	Account* _tmp9_ = NULL;
	CbTweet* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp1_ = self->priv->values_set;
	if (!_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkToggleButton* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->favorite_button;
		_tmp3_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	}
	if (_tmp0_) {
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return;
	}
	_tmp5_ = self->priv->favorite_button;
	_tmp6_ = gtk_toggle_button_get_active (_tmp5_);
	_tmp7_ = _tmp6_;
	_data31_->favoriting = !_tmp7_;
	_tmp8_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
	tweet_info_page_update_rt_fav_labels (self);
	_tmp9_ = self->account;
	_tmp10_ = self->priv->tweet;
	_tmp11_ = _data31_->favoriting;
	tweet_utils_set_favorite_status (_tmp9_, _tmp10_, _tmp11_, ___lambda56__gasync_ready_callback, block31_data_ref (_data31_));
	block31_data_unref (_data31_);
	_data31_ = NULL;
}


static void __lambda58_ (TweetInfoPage* self) {
}


static void ___lambda58__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda58_ ((TweetInfoPage*) self);
	g_object_unref (self);
}


static void tweet_info_page_delete_activated (TweetInfoPage* self) {
	gboolean _tmp0_ = FALSE;
	CbTweet* _tmp1_ = NULL;
	MainWindow* _tmp6_ = NULL;
	MainWidget* _tmp7_ = NULL;
	Account* _tmp8_ = NULL;
	CbTweet* _tmp9_ = NULL;
	g_return_if_fail (IS_TWEET_INFO_PAGE (self));
	_tmp1_ = self->priv->tweet;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		CbTweet* _tmp2_ = NULL;
		gint64 _tmp3_ = 0LL;
		Account* _tmp4_ = NULL;
		gint64 _tmp5_ = 0LL;
		_tmp2_ = self->priv->tweet;
		_tmp3_ = cb_tweet_get_user_id (_tmp2_);
		_tmp4_ = self->account;
		_tmp5_ = _tmp4_->id;
		_tmp0_ = _tmp3_ != _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->main_window;
	_tmp7_ = _tmp6_->main_widget;
	main_widget_remove_current_page (_tmp7_);
	_tmp8_ = self->account;
	_tmp9_ = self->priv->tweet;
	tweet_utils_delete_tweet (_tmp8_, _tmp9_, ___lambda58__gasync_ready_callback, g_object_ref (self));
}


static gchar* tweet_info_page_real_get_title (IPage* base) {
	TweetInfoPage * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = _ ("Tweet Details");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * Twitter's source parameter of tweets includes a 'rel' parameter
   * that doesn't work as pango markup, so we just remove it here.
   *
   * Example string:
   *   <a href=\"http://www.tweetdeck.com\" rel=\"nofollow\">TweetDeck</a>
   *
   * @param source_str The source string from twitter
   *
   * @return The #source_string without the rel parameter
   */
static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gchar* tweet_info_page_extract_source (TweetInfoPage* self, const gchar* source_str) {
	gchar* result = NULL;
	gint from = 0;
	gint to = 0;
	gint tmp = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	const gchar* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), NULL);
	g_return_val_if_fail (source_str != NULL, NULL);
	tmp = 0;
	_tmp0_ = source_str;
	_tmp1_ = string_index_of_char (_tmp0_, (gunichar) '"', 0);
	tmp = _tmp1_;
	_tmp2_ = source_str;
	_tmp3_ = tmp;
	_tmp4_ = string_index_of_char (_tmp2_, (gunichar) '"', _tmp3_ + 1);
	tmp = _tmp4_;
	_tmp5_ = source_str;
	_tmp6_ = tmp;
	_tmp7_ = string_index_of_char (_tmp5_, (gunichar) '"', _tmp6_ + 1);
	from = _tmp7_;
	_tmp8_ = source_str;
	_tmp9_ = from;
	_tmp10_ = string_index_of_char (_tmp8_, (gunichar) '"', _tmp9_ + 1);
	to = _tmp10_;
	_tmp12_ = to;
	if (_tmp12_ == -1) {
		_tmp11_ = TRUE;
	} else {
		gint _tmp13_ = 0;
		_tmp13_ = from;
		_tmp11_ = _tmp13_ == -1;
	}
	if (_tmp11_) {
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		_tmp14_ = source_str;
		_tmp15_ = g_strdup (_tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = source_str;
	_tmp17_ = from;
	_tmp18_ = string_substring (_tmp16_, (glong) 0, (glong) (_tmp17_ - 5));
	_tmp19_ = _tmp18_;
	_tmp20_ = source_str;
	_tmp21_ = to;
	_tmp22_ = string_substring (_tmp20_, (glong) (_tmp21_ + 1), (glong) -1);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	result = _tmp25_;
	return result;
}


static void tweet_info_page_real_create_radio_button (IPage* base, GtkRadioButton* group) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
}


static GtkRadioButton* tweet_info_page_real_get_radio_button (IPage* base) {
	TweetInfoPage * self;
	GtkRadioButton* result = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	result = NULL;
	return result;
}


static void tweet_info_page_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	TweetInfoPage * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonObject* root_obj = NULL;
		JsonNode* _tmp1_ = NULL;
		JsonObject* _tmp2_ = NULL;
		JsonObject* _tmp3_ = NULL;
		JsonObject* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		_tmp1_ = root;
		_tmp2_ = json_node_get_object (_tmp1_);
		_tmp3_ = _json_object_ref0 (_tmp2_);
		root_obj = _tmp3_;
		_tmp4_ = root_obj;
		_tmp5_ = utils_usable_json_value (_tmp4_, "in_reply_to_status_id");
		if (_tmp5_) {
			gint64 reply_id = 0LL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			gint64 _tmp9_ = 0LL;
			_tmp6_ = root_obj;
			_tmp7_ = json_object_get_int_member (_tmp6_, "in_reply_to_status_id");
			reply_id = _tmp7_;
			_tmp8_ = reply_id;
			_tmp9_ = self->priv->tweet_id;
			if (_tmp8_ == _tmp9_) {
				CbTweet* t = NULL;
				CbTweet* _tmp10_ = NULL;
				CbTweet* _tmp11_ = NULL;
				JsonNode* _tmp12_ = NULL;
				Account* _tmp13_ = NULL;
				gint64 _tmp14_ = 0LL;
				GDateTime* _tmp15_ = NULL;
				GDateTime* _tmp16_ = NULL;
				TweetListBox* _tmp17_ = NULL;
				TweetModel* _tmp18_ = NULL;
				CbTweet* _tmp19_ = NULL;
				TweetListBox* _tmp20_ = NULL;
				ReplyIndicator* _tmp21_ = NULL;
				_tmp10_ = cb_tweet_new ();
				t = _tmp10_;
				_tmp11_ = t;
				_tmp12_ = root;
				_tmp13_ = self->account;
				_tmp14_ = _tmp13_->id;
				_tmp15_ = g_date_time_new_now_local ();
				_tmp16_ = _tmp15_;
				cb_tweet_load_from_json (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
				_g_date_time_unref0 (_tmp16_);
				_tmp17_ = self->priv->top_list_box;
				_tmp18_ = _tmp17_->model;
				_tmp19_ = t;
				tweet_model_add (_tmp18_, _tmp19_);
				_tmp20_ = self->priv->top_list_box;
				gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget));
				_tmp21_ = self->priv->reply_indicator;
				reply_indicator_set_replies_available (_tmp21_, TRUE);
				_g_object_unref0 (t);
			}
		}
		_json_object_unref0 (root_obj);
	} else {
		StreamMessageType _tmp22_ = 0;
		_tmp22_ = type;
		if (_tmp22_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 tweet_id = 0LL;
			JsonNode* _tmp23_ = NULL;
			JsonObject* _tmp24_ = NULL;
			JsonObject* _tmp25_ = NULL;
			JsonObject* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			gboolean _tmp28_ = FALSE;
			gint64 _tmp29_ = 0LL;
			gint64 _tmp30_ = 0LL;
			_tmp23_ = root;
			_tmp24_ = json_node_get_object (_tmp23_);
			_tmp25_ = json_object_get_object_member (_tmp24_, "delete");
			_tmp26_ = json_object_get_object_member (_tmp25_, "status");
			_tmp27_ = json_object_get_int_member (_tmp26_, "id");
			tweet_id = _tmp27_;
			_tmp29_ = tweet_id;
			_tmp30_ = self->priv->tweet_id;
			if (_tmp29_ == _tmp30_) {
				MainWindow* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				_tmp31_ = self->priv->main_window;
				_tmp32_ = main_window_get_cur_page_id (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
				_tmp35_ = _tmp34_;
				_tmp28_ = _tmp33_ == _tmp35_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				gint64 _tmp36_ = 0LL;
				gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				MainWindow* _tmp39_ = NULL;
				MainWidget* _tmp40_ = NULL;
				_tmp36_ = tweet_id;
				_tmp37_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp36_);
				_tmp38_ = _tmp37_;
				g_debug ("TweetInfoPage.vala:586: Current tweet with id %s deleted!", _tmp38_);
				_g_free0 (_tmp38_);
				_tmp39_ = self->priv->main_window;
				_tmp40_ = _tmp39_->main_widget;
				main_widget_remove_current_page (_tmp40_);
			}
		} else {
			StreamMessageType _tmp41_ = 0;
			_tmp41_ = type;
			if (_tmp41_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp42_ = NULL;
				JsonObject* _tmp43_ = NULL;
				JsonObject* _tmp44_ = NULL;
				gint64 _tmp45_ = 0LL;
				gint64 source_id = 0LL;
				JsonNode* _tmp46_ = NULL;
				JsonObject* _tmp47_ = NULL;
				JsonObject* _tmp48_ = NULL;
				gint64 _tmp49_ = 0LL;
				gboolean _tmp50_ = FALSE;
				gint64 _tmp51_ = 0LL;
				Account* _tmp52_ = NULL;
				gint64 _tmp53_ = 0LL;
				_tmp42_ = root;
				_tmp43_ = json_node_get_object (_tmp42_);
				_tmp44_ = json_object_get_object_member (_tmp43_, "target_object");
				_tmp45_ = json_object_get_int_member (_tmp44_, "id");
				id = _tmp45_;
				_tmp46_ = root;
				_tmp47_ = json_node_get_object (_tmp46_);
				_tmp48_ = json_object_get_object_member (_tmp47_, "source");
				_tmp49_ = json_object_get_int_member (_tmp48_, "id");
				source_id = _tmp49_;
				_tmp51_ = source_id;
				_tmp52_ = self->account;
				_tmp53_ = _tmp52_->id;
				if (_tmp51_ == _tmp53_) {
					gint64 _tmp54_ = 0LL;
					gint64 _tmp55_ = 0LL;
					_tmp54_ = id;
					_tmp55_ = self->priv->tweet_id;
					_tmp50_ = _tmp54_ == _tmp55_;
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					GtkToggleButton* _tmp56_ = NULL;
					CbTweet* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					self->priv->values_set = FALSE;
					_tmp56_ = self->priv->favorite_button;
					gtk_toggle_button_set_active (_tmp56_, TRUE);
					_tmp57_ = self->priv->tweet;
					_tmp58_ = _tmp57_->favorite_count;
					_tmp57_->favorite_count = _tmp58_ + 1;
					tweet_info_page_update_rt_fav_labels (self);
					self->priv->values_set = TRUE;
				}
			} else {
				StreamMessageType _tmp59_ = 0;
				_tmp59_ = type;
				if (_tmp59_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp60_ = NULL;
					JsonObject* _tmp61_ = NULL;
					JsonObject* _tmp62_ = NULL;
					gint64 _tmp63_ = 0LL;
					gint64 source_id = 0LL;
					JsonNode* _tmp64_ = NULL;
					JsonObject* _tmp65_ = NULL;
					JsonObject* _tmp66_ = NULL;
					gint64 _tmp67_ = 0LL;
					gboolean _tmp68_ = FALSE;
					gint64 _tmp69_ = 0LL;
					Account* _tmp70_ = NULL;
					gint64 _tmp71_ = 0LL;
					_tmp60_ = root;
					_tmp61_ = json_node_get_object (_tmp60_);
					_tmp62_ = json_object_get_object_member (_tmp61_, "target_object");
					_tmp63_ = json_object_get_int_member (_tmp62_, "id");
					id = _tmp63_;
					_tmp64_ = root;
					_tmp65_ = json_node_get_object (_tmp64_);
					_tmp66_ = json_object_get_object_member (_tmp65_, "source");
					_tmp67_ = json_object_get_int_member (_tmp66_, "id");
					source_id = _tmp67_;
					_tmp69_ = source_id;
					_tmp70_ = self->account;
					_tmp71_ = _tmp70_->id;
					if (_tmp69_ == _tmp71_) {
						gint64 _tmp72_ = 0LL;
						gint64 _tmp73_ = 0LL;
						_tmp72_ = id;
						_tmp73_ = self->priv->tweet_id;
						_tmp68_ = _tmp72_ == _tmp73_;
					} else {
						_tmp68_ = FALSE;
					}
					if (_tmp68_) {
						GtkToggleButton* _tmp74_ = NULL;
						CbTweet* _tmp75_ = NULL;
						gint _tmp76_ = 0;
						self->priv->values_set = FALSE;
						_tmp74_ = self->priv->favorite_button;
						gtk_toggle_button_set_active (_tmp74_, FALSE);
						_tmp75_ = self->priv->tweet;
						_tmp76_ = _tmp75_->favorite_count;
						_tmp75_->favorite_count = _tmp76_ - 1;
						tweet_info_page_update_rt_fav_labels (self);
						self->priv->values_set = TRUE;
					}
				}
			}
		}
	}
}


gint tweet_info_page_get_unread_count (TweetInfoPage* self) {
	gint result;
	g_return_val_if_fail (IS_TWEET_INFO_PAGE (self), 0);
	result = 0;
	return result;
}


static gint tweet_info_page_real_get_id (IPage* base) {
	gint result;
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void tweet_info_page_real_set_id (IPage* base, gint value) {
	TweetInfoPage* self;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


static void tweet_info_page_real_set_window (IPage* base, MainWindow* value) {
	TweetInfoPage* self;
	MainWindow* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_tmp0_ = value;
	self->priv->main_window = _tmp0_;
	g_object_notify ((GObject *) self, "window");
}


static void tweet_info_page_class_init (TweetInfoPageClass * klass) {
	gint TweetInfoPage_private_offset;
	tweet_info_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetInfoPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_info_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_info_page_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_info_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_UNREAD_COUNT, g_param_spec_int ("unread-count", "unread-count", "unread-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_INFO_PAGE_WINDOW, g_param_spec_object ("window", "window", "window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	TweetInfoPage_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-info-page.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, fav_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "bottom_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, bottom_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "top_list_box", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, top_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, time_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "source_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, source_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "max_size_container", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, max_size_container));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "reply_indicator", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, reply_indicator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_stack", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, main_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_label", FALSE, TweetInfoPage_private_offset + G_STRUCT_OFFSET (TweetInfoPagePrivate, error_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_info_page_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_info_page_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_info_page_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_info_page_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_info_page_name_button_clicked_cb_gtk_button_clicked));
}


static void tweet_info_page_ipage_interface_init (IPageIface * iface) {
	tweet_info_page_ipage_parent_iface = g_type_interface_peek_parent (iface);
	iface->on_join = (void (*)(IPage*, gint, Bundle*)) tweet_info_page_real_on_join;
	iface->on_leave = (void (*)(IPage*)) tweet_info_page_real_on_leave;
	iface->get_title = (gchar* (*)(IPage*)) tweet_info_page_real_get_title;
	iface->create_radio_button = (void (*)(IPage*, GtkRadioButton*)) tweet_info_page_real_create_radio_button;
	iface->get_radio_button = (GtkRadioButton* (*)(IPage*)) tweet_info_page_real_get_radio_button;
	iface->get_id = tweet_info_page_real_get_id;
	iface->set_id = tweet_info_page_real_set_id;
	iface->set_window = tweet_info_page_real_set_window;
}


static void tweet_info_page_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	tweet_info_page_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) tweet_info_page_real_stream_message_received;
}


static void tweet_info_page_instance_init (TweetInfoPage * self) {
	self->priv = TWEET_INFO_PAGE_GET_PRIVATE (self);
	self->priv->values_set = FALSE;
	self->priv->cancellable = NULL;
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_TWEET_LIST_BOX);
	g_type_ensure (TYPE_MAX_SIZE_CONTAINER);
	g_type_ensure (TYPE_REPLY_INDICATOR);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_info_page_finalize (GObject* obj) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	_g_free0 (self->priv->screen_name);
	_g_object_unref0 (self->priv->tweet);
	_g_object_unref0 (self->priv->actions);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->fav_label);
	_g_object_unref0 (self->priv->bottom_list_box);
	_g_object_unref0 (self->priv->top_list_box);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->time_label);
	_g_object_unref0 (self->priv->source_label);
	_g_object_unref0 (self->priv->max_size_container);
	_g_object_unref0 (self->priv->reply_indicator);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->error_label);
	G_OBJECT_CLASS (tweet_info_page_parent_class)->finalize (obj);
}


GType tweet_info_page_get_type (void) {
	static volatile gsize tweet_info_page_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_info_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetInfoPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_info_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetInfoPage), 0, (GInstanceInitFunc) tweet_info_page_instance_init, NULL };
		static const GInterfaceInfo ipage_info = { (GInterfaceInitFunc) tweet_info_page_ipage_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) tweet_info_page_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_info_page_type_id;
		tweet_info_page_type_id = g_type_register_static (TYPE_SCROLL_WIDGET, "TweetInfoPage", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IPAGE, &ipage_info);
		g_type_add_interface_static (tweet_info_page_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&tweet_info_page_type_id__volatile, tweet_info_page_type_id);
	}
	return tweet_info_page_type_id__volatile;
}


static void _vala_tweet_info_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_UNREAD_COUNT:
		g_value_set_int (value, tweet_info_page_get_unread_count (self));
		break;
		case TWEET_INFO_PAGE_ID:
		g_value_set_int (value, ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_info_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetInfoPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_INFO_PAGE, TweetInfoPage);
	switch (property_id) {
		case TWEET_INFO_PAGE_ID:
		ipage_set_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_int (value));
		break;
		case TWEET_INFO_PAGE_WINDOW:
		ipage_set_window (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



