/* ComposeTweetWindow.c generated by valac 0.36.4, the Vala compiler
 * generated from ComposeTweetWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTweet.h"
#include <gio/gio.h>
#include "CbComposeJob.h"
#include "rest/oauth-proxy.h"
#include <stdlib.h>
#include <string.h>
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy.h"
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
typedef struct _ComposeTweetWindowPrivate ComposeTweetWindowPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_COMPOSE_IMAGE_MANAGER (compose_image_manager_get_type ())
#define COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager))
#define COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))
#define IS_COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_IMAGE_MANAGER))
#define IS_COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_IMAGE_MANAGER))
#define COMPOSE_IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))

typedef struct _ComposeImageManager ComposeImageManager;
typedef struct _ComposeImageManagerClass ComposeImageManagerClass;

#define TYPE_FAV_IMAGE_VIEW (fav_image_view_get_type ())
#define FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FAV_IMAGE_VIEW, FavImageView))
#define FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))
#define IS_FAV_IMAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FAV_IMAGE_VIEW))
#define IS_FAV_IMAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FAV_IMAGE_VIEW))
#define FAV_IMAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FAV_IMAGE_VIEW, FavImageViewClass))

typedef struct _FavImageView FavImageView;
typedef struct _FavImageViewClass FavImageViewClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _gtk_target_list_unref0(var) ((var == NULL) ? NULL : (var = (gtk_target_list_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComposeTweetWindow {
	GtkApplicationWindow parent_instance;
	ComposeTweetWindowPrivate * priv;
};

struct _ComposeTweetWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ComposeTweetWindowPrivate {
	AvatarWidget* avatar_image;
	GtkGrid* content_grid;
	CompletionTextView* tweet_text;
	GtkLabel* length_label;
	GtkButton* send_button;
	GtkSpinner* title_spinner;
	GtkLabel* title_label;
	GtkStack* title_stack;
	ComposeImageManager* compose_image_manager;
	GtkButton* add_image_button;
	GtkStack* stack;
	GtkGrid* image_error_grid;
	GtkLabel* image_error_label;
	GtkButton* cancel_button;
	FavImageView* fav_image_view;
	GtkButton* fav_image_button;
	Account* account;
	CbTweet* reply_to;
	ComposeTweetWindowMode mode;
	GCancellable* cancellable;
	GtkListBox* reply_list;
	CbComposeJob* compose_job;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer compose_tweet_window_parent_class = NULL;

GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType compose_image_manager_get_type (void) G_GNUC_CONST;
GType fav_image_view_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
#define COMPOSE_TWEET_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowPrivate))
enum  {
	COMPOSE_TWEET_WINDOW_DUMMY_PROPERTY
};
#define COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH 450
GType main_window_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
gchar* settings_get_consumer_key (void);
gchar* settings_get_consumer_secret (void);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
static void __lambda39_ (ComposeTweetWindow* self, const gchar* path, gdouble progress);
void compose_image_manager_set_image_progress (ComposeImageManager* self, const gchar* image_path, gdouble progress);
static void ___lambda39__cb_compose_job_image_upload_progress (CbComposeJob* _sender, const gchar* a, gdouble d, gpointer self);
static void __lambda40_ (ComposeTweetWindow* self, const gchar* path, const gchar* error_msg);
void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message);
static void ___lambda40__cb_compose_job_image_upload_finished (CbComposeJob* _sender, const gchar* a, const gchar* b, gpointer self);
cairo_surface_t* account_get_avatar (Account* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void __lambda41_ (ComposeTweetWindow* self);
static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self);
static void _compose_tweet_window_recalc_tweet_length_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self);
static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda42_ (ComposeTweetWindow* self);
static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self);
static gboolean ___lambda42__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void __lambda44_ (ComposeTweetWindow* self, const gchar* path);
gboolean compose_image_manager_get_full (ComposeImageManager* self);
void fav_image_view_set_gifs_enabled (FavImageView* self, gboolean enabled);
gint compose_image_manager_get_n_images (ComposeImageManager* self);
static void ___lambda44__compose_image_manager_image_removed (ComposeImageManager* _sender, const gchar* image_path, gpointer self);
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
gchar* sql_select_statement_once_string (SqlSelectStatement* self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
void compose_image_manager_insensitivize_buttons (ComposeImageManager* self);
static void __lambda43_ (ComposeTweetWindow* self, GObject* obj, GAsyncResult* res);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void compose_tweet_window_save_last_tweet (ComposeTweetWindow* self);
static void ___lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self);
static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, GtkButton* source);
#define TWITTER_MAX_BYTES_PER_IMAGE ((1024 * 1024) * 3)
void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image);
static void _compose_tweet_window_add_image_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void compose_tweet_window_fav_image_button_clicked_cb (ComposeTweetWindow* self);
void fav_image_view_load_images (FavImageView* self);
static void _compose_tweet_window_fav_image_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void compose_tweet_window_favorite_image_selected_cb (ComposeTweetWindow* self, const gchar* path);
static void _compose_tweet_window_favorite_image_selected_cb_fav_image_view_image_selected (FavImageView* _sender, const gchar* image_path, gpointer self);
static void compose_tweet_window_finalize (GObject * obj);


GType compose_tweet_window_mode_get_type (void) {
	static volatile gsize compose_tweet_window_mode_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPOSE_TWEET_WINDOW_MODE_NORMAL, "COMPOSE_TWEET_WINDOW_MODE_NORMAL", "normal"}, {COMPOSE_TWEET_WINDOW_MODE_REPLY, "COMPOSE_TWEET_WINDOW_MODE_REPLY", "reply"}, {COMPOSE_TWEET_WINDOW_MODE_QUOTE, "COMPOSE_TWEET_WINDOW_MODE_QUOTE", "quote"}, {0, NULL, NULL}};
		GType compose_tweet_window_mode_type_id;
		compose_tweet_window_mode_type_id = g_enum_register_static ("ComposeTweetWindowMode", values);
		g_once_init_leave (&compose_tweet_window_mode_type_id__volatile, compose_tweet_window_mode_type_id);
	}
	return compose_tweet_window_mode_type_id__volatile;
}


static void __lambda39_ (ComposeTweetWindow* self, const gchar* path, gdouble progress) {
	ComposeImageManager* _tmp0_;
	const gchar* _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->compose_image_manager;
	_tmp1_ = path;
	_tmp2_ = progress;
	compose_image_manager_set_image_progress (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda39__cb_compose_job_image_upload_progress (CbComposeJob* _sender, const gchar* a, gdouble d, gpointer self) {
	__lambda39_ ((ComposeTweetWindow*) self, a, d);
}


static void __lambda40_ (ComposeTweetWindow* self, const gchar* path, const gchar* error_msg) {
	const gchar* _tmp0_;
	ComposeImageManager* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	g_message ("ComposeTweetWindow.vala:92: %s Finished!", _tmp0_);
	_tmp1_ = self->priv->compose_image_manager;
	_tmp2_ = path;
	_tmp3_ = error_msg;
	compose_image_manager_end_progress (_tmp1_, _tmp2_, _tmp3_);
}


static void ___lambda40__cb_compose_job_image_upload_finished (CbComposeJob* _sender, const gchar* a, const gchar* b, gpointer self) {
	__lambda40_ ((ComposeTweetWindow*) self, a, b);
}


static void __lambda41_ (ComposeTweetWindow* self) {
	AvatarWidget* _tmp0_;
	Account* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_avatar (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ___lambda41__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda41_ ((ComposeTweetWindow*) self);
}


static void _compose_tweet_window_recalc_tweet_length_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	compose_tweet_window_recalc_tweet_length ((ComposeTweetWindow*) self);
}


static void _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	compose_tweet_window_recalc_tweet_length ((ComposeTweetWindow*) self);
}


static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = compose_tweet_window_escape_pressed_cb ((ComposeTweetWindow*) self);
	return result;
}


static gboolean __lambda42_ (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	compose_tweet_window_start_send_tweet (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda42__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda42_ ((ComposeTweetWindow*) self);
	return result;
}


static void __lambda44_ (ComposeTweetWindow* self, const gchar* path) {
	CbComposeJob* _tmp0_;
	const gchar* _tmp1_;
	ComposeImageManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ComposeImageManager* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->compose_job;
	_tmp1_ = path;
	cb_compose_job_abort_image_upload (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->compose_image_manager;
	_tmp3_ = compose_image_manager_get_full (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		GtkButton* _tmp5_;
		GtkButton* _tmp6_;
		_tmp5_ = self->priv->add_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp6_ = self->priv->fav_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_tmp7_ = path;
	_tmp8_ = g_utf8_strdown (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_str_has_suffix (_tmp9_, ".gif");
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	if (_tmp11_) {
		FavImageView* _tmp12_;
		GtkButton* _tmp13_;
		GtkButton* _tmp14_;
		_tmp12_ = self->priv->fav_image_view;
		fav_image_view_set_gifs_enabled (_tmp12_, TRUE);
		_tmp13_ = self->priv->add_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), TRUE);
		_tmp14_ = self->priv->fav_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_tmp15_ = self->priv->compose_image_manager;
	_tmp16_ = compose_image_manager_get_n_images (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == 0) {
		ComposeImageManager* _tmp18_;
		FavImageView* _tmp19_;
		_tmp18_ = self->priv->compose_image_manager;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget));
		_tmp19_ = self->priv->fav_image_view;
		fav_image_view_set_gifs_enabled (_tmp19_, TRUE);
	}
}


static void ___lambda44__compose_image_manager_image_removed (ComposeImageManager* _sender, const gchar* image_path, gpointer self) {
	__lambda44_ ((ComposeTweetWindow*) self, image_path);
}


ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode) {
	ComposeTweetWindow * self = NULL;
	Account* _tmp0_;
	CbTweet* _tmp1_;
	ComposeTweetWindowMode _tmp2_;
	CompletionTextView* _tmp3_;
	Account* _tmp4_;
	GApplication* _tmp5_;
	GCancellable* _tmp6_;
	OAuthProxy* upload_proxy = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	OAuthProxy* _tmp11_;
	OAuthProxy* _tmp12_;
	OAuthProxy* _tmp13_;
	Account* _tmp14_;
	OAuthProxy* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	OAuthProxy* _tmp18_;
	Account* _tmp19_;
	OAuthProxy* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	Account* _tmp23_;
	OAuthProxy* _tmp24_;
	OAuthProxy* _tmp25_;
	GCancellable* _tmp26_;
	CbComposeJob* _tmp27_;
	CbComposeJob* _tmp28_;
	CbComposeJob* _tmp29_;
	ComposeTweetWindowMode _tmp30_;
	AvatarWidget* _tmp37_;
	Account* _tmp38_;
	cairo_surface_t* _tmp39_;
	cairo_surface_t* _tmp40_;
	Account* _tmp41_;
	GNetworkMonitor* _tmp42_;
	GtkLabel* _tmp43_;
	gint _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	CompletionTextView* _tmp47_;
	GtkTextBuffer* _tmp48_;
	GtkTextBuffer* _tmp49_;
	MainWindow* _tmp50_;
	ComposeTweetWindowMode _tmp52_;
	ComposeTweetWindowMode _tmp67_;
	CompletionTextView* _tmp72_;
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp73_;
	GtkAccelGroup* _tmp74_;
	GtkAccelGroup* _tmp75_;
	ComposeImageManager* _tmp76_;
	GtkAccelGroup* _tmp77_;
	gchar* last_tweet = NULL;
	Account* _tmp78_;
	SqlDatabase* _tmp79_;
	SqlSelectStatement* _tmp80_;
	SqlSelectStatement* _tmp81_;
	SqlSelectStatement* _tmp82_;
	SqlSelectStatement* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gboolean _tmp86_ = FALSE;
	gboolean _tmp87_ = FALSE;
	const gchar* _tmp88_;
	GtkTargetList* image_target_list = NULL;
	GtkTargetList* _tmp102_;
	g_return_val_if_fail ((parent == NULL) || IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	g_return_val_if_fail ((reply_to == NULL) || CB_IS_TWEET (reply_to), NULL);
	self = (ComposeTweetWindow*) g_object_new (object_type, NULL);
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), FALSE);
	_tmp0_ = acc;
	self->priv->account = _tmp0_;
	_tmp1_ = reply_to;
	self->priv->reply_to = _tmp1_;
	_tmp2_ = mode;
	self->priv->mode = _tmp2_;
	_tmp3_ = self->priv->tweet_text;
	_tmp4_ = acc;
	completion_text_view_set_account (_tmp3_, _tmp4_);
	_tmp5_ = g_application_get_default ();
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_get_type (), GtkApplication));
	_tmp6_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp6_;
	_tmp7_ = settings_get_consumer_key ();
	_tmp8_ = _tmp7_;
	_tmp9_ = settings_get_consumer_secret ();
	_tmp10_ = _tmp9_;
	_tmp11_ = (OAuthProxy*) oauth_proxy_new (_tmp8_, _tmp10_, "https://upload.twitter.com/", FALSE);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	upload_proxy = _tmp12_;
	_tmp13_ = upload_proxy;
	_tmp14_ = self->priv->account;
	_tmp15_ = _tmp14_->proxy;
	_tmp16_ = oauth_proxy_get_token (_tmp15_);
	_tmp17_ = _tmp16_;
	oauth_proxy_set_token (_tmp13_, _tmp17_);
	_tmp18_ = upload_proxy;
	_tmp19_ = self->priv->account;
	_tmp20_ = _tmp19_->proxy;
	_tmp21_ = oauth_proxy_get_token_secret (_tmp20_);
	_tmp22_ = _tmp21_;
	oauth_proxy_set_token_secret (_tmp18_, _tmp22_);
	_tmp23_ = self->priv->account;
	_tmp24_ = _tmp23_->proxy;
	_tmp25_ = upload_proxy;
	_tmp26_ = self->priv->cancellable;
	_tmp27_ = cb_compose_job_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, rest_proxy_get_type (), RestProxy), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, rest_proxy_get_type (), RestProxy), _tmp26_);
	_g_object_unref0 (self->priv->compose_job);
	self->priv->compose_job = _tmp27_;
	_tmp28_ = self->priv->compose_job;
	g_signal_connect_object (_tmp28_, "image-upload-progress", (GCallback) ___lambda39__cb_compose_job_image_upload_progress, self, 0);
	_tmp29_ = self->priv->compose_job;
	g_signal_connect_object (_tmp29_, "image-upload-finished", (GCallback) ___lambda40__cb_compose_job_image_upload_finished, self, 0);
	_tmp30_ = self->priv->mode;
	if (_tmp30_ == COMPOSE_TWEET_WINDOW_MODE_REPLY) {
		CbComposeJob* _tmp31_;
		CbTweet* _tmp32_;
		gint64 _tmp33_;
		_tmp31_ = self->priv->compose_job;
		_tmp32_ = self->priv->reply_to;
		_tmp33_ = _tmp32_->id;
		cb_compose_job_set_reply_id (_tmp31_, _tmp33_);
	} else {
		ComposeTweetWindowMode _tmp34_;
		_tmp34_ = self->priv->mode;
		if (_tmp34_ == COMPOSE_TWEET_WINDOW_MODE_QUOTE) {
			CbComposeJob* _tmp35_;
			CbTweet* _tmp36_;
			_tmp35_ = self->priv->compose_job;
			_tmp36_ = self->priv->reply_to;
			cb_compose_job_set_quoted_tweet (_tmp35_, _tmp36_);
		}
	}
	_tmp37_ = self->priv->avatar_image;
	_tmp38_ = acc;
	_tmp39_ = account_get_avatar (_tmp38_);
	_tmp40_ = _tmp39_;
	avatar_widget_set_surface (_tmp37_, _tmp40_);
	_tmp41_ = acc;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) ___lambda41__g_object_notify, self, 0);
	_tmp42_ = g_network_monitor_get_default ();
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, G_TYPE_OBJECT, GObject), "notify::network-available", (GCallback) _compose_tweet_window_recalc_tweet_length_g_object_notify, self, 0);
	_tmp43_ = self->priv->length_label;
	_tmp44_ = CB_TWEET_MAX_LENGTH;
	_tmp45_ = g_strdup_printf ("%i", _tmp44_);
	_tmp46_ = _tmp45_;
	gtk_label_set_label (_tmp43_, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = self->priv->tweet_text;
	_tmp48_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_text_view_get_type (), GtkTextView));
	_tmp49_ = _tmp48_;
	g_signal_connect_object (_tmp49_, "changed", (GCallback) _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed, self, 0);
	_tmp50_ = parent;
	if (_tmp50_ != NULL) {
		MainWindow* _tmp51_;
		_tmp51_ = parent;
		gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_window_get_type (), GtkWindow));
		gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	}
	_tmp52_ = mode;
	if (_tmp52_ != COMPOSE_TWEET_WINDOW_MODE_NORMAL) {
		GtkListBox* _tmp53_;
		GtkListBox* _tmp54_;
		TweetListEntry* reply_entry = NULL;
		CbTweet* _tmp55_;
		MainWindow* _tmp56_;
		Account* _tmp57_;
		TweetListEntry* _tmp58_;
		TweetListEntry* _tmp59_;
		TweetListEntry* _tmp60_;
		TweetListEntry* _tmp61_;
		GtkListBox* _tmp62_;
		TweetListEntry* _tmp63_;
		GtkListBox* _tmp64_;
		GtkGrid* _tmp65_;
		GtkListBox* _tmp66_;
		_tmp53_ = (GtkListBox*) gtk_list_box_new ();
		g_object_ref_sink (_tmp53_);
		_g_object_unref0 (self->priv->reply_list);
		self->priv->reply_list = _tmp53_;
		_tmp54_ = self->priv->reply_list;
		gtk_list_box_set_selection_mode (_tmp54_, GTK_SELECTION_NONE);
		_tmp55_ = reply_to;
		_tmp56_ = parent;
		_tmp57_ = acc;
		_tmp58_ = tweet_list_entry_new (_tmp55_, _tmp56_, _tmp57_, TRUE);
		g_object_ref_sink (_tmp58_);
		reply_entry = _tmp58_;
		_tmp59_ = reply_entry;
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
		_tmp60_ = reply_entry;
		tweet_list_entry_set_read_only (_tmp60_, TRUE);
		_tmp61_ = reply_entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget));
		_tmp62_ = self->priv->reply_list;
		_tmp63_ = reply_entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_widget_get_type (), GtkWidget));
		_tmp64_ = self->priv->reply_list;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, gtk_widget_get_type (), GtkWidget));
		_tmp65_ = self->priv->content_grid;
		_tmp66_ = self->priv->reply_list;
		gtk_grid_attach (_tmp65_, G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_widget_get_type (), GtkWidget), 0, 0, 2, 1);
		_g_object_unref0 (reply_entry);
	}
	_tmp67_ = mode;
	if (_tmp67_ == COMPOSE_TWEET_WINDOW_MODE_QUOTE) {
		CbTweet* _tmp68_;
		GtkLabel* _tmp69_;
		GtkButton* _tmp70_;
		GtkButton* _tmp71_;
		_tmp68_ = reply_to;
		_vala_assert (_tmp68_ != NULL, "reply_to != null");
		_tmp69_ = self->priv->title_label;
		gtk_label_set_label (_tmp69_, _ ("Quote tweet"));
		_tmp70_ = self->priv->add_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp71_ = self->priv->fav_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp72_ = self->priv->tweet_text;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, gtk_widget_get_type (), GtkWidget));
	_tmp73_ = gtk_accel_group_new ();
	ag = _tmp73_;
	_tmp74_ = ag;
	gtk_accel_group_connect (_tmp74_, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((_compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp75_ = ag;
	gtk_accel_group_connect (_tmp75_, (guint) GDK_KEY_Return, GDK_CONTROL_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda42__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda42__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp76_ = self->priv->compose_image_manager;
	g_signal_connect_object (_tmp76_, "image-removed", (GCallback) ___lambda44__compose_image_manager_image_removed, self, 0);
	_tmp77_ = ag;
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp77_);
	_tmp78_ = self->priv->account;
	_tmp79_ = _tmp78_->db;
	_tmp80_ = sql_database_select (_tmp79_, "info");
	_tmp81_ = _tmp80_;
	_tmp82_ = sql_select_statement_cols (_tmp81_, "last_tweet", NULL);
	_tmp83_ = _tmp82_;
	_tmp84_ = sql_select_statement_once_string (_tmp83_);
	_tmp85_ = _tmp84_;
	_g_object_unref0 (_tmp83_);
	_g_object_unref0 (_tmp81_);
	last_tweet = _tmp85_;
	_tmp88_ = last_tweet;
	if (_tmp88_ != NULL) {
		const gchar* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		_tmp89_ = last_tweet;
		_tmp90_ = strlen (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp87_ = _tmp91_ > 0;
	} else {
		_tmp87_ = FALSE;
	}
	if (_tmp87_) {
		CompletionTextView* _tmp92_;
		GtkTextBuffer* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		_tmp92_ = self->priv->tweet_text;
		_tmp93_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, gtk_text_view_get_type (), GtkTextView));
		g_object_get (_tmp93_, "text", &_tmp94_, NULL);
		_tmp95_ = _tmp94_;
		_tmp96_ = _tmp95_;
		_tmp97_ = strlen (_tmp96_);
		_tmp98_ = _tmp97_;
		_tmp86_ = _tmp98_ == 0;
		_g_free0 (_tmp96_);
	} else {
		_tmp86_ = FALSE;
	}
	if (_tmp86_) {
		CompletionTextView* _tmp99_;
		GtkTextBuffer* _tmp100_;
		const gchar* _tmp101_;
		_tmp99_ = self->priv->tweet_text;
		_tmp100_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_text_view_get_type (), GtkTextView));
		_tmp101_ = last_tweet;
		g_object_set (_tmp100_, "text", _tmp101_, NULL);
	}
	_tmp102_ = gtk_target_list_new (NULL, 0);
	image_target_list = _tmp102_;
	gtk_target_list_add_text_targets (image_target_list, (guint) 0);
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH, (gint) (COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH / 2.5));
	_gtk_target_list_unref0 (image_target_list);
	_g_free0 (last_tweet);
	_g_object_unref0 (ag);
	_g_object_unref0 (upload_proxy);
	return self;
}


ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode) {
	return compose_tweet_window_construct (TYPE_COMPOSE_TWEET_WINDOW, parent, acc, reply_to, mode);
}


static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	CompletionTextView* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	gchar* _tmp10_;
	gint length = 0;
	const gchar* _tmp11_;
	gint _tmp12_;
	GtkLabel* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_bounds (_tmp2_, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = self->priv->tweet_text;
	_tmp6_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_text_view_get_type (), GtkTextView));
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text (_tmp7_, &_tmp8_, &_tmp9_, TRUE);
	text = _tmp10_;
	_tmp11_ = text;
	_tmp12_ = tweet_utils_calc_tweet_length (_tmp11_, 0);
	length = _tmp12_;
	_tmp13_ = self->priv->length_label;
	_tmp14_ = CB_TWEET_MAX_LENGTH;
	_tmp15_ = length;
	_tmp16_ = g_strdup_printf ("%i", _tmp14_ - _tmp15_);
	_tmp17_ = _tmp16_;
	gtk_label_set_label (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp19_ = length;
	if (_tmp19_ > 0) {
		gint _tmp20_;
		gint _tmp21_;
		_tmp20_ = length;
		_tmp21_ = CB_TWEET_MAX_LENGTH;
		_tmp18_ = _tmp20_ <= _tmp21_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean network_reachable = FALSE;
		GNetworkMonitor* _tmp22_;
		gboolean _tmp23_;
		gboolean _tmp24_;
		GtkButton* _tmp25_;
		gboolean _tmp26_;
		_tmp22_ = g_network_monitor_get_default ();
		_tmp23_ = g_network_monitor_get_network_available (_tmp22_);
		_tmp24_ = _tmp23_;
		network_reachable = _tmp24_;
		_tmp25_ = self->priv->send_button;
		_tmp26_ = network_reachable;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget), _tmp26_);
	} else {
		GtkButton* _tmp27_;
		_tmp27_ = self->priv->send_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_g_free0 (text);
}


static void __lambda43_ (ComposeTweetWindow* self, GObject* obj, GAsyncResult* res) {
	gboolean success = FALSE;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	success = FALSE;
	{
		gboolean _tmp0_ = FALSE;
		CbComposeJob* _tmp1_;
		GAsyncResult* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->compose_job;
		_tmp2_ = res;
		_tmp3_ = cb_compose_job_send_finish (_tmp1_, _tmp2_, &_inner_error_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch85_g_error;
		}
		success = _tmp0_;
	}
	goto __finally85;
	__catch85_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("ComposeTweetWindow.vala:224: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally85:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_debug ("ComposeTweetWindow.vala:226: Tweet sent.");
	_tmp6_ = success;
	if (_tmp6_) {
		Account* _tmp7_;
		SqlDatabase* _tmp8_;
		SqlUpdateStatement* _tmp9_;
		SqlUpdateStatement* _tmp10_;
		SqlUpdateStatement* _tmp11_;
		SqlUpdateStatement* _tmp12_;
		_tmp7_ = self->priv->account;
		_tmp8_ = _tmp7_->db;
		_tmp9_ = sql_database_update (_tmp8_, "info");
		_tmp10_ = _tmp9_;
		_tmp11_ = sql_update_statement_val (_tmp10_, "last_tweet", "");
		_tmp12_ = _tmp11_;
		sql_update_statement_run (_tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp10_);
	} else {
		compose_tweet_window_save_last_tweet (self);
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda43__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda43_ ((ComposeTweetWindow*) self, source_object, res);
	g_object_unref (self);
}


static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self) {
	GtkButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkStack* _tmp3_;
	GtkSpinner* _tmp4_;
	GtkSpinner* _tmp5_;
	GtkButton* _tmp6_;
	CompletionTextView* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	ComposeImageManager* _tmp10_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_ = {0};
	CompletionTextView* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextIter _tmp18_ = {0};
	CbComposeJob* _tmp19_;
	CompletionTextView* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GtkTextBuffer* _tmp22_;
	GtkTextIter _tmp23_;
	GtkTextIter _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	CbComposeJob* _tmp27_;
	GCancellable* _tmp28_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->send_button;
	_tmp1_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->title_stack;
	_tmp4_ = self->priv->title_spinner;
	gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = self->priv->title_spinner;
	gtk_spinner_start (_tmp5_);
	_tmp6_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp7_ = self->priv->tweet_text;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp8_ = self->priv->fav_image_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp9_ = self->priv->add_image_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp10_ = self->priv->compose_image_manager;
	compose_image_manager_insensitivize_buttons (_tmp10_);
	_tmp11_ = self->priv->tweet_text;
	_tmp12_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_text_view_get_type (), GtkTextView));
	_tmp13_ = _tmp12_;
	gtk_text_buffer_get_start_iter (_tmp13_, &_tmp14_);
	start = _tmp14_;
	_tmp15_ = self->priv->tweet_text;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	gtk_text_buffer_get_end_iter (_tmp17_, &_tmp18_);
	end = _tmp18_;
	_tmp19_ = self->priv->compose_job;
	_tmp20_ = self->priv->tweet_text;
	_tmp21_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_text_view_get_type (), GtkTextView));
	_tmp22_ = _tmp21_;
	_tmp23_ = start;
	_tmp24_ = end;
	_tmp25_ = gtk_text_buffer_get_text (_tmp22_, &_tmp23_, &_tmp24_, TRUE);
	_tmp26_ = _tmp25_;
	cb_compose_job_set_text (_tmp19_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp27_ = self->priv->compose_job;
	_tmp28_ = self->priv->cancellable;
	cb_compose_job_send_async (_tmp27_, _tmp28_, ___lambda43__gasync_ready_callback, g_object_ref (self));
}


static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_start_send_tweet ((ComposeTweetWindow*) self);
}


static void compose_tweet_window_save_last_tweet (ComposeTweetWindow* self) {
	CbTweet* _tmp0_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->reply_to;
	if (_tmp0_ == NULL) {
		gchar* text = NULL;
		CompletionTextView* _tmp1_;
		GtkTextBuffer* _tmp2_;
		GtkTextBuffer* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		Account* _tmp6_;
		SqlDatabase* _tmp7_;
		SqlUpdateStatement* _tmp8_;
		SqlUpdateStatement* _tmp9_;
		const gchar* _tmp10_;
		SqlUpdateStatement* _tmp11_;
		SqlUpdateStatement* _tmp12_;
		_tmp1_ = self->priv->tweet_text;
		_tmp2_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_text_view_get_type (), GtkTextView));
		_tmp3_ = _tmp2_;
		g_object_get (_tmp3_, "text", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		text = _tmp5_;
		_tmp6_ = self->priv->account;
		_tmp7_ = _tmp6_->db;
		_tmp8_ = sql_database_update (_tmp7_, "info");
		_tmp9_ = _tmp8_;
		_tmp10_ = text;
		_tmp11_ = sql_update_statement_val (_tmp9_, "last_tweet", _tmp10_);
		_tmp12_ = _tmp11_;
		sql_update_statement_run (_tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp9_);
		_g_free0 (text);
	}
}


static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkGrid* _tmp4_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->image_error_grid;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		_tmp0_ = TRUE;
	} else {
		GtkStack* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = gtk_stack_get_visible_child_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "fav-images") == 0;
	}
	if (_tmp0_) {
		GtkStack* _tmp8_;
		GtkGrid* _tmp9_;
		GtkButton* _tmp10_;
		_tmp8_ = self->priv->stack;
		_tmp9_ = self->priv->content_grid;
		gtk_stack_set_visible_child (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		_tmp10_ = self->priv->cancel_button;
		gtk_button_set_label (_tmp10_, _ ("Cancel"));
		compose_tweet_window_recalc_tweet_length (self);
	} else {
		GCancellable* _tmp11_;
		_tmp11_ = self->priv->cancellable;
		if (_tmp11_ != NULL) {
			GCancellable* _tmp12_;
			_tmp12_ = self->priv->cancellable;
			g_cancellable_cancel (_tmp12_);
		}
		compose_tweet_window_save_last_tweet (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_cancel_clicked ((ComposeTweetWindow*) self);
}


static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (IS_COMPOSE_TWEET_WINDOW (self), FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "fav-images") == 0) {
		GtkStack* _tmp3_;
		GtkGrid* _tmp4_;
		_tmp3_ = self->priv->stack;
		_tmp4_ = self->priv->content_grid;
		gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	} else {
		compose_tweet_window_save_last_tweet (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
	result = GDK_EVENT_STOP;
	return result;
}


void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text) {
	CompletionTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	_tmp3_ = text;
	g_object_set (_tmp2_, "text", _tmp3_, NULL);
}


static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, GtkButton* source) {
	GtkFileChooserNative* filechooser = NULL;
	GtkFileChooserNative* _tmp0_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp3_;
	GtkFileFilter* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileChooserNative* _tmp7_;
	gint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (GTK_IS_BUTTON (source));
	_tmp0_ = gtk_file_chooser_native_new (_ ("Select Image"), G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Open"), _ ("Cancel"));
	filechooser = _tmp0_;
	_tmp1_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp1_);
	filter = _tmp1_;
	_tmp2_ = filter;
	gtk_file_filter_add_mime_type (_tmp2_, "image/png");
	_tmp3_ = filter;
	gtk_file_filter_add_mime_type (_tmp3_, "image/jpeg");
	_tmp4_ = filter;
	gtk_file_filter_add_mime_type (_tmp4_, "image/gif");
	_tmp5_ = filechooser;
	_tmp6_ = filter;
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), _tmp6_);
	_tmp7_ = filechooser;
	_tmp8_ = gtk_native_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GTK_TYPE_NATIVE_DIALOG, GtkNativeDialog));
	if (_tmp8_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* filename = NULL;
		GtkFileChooserNative* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		GFile* file = NULL;
		const gchar* _tmp12_;
		GFile* _tmp13_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_;
		_tmp9_ = filechooser;
		_tmp10_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		filename = _tmp10_;
		_tmp11_ = filename;
		g_debug ("ComposeTweetWindow.vala:295: Loading %s", _tmp11_);
		_tmp12_ = filename;
		_tmp13_ = g_file_new_for_path (_tmp12_);
		file = _tmp13_;
		{
			GFileInfo* _tmp14_ = NULL;
			GFile* _tmp15_;
			GFileInfo* _tmp16_;
			GFileInfo* _tmp17_;
			_tmp15_ = file;
			_tmp16_ = g_file_query_info (_tmp15_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &_inner_error_);
			_tmp14_ = _tmp16_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch86_g_error;
			}
			_tmp17_ = _tmp14_;
			_tmp14_ = NULL;
			_g_object_unref0 (info);
			info = _tmp17_;
			_g_object_unref0 (_tmp14_);
		}
		goto __finally86;
		__catch86_g_error:
		{
			GError* e = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			_tmp20_ = filename;
			g_warning ("ComposeTweetWindow.vala:305: %s (%s)", _tmp19_, _tmp20_);
			_g_error_free0 (e);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (filename);
			_g_object_unref0 (filter);
			_g_object_unref0 (filechooser);
			return;
		}
		__finally86:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (filename);
			_g_object_unref0 (filter);
			_g_object_unref0 (filechooser);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp21_ = info;
		_tmp22_ = g_file_info_get_content_type (_tmp21_);
		_tmp23_ = g_str_has_prefix (_tmp22_, "image/");
		if (!_tmp23_) {
			GtkStack* _tmp24_;
			GtkGrid* _tmp25_;
			GtkLabel* _tmp26_;
			GtkButton* _tmp27_;
			GtkButton* _tmp28_;
			_tmp24_ = self->priv->stack;
			_tmp25_ = self->priv->image_error_grid;
			gtk_stack_set_visible_child (_tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
			_tmp26_ = self->priv->image_error_label;
			gtk_label_set_label (_tmp26_, _ ("Selected file is not an image."));
			_tmp27_ = self->priv->cancel_button;
			gtk_button_set_label (_tmp27_, _ ("Back"));
			_tmp28_ = self->priv->send_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget), FALSE);
		} else {
			GFileInfo* _tmp29_;
			gint64 _tmp30_;
			_tmp29_ = info;
			_tmp30_ = g_file_info_get_size (_tmp29_);
			if (_tmp30_ > ((gint64) TWITTER_MAX_BYTES_PER_IMAGE)) {
				GtkStack* _tmp31_;
				GtkGrid* _tmp32_;
				GtkLabel* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				GtkButton* _tmp36_;
				GtkButton* _tmp37_;
				_tmp31_ = self->priv->stack;
				_tmp32_ = self->priv->image_error_grid;
				gtk_stack_set_visible_child (_tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
				_tmp33_ = self->priv->image_error_label;
				_tmp34_ = g_strdup_printf (_ ("The selected image is too big. The maximum file size per image is %'d " \
"MB"), (TWITTER_MAX_BYTES_PER_IMAGE / 1024) / 1024);
				_tmp35_ = _tmp34_;
				gtk_label_set_label (_tmp33_, _tmp35_);
				_g_free0 (_tmp35_);
				_tmp36_ = self->priv->cancel_button;
				gtk_button_set_label (_tmp36_, _ ("Back"));
				_tmp37_ = self->priv->send_button;
				gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), FALSE);
			} else {
				gboolean _tmp38_ = FALSE;
				const gchar* _tmp39_;
				gboolean _tmp40_;
				_tmp39_ = filename;
				_tmp40_ = g_str_has_suffix (_tmp39_, ".gif");
				if (_tmp40_) {
					ComposeImageManager* _tmp41_;
					gint _tmp42_;
					gint _tmp43_;
					_tmp41_ = self->priv->compose_image_manager;
					_tmp42_ = compose_image_manager_get_n_images (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp38_ = _tmp43_ > 0;
				} else {
					_tmp38_ = FALSE;
				}
				if (_tmp38_) {
					GtkStack* _tmp44_;
					GtkGrid* _tmp45_;
					GtkLabel* _tmp46_;
					GtkButton* _tmp47_;
					GtkButton* _tmp48_;
					_tmp44_ = self->priv->stack;
					_tmp45_ = self->priv->image_error_grid;
					gtk_stack_set_visible_child (_tmp44_, G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_widget_get_type (), GtkWidget));
					_tmp46_ = self->priv->image_error_label;
					gtk_label_set_label (_tmp46_, _ ("Only one GIF file per tweet is allowed."));
					_tmp47_ = self->priv->cancel_button;
					gtk_button_set_label (_tmp47_, _ ("Back"));
					_tmp48_ = self->priv->send_button;
					gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_widget_get_type (), GtkWidget), FALSE);
				} else {
					ComposeImageManager* _tmp49_;
					ComposeImageManager* _tmp50_;
					const gchar* _tmp51_;
					CbComposeJob* _tmp52_;
					const gchar* _tmp53_;
					ComposeImageManager* _tmp54_;
					gint _tmp55_;
					gint _tmp56_;
					ComposeImageManager* _tmp58_;
					gboolean _tmp59_;
					gboolean _tmp60_;
					_tmp49_ = self->priv->compose_image_manager;
					gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, gtk_widget_get_type (), GtkWidget));
					_tmp50_ = self->priv->compose_image_manager;
					_tmp51_ = filename;
					compose_image_manager_load_image (_tmp50_, _tmp51_, NULL);
					_tmp52_ = self->priv->compose_job;
					_tmp53_ = filename;
					cb_compose_job_upload_image_async (_tmp52_, _tmp53_);
					_tmp54_ = self->priv->compose_image_manager;
					_tmp55_ = compose_image_manager_get_n_images (_tmp54_);
					_tmp56_ = _tmp55_;
					if (_tmp56_ > 0) {
						FavImageView* _tmp57_;
						_tmp57_ = self->priv->fav_image_view;
						fav_image_view_set_gifs_enabled (_tmp57_, FALSE);
					}
					_tmp58_ = self->priv->compose_image_manager;
					_tmp59_ = compose_image_manager_get_full (_tmp58_);
					_tmp60_ = _tmp59_;
					if (_tmp60_) {
						GtkButton* _tmp61_;
						GtkButton* _tmp62_;
						_tmp61_ = self->priv->add_image_button;
						gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, gtk_widget_get_type (), GtkWidget), FALSE);
						_tmp62_ = self->priv->fav_image_button;
						gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_widget_get_type (), GtkWidget), FALSE);
					}
				}
			}
		}
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (filename);
	}
	_g_object_unref0 (filter);
	_g_object_unref0 (filechooser);
}


static void _compose_tweet_window_add_image_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_add_image_clicked_cb ((ComposeTweetWindow*) self, _sender);
}


void compose_tweet_window_fav_image_button_clicked_cb (ComposeTweetWindow* self) {
	GtkButton* _tmp0_;
	GtkStack* _tmp1_;
	FavImageView* _tmp2_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->cancel_button;
	gtk_button_set_label (_tmp0_, _ ("Back"));
	_tmp1_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp1_, "fav-images");
	_tmp2_ = self->priv->fav_image_view;
	fav_image_view_load_images (_tmp2_);
}


static void _compose_tweet_window_fav_image_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_fav_image_button_clicked_cb ((ComposeTweetWindow*) self);
}


void compose_tweet_window_favorite_image_selected_cb (ComposeTweetWindow* self, const gchar* path) {
	ComposeImageManager* _tmp0_;
	ComposeImageManager* _tmp1_;
	const gchar* _tmp2_;
	CbComposeJob* _tmp3_;
	const gchar* _tmp4_;
	ComposeImageManager* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	ComposeImageManager* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (path != NULL);
	compose_tweet_window_cancel_clicked (self);
	_tmp0_ = self->priv->compose_image_manager;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->compose_image_manager;
	_tmp2_ = path;
	compose_image_manager_load_image (_tmp1_, _tmp2_, NULL);
	_tmp3_ = self->priv->compose_job;
	_tmp4_ = path;
	cb_compose_job_upload_image_async (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->compose_image_manager;
	_tmp6_ = compose_image_manager_get_full (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp8_ = self->priv->add_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget), FALSE);
		_tmp9_ = self->priv->fav_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_tmp10_ = self->priv->compose_image_manager;
	_tmp11_ = compose_image_manager_get_n_images (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ > 0) {
		FavImageView* _tmp13_;
		_tmp13_ = self->priv->fav_image_view;
		fav_image_view_set_gifs_enabled (_tmp13_, FALSE);
	}
}


static void _compose_tweet_window_favorite_image_selected_cb_fav_image_view_image_selected (FavImageView* _sender, const gchar* image_path, gpointer self) {
	compose_tweet_window_favorite_image_selected_cb ((ComposeTweetWindow*) self, image_path);
}


static void compose_tweet_window_class_init (ComposeTweetWindowClass * klass) {
	gint ComposeTweetWindow_private_offset;
	compose_tweet_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeTweetWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = compose_tweet_window_finalize;
	ComposeTweetWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/compose-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_grid", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, content_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_text", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, tweet_text));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "length_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, length_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_spinner", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_stack", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compose_image_manager", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, compose_image_manager));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_image_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, add_image_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_error_grid", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, image_error_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_error_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, image_error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_image_view", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, fav_image_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_image_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, fav_image_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_send_tweet", G_CALLBACK(_compose_tweet_window_start_send_tweet_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_clicked", G_CALLBACK(_compose_tweet_window_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_image_clicked_cb", G_CALLBACK(_compose_tweet_window_add_image_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "fav_image_button_clicked_cb", G_CALLBACK(_compose_tweet_window_fav_image_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_image_selected_cb", G_CALLBACK(_compose_tweet_window_favorite_image_selected_cb_fav_image_view_image_selected));
}


static void compose_tweet_window_instance_init (ComposeTweetWindow * self) {
	self->priv = COMPOSE_TWEET_WINDOW_GET_PRIVATE (self);
	self->priv->reply_list = NULL;
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_COMPOSE_IMAGE_MANAGER);
	g_type_ensure (TYPE_FAV_IMAGE_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void compose_tweet_window_finalize (GObject * obj) {
	ComposeTweetWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->content_grid);
	_g_object_unref0 (self->priv->tweet_text);
	_g_object_unref0 (self->priv->length_label);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->title_spinner);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->title_stack);
	_g_object_unref0 (self->priv->compose_image_manager);
	_g_object_unref0 (self->priv->add_image_button);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->image_error_grid);
	_g_object_unref0 (self->priv->image_error_label);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->fav_image_view);
	_g_object_unref0 (self->priv->fav_image_button);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->reply_list);
	_g_object_unref0 (self->priv->compose_job);
	G_OBJECT_CLASS (compose_tweet_window_parent_class)->finalize (obj);
}


GType compose_tweet_window_get_type (void) {
	static volatile gsize compose_tweet_window_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeTweetWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_tweet_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeTweetWindow), 0, (GInstanceInitFunc) compose_tweet_window_instance_init, NULL };
		GType compose_tweet_window_type_id;
		compose_tweet_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ComposeTweetWindow", &g_define_type_info, 0);
		g_once_init_leave (&compose_tweet_window_type_id__volatile, compose_tweet_window_type_id);
	}
	return compose_tweet_window_type_id__volatile;
}



