/* SelectStatement.c generated by valac 0.38.7, the Vala compiler
 * generated from SelectStatement.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>


#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
typedef struct _SqlSelectStatementPrivate SqlSelectStatementPrivate;
enum  {
	SQL_SELECT_STATEMENT_0_PROPERTY,
	SQL_SELECT_STATEMENT_NUM_PROPERTIES
};
static GParamSpec* sql_select_statement_properties[SQL_SELECT_STATEMENT_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
typedef struct _Block79Data Block79Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block80Data Block80Data;

struct _SqlSelectStatement {
	GObject parent_instance;
	SqlSelectStatementPrivate * priv;
	sqlite3* db;
};

struct _SqlSelectStatementClass {
	GObjectClass parent_class;
};

struct _SqlSelectStatementPrivate {
	GString* query_builder;
	gchar* table_name;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);
struct _Block79Data {
	int _ref_count_;
	SqlSelectStatement* self;
	gint64 back;
};

struct _Block80Data {
	int _ref_count_;
	SqlSelectStatement* self;
	gchar* back;
};


static gpointer sql_select_statement_parent_class = NULL;

GType sql_select_statement_get_type (void) G_GNUC_CONST;
#define SQL_SELECT_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementPrivate))
SqlSelectStatement* sql_select_statement_new (const gchar* table_name);
SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt);
SqlSelectStatement* sql_select_statement_where_prefix (SqlSelectStatement* self, const gchar* field, const gchar* prefix);
SqlSelectStatement* sql_select_statement_where_prefix2 (SqlSelectStatement* self, const gchar* field, const gchar* prefix);
SqlSelectStatement* sql_select_statement_or (SqlSelectStatement* self);
SqlSelectStatement* sql_select_statement_nocase (SqlSelectStatement* self);
SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
gint64 sql_select_statement_once_i64 (SqlSelectStatement* self);
static Block79Data* block79_data_ref (Block79Data* _data79_);
static void block79_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block79Data* _data79_, gchar** vals, int vals_length1);
static gboolean ___lambda5__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
gchar* sql_select_statement_once_string (SqlSelectStatement* self);
static Block80Data* block80_data_ref (Block80Data* _data80_);
static void block80_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block80Data* _data80_, gchar** vals, int vals_length1);
static gboolean ___lambda6__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
static void sql_select_statement_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


SqlSelectStatement* sql_select_statement_construct (GType object_type, const gchar* table_name) {
	SqlSelectStatement * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (table_name != NULL, NULL);
	self = (SqlSelectStatement*) g_object_new (object_type, NULL);
	_tmp0_ = table_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->table_name);
	self->priv->table_name = _tmp1_;
	return self;
}


SqlSelectStatement* sql_select_statement_new (const gchar* table_name) {
	return sql_select_statement_construct (SQL_TYPE_SELECT_STATEMENT, table_name);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...) {
	SqlSelectStatement* result = NULL;
	va_list arg_list = {0};
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	GString* _tmp17_;
	SqlSelectStatement* _tmp18_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (first != NULL, NULL);
	va_start (arg_list, first);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, "SELECT `");
	_tmp2_ = first;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	g_string_append (_tmp3_, "`");
	{
		gchar* arg = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = va_arg (arg_list, gchar*);
		_tmp5_ = g_strdup (_tmp4_);
		arg = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				const gchar* _tmp9_;
				GString* _tmp10_;
				GString* _tmp11_;
				const gchar* _tmp12_;
				GString* _tmp13_;
				if (!_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = va_arg (arg_list, gchar*);
					_tmp8_ = g_strdup (_tmp7_);
					_g_free0 (arg);
					arg = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = arg;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = self->priv->query_builder;
				_tmp11_ = g_string_append (_tmp10_, ", `");
				_tmp12_ = arg;
				_tmp13_ = g_string_append (_tmp11_, _tmp12_);
				g_string_append (_tmp13_, "`");
			}
		}
		_g_free0 (arg);
	}
	_tmp14_ = self->priv->query_builder;
	_tmp15_ = g_string_append (_tmp14_, " FROM `");
	_tmp16_ = self->priv->table_name;
	_tmp17_ = g_string_append (_tmp15_, _tmp16_);
	g_string_append (_tmp17_, "`");
	_tmp18_ = _g_object_ref0 (self);
	result = _tmp18_;
	va_end (arg_list);
	return result;
}


SqlSelectStatement* sql_select_statement_where (SqlSelectStatement* self, const gchar* stmt) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	SqlSelectStatement* _tmp3_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (stmt != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " WHERE ");
	_tmp2_ = stmt;
	g_string_append (_tmp1_, _tmp2_);
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}


SqlSelectStatement* sql_select_statement_where_prefix (SqlSelectStatement* self, const gchar* field, const gchar* prefix) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	GString* _tmp6_;
	SqlSelectStatement* _tmp7_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " WHERE `");
	_tmp2_ = field;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	_tmp4_ = g_string_append (_tmp3_, "` LIKE '");
	_tmp5_ = prefix;
	_tmp6_ = g_string_append (_tmp4_, _tmp5_);
	g_string_append (_tmp6_, "%'");
	_tmp7_ = _g_object_ref0 (self);
	result = _tmp7_;
	return result;
}


SqlSelectStatement* sql_select_statement_where_prefix2 (SqlSelectStatement* self, const gchar* field, const gchar* prefix) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	const gchar* _tmp5_;
	GString* _tmp6_;
	SqlSelectStatement* _tmp7_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (field != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, "`");
	_tmp2_ = field;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	_tmp4_ = g_string_append (_tmp3_, "` LIKE '");
	_tmp5_ = prefix;
	_tmp6_ = g_string_append (_tmp4_, _tmp5_);
	g_string_append (_tmp6_, "%'");
	_tmp7_ = _g_object_ref0 (self);
	result = _tmp7_;
	return result;
}


SqlSelectStatement* sql_select_statement_or (SqlSelectStatement* self) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	SqlSelectStatement* _tmp1_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	_tmp0_ = self->priv->query_builder;
	g_string_append (_tmp0_, " OR ");
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}


SqlSelectStatement* sql_select_statement_nocase (SqlSelectStatement* self) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	SqlSelectStatement* _tmp1_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	_tmp0_ = self->priv->query_builder;
	g_string_append (_tmp0_, " COLLATE NOCASE");
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}


SqlSelectStatement* sql_select_statement_where_eqi (SqlSelectStatement* self, const gchar* w, gint64 v) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GString* _tmp8_;
	SqlSelectStatement* _tmp9_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (w != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " WHERE `");
	_tmp2_ = w;
	_tmp3_ = g_string_append (_tmp1_, _tmp2_);
	_tmp4_ = g_string_append (_tmp3_, "`='");
	_tmp5_ = v;
	_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_string_append (_tmp4_, _tmp7_);
	g_string_append (_tmp8_, "'");
	_g_free0 (_tmp7_);
	_tmp9_ = _g_object_ref0 (self);
	result = _tmp9_;
	return result;
}


SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	SqlSelectStatement* _tmp3_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	g_return_val_if_fail (order_by != NULL, NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " ORDER BY ");
	_tmp2_ = order_by;
	g_string_append (_tmp1_, _tmp2_);
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}


SqlSelectStatement* sql_select_statement_limit (SqlSelectStatement* self, gint limit) {
	SqlSelectStatement* result = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	SqlSelectStatement* _tmp5_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	_tmp0_ = self->priv->query_builder;
	_tmp1_ = g_string_append (_tmp0_, " LIMIT ");
	_tmp2_ = limit;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	g_string_append (_tmp1_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = _g_object_ref0 (self);
	result = _tmp5_;
	return result;
}


gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target) {
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint ok = 0;
	sqlite3* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	gboolean next = FALSE;
	gint n_cols = 0;
	sqlite3_stmt* _tmp10_;
	gint _tmp11_;
	gint n_rows = 0;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), 0);
	_tmp0_ = self->db;
	_tmp1_ = self->priv->query_builder;
	_tmp2_ = _tmp1_->str;
	_tmp4_ = sqlite3_prepare_v2 (_tmp0_, _tmp2_, -1, &_tmp3_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp3_;
	ok = _tmp4_;
	_tmp5_ = ok;
	if (_tmp5_ != SQLITE_OK) {
		sqlite3* _tmp6_;
		const gchar* _tmp7_;
		GString* _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->db;
		_tmp7_ = sqlite3_errmsg (_tmp6_);
		g_critical ("SelectStatement.vala:86: %s", _tmp7_);
		_tmp8_ = self->priv->query_builder;
		_tmp9_ = _tmp8_->str;
		g_critical ("SelectStatement.vala:87: %s", _tmp9_);
		result = 0;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	next = TRUE;
	_tmp10_ = stmt;
	_tmp11_ = sqlite3_column_count (_tmp10_);
	n_cols = _tmp11_;
	n_rows = 0;
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		sqlite3_stmt* _tmp13_;
		gint _tmp14_;
		gchar** vals = NULL;
		gint _tmp16_;
		gchar** _tmp17_;
		gint vals_length1;
		gint _vals_size_;
		SqlSelectCallback _tmp29_;
		void* _tmp29__target;
		gchar** _tmp30_;
		gint _tmp30__length1;
		gboolean _tmp31_;
		gint _tmp32_;
		_tmp13_ = stmt;
		_tmp14_ = sqlite3_step (_tmp13_);
		if (_tmp14_ == SQLITE_ROW) {
			gboolean _tmp15_;
			_tmp15_ = next;
			_tmp12_ = _tmp15_;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		_tmp16_ = n_cols;
		_tmp17_ = g_new0 (gchar*, _tmp16_ + 1);
		vals = _tmp17_;
		vals_length1 = _tmp16_;
		_vals_size_ = vals_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					gchar** _tmp22_;
					gint _tmp22__length1;
					gint _tmp23_;
					sqlite3_stmt* _tmp24_;
					gint _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = i;
					_tmp21_ = n_cols;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = vals;
					_tmp22__length1 = vals_length1;
					_tmp23_ = i;
					_tmp24_ = stmt;
					_tmp25_ = i;
					_tmp26_ = sqlite3_column_text (_tmp24_, _tmp25_);
					_tmp27_ = g_strdup (_tmp26_);
					_g_free0 (_tmp22_[_tmp23_]);
					_tmp22_[_tmp23_] = _tmp27_;
					_tmp28_ = _tmp22_[_tmp23_];
				}
			}
		}
		_tmp29_ = callback;
		_tmp29__target = callback_target;
		_tmp30_ = vals;
		_tmp30__length1 = vals_length1;
		_tmp31_ = _tmp29_ (_tmp30_, _tmp30__length1, _tmp29__target);
		next = _tmp31_;
		_tmp32_ = n_rows;
		n_rows = _tmp32_ + 1;
		vals = (_vala_array_free (vals, vals_length1, (GDestroyNotify) g_free), NULL);
	}
	result = n_rows;
	_sqlite3_finalize0 (stmt);
	return result;
}


static Block79Data* block79_data_ref (Block79Data* _data79_) {
	g_atomic_int_inc (&_data79_->_ref_count_);
	return _data79_;
}


static void block79_data_unref (void * _userdata_) {
	Block79Data* _data79_;
	_data79_ = (Block79Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data79_->_ref_count_)) {
		SqlSelectStatement* self;
		self = _data79_->self;
		_g_object_unref0 (self);
		g_slice_free (Block79Data, _data79_);
	}
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gboolean __lambda5_ (Block79Data* _data79_, gchar** vals, int vals_length1) {
	SqlSelectStatement* self;
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint64 _tmp2_;
	self = _data79_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = int64_parse (_tmp1_);
	_data79_->back = _tmp2_;
	result = FALSE;
	return result;
}


static gboolean ___lambda5__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda5_ (self, vals, vals_length1);
	return result;
}


gint64 sql_select_statement_once_i64 (SqlSelectStatement* self) {
	gint64 result = 0LL;
	Block79Data* _data79_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), 0LL);
	_data79_ = g_slice_new0 (Block79Data);
	_data79_->_ref_count_ = 1;
	_data79_->self = g_object_ref (self);
	_data79_->back = (gint64) -1;
	sql_select_statement_run (self, ___lambda5__sql_select_callback, _data79_);
	result = _data79_->back;
	block79_data_unref (_data79_);
	_data79_ = NULL;
	return result;
}


static Block80Data* block80_data_ref (Block80Data* _data80_) {
	g_atomic_int_inc (&_data80_->_ref_count_);
	return _data80_;
}


static void block80_data_unref (void * _userdata_) {
	Block80Data* _data80_;
	_data80_ = (Block80Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data80_->_ref_count_)) {
		SqlSelectStatement* self;
		self = _data80_->self;
		_g_free0 (_data80_->back);
		_g_object_unref0 (self);
		g_slice_free (Block80Data, _data80_);
	}
}


static gboolean __lambda6_ (Block80Data* _data80_, gchar** vals, int vals_length1) {
	SqlSelectStatement* self;
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data80_->self;
	_tmp0_ = vals;
	_tmp0__length1 = vals_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data80_->back);
	_data80_->back = _tmp2_;
	result = FALSE;
	return result;
}


static gboolean ___lambda6__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda6_ (self, vals, vals_length1);
	return result;
}


gchar* sql_select_statement_once_string (SqlSelectStatement* self) {
	gchar* result = NULL;
	Block80Data* _data80_;
	gchar* _tmp0_;
	g_return_val_if_fail (SQL_IS_SELECT_STATEMENT (self), NULL);
	_data80_ = g_slice_new0 (Block80Data);
	_data80_->_ref_count_ = 1;
	_data80_->self = g_object_ref (self);
	_data80_->back = NULL;
	sql_select_statement_run (self, ___lambda6__sql_select_callback, _data80_);
	_tmp0_ = g_strdup (_data80_->back);
	result = _tmp0_;
	block80_data_unref (_data80_);
	_data80_ = NULL;
	return result;
}


static void sql_select_statement_class_init (SqlSelectStatementClass * klass) {
	sql_select_statement_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SqlSelectStatementPrivate));
	G_OBJECT_CLASS (klass)->finalize = sql_select_statement_finalize;
}


static void sql_select_statement_instance_init (SqlSelectStatement * self) {
	GString* _tmp0_;
	self->priv = SQL_SELECT_STATEMENT_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->query_builder = _tmp0_;
}


static void sql_select_statement_finalize (GObject * obj) {
	SqlSelectStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement);
	_g_string_free0 (self->priv->query_builder);
	_g_free0 (self->priv->table_name);
	G_OBJECT_CLASS (sql_select_statement_parent_class)->finalize (obj);
}


GType sql_select_statement_get_type (void) {
	static volatile gsize sql_select_statement_type_id__volatile = 0;
	if (g_once_init_enter (&sql_select_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SqlSelectStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sql_select_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SqlSelectStatement), 0, (GInstanceInitFunc) sql_select_statement_instance_init, NULL };
		GType sql_select_statement_type_id;
		sql_select_statement_type_id = g_type_register_static (G_TYPE_OBJECT, "SqlSelectStatement", &g_define_type_info, 0);
		g_once_init_leave (&sql_select_statement_type_id__volatile, sql_select_statement_type_id);
	}
	return sql_select_statement_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



