/* AvatarWidget.c generated by valac 0.38.7, the Vala compiler
 * generated from AvatarWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;
typedef struct _AvatarWidgetPrivate AvatarWidgetPrivate;
enum  {
	AVATAR_WIDGET_0_PROPERTY,
	AVATAR_WIDGET_MAKE_ROUND_PROPERTY,
	AVATAR_WIDGET_VERIFIED_PROPERTY,
	AVATAR_WIDGET_OVERLAP_PROPERTY,
	AVATAR_WIDGET_SIZE_PROPERTY,
	AVATAR_WIDGET_SURFACE_PROPERTY,
	AVATAR_WIDGET_NUM_PROPERTIES
};
static GParamSpec* avatar_widget_properties[AVATAR_WIDGET_NUM_PROPERTIES];

#define TYPE_TWITTER (twitter_get_type ())
#define TWITTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWITTER, Twitter))
#define TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWITTER, TwitterClass))
#define IS_TWITTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWITTER))
#define IS_TWITTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWITTER))
#define TWITTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWITTER, TwitterClass))

typedef struct _Twitter Twitter;
typedef struct _TwitterClass TwitterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _AvatarWidget {
	GtkWidget parent_instance;
	AvatarWidgetPrivate * priv;
};

struct _AvatarWidgetClass {
	GtkWidgetClass parent_class;
};

struct _AvatarWidgetPrivate {
	gboolean _round;
	gboolean _verified;
	gboolean _overlap;
	gint _size;
	cairo_surface_t* _surface;
	gdouble alpha;
	gint64 start_time;
};


static gpointer avatar_widget_parent_class = NULL;
static cairo_surface_t** avatar_widget_verified_icons;
static gint avatar_widget_verified_icons_length1;
static cairo_surface_t** avatar_widget_verified_icons = NULL;
static gint avatar_widget_verified_icons_length1 = 0;
static gint _avatar_widget_verified_icons_size_ = 0;

GType avatar_widget_get_type (void) G_GNUC_CONST;
#define AVATAR_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_WIDGET, AvatarWidgetPrivate))
GType twitter_get_type (void) G_GNUC_CONST;
Twitter* twitter_get (void);
void twitter_unref_avatar (Twitter* self, cairo_surface_t* surface);
#define AVATAR_WIDGET_SMALL 0
#define AVATAR_WIDGET_LARGE 1
#define AVATAR_WIDGET_OVERLAP_DIST 40
static void avatar_widget_start_animation (AvatarWidget* self);
static gboolean avatar_widget_fade_in_cb (AvatarWidget* self, GtkWidget* widget, GdkFrameClock* frame_clock);
static gboolean _avatar_widget_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
#define TRANSITION_DURATION (200 * 1000)
gdouble ease_out_cubic (gdouble t);
static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx);
gint avatar_widget_get_size (AvatarWidget* self);
gboolean avatar_widget_get_overlap (AvatarWidget* self);
gboolean avatar_widget_get_verified (AvatarWidget* self);
static void avatar_widget_real_size_allocate (GtkWidget* base, GtkAllocation* alloc);
static void avatar_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void avatar_widget_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
AvatarWidget* avatar_widget_new (void);
AvatarWidget* avatar_widget_construct (GType object_type);
gboolean avatar_widget_get_make_round (AvatarWidget* self);
void avatar_widget_set_make_round (AvatarWidget* self, gboolean value);
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
void avatar_widget_set_overlap (AvatarWidget* self, gboolean value);
void avatar_widget_set_size (AvatarWidget* self, gint value);
cairo_surface_t* avatar_widget_get_surface (AvatarWidget* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
void twitter_ref_avatar (Twitter* self, cairo_surface_t* surface);
static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
GSettings* settings_get (void);
static void avatar_widget_finalize (GObject * obj);
static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gint AVATAR_WIDGET_VERIFIED_SIZES[2] = {12, 25};

static gboolean _avatar_widget_fade_in_cb_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = avatar_widget_fade_in_cb ((AvatarWidget*) self, widget, frame_clock);
	return result;
}


static void avatar_widget_start_animation (AvatarWidget* self) {
	gboolean _tmp0_;
	GdkFrameClock* _tmp1_;
	gint64 _tmp2_;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (!_tmp0_) {
		return;
	}
	self->priv->alpha = 0.0;
	_tmp1_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = gdk_frame_clock_get_frame_time (_tmp1_);
	self->priv->start_time = _tmp2_;
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _avatar_widget_fade_in_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}


static gboolean avatar_widget_fade_in_cb (AvatarWidget* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp0_;
	gint64 _tmp1_;
	gdouble t = 0.0;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->start_time;
	t = (_tmp2_ - _tmp3_) / ((gdouble) TRANSITION_DURATION);
	_tmp4_ = t;
	if (_tmp4_ >= 1.0) {
		t = 1.0;
	}
	_tmp5_ = t;
	_tmp6_ = ease_out_cubic (_tmp5_);
	self->priv->alpha = _tmp6_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = t;
	result = _tmp7_ < 1.0;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


static gboolean avatar_widget_real_draw (GtkWidget* base, cairo_t* ctx) {
	AvatarWidget * self;
	gboolean result = FALSE;
	gint width = 0;
	gint _tmp0_;
	gint height = 0;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	gdouble surface_scale = 0.0;
	cairo_surface_t* _tmp3_;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gint _tmp6_;
	gint _tmp7_;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	cairo_surface_t* _tmp14_;
	cairo_t* ct = NULL;
	cairo_surface_t* _tmp15_;
	cairo_t* _tmp16_;
	gdouble scale = 0.0;
	gint _tmp17_;
	cairo_surface_t* _tmp18_;
	gint _tmp19_;
	gdouble _tmp20_;
	cairo_t* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	cairo_t* _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	cairo_t* _tmp27_;
	cairo_surface_t* _tmp28_;
	cairo_t* _tmp29_;
	gint y = 0;
	gboolean _tmp30_;
	gboolean _tmp31_;
	cairo_t* _tmp46_;
	cairo_surface_t* _tmp47_;
	gint _tmp48_;
	cairo_t* _tmp49_;
	gdouble _tmp50_;
	gboolean _tmp51_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	g_return_val_if_fail (ctx != NULL, FALSE);
	_tmp0_ = self->priv->_size;
	width = _tmp0_;
	_tmp1_ = self->priv->_size;
	height = _tmp1_;
	_tmp2_ = self->priv->_surface;
	if (_tmp2_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp3_ = self->priv->_surface;
	cairo_surface_get_device_scale (_tmp3_, &_tmp4_, &_tmp5_);
	surface_scale = _tmp4_;
	surface_scale = _tmp5_;
	_tmp6_ = width;
	_tmp7_ = height;
	if (_tmp6_ != _tmp7_) {
		gint _tmp8_;
		gint _tmp9_;
		_tmp8_ = width;
		_tmp9_ = height;
		g_warning ("AvatarWidget.vala:149: Avatar with mapped with width %d and height %d", _tmp8_, _tmp9_);
	}
	_tmp10_ = ctx;
	_tmp11_ = cairo_get_target (_tmp10_);
	_tmp12_ = width;
	_tmp13_ = height;
	_tmp14_ = cairo_surface_create_similar (_tmp11_, CAIRO_CONTENT_COLOR_ALPHA, _tmp12_, _tmp13_);
	surface = _tmp14_;
	_tmp15_ = surface;
	_tmp16_ = cairo_create (_tmp15_);
	ct = _tmp16_;
	_tmp17_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp18_ = self->priv->_surface;
	_tmp19_ = cairo_image_surface_get_width (_tmp18_);
	_tmp20_ = surface_scale;
	scale = ((gdouble) _tmp17_) / ((gdouble) (_tmp19_ / _tmp20_));
	_tmp21_ = ct;
	_tmp22_ = width;
	_tmp23_ = height;
	cairo_rectangle (_tmp21_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp22_, (gdouble) _tmp23_);
	_tmp24_ = ct;
	_tmp25_ = scale;
	_tmp26_ = scale;
	cairo_scale (_tmp24_, _tmp25_, _tmp26_);
	_tmp27_ = ct;
	_tmp28_ = self->priv->_surface;
	cairo_set_source_surface (_tmp27_, _tmp28_, (gdouble) 0, (gdouble) 0);
	_tmp29_ = ct;
	cairo_fill (_tmp29_);
	_tmp30_ = self->priv->_overlap;
	if (_tmp30_) {
		y = -AVATAR_WIDGET_OVERLAP_DIST;
	} else {
		y = 0;
	}
	_tmp31_ = self->priv->_round;
	if (_tmp31_) {
		cairo_t* _tmp32_;
		gdouble _tmp33_;
		gdouble _tmp34_;
		cairo_t* _tmp35_;
		cairo_t* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		cairo_t* _tmp40_;
		GtkStyleContext* _tmp41_;
		cairo_t* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		_tmp32_ = ct;
		_tmp33_ = scale;
		_tmp34_ = scale;
		cairo_scale (_tmp32_, 1.0 / _tmp33_, 1.0 / _tmp34_);
		_tmp35_ = ct;
		cairo_set_operator (_tmp35_, CAIRO_OPERATOR_DEST_IN);
		_tmp36_ = ct;
		_tmp37_ = width;
		_tmp38_ = height;
		_tmp39_ = width;
		cairo_arc (_tmp36_, _tmp37_ / 2.0, _tmp38_ / 2.0, (_tmp39_ / 2.0) - 0.5, (gdouble) 0, 2 * G_PI);
		_tmp40_ = ct;
		cairo_fill (_tmp40_);
		_tmp41_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		_tmp42_ = ctx;
		_tmp43_ = y;
		_tmp44_ = width;
		_tmp45_ = height;
		gtk_render_frame (_tmp41_, _tmp42_, (gdouble) 0, (gdouble) _tmp43_, (gdouble) _tmp44_, (gdouble) _tmp45_);
	}
	_tmp46_ = ctx;
	_tmp47_ = surface;
	_tmp48_ = y;
	cairo_set_source_surface (_tmp46_, _tmp47_, (gdouble) 0, (gdouble) _tmp48_);
	_tmp49_ = ctx;
	_tmp50_ = self->priv->alpha;
	cairo_paint_with_alpha (_tmp49_, _tmp50_);
	_tmp51_ = self->priv->_verified;
	if (_tmp51_) {
		gdouble verified_scale = 0.0;
		gint index = 0;
		gint _tmp52_;
		gboolean _tmp53_ = FALSE;
		gint _tmp54_;
		gint scale_factor = 0;
		gint _tmp57_;
		cairo_surface_t* verified_img = NULL;
		cairo_surface_t** _tmp58_;
		gint _tmp58__length1;
		gint _tmp59_;
		gint _tmp60_;
		cairo_surface_t* _tmp61_;
		cairo_surface_t* _tmp62_;
		cairo_t* _tmp63_;
		gdouble _tmp64_;
		gdouble _tmp65_;
		cairo_t* _tmp66_;
		cairo_surface_t* _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gdouble _tmp71_;
		gdouble _tmp72_;
		gint _tmp73_;
		cairo_t* _tmp74_;
		gdouble _tmp75_;
		verified_scale = 1.0;
		index = AVATAR_WIDGET_SMALL;
		_tmp52_ = width;
		if (_tmp52_ > 48) {
			index = AVATAR_WIDGET_LARGE;
		}
		_tmp54_ = index;
		if (_tmp54_ == AVATAR_WIDGET_LARGE) {
			gint _tmp55_;
			_tmp55_ = self->priv->_size;
			_tmp53_ = _tmp55_ < 100;
		} else {
			_tmp53_ = FALSE;
		}
		if (_tmp53_) {
			gint _tmp56_;
			_tmp56_ = self->priv->_size;
			verified_scale = ((gdouble) _tmp56_) / 100.0;
		}
		_tmp57_ = gtk_widget_get_scale_factor (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		scale_factor = _tmp57_ - 1;
		_tmp58_ = avatar_widget_verified_icons;
		_tmp58__length1 = avatar_widget_verified_icons_length1;
		_tmp59_ = scale_factor;
		_tmp60_ = index;
		_tmp61_ = _tmp58_[(_tmp59_ * 2) + _tmp60_];
		_tmp62_ = _cairo_surface_reference0 (_tmp61_);
		verified_img = _tmp62_;
		_tmp63_ = ctx;
		_tmp64_ = verified_scale;
		_tmp65_ = verified_scale;
		cairo_scale (_tmp63_, _tmp64_, _tmp65_);
		_tmp66_ = ctx;
		_tmp67_ = verified_img;
		_tmp68_ = width;
		_tmp69_ = index;
		_tmp70_ = AVATAR_WIDGET_VERIFIED_SIZES[_tmp69_];
		_tmp71_ = verified_scale;
		_tmp72_ = verified_scale;
		_tmp73_ = y;
		cairo_set_source_surface (_tmp66_, _tmp67_, (_tmp68_ - (_tmp70_ * _tmp71_)) / _tmp72_, (gdouble) _tmp73_);
		_tmp74_ = ctx;
		_tmp75_ = self->priv->alpha;
		cairo_paint_with_alpha (_tmp74_, _tmp75_);
		_cairo_surface_destroy0 (verified_img);
	}
	result = GDK_EVENT_PROPAGATE;
	_cairo_destroy0 (ct);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void avatar_widget_real_size_allocate (GtkWidget* base, GtkAllocation* alloc) {
	AvatarWidget * self;
	GtkAllocation _tmp0_;
	gboolean _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	g_return_if_fail (alloc != NULL);
	_tmp0_ = *alloc;
	GTK_WIDGET_CLASS (avatar_widget_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp0_);
	_tmp1_ = self->priv->_overlap;
	if (_tmp1_) {
		gint _tmp2_;
		gint _tmp3_;
		GtkAllocation _tmp4_;
		_tmp2_ = (*alloc).y;
		(*alloc).y = _tmp2_ - AVATAR_WIDGET_OVERLAP_DIST;
		_tmp3_ = (*alloc).height;
		(*alloc).height = _tmp3_ + AVATAR_WIDGET_OVERLAP_DIST;
		_tmp4_ = *alloc;
		gtk_widget_set_clip (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), &_tmp4_);
	}
}


static void avatar_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	AvatarWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = self->priv->_size;
	_vala_min = _tmp0_;
	_tmp1_ = self->priv->_size;
	_vala_nat = _tmp1_;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_widget_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	AvatarWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gboolean _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = self->priv->_overlap;
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = self->priv->_size;
		_vala_min = _tmp1_ - AVATAR_WIDGET_OVERLAP_DIST;
		_tmp2_ = self->priv->_size;
		_vala_nat = _tmp2_ - AVATAR_WIDGET_OVERLAP_DIST;
	} else {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->_size;
		_vala_min = _tmp3_;
		_tmp4_ = self->priv->_size;
		_vala_nat = _tmp4_;
	}
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


AvatarWidget* avatar_widget_construct (GType object_type) {
	AvatarWidget * self = NULL;
	self = (AvatarWidget*) gtk_widget_new (object_type, NULL);
	return self;
}


AvatarWidget* avatar_widget_new (void) {
	return avatar_widget_construct (TYPE_AVATAR_WIDGET);
}


gboolean avatar_widget_get_make_round (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_round;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_make_round (AvatarWidget* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp5_;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = value;
	_tmp1_ = self->priv->_round;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = value;
	if (_tmp2_) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_add_class (_tmp3_, "avatar-round");
	} else {
		GtkStyleContext* _tmp4_;
		_tmp4_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gtk_style_context_remove_class (_tmp4_, "avatar-round");
	}
	_tmp5_ = value;
	self->priv->_round = _tmp5_;
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify_by_pspec ((GObject *) self, avatar_widget_properties[AVATAR_WIDGET_MAKE_ROUND_PROPERTY]);
}


gboolean avatar_widget_get_verified (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_verified;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_verified (AvatarWidget* self, gboolean value) {
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	if (avatar_widget_get_verified (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_verified = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avatar_widget_properties[AVATAR_WIDGET_VERIFIED_PROPERTY]);
	}
}


gboolean avatar_widget_get_overlap (AvatarWidget* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), FALSE);
	_tmp0_ = self->priv->_overlap;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_overlap (AvatarWidget* self, gboolean value) {
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	if (avatar_widget_get_overlap (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_overlap = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avatar_widget_properties[AVATAR_WIDGET_OVERLAP_PROPERTY]);
	}
}


gint avatar_widget_get_size (AvatarWidget* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), 0);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_size (AvatarWidget* self, gint value) {
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	if (avatar_widget_get_size (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_size = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, avatar_widget_properties[AVATAR_WIDGET_SIZE_PROPERTY]);
	}
}


cairo_surface_t* avatar_widget_get_surface (AvatarWidget* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
	g_return_val_if_fail (IS_AVATAR_WIDGET (self), NULL);
	_tmp0_ = self->priv->_surface;
	result = _tmp0_;
	return result;
}


void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	gboolean animate = FALSE;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	g_return_if_fail (IS_AVATAR_WIDGET (self));
	_tmp0_ = self->priv->_surface;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	animate = FALSE;
	_tmp2_ = self->priv->_surface;
	if (_tmp2_ != NULL) {
		Twitter* _tmp3_;
		Twitter* _tmp4_;
		cairo_surface_t* _tmp5_;
		_tmp3_ = twitter_get ();
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->_surface;
		twitter_unref_avatar (_tmp4_, _tmp5_);
		_g_object_unref0 (_tmp4_);
	} else {
		animate = TRUE;
	}
	_tmp6_ = value;
	_tmp7_ = _cairo_surface_reference0 ((cairo_surface_t*) _tmp6_);
	_cairo_surface_destroy0 (self->priv->_surface);
	self->priv->_surface = _tmp7_;
	_tmp8_ = self->priv->_surface;
	if (_tmp8_ != NULL) {
		Twitter* _tmp9_;
		Twitter* _tmp10_;
		cairo_surface_t* _tmp11_;
		gboolean _tmp12_;
		_tmp9_ = twitter_get ();
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_surface;
		twitter_ref_avatar (_tmp10_, _tmp11_);
		_g_object_unref0 (_tmp10_);
		_tmp12_ = animate;
		if (_tmp12_) {
			avatar_widget_start_animation (self);
		}
	}
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify_by_pspec ((GObject *) self, avatar_widget_properties[AVATAR_WIDGET_SURFACE_PROPERTY]);
}


static GObject * avatar_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarWidget * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	parent_class = G_OBJECT_CLASS (avatar_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_settings_bind (_tmp1_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), "make_round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp2_, "avatar");
	_tmp3_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp3_, "avatar-round");
	return obj;
}


static void avatar_widget_class_init (AvatarWidgetClass * klass) {
	GError * _inner_error_ = NULL;
	avatar_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) avatar_widget_real_draw;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget *, GtkAllocation*)) avatar_widget_real_size_allocate;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget *, gint*, gint*)) avatar_widget_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget *, gint*, gint*)) avatar_widget_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_avatar_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avatar_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = avatar_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_MAKE_ROUND_PROPERTY, avatar_widget_properties[AVATAR_WIDGET_MAKE_ROUND_PROPERTY] = g_param_spec_boolean ("make-round", "make-round", "make-round", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_VERIFIED_PROPERTY, avatar_widget_properties[AVATAR_WIDGET_VERIFIED_PROPERTY] = g_param_spec_boolean ("verified", "verified", "verified", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_OVERLAP_PROPERTY, avatar_widget_properties[AVATAR_WIDGET_OVERLAP_PROPERTY] = g_param_spec_boolean ("overlap", "overlap", "overlap", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_SIZE_PROPERTY, avatar_widget_properties[AVATAR_WIDGET_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 48, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_WIDGET_SURFACE_PROPERTY, avatar_widget_properties[AVATAR_WIDGET_SURFACE_PROPERTY] = g_param_spec_pointer ("surface", "surface", "surface", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	{
		GdkPixbuf* _tmp0_ = NULL;
		GdkPixbuf* _tmp1_;
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_ = NULL;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_;
		cairo_surface_t* _tmp8_;
		cairo_surface_t* _tmp9_;
		cairo_surface_t* _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_surface_t** _tmp12_;
		_tmp1_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/verified-small.png", &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch52_g_error;
		}
		_tmp3_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/verified-large.png", &_inner_error_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch52_g_error;
		}
		_tmp5_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/verified-small@2.png", &_inner_error_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch52_g_error;
		}
		_tmp7_ = gdk_pixbuf_new_from_resource ("/org/baedert/corebird/data/verified-large@2.png", &_inner_error_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (_tmp2_);
			_g_object_unref0 (_tmp0_);
			goto __catch52_g_error;
		}
		_tmp8_ = gdk_cairo_surface_create_from_pixbuf (_tmp0_, 1, NULL);
		_tmp9_ = gdk_cairo_surface_create_from_pixbuf (_tmp2_, 1, NULL);
		_tmp10_ = gdk_cairo_surface_create_from_pixbuf (_tmp4_, 2, NULL);
		_tmp11_ = gdk_cairo_surface_create_from_pixbuf (_tmp6_, 2, NULL);
		_tmp12_ = g_new0 (cairo_surface_t*, 4 + 1);
		_tmp12_[0] = _tmp8_;
		_tmp12_[1] = _tmp9_;
		_tmp12_[2] = _tmp10_;
		_tmp12_[3] = _tmp11_;
		avatar_widget_verified_icons = (_vala_array_free (avatar_widget_verified_icons, avatar_widget_verified_icons_length1, (GDestroyNotify) cairo_surface_destroy), NULL);
		avatar_widget_verified_icons = _tmp12_;
		avatar_widget_verified_icons_length1 = 4;
		_avatar_widget_verified_icons_size_ = avatar_widget_verified_icons_length1;
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally52;
	__catch52_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_critical ("AvatarWidget.vala:94: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally52:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void avatar_widget_instance_init (AvatarWidget * self) {
	self->priv = AVATAR_WIDGET_GET_PRIVATE (self);
	self->priv->_round = TRUE;
	self->priv->_verified = FALSE;
	self->priv->_overlap = FALSE;
	self->priv->_size = 48;
	self->priv->alpha = (gdouble) 1.0f;
}


static void avatar_widget_finalize (GObject * obj) {
	AvatarWidget * self;
	cairo_surface_t* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_WIDGET, AvatarWidget);
	_tmp0_ = self->priv->_surface;
	if (_tmp0_ != NULL) {
		Twitter* _tmp1_;
		Twitter* _tmp2_;
		cairo_surface_t* _tmp3_;
		_tmp1_ = twitter_get ();
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->_surface;
		twitter_unref_avatar (_tmp2_, _tmp3_);
		_g_object_unref0 (_tmp2_);
	}
	_cairo_surface_destroy0 (self->priv->_surface);
	G_OBJECT_CLASS (avatar_widget_parent_class)->finalize (obj);
}


GType avatar_widget_get_type (void) {
	static volatile gsize avatar_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarWidget), 0, (GInstanceInitFunc) avatar_widget_instance_init, NULL };
		GType avatar_widget_type_id;
		avatar_widget_type_id = g_type_register_static (gtk_widget_get_type (), "AvatarWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_widget_type_id__volatile, avatar_widget_type_id);
	}
	return avatar_widget_type_id__volatile;
}


static void _vala_avatar_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND_PROPERTY:
		g_value_set_boolean (value, avatar_widget_get_make_round (self));
		break;
		case AVATAR_WIDGET_VERIFIED_PROPERTY:
		g_value_set_boolean (value, avatar_widget_get_verified (self));
		break;
		case AVATAR_WIDGET_OVERLAP_PROPERTY:
		g_value_set_boolean (value, avatar_widget_get_overlap (self));
		break;
		case AVATAR_WIDGET_SIZE_PROPERTY:
		g_value_set_int (value, avatar_widget_get_size (self));
		break;
		case AVATAR_WIDGET_SURFACE_PROPERTY:
		g_value_set_pointer (value, avatar_widget_get_surface (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_avatar_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AvatarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_WIDGET, AvatarWidget);
	switch (property_id) {
		case AVATAR_WIDGET_MAKE_ROUND_PROPERTY:
		avatar_widget_set_make_round (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_VERIFIED_PROPERTY:
		avatar_widget_set_verified (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_OVERLAP_PROPERTY:
		avatar_widget_set_overlap (self, g_value_get_boolean (value));
		break;
		case AVATAR_WIDGET_SIZE_PROPERTY:
		avatar_widget_set_size (self, g_value_get_int (value));
		break;
		case AVATAR_WIDGET_SURFACE_PROPERTY:
		avatar_widget_set_surface (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



