#include "_gen/svc-misc.h"

static const DBusGObjectInfo _emp_svc_channel_interface_credentials_storage_object_info;

struct _EmpSvcChannelInterfaceCredentialsStorageClass {
    GTypeInterface parent_class;
    emp_svc_channel_interface_credentials_storage_store_credentials_impl store_credentials_cb;
};

static void emp_svc_channel_interface_credentials_storage_base_init (gpointer klass);

GType
emp_svc_channel_interface_credentials_storage_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (EmpSvcChannelInterfaceCredentialsStorageClass),
        emp_svc_channel_interface_credentials_storage_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "EmpSvcChannelInterfaceCredentialsStorage", &info, 0);
    }

  return type;
}

static void
emp_svc_channel_interface_credentials_storage_store_credentials (EmpSvcChannelInterfaceCredentialsStorage *self,
    gboolean in_Store,
    DBusGMethodInvocation *context)
{
  emp_svc_channel_interface_credentials_storage_store_credentials_impl impl = (EMP_SVC_CHANNEL_INTERFACE_CREDENTIALS_STORAGE_GET_CLASS (self)->store_credentials_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Store,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_channel_interface_credentials_storage_implement_store_credentials (EmpSvcChannelInterfaceCredentialsStorageClass *klass, emp_svc_channel_interface_credentials_storage_store_credentials_impl impl)
{
  klass->store_credentials_cb = impl;
}

static inline void
emp_svc_channel_interface_credentials_storage_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (emp_svc_channel_interface_credentials_storage_get_type (),
      &_emp_svc_channel_interface_credentials_storage_object_info);

}
static void
emp_svc_channel_interface_credentials_storage_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      emp_svc_channel_interface_credentials_storage_base_init_once (klass);
    }
}
static const DBusGMethodInfo _emp_svc_channel_interface_credentials_storage_methods[] = {
  { (GCallback) emp_svc_channel_interface_credentials_storage_store_credentials, g_cclosure_marshal_generic, 0 },
};

static const DBusGObjectInfo _emp_svc_channel_interface_credentials_storage_object_info = {
  0,
  _emp_svc_channel_interface_credentials_storage_methods,
  1,
"org.freedesktop.Telepathy.Channel.Interface.CredentialsStorage.DRAFT\0StoreCredentials\0A\0Store\0I\0b\0\0\0",
"\0\0",
"\0\0",
};

static const DBusGObjectInfo _emp_svc_logger_object_info;

struct _EmpSvcLoggerClass {
    GTypeInterface parent_class;
    emp_svc_logger_get_favourite_contacts_impl get_favourite_contacts_cb;
    emp_svc_logger_add_favourite_contact_impl add_favourite_contact_cb;
    emp_svc_logger_remove_favourite_contact_impl remove_favourite_contact_cb;
    emp_svc_logger_clear_impl clear_cb;
    emp_svc_logger_clear_account_impl clear_account_cb;
    emp_svc_logger_clear_entity_impl clear_entity_cb;
};

enum {
    SIGNAL_LOGGER_FavouriteContactsChanged,
    N_LOGGER_SIGNALS
};
static guint logger_signals[N_LOGGER_SIGNALS] = {0};

static void emp_svc_logger_base_init (gpointer klass);

GType
emp_svc_logger_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (EmpSvcLoggerClass),
        emp_svc_logger_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "EmpSvcLogger", &info, 0);
    }

  return type;
}

static void
emp_svc_logger_get_favourite_contacts (EmpSvcLogger *self,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_get_favourite_contacts_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->get_favourite_contacts_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_get_favourite_contacts (EmpSvcLoggerClass *klass, emp_svc_logger_get_favourite_contacts_impl impl)
{
  klass->get_favourite_contacts_cb = impl;
}

static void
emp_svc_logger_add_favourite_contact (EmpSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_add_favourite_contact_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->add_favourite_contact_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_add_favourite_contact (EmpSvcLoggerClass *klass, emp_svc_logger_add_favourite_contact_impl impl)
{
  klass->add_favourite_contact_cb = impl;
}

static void
emp_svc_logger_remove_favourite_contact (EmpSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_remove_favourite_contact_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->remove_favourite_contact_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_remove_favourite_contact (EmpSvcLoggerClass *klass, emp_svc_logger_remove_favourite_contact_impl impl)
{
  klass->remove_favourite_contact_cb = impl;
}

static void
emp_svc_logger_clear (EmpSvcLogger *self,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_clear_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->clear_cb);

  if (impl != NULL)
    {
      (impl) (self,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_clear (EmpSvcLoggerClass *klass, emp_svc_logger_clear_impl impl)
{
  klass->clear_cb = impl;
}

static void
emp_svc_logger_clear_account (EmpSvcLogger *self,
    const gchar *in_Account,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_clear_account_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->clear_account_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_clear_account (EmpSvcLoggerClass *klass, emp_svc_logger_clear_account_impl impl)
{
  klass->clear_account_cb = impl;
}

static void
emp_svc_logger_clear_entity (EmpSvcLogger *self,
    const gchar *in_Account,
    const gchar *in_Identifier,
    gint in_Type,
    DBusGMethodInvocation *context)
{
  emp_svc_logger_clear_entity_impl impl = (EMP_SVC_LOGGER_GET_CLASS (self)->clear_entity_cb);

  if (impl != NULL)
    {
      (impl) (self,
        in_Account,
        in_Identifier,
        in_Type,
        context);
    }
  else
    {
      tp_dbus_g_method_return_not_implemented (context);
    }
}

void
emp_svc_logger_implement_clear_entity (EmpSvcLoggerClass *klass, emp_svc_logger_clear_entity_impl impl)
{
  klass->clear_entity_cb = impl;
}

void
emp_svc_logger_emit_favourite_contacts_changed (gpointer instance,
    const gchar *arg_Account,
    const gchar **arg_Added,
    const gchar **arg_Removed)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, EMP_TYPE_SVC_LOGGER));
  g_signal_emit (instance,
      logger_signals[SIGNAL_LOGGER_FavouriteContactsChanged],
      0,
      arg_Account,
      arg_Added,
      arg_Removed);
}

static inline void
emp_svc_logger_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (emp_svc_logger_get_type (),
      &_emp_svc_logger_object_info);

  logger_signals[SIGNAL_LOGGER_FavouriteContactsChanged] =
  g_signal_new ("favourite-contacts-changed",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_generic,
      G_TYPE_NONE,
      3,
      DBUS_TYPE_G_OBJECT_PATH,
      G_TYPE_STRV,
      G_TYPE_STRV);

}
static void
emp_svc_logger_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      emp_svc_logger_base_init_once (klass);
    }
}
static const DBusGMethodInfo _emp_svc_logger_methods[] = {
  { (GCallback) emp_svc_logger_get_favourite_contacts, g_cclosure_marshal_generic, 0 },
  { (GCallback) emp_svc_logger_add_favourite_contact, g_cclosure_marshal_generic, 95 },
  { (GCallback) emp_svc_logger_remove_favourite_contact, g_cclosure_marshal_generic, 184 },
  { (GCallback) emp_svc_logger_clear, g_cclosure_marshal_generic, 276 },
  { (GCallback) emp_svc_logger_clear_account, g_cclosure_marshal_generic, 324 },
  { (GCallback) emp_svc_logger_clear_entity, g_cclosure_marshal_generic, 391 },
};

static const DBusGObjectInfo _emp_svc_logger_object_info = {
  0,
  _emp_svc_logger_methods,
  6,
"org.freedesktop.Telepathy.Logger.DRAFT\0GetFavouriteContacts\0A\0Favourite_Contacts\0O\0F\0N\0a(oas)\0\0org.freedesktop.Telepathy.Logger.DRAFT\0AddFavouriteContact\0A\0Account\0I\0o\0Identifier\0I\0s\0\0org.freedesktop.Telepathy.Logger.DRAFT\0RemoveFavouriteContact\0A\0Account\0I\0o\0Identifier\0I\0s\0\0org.freedesktop.Telepathy.Logger.DRAFT\0Clear\0A\0\0org.freedesktop.Telepathy.Logger.DRAFT\0ClearAccount\0A\0Account\0I\0o\0\0org.freedesktop.Telepathy.Logger.DRAFT\0ClearEntity\0A\0Account\0I\0o\0Identifier\0I\0s\0Type\0I\0i\0\0\0",
"org.freedesktop.Telepathy.Logger.DRAFT\0FavouriteContactsChanged\0\0",
"\0\0",
};


