; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --include-generated-funcs
; RUN: opt -S -passes=lower-ifunc < %s | FileCheck %s

define ptr @resolver() {
  ret ptr inttoptr (i64 333 to ptr)
}

@resolver_alias = alias ptr (), ptr @resolver
@ifunc_alias = alias ptr (), ptr @resolver_alias

@ifunc0_kept = ifunc float (i64), ptr @resolver_alias
@ifunc1_removed = ifunc float (i64), ptr @resolver_alias

@ifunc_def = ifunc float (i64), ptr @resolver
@alias_of_ifunc = alias float (i64), ptr @ifunc_def

define float @call_ifunc_aliasee(i64 %arg) {
  %call = call float @ifunc1_removed(i64 %arg)
  ret float %call
}

define float @call_alias_of_ifunc(i64 %arg) {
  %call = call float @alias_of_ifunc(i64 %arg)
  ret float %call
}
;.
; CHECK: @[[GLOB0:[0-9]+]] = internal global [3 x ptr] poison, align 8
; CHECK: @[[LLVM_GLOBAL_CTORS:[a-zA-Z0-9_$"\\.-]+]] = appending global [1 x { i32, ptr, ptr }] [{ i32, ptr, ptr } { i32 10, ptr @[[GLOB1:[0-9]+]], ptr null }]
; CHECK: @[[RESOLVER_ALIAS:[a-zA-Z0-9_$"\\.-]+]] = alias ptr (), ptr @resolver
; CHECK: @[[IFUNC_ALIAS:[a-zA-Z0-9_$"\\.-]+]] = alias ptr (), ptr @resolver_alias
; CHECK: @[[ALIAS_OF_IFUNC:[a-zA-Z0-9_$"\\.-]+]] = alias float (i64), ptr @ifunc_def
; CHECK: @[[IFUNC_DEF:[a-zA-Z0-9_$"\\.-]+]] = ifunc float (i64), ptr @resolver
;.
; CHECK-LABEL: define {{[^@]+}}@resolver(
; CHECK-NEXT:    ret ptr inttoptr (i64 333 to ptr)
;
;
; CHECK-LABEL: define {{[^@]+}}@call_ifunc_aliasee(
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr getelementptr inbounds ([3 x ptr], ptr @[[GLOB0]], i32 0, i32 1), align 8
; CHECK-NEXT:    [[CALL:%.*]] = call float [[TMP1]](i64 [[ARG:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
;
; CHECK-LABEL: define {{[^@]+}}@call_alias_of_ifunc(
; CHECK-NEXT:    [[CALL:%.*]] = call float @alias_of_ifunc(i64 [[ARG:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
;
; CHECK-LABEL: define {{[^@]+}}@1(
; CHECK-NEXT:    [[TMP1:%.*]] = call ptr @resolver()
; CHECK-NEXT:    store ptr [[TMP1]], ptr @[[GLOB0]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = call ptr @resolver()
; CHECK-NEXT:    store ptr [[TMP2]], ptr getelementptr inbounds ([3 x ptr], ptr @[[GLOB0]], i32 0, i32 1), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = call ptr @resolver()
; CHECK-NEXT:    store ptr [[TMP3]], ptr getelementptr inbounds ([3 x ptr], ptr @[[GLOB0]], i32 0, i32 2), align 8
; CHECK-NEXT:    ret void
;
