; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-linux-gnu -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

define i32 @extract_first_i32({i32, i32} %agg) {
; CHECK-LABEL: 'extract_first_i32'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, i32 } %agg, 0
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %r
;
  %r = extractvalue {i32, i32} %agg, 0
  ret i32 %r
}

define i32 @extract_second_i32({i32, i32} %agg) {
; CHECK-LABEL: 'extract_second_i32'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, i32 } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %r
;
  %r = extractvalue {i32, i32} %agg, 1
  ret i32 %r
}

define i32 @extract_i32({i32, i1} %agg) {
; CHECK-LABEL: 'extract_i32'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, i1 } %agg, 0
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %r
;
  %r = extractvalue {i32, i1} %agg, 0
  ret i32 %r
}

define i1 @extract_i1({i32, i1} %agg) {
; CHECK-LABEL: 'extract_i1'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, i1 } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i1 %r
;
  %r = extractvalue {i32, i1} %agg, 1
  ret i1 %r
}

define float @extract_float({i32, float} %agg) {
; CHECK-LABEL: 'extract_float'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, float } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret float %r
;
  %r = extractvalue {i32, float} %agg, 1
  ret float %r
}

define [42 x i42] @extract_array({i32, [42 x i42]} %agg) {
; CHECK-LABEL: 'extract_array'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, [42 x i42] } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret [42 x i42] %r
;
  %r = extractvalue {i32, [42 x i42]} %agg, 1
  ret [42 x i42] %r
}

define <42 x i42> @extract_vector({i32, <42 x i42>} %agg) {
; CHECK-LABEL: 'extract_vector'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, <42 x i42> } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <42 x i42> %r
;
  %r = extractvalue {i32, <42 x i42>} %agg, 1
  ret <42 x i42> %r
}

%T1 = type { i32, float, <4 x i1> }

define %T1 @extract_struct({i32, %T1} %agg) {
; CHECK-LABEL: 'extract_struct'
; CHECK-NEXT:  Cost Model: Found costs of 0 for: %r = extractvalue { i32, %T1 } %agg, 1
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret %T1 %r
;
  %r = extractvalue {i32, %T1} %agg, 1
  ret %T1 %r
}
