; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

target datalayout = "S16-p:16:16-i1:16-i8:8-i32:16-i64:16-i128:16"

define void @safe_deps_1_due_to_dependence_distance(i16  %n, ptr %p) {
; CHECK-LABEL: 'safe_deps_1_due_to_dependence_distance'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  %cmp42 = icmp sgt i16 %n, 0
  br i1 %cmp42, label %ph, label %exit

ph:
  %gep.off = getelementptr i32, ptr %p, i16 %n
  br label %loop

loop:
  %iv = phi i16 [ 0, %ph ], [ %iv.next, %loop ]
  %gep.iv = getelementptr inbounds i32, ptr %p, i16 %iv
  store i32 0, ptr %gep.iv, align 1
  %gep.off.iv = getelementptr i32, ptr %gep.off, i16 %iv
  store i32 1, ptr %gep.off.iv, align 1
  %iv.next = add i16 %iv, 1
  %exitcond.not = icmp eq i16 %iv.next, %n
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}

define void @safe_deps_2_due_to_dependence_distance(i16 %n, ptr %p3, i16 noundef %q, ptr %p1, ptr %p2) {
; CHECK-LABEL: 'safe_deps_2_due_to_dependence_distance'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  %0 = shl i16 %n, 1
  %alloca = alloca [2 x i32], i16 %0
  %arrayidx1 = getelementptr inbounds i32, ptr %p1, i16 %q
  %arrayidx2 = getelementptr inbounds i8, ptr %p3, i16 2
  %arrayidx4 = getelementptr inbounds i32, ptr %p2, i16 %q
  %cmp42 = icmp sgt i16 %n, 0
  br i1 %cmp42, label %ph, label %exit

ph:
  %arrayidx40 = getelementptr inbounds [2 x i32], ptr %alloca, i16 %n
  br label %loop

loop:
  %iv = phi i16 [ 0, %ph ], [ %iv.next, %loop ]
  %arrayidx6 = getelementptr inbounds i32, ptr %arrayidx1, i16 %iv
  %arrayidx11 = getelementptr inbounds i32, ptr %arrayidx4, i16 %iv
  %arrayidx22 = getelementptr inbounds [2 x i32], ptr %alloca, i16 %iv
  store i32 10, ptr %arrayidx22
  %arrayidx33 = getelementptr inbounds i8, ptr %arrayidx22, i16 4
  store i32 16, ptr %arrayidx33
  %arrayidx42 = getelementptr inbounds [2 x i32], ptr %arrayidx40, i16 %iv
  store i32 19, ptr %arrayidx42
  %arrayidx53 = getelementptr inbounds i8, ptr %arrayidx42, i16 4
  store i32 23, ptr %arrayidx53
  %iv.next = add nuw nsw i16 %iv, 1
  %exitcond.not = icmp eq i16 %iv.next, %n
  br i1 %exitcond.not, label %exit, label %loop

exit:
  ret void
}
