; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+avx512f,+avx512vl,+avx512dq %s -o - | FileCheck %s

define <8 x float> @test_2xfloat_to_8xfloat(<8 x float> %vec) {
; CHECK-LABEL: test_2xfloat_to_8xfloat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %ymm0
; CHECK-NEXT:    retq
  %res = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mask0(<8 x float> %vec, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %ymm3, %ymm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm1 {%k1} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mask0(<8 x float> %vec, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mask1(<8 x float> %vec, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %ymm3, %ymm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm1 {%k1} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mask1(<8 x float> %vec, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mask2(<8 x float> %vec, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %ymm3, %ymm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm1 {%k1} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mask2(<8 x float> %vec, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mask3(<8 x float> %vec, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %ymm3, %ymm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm1 {%k1} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %ymm1, %ymm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mask3(<8 x float> %vec, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <16 x float> @test_2xfloat_to_16xfloat(<16 x float> %vec) {
; CHECK-LABEL: test_2xfloat_to_16xfloat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd %xmm0, %zmm0
; CHECK-NEXT:    retq
  %res = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mask0(<16 x float> %vec, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %zmm3, %zmm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm1 {%k1} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mask0(<16 x float> %vec, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mask1(<16 x float> %vec, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %zmm3, %zmm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm1 {%k1} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mask1(<16 x float> %vec, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mask2(<16 x float> %vec, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %zmm3, %zmm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm1 {%k1} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mask2(<16 x float> %vec, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mask3(<16 x float> %vec, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm3, %xmm3, %xmm3
; CHECK-NEXT:    vcmpeqps %zmm3, %zmm2, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm1 {%k1} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    vmovapd %zmm1, %zmm0
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mask3(<16 x float> %vec, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = xmm0[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %shuf = shufflevector <16 x float> %vec, <16 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <4 x double> @test_2xdouble_to_4xdouble_mem(ptr %vp) {
; CHECK-LABEL: test_2xdouble_to_4xdouble_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %res = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  ret <4 x double> %res
}
define <4 x double> @test_masked_2xdouble_to_4xdouble_mem_mask0(ptr %vp, <4 x double> %default, <4 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_4xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> %default
  ret <4 x double> %res
}

define <4 x double> @test_masked_z_2xdouble_to_4xdouble_mem_mask0(ptr %vp, <4 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_4xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> zeroinitializer
  ret <4 x double> %res
}
define <4 x double> @test_masked_2xdouble_to_4xdouble_mem_mask1(ptr %vp, <4 x double> %default, <4 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_4xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> %default
  ret <4 x double> %res
}

define <4 x double> @test_masked_z_2xdouble_to_4xdouble_mem_mask1(ptr %vp, <4 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_4xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> zeroinitializer
  ret <4 x double> %res
}
define <4 x double> @test_masked_2xdouble_to_4xdouble_mem_mask2(ptr %vp, <4 x double> %default, <4 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_4xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> %default
  ret <4 x double> %res
}

define <4 x double> @test_masked_z_2xdouble_to_4xdouble_mem_mask2(ptr %vp, <4 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_4xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> zeroinitializer
  ret <4 x double> %res
}
define <4 x double> @test_masked_2xdouble_to_4xdouble_mem_mask3(ptr %vp, <4 x double> %default, <4 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_4xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> %default
  ret <4 x double> %res
}

define <4 x double> @test_masked_z_2xdouble_to_4xdouble_mem_mask3(ptr %vp, <4 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_4xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <4 x i32> <i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <4 x double> %mask, zeroinitializer
  %res = select <4 x i1> %cmp, <4 x double> %shuf, <4 x double> zeroinitializer
  ret <4 x double> %res
}
define <8 x double> @test_2xdouble_to_8xdouble_mem(ptr %vp) {
; CHECK-LABEL: test_2xdouble_to_8xdouble_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %res = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  ret <8 x double> %res
}
define <8 x double> @test_masked_2xdouble_to_8xdouble_mem_mask0(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_8xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_2xdouble_to_8xdouble_mem_mask0(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_8xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_2xdouble_to_8xdouble_mem_mask1(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_8xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_2xdouble_to_8xdouble_mem_mask1(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_8xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_2xdouble_to_8xdouble_mem_mask2(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_8xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_2xdouble_to_8xdouble_mem_mask2(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_8xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_2xdouble_to_8xdouble_mem_mask3(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_2xdouble_to_8xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_2xdouble_to_8xdouble_mem_mask3(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_2xdouble_to_8xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x double>, ptr %vp
  %shuf = shufflevector <2 x double> %vec, <2 x double> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_4xdouble_to_8xdouble_mem(ptr %vp) {
; CHECK-LABEL: test_4xdouble_to_8xdouble_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %res = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <8 x double> %res
}
define <8 x double> @test_masked_4xdouble_to_8xdouble_mem_mask0(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_4xdouble_to_8xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_4xdouble_to_8xdouble_mem_mask0(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_4xdouble_to_8xdouble_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_4xdouble_to_8xdouble_mem_mask1(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_4xdouble_to_8xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_4xdouble_to_8xdouble_mem_mask1(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_4xdouble_to_8xdouble_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_4xdouble_to_8xdouble_mem_mask2(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_4xdouble_to_8xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_4xdouble_to_8xdouble_mem_mask2(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_4xdouble_to_8xdouble_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x double> @test_masked_4xdouble_to_8xdouble_mem_mask3(ptr %vp, <8 x double> %default, <8 x double> %mask) {
; CHECK-LABEL: test_masked_4xdouble_to_8xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqpd %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> %default
  ret <8 x double> %res
}

define <8 x double> @test_masked_z_4xdouble_to_8xdouble_mem_mask3(ptr %vp, <8 x double> %mask) {
; CHECK-LABEL: test_masked_z_4xdouble_to_8xdouble_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorpd %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqpd %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x double>, ptr %vp
  %shuf = shufflevector <4 x double> %vec, <4 x double> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x double> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x double> %shuf, <8 x double> zeroinitializer
  ret <8 x double> %res
}
define <8 x float> @test_2xfloat_to_8xfloat_mem(ptr %vp) {
; CHECK-LABEL: test_2xfloat_to_8xfloat_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd (%rdi), %ymm0
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %res = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mem_mask0(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mem_mask0(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mem_mask1(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mem_mask1(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mem_mask2(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mem_mask2(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_2xfloat_to_8xfloat_mem_mask3(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_8xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_2xfloat_to_8xfloat_mem_mask3(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_8xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <8 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <16 x float> @test_2xfloat_to_16xfloat_mem(ptr %vp) {
; CHECK-LABEL: test_2xfloat_to_16xfloat_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastsd (%rdi), %zmm0
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %res = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_2xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_2xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_2xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_2xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x2 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <2 x float>, ptr %vp
  %shuf = shufflevector <2 x float> %vec, <2 x float> undef, <16 x i32> <i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1, i32 0, i32 1>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <8 x float> @test_4xfloat_to_8xfloat_mem(ptr %vp) {
; CHECK-LABEL: test_4xfloat_to_8xfloat_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf128 {{.*#+}} ymm0 = mem[0,1,0,1]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %res = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <8 x float> %res
}
define <8 x float> @test_masked_4xfloat_to_8xfloat_mem_mask0(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_8xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_4xfloat_to_8xfloat_mem_mask0(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_8xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_4xfloat_to_8xfloat_mem_mask1(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_8xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_4xfloat_to_8xfloat_mem_mask1(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_8xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_4xfloat_to_8xfloat_mem_mask2(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_8xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_4xfloat_to_8xfloat_mem_mask2(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_8xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <8 x float> @test_masked_4xfloat_to_8xfloat_mem_mask3(ptr %vp, <8 x float> %default, <8 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_8xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %ymm2, %ymm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> %default
  ret <8 x float> %res
}

define <8 x float> @test_masked_z_4xfloat_to_8xfloat_mem_mask3(ptr %vp, <8 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_8xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %ymm1, %ymm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} ymm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <8 x float> %mask, zeroinitializer
  %res = select <8 x i1> %cmp, <8 x float> %shuf, <8 x float> zeroinitializer
  ret <8 x float> %res
}
define <16 x float> @test_4xfloat_to_16xfloat_mem(ptr %vp) {
; CHECK-LABEL: test_4xfloat_to_16xfloat_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %res = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  ret <16 x float> %res
}
define <16 x float> @test_masked_4xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_4xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_4xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_4xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_4xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_4xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_4xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_4xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_4xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_4xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x4 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,0,1,2,3,0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <4 x float>, ptr %vp
  %shuf = shufflevector <4 x float> %vec, <4 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3, i32 0, i32 1, i32 2, i32 3>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_8xfloat_to_16xfloat_mem(ptr %vp) {
; CHECK-LABEL: test_8xfloat_to_16xfloat_mem:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vbroadcastf64x4 {{.*#+}} zmm0 = mem[0,1,2,3,0,1,2,3]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %res = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <16 x float> %res
}
define <16 x float> @test_masked_8xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_8xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_8xfloat_to_16xfloat_mem_mask0(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_8xfloat_to_16xfloat_mem_mask0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_8xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_8xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_8xfloat_to_16xfloat_mem_mask1(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_8xfloat_to_16xfloat_mem_mask1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_8xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_8xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_8xfloat_to_16xfloat_mem_mask2(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_8xfloat_to_16xfloat_mem_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
define <16 x float> @test_masked_8xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %default, <16 x float> %mask) {
; CHECK-LABEL: test_masked_8xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; CHECK-NEXT:    vcmpeqps %zmm2, %zmm1, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> %default
  ret <16 x float> %res
}

define <16 x float> @test_masked_z_8xfloat_to_16xfloat_mem_mask3(ptr %vp, <16 x float> %mask) {
; CHECK-LABEL: test_masked_z_8xfloat_to_16xfloat_mem_mask3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; CHECK-NEXT:    vcmpeqps %zmm1, %zmm0, %k1
; CHECK-NEXT:    vbroadcastf32x8 {{.*#+}} zmm0 {%k1} {z} = mem[0,1,2,3,4,5,6,7,0,1,2,3,4,5,6,7]
; CHECK-NEXT:    retq
  %vec = load <8 x float>, ptr %vp
  %shuf = shufflevector <8 x float> %vec, <8 x float> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %cmp = fcmp oeq <16 x float> %mask, zeroinitializer
  %res = select <16 x i1> %cmp, <16 x float> %shuf, <16 x float> zeroinitializer
  ret <16 x float> %res
}
