; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=aarch64-linux-gnu < %s | FileCheck %s

define float @f(float nofpclass(nan) %a, float nofpclass(nan) %b) {
; CHECK-LABEL: f:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s0, s0, s1
; CHECK-NEXT:    ret
entry:
  %cond = tail call float @llvm.maximumnum.f32(float %a, float %b)
  ret float %cond
}

define <4 x float> @fv4f32(<4 x float> nofpclass(nan) %a, <4 x float> nofpclass(nan) %b) {
; CHECK-LABEL: fv4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.maximumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define {float, float} @m({float, float} nofpclass(nan) %a0, {float, float} nofpclass(nan) %a1) {
; CHECK-LABEL: m:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue {float, float} %a0, 0
  %a0f1 = extractvalue {float, float} %a0, 1
  %a1f0 = extractvalue {float, float} %a1, 0
  %a1f1 = extractvalue {float, float} %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue {float, float} poison, float %max0, 0
  %ret1 = insertvalue {float, float} %ret0, float %max1, 1
  ret {float, float} %ret1
}

define [2 x float] @mA([2 x float] nofpclass(nan) %a0, [2 x float] nofpclass(nan) %a1) {
; CHECK-LABEL: mA:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue [2 x float] %a0, 0
  %a0f1 = extractvalue [2 x float] %a0, 1
  %a1f0 = extractvalue [2 x float] %a1, 0
  %a1f1 = extractvalue [2 x float] %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue [2 x float] poison, float %max0, 0
  %ret1 = insertvalue [2 x float] %ret0, float %max1, 1
  ret [2 x float] %ret1
}

define float @fS(float nofpclass(snan) %a, float nofpclass(snan) %b) {
; CHECK-LABEL: fS:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s0, s0, s1
; CHECK-NEXT:    ret
entry:
  %cond = tail call float @llvm.maximumnum.f32(float %a, float %b)
  ret float %cond
}

define <4 x float> @fSv4f32(<4 x float> nofpclass(snan) %a, <4 x float> nofpclass(snan) %b) {
; CHECK-LABEL: fSv4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.maximumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define {float, float} @mS({float, float} nofpclass(snan) %a0, {float, float} nofpclass(snan) %a1) {
; CHECK-LABEL: mS:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue {float, float} %a0, 0
  %a0f1 = extractvalue {float, float} %a0, 1
  %a1f0 = extractvalue {float, float} %a1, 0
  %a1f1 = extractvalue {float, float} %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue {float, float} poison, float %max0, 0
  %ret1 = insertvalue {float, float} %ret0, float %max1, 1
  ret {float, float} %ret1
}

define [2 x float] @mAS([2 x float] nofpclass(snan) %a0, [2 x float] nofpclass(snan) %a1) {
; CHECK-LABEL: mAS:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue [2 x float] %a0, 0
  %a0f1 = extractvalue [2 x float] %a0, 1
  %a1f0 = extractvalue [2 x float] %a1, 0
  %a1f1 = extractvalue [2 x float] %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue [2 x float] poison, float %max0, 0
  %ret1 = insertvalue [2 x float] %ret0, float %max1, 1
  ret [2 x float] %ret1
}

define float @fQ(float nofpclass(qnan) %a, float nofpclass(qnan) %b) {
; CHECK-LABEL: fQ:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fminnm s1, s1, s1
; CHECK-NEXT:    fminnm s0, s0, s0
; CHECK-NEXT:    fmaxnm s0, s0, s1
; CHECK-NEXT:    ret
entry:
  %cond = tail call float @llvm.maximumnum.f32(float %a, float %b)
  ret float %cond
}

define <4 x float> @fQv4f32(<4 x float> nofpclass(qnan) %a, <4 x float> nofpclass(qnan) %b) {
; CHECK-LABEL: fQv4f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fminnm v1.4s, v1.4s, v1.4s
; CHECK-NEXT:    fminnm v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    fmaxnm v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ret
entry:
  %c = call <4 x float> @llvm.maximumnum.v4f32(<4 x float> %a, <4 x float> %b)
  ret <4 x float> %c
}

define {float, float} @mQ({float, float} nofpclass(qnan) %a0, {float, float} nofpclass(qnan) %a1) {
; CHECK-LABEL: mQ:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fminnm s2, s2, s2
; CHECK-NEXT:    fminnm s0, s0, s0
; CHECK-NEXT:    fminnm s3, s3, s3
; CHECK-NEXT:    fminnm s1, s1, s1
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue {float, float} %a0, 0
  %a0f1 = extractvalue {float, float} %a0, 1
  %a1f0 = extractvalue {float, float} %a1, 0
  %a1f1 = extractvalue {float, float} %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue {float, float} poison, float %max0, 0
  %ret1 = insertvalue {float, float} %ret0, float %max1, 1
  ret {float, float} %ret1
}

define [2 x float] @mAQ([2 x float] nofpclass(qnan) %a0, [2 x float] nofpclass(qnan) %a1) {
; CHECK-LABEL: mAQ:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fminnm s2, s2, s2
; CHECK-NEXT:    fminnm s0, s0, s0
; CHECK-NEXT:    fminnm s3, s3, s3
; CHECK-NEXT:    fminnm s1, s1, s1
; CHECK-NEXT:    fmaxnm s0, s0, s2
; CHECK-NEXT:    fmaxnm s1, s1, s3
; CHECK-NEXT:    ret
entry:
  %a0f0 = extractvalue [2 x float] %a0, 0
  %a0f1 = extractvalue [2 x float] %a0, 1
  %a1f0 = extractvalue [2 x float] %a1, 0
  %a1f1 = extractvalue [2 x float] %a1, 1
  %max0 = tail call float @llvm.maximumnum.f32(float %a0f0, float %a1f0)
  %max1 = tail call float @llvm.maximumnum.f32(float %a0f1, float %a1f1)
  %ret0 = insertvalue [2 x float] poison, float %max0, 0
  %ret1 = insertvalue [2 x float] %ret0, float %max1, 1
  ret [2 x float] %ret1
}
