# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca --timeline -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr4-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR4_64
# RUN: llvm-mca --timeline -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr4-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR4_32
# RUN: llvm-mca --timeline -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr5-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR5_64
# RUN: llvm-mca --timeline -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr5-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,SCR5_32

fadd.s ft0, ft0, ft0
fadd.d ft1, ft1, ft1
fmul.s ft2, ft2, ft2
fmul.d ft3, ft3, ft3
fmadd.s ft4, ft4, ft4, ft4
fmadd.d ft5, ft5, ft5, ft5
fdiv.s ft6, ft6, ft6
fdiv.d ft7, ft7, ft7
fadd.s ft0, ft0, ft0
fadd.d ft1, ft1, ft1
fmul.s ft2, ft2, ft2
fmul.d ft3, ft3, ft3
fmadd.s ft4, ft4, ft4, ft4
fmadd.d ft5, ft5, ft5, ft5
fdiv.s ft6, ft6, ft6
fdiv.d ft7, ft7, ft7

# CHECK:        Iterations:        1
# CHECK-NEXT:   Instructions:      16
# CHECK-NEXT:   Total Cycles:      60
# CHECK-NEXT:   Total uOps:        16

# CHECK:        Dispatch Width:    1
# CHECK-NEXT:   uOps Per Cycle:    0.27
# CHECK-NEXT:   IPC:               0.27
# CHECK-NEXT:   Block RThroughput: 46.0

# CHECK:        Instruction Info:
# CHECK-NEXT:   [1]: #uOps
# CHECK-NEXT:   [2]: Latency
# CHECK-NEXT:   [3]: RThroughput
# CHECK-NEXT:   [4]: MayLoad
# CHECK-NEXT:   [5]: MayStore
# CHECK-NEXT:   [6]: HasSideEffects (U)

# CHECK:        [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:    1      3     1.00                        fadd.s	ft0, ft0, ft0
# CHECK-NEXT:    1      3     1.00                        fadd.d	ft1, ft1, ft1
# CHECK-NEXT:    1      4     1.00                        fmul.s	ft2, ft2, ft2
# CHECK-NEXT:    1      4     1.00                        fmul.d	ft3, ft3, ft3
# CHECK-NEXT:    1      4     1.00                        fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:    1      4     1.00                        fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:    1      10    8.00                        fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:    1      17    15.00                       fdiv.d	ft7, ft7, ft7
# CHECK-NEXT:    1      3     1.00                        fadd.s	ft0, ft0, ft0
# CHECK-NEXT:    1      3     1.00                        fadd.d	ft1, ft1, ft1
# CHECK-NEXT:    1      4     1.00                        fmul.s	ft2, ft2, ft2
# CHECK-NEXT:    1      4     1.00                        fmul.d	ft3, ft3, ft3
# CHECK-NEXT:    1      4     1.00                        fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:    1      4     1.00                        fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:    1      10    8.00                        fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:    1      17    15.00                       fdiv.d	ft7, ft7, ft7

# CHECK:        Resources:

# SCR4_32-NEXT: [0]   - SCR4RV32_ALU
# SCR4_32-NEXT: [1]   - SCR4RV32_CFU
# SCR4_32-NEXT: [2]   - SCR4RV32_DIV
# SCR4_32-NEXT: [3]   - SCR4RV32_FDU
# SCR4_32-NEXT: [4]   - SCR4RV32_FPU
# SCR4_32-NEXT: [5]   - SCR4RV32_LSU
# SCR4_32-NEXT: [6]   - SCR4RV32_MUL

# SCR4_64-NEXT: [0]   - SCR4RV64_ALU
# SCR4_64-NEXT: [1]   - SCR4RV64_CFU
# SCR4_64-NEXT: [2]   - SCR4RV64_DIV
# SCR4_64-NEXT: [3]   - SCR4RV64_FDU
# SCR4_64-NEXT: [4]   - SCR4RV64_FPU
# SCR4_64-NEXT: [5]   - SCR4RV64_LSU
# SCR4_64-NEXT: [6]   - SCR4RV64_MUL

# SCR5_32-NEXT: [0]   - SCR5RV32_ALU
# SCR5_32-NEXT: [1]   - SCR5RV32_CFU
# SCR5_32-NEXT: [2]   - SCR5RV32_DIV
# SCR5_32-NEXT: [3]   - SCR5RV32_FDU
# SCR5_32-NEXT: [4]   - SCR5RV32_FPU
# SCR5_32-NEXT: [5]   - SCR5RV32_LSU
# SCR5_32-NEXT: [6]   - SCR5RV32_MUL

# SCR5_64-NEXT: [0]   - SCR5RV64_ALU
# SCR5_64-NEXT: [1]   - SCR5RV64_CFU
# SCR5_64-NEXT: [2]   - SCR5RV64_DIV
# SCR5_64-NEXT: [3]   - SCR5RV64_FDU
# SCR5_64-NEXT: [4]   - SCR5RV64_FPU
# SCR5_64-NEXT: [5]   - SCR5RV64_LSU
# SCR5_64-NEXT: [6]   - SCR5RV64_MUL

# CHECK:        Resource pressure per iteration:
# CHECK-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]
# CHECK-NEXT:    -      -      -     46.00  12.00   -      -

# CHECK:        Resource pressure by instruction:
# CHECK-NEXT:   [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fadd.s	ft0, ft0, ft0
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fadd.d	ft1, ft1, ft1
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmul.s	ft2, ft2, ft2
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmul.d	ft3, ft3, ft3
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:    -      -      -     8.00    -      -      -     fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:    -      -      -     15.00   -      -      -     fdiv.d	ft7, ft7, ft7
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fadd.s	ft0, ft0, ft0
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fadd.d	ft1, ft1, ft1
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmul.s	ft2, ft2, ft2
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmul.d	ft3, ft3, ft3
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:    -      -      -      -     1.00    -      -     fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:    -      -      -     8.00    -      -      -     fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:    -      -      -     15.00   -      -      -     fdiv.d	ft7, ft7, ft7

# CHECK:        Timeline view:
# CHECK-NEXT:                       0123456789          0123456789          0123456789
# CHECK-NEXT:   Index     0123456789          0123456789          0123456789

# CHECK:        [0,0]     DeeE .    .    .    .    .    .    .    .    .    .    .   .   fadd.s	ft0, ft0, ft0
# CHECK-NEXT:   [0,1]     .DeeE.    .    .    .    .    .    .    .    .    .    .   .   fadd.d	ft1, ft1, ft1
# CHECK-NEXT:   [0,2]     . DeeeE   .    .    .    .    .    .    .    .    .    .   .   fmul.s	ft2, ft2, ft2
# CHECK-NEXT:   [0,3]     .  DeeeE  .    .    .    .    .    .    .    .    .    .   .   fmul.d	ft3, ft3, ft3
# CHECK-NEXT:   [0,4]     .   DeeeE .    .    .    .    .    .    .    .    .    .   .   fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:   [0,5]     .    DeeeE.    .    .    .    .    .    .    .    .    .   .   fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:   [0,6]     .    .DeeeeeeeeeE   .    .    .    .    .    .    .    .   .   fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:   [0,7]     .    .    .   DeeeeeeeeeeeeeeeeE   .    .    .    .    .   .   fdiv.d	ft7, ft7, ft7
# CHECK-NEXT:   [0,8]     .    .    .    .    .    .  DeeE   .    .    .    .    .   .   fadd.s	ft0, ft0, ft0
# CHECK-NEXT:   [0,9]     .    .    .    .    .    .   DeeE  .    .    .    .    .   .   fadd.d	ft1, ft1, ft1
# CHECK-NEXT:   [0,10]    .    .    .    .    .    .    DeeeE.    .    .    .    .   .   fmul.s	ft2, ft2, ft2
# CHECK-NEXT:   [0,11]    .    .    .    .    .    .    .DeeeE    .    .    .    .   .   fmul.d	ft3, ft3, ft3
# CHECK-NEXT:   [0,12]    .    .    .    .    .    .    . DeeeE   .    .    .    .   .   fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:   [0,13]    .    .    .    .    .    .    .  DeeeE  .    .    .    .   .   fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:   [0,14]    .    .    .    .    .    .    .   DeeeeeeeeeE.    .    .   .   fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:   [0,15]    .    .    .    .    .    .    .    .    . DeeeeeeeeeeeeeeeeE   fdiv.d	ft7, ft7, ft7

# CHECK:        Average Wait times (based on the timeline view):
# CHECK-NEXT:   [0]: Executions
# CHECK-NEXT:   [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT:   [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT:   [3]: Average time elapsed from WB until retire stage

# CHECK:              [0]    [1]    [2]    [3]
# CHECK-NEXT:   0.     1     0.0    0.0    0.0       fadd.s	ft0, ft0, ft0
# CHECK-NEXT:   1.     1     0.0    0.0    0.0       fadd.d	ft1, ft1, ft1
# CHECK-NEXT:   2.     1     0.0    0.0    0.0       fmul.s	ft2, ft2, ft2
# CHECK-NEXT:   3.     1     0.0    0.0    0.0       fmul.d	ft3, ft3, ft3
# CHECK-NEXT:   4.     1     0.0    0.0    0.0       fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:   5.     1     0.0    0.0    0.0       fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:   6.     1     0.0    0.0    0.0       fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:   7.     1     0.0    0.0    0.0       fdiv.d	ft7, ft7, ft7
# CHECK-NEXT:   8.     1     0.0    0.0    0.0       fadd.s	ft0, ft0, ft0
# CHECK-NEXT:   9.     1     0.0    0.0    0.0       fadd.d	ft1, ft1, ft1
# CHECK-NEXT:   10.    1     0.0    0.0    0.0       fmul.s	ft2, ft2, ft2
# CHECK-NEXT:   11.    1     0.0    0.0    0.0       fmul.d	ft3, ft3, ft3
# CHECK-NEXT:   12.    1     0.0    0.0    0.0       fmadd.s	ft4, ft4, ft4, ft4
# CHECK-NEXT:   13.    1     0.0    0.0    0.0       fmadd.d	ft5, ft5, ft5, ft5
# CHECK-NEXT:   14.    1     0.0    0.0    0.0       fdiv.s	ft6, ft6, ft6
# CHECK-NEXT:   15.    1     0.0    0.0    0.0       fdiv.d	ft7, ft7, ft7
# CHECK-NEXT:          1     0.0    0.0    0.0       <total>
