; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -nvptx-prec-divf32=0 -nvptx-prec-sqrtf32=0 \
; RUN:   | FileCheck %s
; RUN: %if ptxas %{                                                                   \
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_20 -nvptx-prec-divf32=0 -nvptx-prec-sqrtf32=0 \
; RUN:   | %ptxas-verify                                                              \
; RUN: %}

target datalayout = "e-p:32:32:32-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v16:16:16-v32:32:32-v64:64:64-v128:128:128-n16:32:64"

declare float @llvm.sqrt.f32(float)
declare double @llvm.sqrt.f64(double)

; -- reciprocal sqrt --

define float @test_rsqrt32(float %a) #0 {
; CHECK-LABEL: test_rsqrt32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_rsqrt32_param_0];
; CHECK-NEXT:    rsqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %val = tail call float @llvm.sqrt.f32(float %a)
  %ret = fdiv float 1.0, %val
  ret float %ret
}

define float @test_rsqrt_ftz(float %a) #0 #1 {
; CHECK-LABEL: test_rsqrt_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_rsqrt_ftz_param_0];
; CHECK-NEXT:    rsqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %val = tail call float @llvm.sqrt.f32(float %a)
  %ret = fdiv float 1.0, %val
  ret float %ret
}

define double @test_rsqrt64(double %a) {
; CHECK-LABEL: test_rsqrt64(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_rsqrt64_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = tail call double @llvm.sqrt.f64(double %a)
  %ret = fdiv arcp double 1.0, %val
  ret double %ret
}

; There's no rsqrt.approx.ftz.f64 instruction; we just use the non-ftz version.
define double @test_rsqrt64_ftz(double %a) #1 {
; CHECK-LABEL: test_rsqrt64_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_rsqrt64_ftz_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %val = tail call double @llvm.sqrt.f64(double %a)
  %ret = fdiv arcp double 1.0, %val
  ret double %ret
}

; -- sqrt --

define float @test_sqrt32(float %a) #0 {
; CHECK-LABEL: test_sqrt32(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_param_0];
; CHECK-NEXT:    sqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %ret = tail call float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define float @test_sqrt32_ninf(float %a) #0 {
; CHECK-LABEL: test_sqrt32_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_ninf_param_0];
; CHECK-NEXT:    sqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    abs.f32 %r3, %r1;
; CHECK-NEXT:    setp.lt.f32 %p1, %r3, 0f00800000;
; CHECK-NEXT:    selp.f32 %r4, 0f00000000, %r2, %p1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define float @test_sqrt_ftz(float %a) #0 #1 {
; CHECK-LABEL: test_sqrt_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt_ftz_param_0];
; CHECK-NEXT:    sqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %ret = tail call float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define float @test_sqrt_ftz_ninf(float %a) #0 #1 {
; CHECK-LABEL: test_sqrt_ftz_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt_ftz_ninf_param_0];
; CHECK-NEXT:    setp.eq.ftz.f32 %p1, %r1, 0f00000000;
; CHECK-NEXT:    sqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    selp.f32 %r3, 0f00000000, %r2, %p1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define double @test_sqrt64(double %a) #0 {
; CHECK-LABEL: test_sqrt64(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_param_0];
; CHECK-NEXT:    sqrt.rn.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %ret = tail call double @llvm.sqrt.f64(double %a)
  ret double %ret
}

; There's no sqrt.approx.f64 instruction; we emit
; reciprocal(rsqrt.approx.f64(x)).  There's no non-ftz approximate reciprocal,
; so we just use the ftz version.
define double @test_sqrt64_ninf(double %a) #0 {
; CHECK-LABEL: test_sqrt64_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b64 %rd<6>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_ninf_param_0];
; CHECK-NEXT:    abs.f64 %rd2, %rd1;
; CHECK-NEXT:    setp.lt.f64 %p1, %rd2, 0d0010000000000000;
; CHECK-NEXT:    rsqrt.approx.f64 %rd3, %rd1;
; CHECK-NEXT:    rcp.approx.ftz.f64 %rd4, %rd3;
; CHECK-NEXT:    selp.f64 %rd5, 0d0000000000000000, %rd4, %p1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd5;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn double @llvm.sqrt.f64(double %a)
  ret double %ret
}

define double @test_sqrt64_ftz(double %a) #0 #1 {
; CHECK-LABEL: test_sqrt64_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_ftz_param_0];
; CHECK-NEXT:    sqrt.rn.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %ret = tail call double @llvm.sqrt.f64(double %a)
  ret double %ret
}

; There's no sqrt.approx.ftz.f64 instruction; we just use the non-ftz version.
define double @test_sqrt64_ftz_ninf(double %a) #0 #1 {
; CHECK-LABEL: test_sqrt64_ftz_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b64 %rd<6>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_ftz_ninf_param_0];
; CHECK-NEXT:    abs.f64 %rd2, %rd1;
; CHECK-NEXT:    setp.lt.f64 %p1, %rd2, 0d0010000000000000;
; CHECK-NEXT:    rsqrt.approx.f64 %rd3, %rd1;
; CHECK-NEXT:    rcp.approx.ftz.f64 %rd4, %rd3;
; CHECK-NEXT:    selp.f64 %rd5, 0d0000000000000000, %rd4, %p1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd5;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn double @llvm.sqrt.f64(double %a)
  ret double %ret
}

; -- refined sqrt and rsqrt --
;
; The sqrt and rsqrt refinement algorithms both emit an rsqrt.approx, followed
; by some math.

define float @test_rsqrt32_refined(float %a) #0 #2 {
; CHECK-LABEL: test_rsqrt32_refined(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_rsqrt32_refined_param_0];
; CHECK-NEXT:    rsqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    mul.f32 %r3, %r1, %r2;
; CHECK-NEXT:    fma.rn.f32 %r4, %r3, %r2, 0fC0400000;
; CHECK-NEXT:    mul.f32 %r5, %r2, 0fBF000000;
; CHECK-NEXT:    mul.f32 %r6, %r5, %r4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %val = tail call float @llvm.sqrt.f32(float %a)
  %ret = fdiv arcp float 1.0, %val
  ret float %ret
}

define float @test_sqrt32_refined(float %a) #0 #2 {
; CHECK-LABEL: test_sqrt32_refined(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_refined_param_0];
; CHECK-NEXT:    sqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %ret = tail call float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define float @test_sqrt32_refined_ninf(float %a) #0 #2 {
; CHECK-LABEL: test_sqrt32_refined_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b32 %r<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_refined_ninf_param_0];
; CHECK-NEXT:    rsqrt.approx.f32 %r2, %r1;
; CHECK-NEXT:    mul.f32 %r3, %r1, %r2;
; CHECK-NEXT:    fma.rn.f32 %r4, %r3, %r2, 0fC0400000;
; CHECK-NEXT:    mul.f32 %r5, %r3, 0fBF000000;
; CHECK-NEXT:    mul.f32 %r6, %r5, %r4;
; CHECK-NEXT:    abs.f32 %r7, %r1;
; CHECK-NEXT:    setp.lt.f32 %p1, %r7, 0f00800000;
; CHECK-NEXT:    selp.f32 %r8, 0f00000000, %r6, %p1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r8;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define double @test_rsqrt64_refined(double %a) #0 #2 {
; CHECK-LABEL: test_rsqrt64_refined(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_rsqrt64_refined_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    mul.f64 %rd3, %rd1, %rd2;
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd3, %rd2, 0dC008000000000000;
; CHECK-NEXT:    mul.f64 %rd5, %rd2, 0dBFE0000000000000;
; CHECK-NEXT:    mul.f64 %rd6, %rd5, %rd4;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd6;
; CHECK-NEXT:    ret;
  %val = tail call double @llvm.sqrt.f64(double %a)
  %ret = fdiv arcp double 1.0, %val
  ret double %ret
}

define double @test_sqrt64_refined(double %a) #0 #2 {
; CHECK-LABEL: test_sqrt64_refined(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_refined_param_0];
; CHECK-NEXT:    sqrt.rn.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %ret = tail call double @llvm.sqrt.f64(double %a)
  ret double %ret
}

define double @test_sqrt64_refined_ninf(double %a) #0 #2 {
; CHECK-LABEL: test_sqrt64_refined_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b64 %rd<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_refined_ninf_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    mul.f64 %rd3, %rd1, %rd2;
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd3, %rd2, 0dC008000000000000;
; CHECK-NEXT:    mul.f64 %rd5, %rd3, 0dBFE0000000000000;
; CHECK-NEXT:    mul.f64 %rd6, %rd5, %rd4;
; CHECK-NEXT:    abs.f64 %rd7, %rd1;
; CHECK-NEXT:    setp.lt.f64 %p1, %rd7, 0d0010000000000000;
; CHECK-NEXT:    selp.f64 %rd8, 0d0000000000000000, %rd6, %p1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd8;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn double @llvm.sqrt.f64(double %a)
  ret double %ret
}

; -- refined sqrt and rsqrt with ftz enabled --

define float @test_rsqrt32_refined_ftz(float %a) #0 #1 #2 {
; CHECK-LABEL: test_rsqrt32_refined_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_rsqrt32_refined_ftz_param_0];
; CHECK-NEXT:    rsqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    mul.ftz.f32 %r3, %r1, %r2;
; CHECK-NEXT:    fma.rn.ftz.f32 %r4, %r3, %r2, 0fC0400000;
; CHECK-NEXT:    mul.ftz.f32 %r5, %r2, 0fBF000000;
; CHECK-NEXT:    mul.ftz.f32 %r6, %r5, %r4;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r6;
; CHECK-NEXT:    ret;
  %val = tail call float @llvm.sqrt.f32(float %a)
  %ret = fdiv arcp float 1.0, %val
  ret float %ret
}

define float @test_sqrt32_refined_ftz(float %a) #0 #1 #2 {
; CHECK-LABEL: test_sqrt32_refined_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_refined_ftz_param_0];
; CHECK-NEXT:    sqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r2;
; CHECK-NEXT:    ret;
  %ret = tail call float @llvm.sqrt.f32(float %a)
  ret float %ret
}

define float @test_sqrt32_refined_ftz_ninf(float %a) #0 #1 #2 {
; CHECK-LABEL: test_sqrt32_refined_ftz_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b32 %r<8>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_sqrt32_refined_ftz_ninf_param_0];
; CHECK-NEXT:    rsqrt.approx.ftz.f32 %r2, %r1;
; CHECK-NEXT:    mul.ftz.f32 %r3, %r1, %r2;
; CHECK-NEXT:    fma.rn.ftz.f32 %r4, %r3, %r2, 0fC0400000;
; CHECK-NEXT:    mul.ftz.f32 %r5, %r3, 0fBF000000;
; CHECK-NEXT:    mul.ftz.f32 %r6, %r5, %r4;
; CHECK-NEXT:    setp.eq.ftz.f32 %p1, %r1, 0f00000000;
; CHECK-NEXT:    selp.f32 %r7, 0f00000000, %r6, %p1;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r7;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn float @llvm.sqrt.f32(float %a)
  ret float %ret
}

; There's no rsqrt.approx.ftz.f64, so we just use the non-ftz version.
define double @test_rsqrt64_refined_ftz(double %a) #0 #1 #2 {
; CHECK-LABEL: test_rsqrt64_refined_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<7>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_rsqrt64_refined_ftz_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    mul.f64 %rd3, %rd1, %rd2;
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd3, %rd2, 0dC008000000000000;
; CHECK-NEXT:    mul.f64 %rd5, %rd2, 0dBFE0000000000000;
; CHECK-NEXT:    mul.f64 %rd6, %rd5, %rd4;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd6;
; CHECK-NEXT:    ret;
  %val = tail call double @llvm.sqrt.f64(double %a)
  %ret = fdiv arcp double 1.0, %val
  ret double %ret
}

define double @test_sqrt64_refined_ftz(double %a) #0 #1 #2 {
; CHECK-LABEL: test_sqrt64_refined_ftz(
; CHECK:       {
; CHECK-NEXT:    .reg .b64 %rd<3>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_refined_ftz_param_0];
; CHECK-NEXT:    sqrt.rn.f64 %rd2, %rd1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd2;
; CHECK-NEXT:    ret;
  %ret = tail call double @llvm.sqrt.f64(double %a)
  ret double %ret
}

define double @test_sqrt64_refined_ftz_ninf(double %a) #0 #1 #2 {
; CHECK-LABEL: test_sqrt64_refined_ftz_ninf(
; CHECK:       {
; CHECK-NEXT:    .reg .pred %p<2>;
; CHECK-NEXT:    .reg .b64 %rd<9>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [test_sqrt64_refined_ftz_ninf_param_0];
; CHECK-NEXT:    rsqrt.approx.f64 %rd2, %rd1;
; CHECK-NEXT:    mul.f64 %rd3, %rd1, %rd2;
; CHECK-NEXT:    fma.rn.f64 %rd4, %rd3, %rd2, 0dC008000000000000;
; CHECK-NEXT:    mul.f64 %rd5, %rd3, 0dBFE0000000000000;
; CHECK-NEXT:    mul.f64 %rd6, %rd5, %rd4;
; CHECK-NEXT:    abs.f64 %rd7, %rd1;
; CHECK-NEXT:    setp.lt.f64 %p1, %rd7, 0d0010000000000000;
; CHECK-NEXT:    selp.f64 %rd8, 0d0000000000000000, %rd6, %p1;
; CHECK-NEXT:    st.param.b64 [func_retval0], %rd8;
; CHECK-NEXT:    ret;
  %ret = tail call ninf afn double @llvm.sqrt.f64(double %a)
  ret double %ret
}

attributes #0 = { "unsafe-fp-math" = "true" }
attributes #1 = { "denormal-fp-math-f32" = "preserve-sign,preserve-sign" }
attributes #2 = { "reciprocal-estimates" = "rsqrtf:1,rsqrtd:1,sqrtf:1,sqrtd:1" }
