; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64-- -mattr=+altivec | \
; RUN:   FileCheck %s
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc64-aix- \
; RUN:   -mattr=+altivec | FileCheck %s --check-prefix=AIX64
; RUN: llc -verify-machineinstrs < %s -mtriple=powerpc-aix- -mattr=+altivec | \
; RUN:   FileCheck %s --check-prefix=AIX32


define hidden void @_Z4borkPc(ptr %image) {
; CHECK-LABEL: _Z4borkPc:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li 4, 8
; CHECK-NEXT:    dst 3, 4, 0
; CHECK-NEXT:    dstt 3, 4, 0
; CHECK-NEXT:    dstst 3, 4, 0
; CHECK-NEXT:    dststt 3, 4, 0
; CHECK-NEXT:    blr
;
; AIX64-LABEL: _Z4borkPc:
; AIX64:       # %bb.0: # %entry
; AIX64-NEXT:    li 4, 8
; AIX64-NEXT:    nop
; AIX64-NEXT:    nop
; AIX64-NEXT:    nop
; AIX64-NEXT:    nop
; AIX64-NEXT:    blr
;
; AIX32-LABEL: _Z4borkPc:
; AIX32:       # %bb.0: # %entry
; AIX32-NEXT:    li 4, 8
; AIX32-NEXT:    nop
; AIX32-NEXT:    nop
; AIX32-NEXT:    nop
; AIX32-NEXT:    nop
; AIX32-NEXT:    blr
entry:
	tail call void @llvm.ppc.altivec.dst( ptr %image, i32 8, i32 0 )
	tail call void @llvm.ppc.altivec.dstt( ptr %image, i32 8, i32 0 )
	tail call void @llvm.ppc.altivec.dstst( ptr %image, i32 8, i32 0 )
	tail call void @llvm.ppc.altivec.dststt( ptr %image, i32 8, i32 0 )
	ret void
}

declare void @llvm.ppc.altivec.dst(ptr, i32, i32)
declare void @llvm.ppc.altivec.dstt(ptr, i32, i32)
declare void @llvm.ppc.altivec.dstst(ptr, i32, i32)
declare void @llvm.ppc.altivec.dststt(ptr, i32, i32)
