; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvbb,+zvfbfwma -riscv-enable-vl-optimizer=false -verify-machineinstrs | FileCheck %s --check-prefixes=NOVLOPT
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvbb,+zvfbfwma -riscv-enable-vl-optimizer=false -verify-machineinstrs | FileCheck %s --check-prefixes=NOVLOPT
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvbb,+zvfbfwma -riscv-enable-vl-optimizer -verify-machineinstrs | FileCheck %s --check-prefixes=VLOPT
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvbb,+zvfbfwma -riscv-enable-vl-optimizer -verify-machineinstrs | FileCheck %s --check-prefixes=VLOPT

; The purpose of this file is to check the behavior of specific instructions as it relates to the VL optimizer

define <vscale x 4 x i32> @vadd_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vadd_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadd_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vadd_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vadd_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vadd_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadd_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsub_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsub.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsub.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vsub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsub.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsub.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrsub_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vrsub_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrsub.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrsub_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vrsub.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrsub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrsub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vrsub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrsub.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrsub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vrsub.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrsub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vand_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vand_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vand.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vand_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vand.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vand.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vand_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vand_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vand.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vand_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vand.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vand.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vand_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vand_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vand.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vand_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vand.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vand.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vor_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vor_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vor.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vor_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vor.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vor.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vor_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vor_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vor.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vor_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vor.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vor.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vor_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vor_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vor.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vor_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vor.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vor.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vxor_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vxor_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vxor.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vxor_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vxor.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vxor.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vxor_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vxor_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vxor.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vxor_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vxor.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vxor.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vxor_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vxor_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vxor.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vxor_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vxor.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vxor.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsll_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vsll_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsll.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsll_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsll.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsll.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsll_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsll_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsll.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsll_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsll.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsll.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsll_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vsll_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsll.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsll_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsll.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsll.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i64> @vwaddu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwaddu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwaddu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwaddu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwaddu.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwaddu.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i32> @vsrl_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vsrl_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsrl.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsrl_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsrl.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsrl_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsrl_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsrl.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsrl_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsrl.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsrl_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vsrl_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsrl.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsrl_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsrl.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsra_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vsra_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsra.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsra_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsra.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsra_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsra_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsra.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsra_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsra.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsra_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vsra_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsra.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsra_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsra.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i64> @vwaddu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwaddu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwaddu.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwaddu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwaddu.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwaddu.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsubu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsubu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsubu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsubu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwsubu.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsubu.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsubu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsubu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsubu.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsubu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwsubu.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsubu.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwadd_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwadd.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwadd.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwadd.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwadd_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwadd_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwadd.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwadd_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwadd.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwadd.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsub_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsub.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwsub.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsub.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsub.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwsub.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsub.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwaddu_wv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwaddu_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwaddu.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwaddu_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwaddu.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwaddu.w.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwaddu_wx(<vscale x 4 x i64> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwaddu_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwaddu.wx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwaddu_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwaddu.wx v8, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwaddu.w.xv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsubu_wv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsubu_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsubu.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsubu_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwsubu.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsubu.w.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsubu_wx(<vscale x 4 x i64> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsubu_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsubu.wx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsubu_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwsubu.wx v8, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsubu.w.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwadd_wv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwadd_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwadd.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwadd_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwadd.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwadd.w.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwadd_wx(<vscale x 4 x i64> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwadd_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwadd.wx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwadd_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwadd.wx v8, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwadd.w.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsub_wv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsub_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsub.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsub_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwsub.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsub.w.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwsub_wx(<vscale x 4 x i64> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsub_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwsub.wx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsub_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwsub.wx v8, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwsub.w.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i32> @vsext_vf2(<vscale x 4 x i16> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsext_vf2:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsext.vf2 v12, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsext_vf2:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsext.vf2 v12, v8
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsext.nxv4i32.nxv4i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsext_vf4(<vscale x 4 x i8> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsext_vf4:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsext.vf4 v12, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsext_vf4:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsext.vf4 v12, v8
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsext.nxv4i32.nxv4i8(<vscale x 4 x i32> poison, <vscale x 4 x i8> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i64> @vsext_vf8(<vscale x 4 x i8> %a, <vscale x 4 x i64> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsext_vf8:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; NOVLOPT-NEXT:    vsext.vf8 v16, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v16, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsext_vf8:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; VLOPT-NEXT:    vsext.vf8 v16, v8
; VLOPT-NEXT:    vadd.vv v8, v16, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vsext.nxv4i32.nxv4i8(<vscale x 4 x i64> poison, <vscale x 4 x i8> %a, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %b, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i32> @vzext_vf2(<vscale x 4 x i16> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vzext_vf2:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vzext.vf2 v12, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vzext_vf2:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vzext.vf2 v12, v8
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vzext.nxv4i32.nxv4i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vzext_vf4(<vscale x 4 x i8> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vzext_vf4:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vzext.vf4 v12, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vzext_vf4:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vzext.vf4 v12, v8
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vzext.nxv4i32.nxv4i8(<vscale x 4 x i32> poison, <vscale x 4 x i8> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i64> @vzext_vf8(<vscale x 4 x i8> %a, <vscale x 4 x i64> %b, iXLen %vl) {
; NOVLOPT-LABEL: vzext_vf8:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; NOVLOPT-NEXT:    vzext.vf8 v16, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v16, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vzext_vf8:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; VLOPT-NEXT:    vzext.vf8 v16, v8
; VLOPT-NEXT:    vadd.vv v8, v16, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vzext.nxv4i32.nxv4i8(<vscale x 4 x i64> poison, <vscale x 4 x i8> %a, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %b, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i1> @vmadc_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmadc_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmadc_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmadc_vim(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vim:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vim v11, v8, 5, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vim:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vim v11, v8, 5, v0
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; VLOPT-NEXT:    vmand.mm v0, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.carry.in.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmadc_vxm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vxm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vxm v11, v8, a0, v0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vxm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vxm v11, v8, a0, v0
; VLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; VLOPT-NEXT:    vmand.mm v0, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.carry.in.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmadc_vvm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmadc_vvm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmadc.vvm v11, v8, v12, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadc_vvm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vmadc.vvm v11, v8, v12, v0
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; VLOPT-NEXT:    vmand.mm v0, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmadc.carry.in.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsbc_vvm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsbc_vvm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsbc.vvm v11, v8, v12, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsbc_vvm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vmsbc.vvm v11, v8, v12, v0
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; VLOPT-NEXT:    vmand.mm v0, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsbc.borrow.in.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsbc_vxm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsbc_vxm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsbc.vxm v11, v8, a0, v0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsbc_vxm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vmsbc.vxm v11, v8, a0, v0
; VLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; VLOPT-NEXT:    vmand.mm v0, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsbc.borrow.in.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsbc_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsbc_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsbc.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsbc_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsbc.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsbc.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsbc_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsbc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsbc.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsbc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsbc.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsbc.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i16> @vnsrl_wi(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnsrl_wi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsrl.wi v11, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsrl_wi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vnsrl.wi v11, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsrl.nxv4i16.nxv4i32(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @vnsrl_wx(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, iXLen %c, iXLen %vl) {
; NOVLOPT-LABEL: vnsrl_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsrl.wx v11, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsrl_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; VLOPT-NEXT:    vnsrl.wx v11, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsrl.nxv4i16.nxv4i32(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, iXLen %c, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @vnsrl_wv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vnsrl_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsrl.wv v12, v8, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsrl_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vnsrl.wv v12, v8, v11
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsrl.nxv4i16.nxv4i32.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, <vscale x 4 x i16> %c, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @vnsra_wi(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnsra_wi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsra.wi v11, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsra_wi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vnsra.wi v11, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsra.nxv4i16.nxv4i32(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @vnsra_wx(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, iXLen %c, iXLen %vl) {
; NOVLOPT-LABEL: vnsra_wx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsra.wx v11, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v11, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsra_wx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; VLOPT-NEXT:    vnsra.wx v11, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v11, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsra.nxv4i16.nxv4i32(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, iXLen %c, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i16> @vnsra_wv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vnsra_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vnsra.wv v12, v8, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnsra_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vnsra.wv v12, v8, v11
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i16> @llvm.riscv.vnsra.nxv4i16.nxv4i32.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i32> %a, <vscale x 4 x i16> %c, iXLen -1)
  %2 = call <vscale x 4 x i16> @llvm.riscv.vadd.nxv4i16.nxv4i16(<vscale x 4 x i16> poison, <vscale x 4 x i16> %1, <vscale x 4 x i16> %b, iXLen %vl)
  ret <vscale x 4 x i16> %2
}

define <vscale x 4 x i1> @vmseq_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmseq_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmseq.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmseq_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmseq.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmseq.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmseq_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmseq_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmseq.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmseq_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmseq.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmseq.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmseq_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmseq_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmseq.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmseq_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmseq.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmseq.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsne_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmsne_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsne.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsne_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsne.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsne.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsne_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsne_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsne.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsne_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsne.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsne.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsne_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsne_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsne.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsne_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsne.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsne.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsltu_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsltu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsltu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsltu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsltu.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsltu.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsltu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsltu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsltu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsltu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsltu.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsltu.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmslt_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmslt_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmslt.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmslt_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmslt.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmslt.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmslt_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmslt_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmslt.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmslt_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmslt.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmslt.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsleu_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmsleu_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsleu.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsleu_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsleu.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsleu.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsleu_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsleu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsleu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsleu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsleu.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsleu.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsleu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsleu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsleu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsleu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsleu.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsleu.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsle_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmsle_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsle.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsle_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsle.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsle.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsle_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsle_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsle.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsle_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsle.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsle.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsle_vv(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsle_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsle.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsle_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsle.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsle.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsgtu_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmsgtu_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsgtu.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsgtu_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsgtu.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsgtu.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsgtu_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsgtu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsgtu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsgtu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsgtu.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsgtu.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsgt_vi(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmsgt_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsgt.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsgt_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmsgt.vi v10, v8, 5
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsgt.nxv4i32.i32(<vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmsgt_vx(<vscale x 4 x i32> %a, <vscale x 4 x i1> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsgt_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmsgt.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsgt_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmsgt.vx v10, v8, a0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmsgt.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i32> @vminu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vminu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vminu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vminu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vminu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vminu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vminu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vminu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vminu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vminu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vminu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vminu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmin_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmin_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmin.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmin_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmin.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmin.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmin_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmin_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmin.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmin_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmin.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmin.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmaxu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmaxu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmaxu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmaxu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmaxu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmaxu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmaxu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmaxu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmaxu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmaxu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmaxu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmaxu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmax_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmax_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmax.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmax_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmax.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmax.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmax_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmax_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmax.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmax_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmax.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmax.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmul_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmul_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmul.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmul_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmul.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmul.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmul_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmul_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmul.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmul_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmul.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmul.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulh_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulh_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulh.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulh_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmulh.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulh.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulh_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulh_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulh.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulh_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmulh.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulh.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulhu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulhu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulhu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulhu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmulhu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulhu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulhu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulhu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulhu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulhu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmulhu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulhu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulhsu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulhsu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulhsu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulhsu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmulhsu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulhsu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmulhsu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmulhsu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmulhsu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmulhsu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmulhsu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmulhsu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vdivu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vdivu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vdivu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vdivu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vdivu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vdivu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vdivu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vdivu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vdivu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vdivu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vdivu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vdivu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vdiv_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vdiv_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vdiv.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vdiv_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vdiv.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vdiv.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vdiv_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vdiv_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vdiv.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vdiv_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vdiv.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vdiv.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vremu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vremu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vremu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vremu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vremu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vremu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vremu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vremu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vremu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vremu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vremu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vremu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrem_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vrem_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrem.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrem_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vrem.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrem.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrem_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vrem_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrem.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrem_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vrem.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrem.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i64> @vwmul_vv(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwmul_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vwmul.vv v12, v8, v9
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmul.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmul_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vwmul.vv v12, v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vwmul.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmul.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, <vscale x 4 x i16> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vwmul.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwmul_vx(<vscale x 4 x i16> %a, i16 %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vwmul_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a3, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vwmul.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmul.vx v8, v12, a1
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmul_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a2, e16, m1, ta, ma
; VLOPT-NEXT:    vwmul.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vwmul.vx v8, v12, a1
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmul.nxv4i32.nxv4i16.i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, i16 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vwmul.nxv4i64.nxv4i64.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %1, i32 %c, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwmulsu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwmulsu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmulsu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmulsu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwmulsu.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwmulsu.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwmulsu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwmulsu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmulsu.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmulsu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwmulsu.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwmulsu.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwmulu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwmulu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmulu.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmulu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vwmulu.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwmulu.nxv4i64.nxv4i32.nxv4i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i64> @vwmulu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vwmulu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vwmulu.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmulu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vwmulu.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i64> @llvm.riscv.vwmulu.nxv4i64.nxv4i32.i32(<vscale x 4 x i64> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i64> @llvm.riscv.vadd.nxv4i64.nxv4i64(<vscale x 4 x i64> poison, <vscale x 4 x i64> %1, <vscale x 4 x i64> %1, iXLen %vl)
  ret <vscale x 4 x i64> %2
}

define <vscale x 4 x i32> @vwmacc_vv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, <vscale x 4 x i32> %d, iXLen %vl) {
; NOVLOPT-LABEL: vwmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmacc.vv v8, v10, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; VLOPT-NEXT:    vwmacc.vv v8, v10, v11
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmacc.nxv4i32.nxv4i16(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %d, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmacc_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmacc.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vmacc.vv v8, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmacc.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmacc_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmacc_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmv2r.v v10, v8
; NOVLOPT-NEXT:    vmacc.vx v10, a0, v8
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmacc_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; VLOPT-NEXT:    vmv2r.v v10, v8
; VLOPT-NEXT:    vmacc.vx v10, a0, v8
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmacc.nxv4i32.i32(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i32> %a, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmadd_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vmadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmadd.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vmadd.vv v8, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmadd.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmadd_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vmadd_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmv2r.v v10, v8
; NOVLOPT-NEXT:    vmadd.vx v10, a0, v8
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmadd_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; VLOPT-NEXT:    vmv2r.v v10, v8
; VLOPT-NEXT:    vmadd.vx v10, a0, v8
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmadd.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i32> %a, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnmsac_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnmsac_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vnmsac.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnmsac_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vnmsac.vv v8, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnmsac.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnmsac_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vnmsac_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmv2r.v v10, v8
; NOVLOPT-NEXT:    vnmsac.vx v10, a0, v8
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnmsac_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; VLOPT-NEXT:    vmv2r.v v10, v8
; VLOPT-NEXT:    vnmsac.vx v10, a0, v8
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnmsac.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i32> %a, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnmsub_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnmsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vnmsub.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnmsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vnmsub.vv v8, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnmsub.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnmsub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vnmsub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vmv2r.v v10, v8
; NOVLOPT-NEXT:    vnmsub.vx v10, a0, v8
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnmsub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; VLOPT-NEXT:    vmv2r.v v10, v8
; VLOPT-NEXT:    vnmsub.vx v10, a0, v8
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnmsub.nxv4i32.nxv4i32(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i32> %a, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmacc_vx(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vwmacc_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmacc.vx v8, a0, v10
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmacc_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; VLOPT-NEXT:    vwmacc.vx v8, a0, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmacc.nxv4i32.i16(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmaccu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, <vscale x 4 x i32> %d, iXLen %vl) {
; NOVLOPT-LABEL: vwmaccu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmaccu.vv v8, v10, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmaccu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; VLOPT-NEXT:    vwmaccu.vv v8, v10, v11
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmaccu.nxv4i32.nxv4i16(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %d, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmaccu_vx(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, <vscale x 4 x i32> %d, i32 %e, iXLen %vl) {
; NOVLOPT-LABEL: vwmaccu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmaccu.vx v8, a0, v10
; NOVLOPT-NEXT:    vsetvli zero, a2, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmaccu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a2, e16, m1, tu, ma
; VLOPT-NEXT:    vwmaccu.vx v8, a0, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmaccu.nxv4i32.i16(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %d, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmaccsu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vwmaccsu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmaccsu.vv v8, v10, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmaccsu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; VLOPT-NEXT:    vwmaccsu.vv v8, v10, v11
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmaccsu.nxv4i32.nxv4i16(<vscale x 4 x i32> %a, <vscale x 4 x i16> %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmaccsu_vx(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vwmaccsu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmaccsu.vx v8, a0, v10
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmaccsu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; VLOPT-NEXT:    vwmaccsu.vx v8, a0, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmaccsu.nxv4i32.i16(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwmaccus_vx(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen %vl) {
; NOVLOPT-LABEL: vwmaccus_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vwmaccus.vx v8, a0, v10
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwmaccus_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; VLOPT-NEXT:    vwmaccus.vx v8, a0, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwmaccus.nxv4i32.i16(<vscale x 4 x i32> %a, i16 %b, <vscale x 4 x i16> %c, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsaddu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsaddu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsaddu.vv v10, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsaddu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsaddu.vv v10, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsaddu(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsaddu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vsaddu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsaddu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsaddu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsaddu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsaddu(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsaddu_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vsaddu_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsaddu.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsaddu_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsaddu.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsaddu(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsadd_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsadd.vv v10, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsadd.vv v10, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsadd_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vsadd_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsadd.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsadd_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsadd.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsadd_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vsadd_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsadd.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsadd_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsadd.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssubu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vssubu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssubu.vv v10, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssubu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssubu.vv v10, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssubu(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssubu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vssubu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssubu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssubu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vssubu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssubu(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssub_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vssub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssub.vv v10, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssub.vv v10, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssub(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vssub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssub.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vssub.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssub(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsmul_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vsmul_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsmul.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsmul_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vsmul.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsmul.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsmul_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vsmul_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsmul.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsmul_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vsmul.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsmul.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssrl_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vssrl_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssrl.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssrl_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssrl.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssrl_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vssrl_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssrl.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssrl_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vssrl.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssrl_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vssrl_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssrl.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssrl_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssrl.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssrl.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssra_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vssra_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssra.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssra_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssra.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssra_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vssra_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssra.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssra_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vssra.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vssra_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vssra_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vssra.vi v10, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vssra_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vssra.vi v10, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vssra.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclipu_vv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnclipu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclipu.wv v14, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v14, v14
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclipu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vnclipu.wv v14, v8, v12
; VLOPT-NEXT:    vadd.vv v8, v14, v14
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclipu(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclipu_vx(<vscale x 4 x i64> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vnclipu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclipu.wx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclipu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vnclipu.wx v12, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclipu(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, iXLen %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclipu_vi(<vscale x 4 x i64> %a, iXLen %vl) {
; NOVLOPT-LABEL: vnclipu_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclipu.wi v12, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclipu_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vnclipu.wi v12, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclipu(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, iXLen 5, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclip_vv(<vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vnclip_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclip.wv v14, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v14, v14
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclip_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vnclip.wv v14, v8, v12
; VLOPT-NEXT:    vadd.vv v8, v14, v14
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclip(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclip_vx(<vscale x 4 x i64> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vnclip_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclip.wx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclip_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vnclip.wx v12, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclip(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, iXLen %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vnclip_vi(<vscale x 4 x i64> %a, iXLen %vl) {
; NOVLOPT-LABEL: vnclip_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vnclip.wi v12, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vnclip_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vnclip.wi v12, v8, 5
; VLOPT-NEXT:    vadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vnclip(<vscale x 4 x i32> poison, <vscale x 4 x i64> %a, iXLen 5, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmv_v_i(<vscale x 4 x i32> %a, i32 %x, iXLen %vl) {
; NOVLOPT-LABEL: vmv_v_i:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmv.v.i v10, 5
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmv_v_i:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmv.v.i v10, 5
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmv.v.x.nxv4i32(<vscale x 4 x i32> poison, i32 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmv_v_x(<vscale x 4 x i32> %a, i32 %x, iXLen %vl) {
; NOVLOPT-LABEL: vmv_v_x:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmv.v.x v10, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmv_v_x:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmv.v.x v10, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmv.v.x.nxv4i32(<vscale x 4 x i32> poison, i32 %x, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

; The vmv.v.v is optimized away if we use a vadd as the user.
define <vscale x 1 x i8> @vmv_v_v(<vscale x 1 x i8> %a, <vscale x 1 x i8> %b, <vscale x 1 x i8> %c, <vscale x 1 x i1> %m, iXLen %vl) {
; NOVLOPT-LABEL: vmv_v_v:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; NOVLOPT-NEXT:    vmv.v.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmerge.vvm v8, v8, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmv_v_v:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; VLOPT-NEXT:    vmv.v.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; VLOPT-NEXT:    vmerge.vvm v8, v8, v10, v0
; VLOPT-NEXT:    ret
  %2 = call <vscale x 1 x i8> @llvm.riscv.vmv.v.v.nxv1i8.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %b, iXLen -1)
  %3 = call <vscale x 1 x i8> @llvm.riscv.vmerge.nxv1i8.nxv1i8(<vscale x 1 x i8> undef, <vscale x 1 x i8> %2, <vscale x 1 x i8> %c, <vscale x 1 x i1> %m, iXLen %vl)
  ret <vscale x 1 x i8> %3
}

define <vscale x 4 x i32> @vwsll_vi(<vscale x 4 x i16> %a, iXLen %vl) {
; NOVLOPT-LABEL: vwsll_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vwsll.vi v10, v8, 1
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsll_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vwsll.vi v10, v8, 1
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwsll.nxv4i32.nxv4i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, iXLen 1, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwsll_vx(<vscale x 4 x i16> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsll_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vwsll.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsll_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; VLOPT-NEXT:    vwsll.vx v10, v8, a0
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwsll.nxv4i32.nxv4i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vwsll_vv(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b, iXLen %vl) {
; NOVLOPT-LABEL: vwsll_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; NOVLOPT-NEXT:    vwsll.vv v10, v8, v9
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vwsll_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; VLOPT-NEXT:    vwsll.vv v10, v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vwsll.nxv4i32.nxv4i16(<vscale x 4 x i32> poison, <vscale x 4 x i16> %a, <vscale x 4 x i16> %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 1 x i32> @vmand_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmand_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmand_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmand.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmnand_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmnand_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmnand.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmnand_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmnand.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmnand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmandn_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmandn_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmandn.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmandn_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmandn.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmandn.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmxor_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmxor_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmxor.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmxor_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmxor.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmxor.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmor_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmor_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmor.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmor_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmor.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmor.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}


define <vscale x 1 x i32> @vmnor_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmnor_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmnor.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmnor_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmnor.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmnor.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmorn_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmorn_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmorn.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmorn_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmorn.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmorn.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmxnor_mm(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmxnor_mm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmxnor.mm v8, v0, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v8
; NOVLOPT-NEXT:    vmv1r.v v8, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmxnor_mm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmxnor.mm v8, v0, v8
; VLOPT-NEXT:    vmand.mm v0, v0, v8
; VLOPT-NEXT:    vmv1r.v v8, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v9, v9, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmxnor.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %b, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmsbf_m(<vscale x 1 x i1> %a, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsbf_m:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmsbf.m v9, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsbf_m:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmsbf.m v9, v0
; VLOPT-NEXT:    vmand.mm v0, v0, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmsbf.nxv1i1(<vscale x 1 x i1> %a, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmsif_m(<vscale x 1 x i1> %a, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsif_m:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmsif.m v9, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsif_m:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmsif.m v9, v0
; VLOPT-NEXT:    vmand.mm v0, v0, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmsif.nxv1i1(<vscale x 1 x i1> %a, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 1 x i32> @vmsof_m(<vscale x 1 x i1> %a, <vscale x 1 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmsof_m:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmsof.m v9, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v0, v9
; NOVLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmsof_m:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; VLOPT-NEXT:    vmsof.m v9, v0
; VLOPT-NEXT:    vmand.mm v0, v0, v9
; VLOPT-NEXT:    vsetvli zero, zero, e32, mf2, tu, mu
; VLOPT-NEXT:    vadd.vv v8, v8, v8, v0.t
; VLOPT-NEXT:    ret
  %1 = call <vscale x 1 x i1> @llvm.riscv.vmsof.nxv1i1(<vscale x 1 x i1> %a, iXLen -1)
  %2 = call <vscale x 1 x i1> @llvm.riscv.vmand.nxv1i1(<vscale x 1 x i1> %a, <vscale x 1 x i1> %1, iXLen %vl)
  %3 = call <vscale x 1 x i32> @llvm.riscv.vadd.mask.nxv1i32.nxv1i32(<vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i32> %c, <vscale x 1 x i1> %2, iXLen %vl, iXLen 0)
  ret <vscale x 1 x i32> %3
}

define <vscale x 4 x i32> @viota_m(<vscale x 4 x i1> %a, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: viota_m:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    viota.m v10, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: viota_m:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    viota.m v10, v0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.viota.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %c, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vid.v(<vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vid.v:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vid.v v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vid.v:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vid.v v10
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vid.nxv4i32(<vscale x 4 x i32> poison, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %c, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vslideup_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vslideup_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslideup.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslideup_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vslideup.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslideup(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vslideup_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vslideup_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslideup.vi v10, v8, 2
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslideup_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vslideup.vi v10, v8, 2
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslideup(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 2, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vslidedown_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vslidedown_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslidedown.vx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslidedown_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vslidedown.vx v8, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslidedown(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vslidedown_vi(<vscale x 4 x i32> %a, iXLen %vl) {
; NOVLOPT-LABEL: vslidedown_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslidedown.vi v8, v8, 2
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslidedown_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vslidedown.vi v8, v8, 2
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslidedown(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 2, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vslide1up_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vslide1up_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslide1up.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslide1up_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vslide1up.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslide1up(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x float> @vfslide1up_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfslide1up_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfslide1up.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfslide1up_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfslide1up.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfslide1up(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

; Negative test – not safe to reduce vl

define <vscale x 4 x i32> @vslide1down_vx(<vscale x 4 x i32> %a, iXLen %b, iXLen %vl) {
; NOVLOPT-LABEL: vslide1down_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vslide1down.vx v8, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vslide1down_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vslide1down.vx v8, v8, a0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vslide1down(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %b, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

; Negative test – not safe to reduce vl

define <vscale x 4 x float> @vfslide1down_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfslide1down_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfslide1down.vf v8, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfslide1down_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vfslide1down.vf v8, v8, fa0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfslide1down(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfadd_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfadd_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfadd_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfadd_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfadd.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsub_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsub.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsub.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsub.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsub_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsub_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsub.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsub_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsub.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsub.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfrsub_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfrsub_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfrsub.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfrsub_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfrsub.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfrsub.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x double> @vfwadd_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwadd.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwadd.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwadd.nxv4f64.nxv4f32.nxv4f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwadd_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwadd_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwadd.vf v12, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwadd_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwadd.vf v12, v8, fa0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwadd.nxv4f64.nxv4f32.f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwsub_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwsub.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwsub.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwsub.nxv4f64.nxv4f32.nxv4f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwsub_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwsub_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwsub.vf v12, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwsub_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwsub.vf v12, v8, fa0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwsub.nxv4f64.nxv4f32.f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwadd_wv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwadd_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwadd.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwadd_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwadd.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwadd.w.nxv4f64.nxv4f32.nxv4f32(<vscale x 4 x double> poison, <vscale x 4 x double> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwadd_wf(<vscale x 4 x double> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwadd_wf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwadd.wf v8, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwadd_wf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwadd.wf v8, v8, fa0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwadd.w.nxv4f64.nxv4f32.f32(<vscale x 4 x double> poison, <vscale x 4 x double> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwsub_wv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwsub_wv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwsub.wv v8, v8, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwsub_wv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwsub.wv v8, v8, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwsub.w.nxv4f64.nxv4f32.nxv4f32(<vscale x 4 x double> poison, <vscale x 4 x double> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwsub_wf(<vscale x 4 x double> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwsub_wf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwsub.wf v8, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwsub_wf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwsub.wf v8, v8, fa0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwsub.w.nxv4f64.nxv4f32.f32(<vscale x 4 x double> poison, <vscale x 4 x double> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x float> @vfmul_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmul_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmul.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmul_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmul.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmul.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmul_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmul_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmul.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmul_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmul.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmul.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfdiv_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfdiv_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfdiv.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfdiv_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfdiv.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfdiv.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfdiv_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfdiv_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfdiv.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfdiv_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfdiv.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfdiv.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfrdiv_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfrdiv_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfrdiv.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfrdiv_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfrdiv.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfrdiv.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x double> @vfwmul_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwmul_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwmul.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmul_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwmul.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmul.nxv4f64.nxv4f32.nxv4f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwmul_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfwmul_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwmul.vf v12, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v12, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmul_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfwmul.vf v12, v8, fa0
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v12, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmul.nxv4f64.nxv4f32.f32(<vscale x 4 x double> poison, <vscale x 4 x float> %a, float %b, iXLen 7, iXLen -1)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd.nxv4f64.nxv4f64(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %1, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x i1> @vmfeq_vf(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, float%c, iXLen %vl) {
; NOVLOPT-LABEL: vmfeq_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfeq.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfeq_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfeq.vf v10, v8, fa0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfeq.nxv4f32.f32(<vscale x 4 x float> %a, float %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfeq_vv(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmfeq_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfeq.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfeq_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfeq.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfeq.nxv4f32.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfne_vf(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, float%c, iXLen %vl) {
; NOVLOPT-LABEL: vmfne_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfne.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfne_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfne.vf v10, v8, fa0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfne.nxv4f32.f32(<vscale x 4 x float> %a, float %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfne_vv(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmfne_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfne.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfne_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfne.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfne.nxv4f32.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmflt_vf(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, float%c, iXLen %vl) {
; NOVLOPT-LABEL: vmflt_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmflt.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmflt_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmflt.vf v10, v8, fa0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmflt.nxv4f32.f32(<vscale x 4 x float> %a, float %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmflt_vv(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmflt_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmflt.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmflt_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmflt.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmflt.nxv4f32.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfle_vf(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, float%c, iXLen %vl) {
; NOVLOPT-LABEL: vmfle_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfle.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfle_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfle.vf v10, v8, fa0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfle.nxv4f32.f32(<vscale x 4 x float> %a, float %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfle_vv(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmfle_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfle.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfle_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfle.vv v12, v8, v10
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfle.nxv4f32.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfgt_vf(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, float%c, iXLen %vl) {
; NOVLOPT-LABEL: vmfgt_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmfgt.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v10, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfgt_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmfgt.vf v10, v8, fa0
; VLOPT-NEXT:    vmand.mm v0, v10, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfgt.nxv4f32.f32(<vscale x 4 x float> %a, float %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i1> @vmfgt_vv(<vscale x 4 x float> %a, <vscale x 4 x i1> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmfgt_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmflt.vv v12, v10, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; NOVLOPT-NEXT:    vmand.mm v0, v12, v0
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmfgt_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmflt.vv v12, v10, v8
; VLOPT-NEXT:    vmand.mm v0, v12, v0
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i1> @llvm.riscv.vmfgt.nxv4f32.nxv4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %c, iXLen -1)
  %2 = call <vscale x 4 x i1> @llvm.riscv.vmand.nxv4i1(<vscale x 4 x i1> %1, <vscale x 4 x i1> %b, iXLen %vl)
  ret <vscale x 4 x i1> %2
}

define <vscale x 4 x i32> @vmerge_vvm(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmerge_vvm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmerge.vvm v8, v8, v10, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmerge_vvm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmerge.vvm v8, v8, v10, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmerge.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmerge_vxm(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmerge_vxm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmerge.vxm v8, v8, a0, v0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmerge_vxm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vmerge.vxm v8, v8, a0, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmerge.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vmerge_vim(<vscale x 4 x i32> %a, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vmerge_vim:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmerge.vim v8, v8, 9, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vmerge_vim:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vmerge.vim v8, v8, 9, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vmerge.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 9, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vadc_vvm(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vadc_vvm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadc.vvm v8, v8, v10, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadc_vvm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadc.vvm v8, v8, v10, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadc.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vadc_vxm(<vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vadc_vxm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadc.vxm v8, v8, a0, v0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadc_vxm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vadc.vxm v8, v8, a0, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadc.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vadc_vim(<vscale x 4 x i32> %a, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vadc_vim:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadc.vim v8, v8, 9, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vadc_vim:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadc.vim v8, v8, 9, v0
; VLOPT-NEXT:    vadd.vv v8, v8, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vadc.nxv4i32.i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 9, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %1, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vaadd_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vaadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vaadd.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vaadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vaadd.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vaadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vaadd_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vaadd_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vaadd.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vaadd_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vaadd.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vaadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vasub_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vasub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vasub.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vasub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vasub.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vasub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vasub_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vasub_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vasub.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vasub_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vasub.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vasub.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vaaddu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vaaddu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vaaddu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vaaddu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vaaddu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vaaddu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vaaddu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vaaddu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vaaddu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vaaddu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vaaddu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vaaddu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vasubu_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vasubu_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vasubu.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vasubu_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vasubu.vv v8, v8, v10
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vasubu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vasubu_vx(<vscale x 4 x i32> %a, i32 %b, iXLen %vl) {
; NOVLOPT-LABEL: vasubu_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    csrwi vxrm, 0
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vasubu.vx v10, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vasubu_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    csrwi vxrm, 0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vasubu.vx v10, v8, a0
; VLOPT-NEXT:    vadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vasubu.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %b, iXLen 0, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x float> @vfmax_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmax_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmax.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmax_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmax.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmax.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmax_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmax_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmax.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmax_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmax.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmax.nxv4f32.f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmin_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmin_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmin.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmin_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmin.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmin.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmin_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmin_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmin.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmin_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmin.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmin.nxv4f32.f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnj_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnj_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnj.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnj_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnj.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnj.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnj_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnj_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnj.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnj_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnj.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnj.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnjn_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnjn_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnjn.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnjn_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnjn.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnjn.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnjn_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnjn_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnjn.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnjn_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnjn.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnjn.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnjx_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnjx_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnjx.vv v8, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnjx_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnjx.vv v8, v8, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnjx.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %b, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfsgnjx_vf(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfsgnjx_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfsgnjx.vf v10, v8, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsgnjx_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfsgnjx.vf v10, v8, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsgnjx.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmerge_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x i1> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmerge_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmerge.vfm v10, v8, fa0, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmerge_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmerge.vfm v10, v8, fa0, v0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmerge(<vscale x 4 x float> poison, <vscale x 4 x float> %a, float %b, <vscale x 4 x i1> %c, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmv_v_f(<vscale x 4 x float> %a, float %b, iXLen %vl) {
; NOVLOPT-LABEL: vfmv_v_f:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmv.v.f v10, fa0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v10, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmv_v_f:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmv.v.f v10, fa0
; VLOPT-NEXT:    vfadd.vv v8, v10, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmv.v.f(<vscale x 4 x float> poison, float %b, iXLen -1)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd.nxv4f32.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %a, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmacc_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmacc.vv v8, v12, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmacc.vv v8, v12, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmacc(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmacc_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmacc_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmacc.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmacc_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmacc.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmacc(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmacc_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmacc.vv v8, v12, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmacc.vv v8, v12, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmacc(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmacc_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmacc_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmacc.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmacc_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmacc.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmacc(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmsac_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmsac_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmsac.vv v8, v12, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmsac_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmsac.vv v8, v12, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmsac(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmsac_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmsac_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmsac.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmsac_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmsac.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmsac(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmsac_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmsac_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmsac.vv v8, v12, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmsac_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmsac.vv v8, v12, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmsac(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmsac_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmsac_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmsac.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmsac_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmsac.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmsac(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmadd_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmadd.vv v8, v10, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmadd.vv v8, v10, v12
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmadd(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmadd_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmadd_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmadd.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmadd_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmadd.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmadd(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmadd_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmadd_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmadd.vv v8, v10, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmadd_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmadd.vv v8, v10, v12
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmadd(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmadd_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmadd_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmadd.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmadd_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmadd.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmadd(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmsub_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmsub.vv v8, v10, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmsub.vv v8, v10, v12
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmsub(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfmsub_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfmsub_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfmsub.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfmsub_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfmsub.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfmsub(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmsub_vv(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmsub_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmsub.vv v8, v10, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmsub_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmsub.vv v8, v10, v12
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmsub(<vscale x 4 x float> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x float> @vfnmsub_vf(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen %vl) {
; NOVLOPT-LABEL: vfnmsub_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfnmsub.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfnmsub_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vfnmsub.vf v8, fa0, v10
; VLOPT-NEXT:    vfadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfnmsub(<vscale x 4 x float> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 3)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %c, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x double> @vfwmacc_vv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmacc(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwmacc_vf(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmacc_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwmacc.vf v8, fa0, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmacc_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwmacc.vf v8, fa0, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmacc(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwnmacc_vv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwnmacc_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwnmacc.vv v8, v12, v14
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwnmacc_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwnmacc.vv v8, v12, v14
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwnmacc(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwnmacc_vf(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwnmacc_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwnmacc.vf v8, fa0, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwnmacc_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwnmacc.vf v8, fa0, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwnmacc(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwmsac_vv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmsac_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwmsac.vv v8, v12, v14
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmsac_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwmsac.vv v8, v12, v14
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmsac(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwmsac_vf(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmsac_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwmsac.vf v8, fa0, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmsac_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwmsac.vf v8, fa0, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwmsac(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwnmsac_vv(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwnmsac_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwnmsac.vv v8, v12, v14
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwnmsac_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwnmsac.vv v8, v12, v14
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwnmsac(<vscale x 4 x double> %a, <vscale x 4 x float> %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfwnmsac_vf(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, <vscale x 4 x double> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwnmsac_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, tu, ma
; NOVLOPT-NEXT:    vfwnmsac.vf v8, fa0, v12
; NOVLOPT-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v16
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwnmsac_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; VLOPT-NEXT:    vfwnmsac.vf v8, fa0, v12
; VLOPT-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v16
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x double> @llvm.riscv.vfwnmsac(<vscale x 4 x double> %a, float %b, <vscale x 4 x float> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfadd(<vscale x 4 x double> poison, <vscale x 4 x double> %1, <vscale x 4 x double> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x float> @vfwmaccbf16_vv(<vscale x 4 x float> %a, <vscale x 4 x bfloat> %b, <vscale x 4 x bfloat> %c, <vscale x 4 x float> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmaccbf16_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vfwmaccbf16.vv v8, v10, v11
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmaccbf16_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; VLOPT-NEXT:    vfwmaccbf16.vv v8, v10, v11
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfwmaccbf16(<vscale x 4 x float> %a, <vscale x 4 x bfloat> %b, <vscale x 4 x bfloat> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x i32> @vsbc_vvm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i32> %b, <vscale x 4 x i32> %c, iXLen %vl) {
; NOVLOPT-LABEL: vsbc_vvm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsbc.vvm v8, v8, v10, v0
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsbc_vvm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vsbc.vvm v8, v8, v10, v0
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsbc.nxv4i32.nxv4i32.nxv4i1(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %b, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %c, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vsbc_vxm(<vscale x 4 x i32> %a, <vscale x 4 x i1> %mask, <vscale x 4 x i32> %b, i32 %c, iXLen %vl) {
; NOVLOPT-LABEL: vsbc_vxm:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vsbc.vxm v8, v8, a0, v0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vsbc_vxm:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vsbc.vxm v8, v8, a0, v0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vsbc.nxv4i32.i32.nxv4i1(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, i32 %c, <vscale x 4 x i1> %mask, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vfclass_v(<vscale x 4 x float> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vfclass_v:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfclass.v v8, v8
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v8, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfclass_v:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vfclass.v v8, v8
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v8, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vfclass.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x float> %a, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrgather_vi(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vrgather_vi:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrgather.vi v12, v8, 5
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrgather_vi:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vrgather.vi v12, v8, 5
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrgather.vx.nxv4i32.iXLen(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen 5, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrgather_vv(<vscale x 4 x i32> %a, <vscale x 4 x i32> %idx, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vrgather_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrgather.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrgather_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vrgather.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrgather.vv.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i32> %idx, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrgather_vx(<vscale x 4 x i32> %a, iXLen %idx, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vrgather_vx:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrgather.vx v12, v8, a0
; NOVLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v10
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrgather_vx:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a2, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vrgather.vx v12, v8, a0
; VLOPT-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v10
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrgather.vx.nxv4i32.iXLen(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, iXLen %idx, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %b, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x i32> @vrgatherei16_vv(<vscale x 4 x i32> %a, <vscale x 4 x i16> %idx, <vscale x 4 x i32> %b, iXLen %vl) {
; NOVLOPT-LABEL: vrgatherei16_vv:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; NOVLOPT-NEXT:    vrgatherei16.vv v12, v8, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vadd.vv v8, v12, v8
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vrgatherei16_vv:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vrgatherei16.vv v12, v8, v10
; VLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; VLOPT-NEXT:    vadd.vv v8, v12, v8
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x i32> @llvm.riscv.vrgatherei16.vv.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %a, <vscale x 4 x i16> %idx, iXLen -1)
  %2 = call <vscale x 4 x i32> @llvm.riscv.vadd.nxv4i32.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i32> %1, <vscale x 4 x i32> %a, iXLen %vl)
  ret <vscale x 4 x i32> %2
}

define <vscale x 4 x float> @vfwmaccbf16_vf(<vscale x 4 x float> %a, bfloat %b, <vscale x 4 x bfloat> %c, <vscale x 4 x float> %d, iXLen %vl) {
; NOVLOPT-LABEL: vfwmaccbf16_vf:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetvli a1, zero, e16, m1, tu, ma
; NOVLOPT-NEXT:    vfwmaccbf16.vf v8, fa0, v10
; NOVLOPT-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfadd.vv v8, v8, v12
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfwmaccbf16_vf:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; VLOPT-NEXT:    vfwmaccbf16.vf v8, fa0, v10
; VLOPT-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; VLOPT-NEXT:    vfadd.vv v8, v8, v12
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfwmaccbf16(<vscale x 4 x float> %a, bfloat %b, <vscale x 4 x bfloat> %c, iXLen 7, iXLen -1, iXLen 0)
  %2 = call <vscale x 4 x float> @llvm.riscv.vfadd(<vscale x 4 x float> poison, <vscale x 4 x float> %1, <vscale x 4 x float> %d, iXLen 7, iXLen %vl)
  ret <vscale x 4 x float> %2
}

define <vscale x 4 x double> @vfsqrt(<vscale x 4 x float> %a) {
; NOVLOPT-LABEL: vfsqrt:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetivli zero, 7, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmv2r.v v12, v8
; NOVLOPT-NEXT:    fsrmi a0, 0
; NOVLOPT-NEXT:    vfsqrt.v v14, v8
; NOVLOPT-NEXT:    fsrm a0
; NOVLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfsqrt:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; VLOPT-NEXT:    vmv2r.v v12, v8
; VLOPT-NEXT:    fsrmi a0, 0
; VLOPT-NEXT:    vfsqrt.v v14, v8
; VLOPT-NEXT:    fsrm a0
; VLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfsqrt.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, iXLen 0, iXLen 7)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfwmacc(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %1, iXLen 7, iXLen 6, iXLen 0)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfrsqrt7(<vscale x 4 x float> %a) {
; NOVLOPT-LABEL: vfrsqrt7:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetivli zero, 7, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmv2r.v v12, v8
; NOVLOPT-NEXT:    vfrsqrt7.v v14, v8
; NOVLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfrsqrt7:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; VLOPT-NEXT:    vmv2r.v v12, v8
; VLOPT-NEXT:    vfrsqrt7.v v14, v8
; VLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfrsqrt7.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, iXLen 7)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfwmacc(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %1, iXLen 7, iXLen 6, iXLen 0)
  ret <vscale x 4 x double> %2
}

define <vscale x 4 x double> @vfrec7(<vscale x 4 x float> %a) {
; NOVLOPT-LABEL: vfrec7:
; NOVLOPT:       # %bb.0:
; NOVLOPT-NEXT:    vsetivli zero, 7, e32, m2, ta, ma
; NOVLOPT-NEXT:    vmv2r.v v12, v8
; NOVLOPT-NEXT:    fsrmi a0, 0
; NOVLOPT-NEXT:    vfrec7.v v14, v8
; NOVLOPT-NEXT:    fsrm a0
; NOVLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; NOVLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; NOVLOPT-NEXT:    ret
;
; VLOPT-LABEL: vfrec7:
; VLOPT:       # %bb.0:
; VLOPT-NEXT:    vsetivli zero, 6, e32, m2, ta, ma
; VLOPT-NEXT:    vmv2r.v v12, v8
; VLOPT-NEXT:    fsrmi a0, 0
; VLOPT-NEXT:    vfrec7.v v14, v8
; VLOPT-NEXT:    fsrm a0
; VLOPT-NEXT:    vfwmacc.vv v8, v12, v14
; VLOPT-NEXT:    ret
  %1 = call <vscale x 4 x float> @llvm.riscv.vfrec7.nxv4f32(<vscale x 4 x float> poison, <vscale x 4 x float> %a, iXLen 0, iXLen 7)
  %2 = call <vscale x 4 x double> @llvm.riscv.vfwmacc(<vscale x 4 x double> poison, <vscale x 4 x float> %a, <vscale x 4 x float> %1, iXLen 7, iXLen 6, iXLen 0)
  ret <vscale x 4 x double> %2
}
