; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=xtensa < %s | FileCheck -check-prefixes=CHECK %s
; RUN: llc --mtriple=xtensa --mattr=+windowed < %s | FileCheck -check-prefixes=CHECK-WINDOWED %s

declare ptr @llvm.stacksave()

declare void @llvm.stackrestore(ptr)

declare void @use_addr(ptr)

define void @test_saverestore(i64 %n) {
; CHECK-LABEL: test_saverestore:
; CHECK:         .cfi_startproc
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    addi a8, a1, -16
; CHECK-NEXT:    or a1, a8, a8
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    s32i a0, a1, 8 # 4-byte Folded Spill
; CHECK-NEXT:    s32i a12, a1, 4 # 4-byte Folded Spill
; CHECK-NEXT:    s32i a15, a1, 0 # 4-byte Folded Spill
; CHECK-NEXT:    .cfi_offset a0, -4
; CHECK-NEXT:    .cfi_offset a12, -8
; CHECK-NEXT:    .cfi_offset a15, -12
; CHECK-NEXT:    or a15, a1, a1
; CHECK-NEXT:    .cfi_def_cfa_register a15
; CHECK-NEXT:    addi a8, a2, 3
; CHECK-NEXT:    movi a9, -4
; CHECK-NEXT:    and a8, a8, a9
; CHECK-NEXT:    addi a8, a8, 31
; CHECK-NEXT:    movi a9, -32
; CHECK-NEXT:    and a8, a8, a9
; CHECK-NEXT:    or a12, a1, a1
; CHECK-NEXT:    sub a1, a1, a8
; CHECK-NEXT:    or a2, a1, a1
; CHECK-NEXT:    l32r a8, .LCPI0_0
; CHECK-NEXT:    callx0 a8
; CHECK-NEXT:    or a1, a12, a12
; CHECK-NEXT:    or a1, a15, a15
; CHECK-NEXT:    l32i a15, a1, 0 # 4-byte Folded Reload
; CHECK-NEXT:    l32i a12, a1, 4 # 4-byte Folded Reload
; CHECK-NEXT:    l32i a0, a1, 8 # 4-byte Folded Reload
; CHECK-NEXT:    addi a8, a1, 16
; CHECK-NEXT:    or a1, a8, a8
; CHECK-NEXT:    ret
;
; CHECK-WINDOWED-LABEL: test_saverestore:
; CHECK-WINDOWED:         .cfi_startproc
; CHECK-WINDOWED-NEXT:  # %bb.0:
; CHECK-WINDOWED-NEXT:    entry a1, 32
; CHECK-WINDOWED-NEXT:    or a7, a1, a1
; CHECK-WINDOWED-NEXT:    .cfi_def_cfa a7, 32
; CHECK-WINDOWED-NEXT:    addi a8, a2, 3
; CHECK-WINDOWED-NEXT:    movi a9, -4
; CHECK-WINDOWED-NEXT:    and a8, a8, a9
; CHECK-WINDOWED-NEXT:    addi a8, a8, 31
; CHECK-WINDOWED-NEXT:    movi a9, -32
; CHECK-WINDOWED-NEXT:    and a8, a8, a9
; CHECK-WINDOWED-NEXT:    or a6, a1, a1
; CHECK-WINDOWED-NEXT:    sub a8, a1, a8
; CHECK-WINDOWED-NEXT:    movsp a1, a8
; CHECK-WINDOWED-NEXT:    or a10, a1, a1
; CHECK-WINDOWED-NEXT:    l32r a8, .LCPI0_0
; CHECK-WINDOWED-NEXT:    callx8 a8
; CHECK-WINDOWED-NEXT:    movsp a1, a6
; CHECK-WINDOWED-NEXT:    retw

  %sp = call ptr @llvm.stacksave.p0()
  %addr = alloca i8, i64 %n
  call void @use_addr(ptr %addr)
  call void @llvm.stackrestore.p0(ptr %sp)
  ret void
}
