/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextprint.h>

        #include <wx/colour.h>
        #include <wx/font.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_Clear, "Clear()\n"
"\n"
"Clears all text.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_Copy, "Copy(data)\n"
"\n"
"Copies the data.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_Copy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_Copy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData* data;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxRichTextHeaderFooterData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Copy(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_Copy, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetFont, "GetFont() -> wx.Font\n"
"\n"
"Returns the font specified for printing the header and footer.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetFont(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetFont(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
             ::wxFont*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxFont(sipCpp->GetFont());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxFont,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetFooterMargin, "GetFooterMargin() -> int\n"
"\n"
"Returns the margin between the text and the footer.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetFooterMargin(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetFooterMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFooterMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetFooterMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetFooterText, "GetFooterText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String\n"
"\n"
"Returns the footer text on odd or even pages, and at a given position\n"
"on the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetFooterText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetFooterText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextOddEvenPage page = wxRICHTEXT_PAGE_EVEN;
         ::wxRichTextPageLocation location = wxRICHTEXT_PAGE_CENTRE;
        const  ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|EE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetFooterText(page,location));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetFooterText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetHeaderMargin, "GetHeaderMargin() -> int\n"
"\n"
"Returns the margin between the text and the header.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetHeaderMargin(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetHeaderMargin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHeaderMargin();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return SIPLong_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetHeaderMargin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetHeaderText, "GetHeaderText(page=RICHTEXT_PAGE_EVEN, location=RICHTEXT_PAGE_CENTRE) -> String\n"
"\n"
"Returns the header text on odd or even pages, and at a given position\n"
"on the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetHeaderText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetHeaderText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextOddEvenPage page = wxRICHTEXT_PAGE_EVEN;
         ::wxRichTextPageLocation location = wxRICHTEXT_PAGE_CENTRE;
        const  ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|EE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetHeaderText(page,location));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetHeaderText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetShowOnFirstPage, "GetShowOnFirstPage() -> bool\n"
"\n"
"Returns true if the header and footer will be shown on the first page.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetShowOnFirstPage(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetShowOnFirstPage(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetShowOnFirstPage();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetShowOnFirstPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetText, "GetText(headerFooter, page, location) -> String\n"
"\n"
"Helper function for getting the header or footer text, odd or even\n"
"pages, and at a given position on the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int headerFooter;
         ::wxRichTextOddEvenPage page;
         ::wxRichTextPageLocation location;
        const  ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_headerFooter,
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BiEE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, &headerFooter, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetText(headerFooter,page,location));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_GetTextColour, "GetTextColour() -> wx.Colour\n"
"\n"
"Returns the text colour for drawing the header and footer.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_GetTextColour(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_GetTextColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
             ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetTextColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_GetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_Init, "Init()\n"
"\n"
"Initialises the object.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_Init(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextHeaderFooterData *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_Init, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetFont, "SetFont(font)\n"
"\n"
"Sets the font for drawing the header and footer.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetFont(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetFont(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxFont* font;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_font,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxFont, &font))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFont(*font);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetFont, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetFooterText, "SetFooterText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)\n"
"\n"
"Sets the footer text on odd or even pages, and at a given position on\n"
"the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetFooterText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetFooterText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxRichTextOddEvenPage page = wxRICHTEXT_PAGE_ALL;
         ::wxRichTextPageLocation location = wxRICHTEXT_PAGE_CENTRE;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|EE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxString,&text, &textState, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFooterText(*text,page,location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetFooterText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetHeaderText, "SetHeaderText(text, page=RICHTEXT_PAGE_ALL, location=RICHTEXT_PAGE_CENTRE)\n"
"\n"
"Sets the header text on odd or even pages, and at a given position on\n"
"the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetHeaderText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetHeaderText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxRichTextOddEvenPage page = wxRICHTEXT_PAGE_ALL;
         ::wxRichTextPageLocation location = wxRICHTEXT_PAGE_CENTRE;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|EE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxString,&text, &textState, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHeaderText(*text,page,location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetHeaderText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetMargins, "SetMargins(headerMargin, footerMargin)\n"
"\n"
"Sets the margins between text and header or footer, in tenths of a\n"
"millimeter.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetMargins(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetMargins(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int headerMargin;
        int footerMargin;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_headerMargin,
            sipName_footerMargin,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, &headerMargin, &footerMargin))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMargins(headerMargin,footerMargin);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetMargins, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetShowOnFirstPage, "SetShowOnFirstPage(showOnFirstPage)\n"
"\n"
"Pass true to show the header or footer on first page (the default).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetShowOnFirstPage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetShowOnFirstPage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool showOnFirstPage;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_showOnFirstPage,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, &showOnFirstPage))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShowOnFirstPage(showOnFirstPage);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetShowOnFirstPage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetText, "SetText(text, headerFooter, page, location)\n"
"\n"
"Helper function for setting the header or footer text, odd or even\n"
"pages, and at a given position on the page (left, centre or right).");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* text;
        int textState = 0;
        int headerFooter;
         ::wxRichTextOddEvenPage page;
         ::wxRichTextPageLocation location;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
            sipName_headerFooter,
            sipName_page,
            sipName_location,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1iEE", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxString,&text, &textState, &headerFooter, sipType_wxRichTextOddEvenPage, &page, sipType_wxRichTextPageLocation, &location))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetText(*text,headerFooter,page,location);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextHeaderFooterData_SetTextColour, "SetTextColour(col)\n"
"\n"
"Sets the text colour for drawing the header and footer.");

extern "C" {static PyObject *meth_wxRichTextHeaderFooterData_SetTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextHeaderFooterData_SetTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxColour* col;
        int colState = 0;
         ::wxRichTextHeaderFooterData *sipCpp;

        static const char *sipKwdList[] = {
            sipName_col,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextHeaderFooterData, &sipCpp, sipType_wxColour, &col, &colState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetTextColour(*col);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(col),sipType_wxColour,colState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_RichTextHeaderFooterData, sipName_SetTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextHeaderFooterData(void *, const sipTypeDef *);}
static void *cast_wxRichTextHeaderFooterData(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxRichTextHeaderFooterData *sipCpp = reinterpret_cast< ::wxRichTextHeaderFooterData *>(sipCppV);

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return sipCppV;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextHeaderFooterData(void *, int);}
static void release_wxRichTextHeaderFooterData(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextHeaderFooterData *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void assign_wxRichTextHeaderFooterData(void *, SIP_SSIZE_T, void *);}
static void assign_wxRichTextHeaderFooterData(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextHeaderFooterData *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextHeaderFooterData *>(sipSrc);
}


extern "C" {static void *array_wxRichTextHeaderFooterData(SIP_SSIZE_T);}
static void *array_wxRichTextHeaderFooterData(SIP_SSIZE_T sipNrElem)
{
    return new  ::wxRichTextHeaderFooterData[sipNrElem];
}


extern "C" {static void *copy_wxRichTextHeaderFooterData(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextHeaderFooterData(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextHeaderFooterData(reinterpret_cast<const  ::wxRichTextHeaderFooterData *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextHeaderFooterData(sipSimpleWrapper *);}
static void dealloc_wxRichTextHeaderFooterData(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextHeaderFooterData(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextHeaderFooterData(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextHeaderFooterData(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextHeaderFooterData *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextHeaderFooterData();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextHeaderFooterData* data;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextHeaderFooterData, &data))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextHeaderFooterData(*data);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextHeaderFooterData[] = {{41, 0, 1}};


static PyMethodDef methods_wxRichTextHeaderFooterData[] = {
    {SIP_MLNAME_CAST(sipName_Clear), meth_wxRichTextHeaderFooterData_Clear, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_Clear)},
    {SIP_MLNAME_CAST(sipName_Copy), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_Copy), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_Copy)},
    {SIP_MLNAME_CAST(sipName_GetFont), meth_wxRichTextHeaderFooterData_GetFont, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetFont)},
    {SIP_MLNAME_CAST(sipName_GetFooterMargin), meth_wxRichTextHeaderFooterData_GetFooterMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetFooterMargin)},
    {SIP_MLNAME_CAST(sipName_GetFooterText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_GetFooterText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetFooterText)},
    {SIP_MLNAME_CAST(sipName_GetHeaderMargin), meth_wxRichTextHeaderFooterData_GetHeaderMargin, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetHeaderMargin)},
    {SIP_MLNAME_CAST(sipName_GetHeaderText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_GetHeaderText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetHeaderText)},
    {SIP_MLNAME_CAST(sipName_GetShowOnFirstPage), meth_wxRichTextHeaderFooterData_GetShowOnFirstPage, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetShowOnFirstPage)},
    {SIP_MLNAME_CAST(sipName_GetText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_GetText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetText)},
    {SIP_MLNAME_CAST(sipName_GetTextColour), meth_wxRichTextHeaderFooterData_GetTextColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_GetTextColour)},
    {SIP_MLNAME_CAST(sipName_Init), meth_wxRichTextHeaderFooterData_Init, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_Init)},
    {SIP_MLNAME_CAST(sipName_SetFont), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetFont), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetFont)},
    {SIP_MLNAME_CAST(sipName_SetFooterText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetFooterText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetFooterText)},
    {SIP_MLNAME_CAST(sipName_SetHeaderText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetHeaderText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetHeaderText)},
    {SIP_MLNAME_CAST(sipName_SetMargins), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetMargins), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetMargins)},
    {SIP_MLNAME_CAST(sipName_SetShowOnFirstPage), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetShowOnFirstPage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetShowOnFirstPage)},
    {SIP_MLNAME_CAST(sipName_SetText), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetText)},
    {SIP_MLNAME_CAST(sipName_SetTextColour), SIP_MLMETH_CAST(meth_wxRichTextHeaderFooterData_SetTextColour), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextHeaderFooterData_SetTextColour)}
};

sipVariableDef variables_wxRichTextHeaderFooterData[] = {
    {PropertyVariable, sipName_TextColour, &methods_wxRichTextHeaderFooterData[9], &methods_wxRichTextHeaderFooterData[17], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ShowOnFirstPage, &methods_wxRichTextHeaderFooterData[7], &methods_wxRichTextHeaderFooterData[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HeaderText, &methods_wxRichTextHeaderFooterData[6], &methods_wxRichTextHeaderFooterData[13], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HeaderMargin, &methods_wxRichTextHeaderFooterData[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FooterText, &methods_wxRichTextHeaderFooterData[4], &methods_wxRichTextHeaderFooterData[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_FooterMargin, &methods_wxRichTextHeaderFooterData[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Font, &methods_wxRichTextHeaderFooterData[2], &methods_wxRichTextHeaderFooterData[11], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextHeaderFooterData, "RichTextHeaderFooterData()\n"
"RichTextHeaderFooterData(data)\n"
"\n"
"This class represents header and footer data to be passed to the\n"
"wxRichTextPrinting and wxRichTextPrintout classes.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextHeaderFooterData = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextHeaderFooterData,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_RichTextHeaderFooterData,
        {0, 0, 1},
        18, methods_wxRichTextHeaderFooterData,
        0, SIP_NULLPTR,
        7, variables_wxRichTextHeaderFooterData,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextHeaderFooterData,
    -1,
    -1,
    supers_wxRichTextHeaderFooterData,
    SIP_NULLPTR,
    init_type_wxRichTextHeaderFooterData,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxRichTextHeaderFooterData,
    assign_wxRichTextHeaderFooterData,
    array_wxRichTextHeaderFooterData,
    copy_wxRichTextHeaderFooterData,
    release_wxRichTextHeaderFooterData,
    cast_wxRichTextHeaderFooterData,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
