/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNamedNodeMap.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNode.h"
#include "NamedNodeMap.h"
#include "Node.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNamedNodeMapTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNamedNodeMapLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNamedNodeMapConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNamedNodeMapTable = { 5, 3, JSNamedNodeMapTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSNamedNodeMapConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNamedNodeMapConstructorTable = { 1, 0, JSNamedNodeMapConstructorTableValues, 0 };
const ClassInfo JSNamedNodeMapConstructor::s_info = { "NamedNodeMapConstructor", &Base::s_info, &JSNamedNodeMapConstructorTable, 0, CREATE_METHOD_TABLE(JSNamedNodeMapConstructor) };

JSNamedNodeMapConstructor::JSNamedNodeMapConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSNamedNodeMapConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSNamedNodeMapPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSNamedNodeMapConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNamedNodeMapConstructor, JSDOMWrapper>(exec, &JSNamedNodeMapConstructorTable, jsCast<JSNamedNodeMapConstructor*>(cell), propertyName, slot);
}

bool JSNamedNodeMapConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSNamedNodeMapConstructor, JSDOMWrapper>(exec, &JSNamedNodeMapConstructorTable, jsCast<JSNamedNodeMapConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSNamedNodeMapPrototypeTableValues[] =
{
    { "getNamedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionGetNamedItem), (intptr_t)1, NoIntrinsic },
    { "setNamedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionSetNamedItem), (intptr_t)1, NoIntrinsic },
    { "removeNamedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionRemoveNamedItem), (intptr_t)1, NoIntrinsic },
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "getNamedItemNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionGetNamedItemNS), (intptr_t)2, NoIntrinsic },
    { "setNamedItemNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionSetNamedItemNS), (intptr_t)1, NoIntrinsic },
    { "removeNamedItemNS", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS), (intptr_t)2, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNamedNodeMapPrototypeTable = { 16, 15, JSNamedNodeMapPrototypeTableValues, 0 };
const ClassInfo JSNamedNodeMapPrototype::s_info = { "NamedNodeMapPrototype", &Base::s_info, &JSNamedNodeMapPrototypeTable, 0, CREATE_METHOD_TABLE(JSNamedNodeMapPrototype) };

JSObject* JSNamedNodeMapPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNamedNodeMap>(exec, globalObject);
}

bool JSNamedNodeMapPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNamedNodeMapPrototype* thisObject = jsCast<JSNamedNodeMapPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNamedNodeMapPrototypeTable, thisObject, propertyName, slot);
}

bool JSNamedNodeMapPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNamedNodeMapPrototype* thisObject = jsCast<JSNamedNodeMapPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNamedNodeMapPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNamedNodeMap::s_info = { "NamedNodeMap", &Base::s_info, &JSNamedNodeMapTable, 0 , CREATE_METHOD_TABLE(JSNamedNodeMap) };

JSNamedNodeMap::JSNamedNodeMap(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NamedNodeMap> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNamedNodeMap::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNamedNodeMap::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNamedNodeMapPrototype::create(exec->globalData(), globalObject, JSNamedNodeMapPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSNamedNodeMap::destroy(JSC::JSCell* cell)
{
    JSNamedNodeMap* thisObject = static_cast<JSNamedNodeMap*>(cell);
    thisObject->JSNamedNodeMap::~JSNamedNodeMap();
}

JSNamedNodeMap::~JSNamedNodeMap()
{
    releaseImplIfNotNull();
}

bool JSNamedNodeMap::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNamedNodeMap* thisObject = jsCast<JSNamedNodeMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSNamedNodeMap>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<NamedNodeMap*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NamedNodeMap*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSNamedNodeMap, Base>(exec, &JSNamedNodeMapTable, thisObject, propertyName, slot);
}

bool JSNamedNodeMap::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNamedNodeMap* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    JSValue proto = thisObject->prototype();
    if (proto.isObject() && jsCast<JSObject*>(asObject(proto))->hasProperty(exec, propertyName))
        return false;

    const HashEntry* entry = JSNamedNodeMapTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<NamedNodeMap*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<NamedNodeMap*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSNamedNodeMap, Base>(exec, &JSNamedNodeMapTable, thisObject, propertyName, descriptor);
}

bool JSNamedNodeMap::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSNamedNodeMap* thisObject = jsCast<JSNamedNodeMap*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<NamedNodeMap*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<NamedNodeMap*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsNamedNodeMapLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsNamedNodeMapConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNamedNodeMap* domObject = jsCast<JSNamedNodeMap*>(asObject(slotBase));
    return JSNamedNodeMap::getConstructor(exec, domObject->globalObject());
}

void JSNamedNodeMap::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSNamedNodeMap* thisObject = jsCast<JSNamedNodeMap*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<NamedNodeMap*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSNamedNodeMap::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNamedNodeMapConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getNamedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->setNamedItem(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& name(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeNamedItem(name, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionGetNamedItemNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getNamedItemNS(namespaceURI, localName)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionSetNamedItemNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    ExceptionCode ec = 0;
    Node* node(toNode(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->setNamedItemNS(node, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNamedNodeMapPrototypeFunctionRemoveNamedItemNS(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNamedNodeMap::s_info))
        return throwVMTypeError(exec);
    JSNamedNodeMap* castedThis = jsCast<JSNamedNodeMap*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNamedNodeMap::s_info);
    NamedNodeMap* impl = static_cast<NamedNodeMap*>(castedThis->impl());
    ExceptionCode ec = 0;
    const String& namespaceURI(valueToStringWithNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& localName(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->removeNamedItemNS(namespaceURI, localName, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


JSValue JSNamedNodeMap::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSNamedNodeMap* thisObj = jsCast<JSNamedNodeMap*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<NamedNodeMap*>(thisObj->impl())->item(index));
}

static inline bool isObservable(JSNamedNodeMap* jsNamedNodeMap)
{
    if (jsNamedNodeMap->hasCustomProperties())
        return true;
    return false;
}

bool JSNamedNodeMapOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNamedNodeMap* jsNamedNodeMap = jsCast<JSNamedNodeMap*>(handle.get().asCell());
    if (!isObservable(jsNamedNodeMap))
        return false;
    Element* element = jsNamedNodeMap->impl()->element();
    if (!element)
        return false;
    void* root = WebCore::root(element);
    return visitor.containsOpaqueRoot(root);
}

void JSNamedNodeMapOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNamedNodeMap* jsNamedNodeMap = jsCast<JSNamedNodeMap*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNamedNodeMap->impl(), jsNamedNodeMap);
    jsNamedNodeMap->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NamedNodeMap* impl)
{
    return wrap<JSNamedNodeMap>(exec, globalObject, impl);
}

NamedNodeMap* toNamedNodeMap(JSC::JSValue value)
{
    return value.inherits(&JSNamedNodeMap::s_info) ? jsCast<JSNamedNodeMap*>(asObject(value))->impl() : 0;
}

}
