/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLCanvasElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCanvasElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLCanvasElement* kit(WebCore::HTMLCanvasElement* obj)
{
    return WEBKIT_DOM_HTML_CANVAS_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLCanvasElement* core(WebKitDOMHTMLCanvasElement* request)
{
    return request ? static_cast<WebCore::HTMLCanvasElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLCanvasElement* wrapHTMLCanvasElement(WebCore::HTMLCanvasElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_CANVAS_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_CANVAS_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLCanvasElement, webkit_dom_html_canvas_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_WIDTH,
    PROP_HEIGHT,
};

static void webkit_dom_html_canvas_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLCanvasElement* self = WEBKIT_DOM_HTML_CANVAS_ELEMENT(object);
    WebCore::HTMLCanvasElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_WIDTH: {
        coreSelf->setWidth((g_value_get_long(value)));
        break;
    }
    case PROP_HEIGHT: {
        coreSelf->setHeight((g_value_get_long(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_canvas_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLCanvasElement* self = WEBKIT_DOM_HTML_CANVAS_ELEMENT(object);
    WebCore::HTMLCanvasElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->width());
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_long(value, coreSelf->height());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_canvas_element_class_init(WebKitDOMHTMLCanvasElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_canvas_element_set_property;
    gobjectClass->get_property = webkit_dom_html_canvas_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_canvas_element_width", /* short description */
                                                           "read-write  glong HTMLCanvasElement.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_long("height", /* name */
                                                           "html_canvas_element_height", /* short description */
                                                           "read-write  glong HTMLCanvasElement.height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_canvas_element_init(WebKitDOMHTMLCanvasElement* request)
{
}

glong
webkit_dom_html_canvas_element_get_width(WebKitDOMHTMLCanvasElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_CANVAS_ELEMENT(self), 0);
    WebCore::HTMLCanvasElement* item = WebKit::core(self);
    glong result = item->width();
    return result;
}

void
webkit_dom_html_canvas_element_set_width(WebKitDOMHTMLCanvasElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_CANVAS_ELEMENT(self));
    WebCore::HTMLCanvasElement* item = WebKit::core(self);
    item->setWidth(value);
}

glong
webkit_dom_html_canvas_element_get_height(WebKitDOMHTMLCanvasElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_CANVAS_ELEMENT(self), 0);
    WebCore::HTMLCanvasElement* item = WebKit::core(self);
    glong result = item->height();
    return result;
}

void
webkit_dom_html_canvas_element_set_height(WebKitDOMHTMLCanvasElement* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_CANVAS_ELEMENT(self));
    WebCore::HTMLCanvasElement* item = WebKit::core(self);
    item->setHeight(value);
}

