/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMediaError.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMMediaErrorPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_MEDIA_ERROR_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_MEDIA_ERROR, WebKitDOMMediaErrorPrivate)

typedef struct _WebKitDOMMediaErrorPrivate {
#if ENABLE(VIDEO)
    RefPtr<WebCore::MediaError> coreObject;
#endif // ENABLE(VIDEO)
} WebKitDOMMediaErrorPrivate;

#if ENABLE(VIDEO)

namespace WebKit {

WebKitDOMMediaError* kit(WebCore::MediaError* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_MEDIA_ERROR(ret);

    return wrapMediaError(obj);
}

WebCore::MediaError* core(WebKitDOMMediaError* request)
{
    return request ? static_cast<WebCore::MediaError*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMediaError* wrapMediaError(WebCore::MediaError* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MEDIA_ERROR(g_object_new(WEBKIT_TYPE_DOM_MEDIA_ERROR, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(VIDEO)

G_DEFINE_TYPE(WebKitDOMMediaError, webkit_dom_media_error, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_CODE,
};

static void webkit_dom_media_error_finalize(GObject* object)
{
    WebKitDOMMediaErrorPrivate* priv = WEBKIT_DOM_MEDIA_ERROR_GET_PRIVATE(object);
#if ENABLE(VIDEO)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(VIDEO)
    priv->~WebKitDOMMediaErrorPrivate();
    G_OBJECT_CLASS(webkit_dom_media_error_parent_class)->finalize(object);
}

static void webkit_dom_media_error_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
#if ENABLE(VIDEO)
    WebKitDOMMediaError* self = WEBKIT_DOM_MEDIA_ERROR(object);
    WebCore::MediaError* coreSelf = WebKit::core(self);
#endif // ENABLE(VIDEO)
    switch (propertyId) {
    case PROP_CODE: {
#if ENABLE(VIDEO)
        g_value_set_uint(value, coreSelf->code());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
#endif /* ENABLE(VIDEO) */
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_media_error_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_media_error_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(VIDEO)
    WebKitDOMMediaErrorPrivate* priv = WEBKIT_DOM_MEDIA_ERROR_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::MediaError*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(VIDEO)
    return object;
}

static void webkit_dom_media_error_class_init(WebKitDOMMediaErrorClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMMediaErrorPrivate));
    gobjectClass->constructor = webkit_dom_media_error_constructor;
    gobjectClass->finalize = webkit_dom_media_error_finalize;
    gobjectClass->get_property = webkit_dom_media_error_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CODE,
                                    g_param_spec_uint("code", /* name */
                                                           "media_error_code", /* short description */
                                                           "read-only  gushort MediaError.code", /* longer - could do with some extra doc stuff here */
                                                           0, /* min */
G_MAXUINT, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_media_error_init(WebKitDOMMediaError* request)
{
    WebKitDOMMediaErrorPrivate* priv = WEBKIT_DOM_MEDIA_ERROR_GET_PRIVATE(request);
    new (priv) WebKitDOMMediaErrorPrivate();
}

gushort
webkit_dom_media_error_get_code(WebKitDOMMediaError* self)
{
#if ENABLE(VIDEO)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_MEDIA_ERROR(self), 0);
    WebCore::MediaError* item = WebKit::core(self);
    gushort result = item->code();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Video")
    return static_cast<gushort>(0);
#endif /* ENABLE(VIDEO) */
}

