/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLBRElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLBRElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLBRElement* kit(WebCore::HTMLBRElement* obj)
{
    return WEBKIT_DOM_HTMLBR_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLBRElement* core(WebKitDOMHTMLBRElement* request)
{
    return request ? static_cast<WebCore::HTMLBRElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLBRElement* wrapHTMLBRElement(WebCore::HTMLBRElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTMLBR_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTMLBR_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLBRElement, webkit_dom_htmlbr_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CLEAR,
};

static void webkit_dom_htmlbr_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLBRElement* self = WEBKIT_DOM_HTMLBR_ELEMENT(object);
    WebCore::HTMLBRElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CLEAR: {
        coreSelf->setAttribute(WebCore::HTMLNames::clearAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlbr_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLBRElement* self = WEBKIT_DOM_HTMLBR_ELEMENT(object);
    WebCore::HTMLBRElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CLEAR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::clearAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_htmlbr_element_class_init(WebKitDOMHTMLBRElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_htmlbr_element_set_property;
    gobjectClass->get_property = webkit_dom_htmlbr_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CLEAR,
                                    g_param_spec_string("clear", /* name */
                                                           "htmlbr_element_clear", /* short description */
                                                           "read-write  gchar* HTMLBRElement.clear", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_htmlbr_element_init(WebKitDOMHTMLBRElement* request)
{
}

gchar*
webkit_dom_htmlbr_element_get_clear(WebKitDOMHTMLBRElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTMLBR_ELEMENT(self), 0);
    WebCore::HTMLBRElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::clearAttr));
    return result;
}

void
webkit_dom_htmlbr_element_set_clear(WebKitDOMHTMLBRElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTMLBR_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLBRElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::clearAttr, convertedValue);
}

