/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLOptionsCollection.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLOptionsCollectionPrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLOptionsCollection* kit(WebCore::HTMLOptionsCollection* obj)
{
    return WEBKIT_DOM_HTML_OPTIONS_COLLECTION(kit(static_cast<WebCore::HTMLCollection*>(obj)));
}

WebCore::HTMLOptionsCollection* core(WebKitDOMHTMLOptionsCollection* request)
{
    return request ? static_cast<WebCore::HTMLOptionsCollection*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLOptionsCollection* wrapHTMLOptionsCollection(WebCore::HTMLOptionsCollection* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_OPTIONS_COLLECTION(g_object_new(WEBKIT_TYPE_DOM_HTML_OPTIONS_COLLECTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLOptionsCollection, webkit_dom_html_options_collection, WEBKIT_TYPE_DOM_HTML_COLLECTION)

enum {
    PROP_0,
    PROP_SELECTED_INDEX,
};

static void webkit_dom_html_options_collection_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptionsCollection* self = WEBKIT_DOM_HTML_OPTIONS_COLLECTION(object);
    WebCore::HTMLOptionsCollection* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_SELECTED_INDEX: {
        coreSelf->setSelectedIndex((g_value_get_long(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_options_collection_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLOptionsCollection* self = WEBKIT_DOM_HTML_OPTIONS_COLLECTION(object);
    WebCore::HTMLOptionsCollection* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_SELECTED_INDEX: {
        g_value_set_long(value, coreSelf->selectedIndex());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_options_collection_class_init(WebKitDOMHTMLOptionsCollectionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_options_collection_set_property;
    gobjectClass->get_property = webkit_dom_html_options_collection_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_SELECTED_INDEX,
                                    g_param_spec_long("selected-index", /* name */
                                                           "html_options_collection_selected-index", /* short description */
                                                           "read-write  glong HTMLOptionsCollection.selected-index", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_options_collection_init(WebKitDOMHTMLOptionsCollection* request)
{
}

glong
webkit_dom_html_options_collection_get_selected_index(WebKitDOMHTMLOptionsCollection* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_OPTIONS_COLLECTION(self), 0);
    WebCore::HTMLOptionsCollection* item = WebKit::core(self);
    glong result = item->selectedIndex();
    return result;
}

void
webkit_dom_html_options_collection_set_selected_index(WebKitDOMHTMLOptionsCollection* self, glong value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_OPTIONS_COLLECTION(self));
    WebCore::HTMLOptionsCollection* item = WebKit::core(self);
    item->setSelectedIndex(value);
}

