/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLStyleElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLStyleElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMStyleSheetPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLStyleElement* kit(WebCore::HTMLStyleElement* obj)
{
    return WEBKIT_DOM_HTML_STYLE_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLStyleElement* core(WebKitDOMHTMLStyleElement* request)
{
    return request ? static_cast<WebCore::HTMLStyleElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLStyleElement* wrapHTMLStyleElement(WebCore::HTMLStyleElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_STYLE_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_STYLE_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLStyleElement, webkit_dom_html_style_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_DISABLED,
    PROP_SCOPED,
    PROP_MEDIA,
    PROP_TYPE,
    PROP_SHEET,
};

static void webkit_dom_html_style_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLStyleElement* self = WEBKIT_DOM_HTML_STYLE_ELEMENT(object);
    WebCore::HTMLStyleElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        coreSelf->setDisabled((g_value_get_boolean(value)));
        break;
    }
    case PROP_SCOPED: {
#if ENABLE(STYLE_SCOPED)
        coreSelf->setScoped((g_value_get_boolean(value)));
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Style Scoped")
#endif /* ENABLE(STYLE_SCOPED) */
        break;
    }
    case PROP_MEDIA: {
        coreSelf->setAttribute(WebCore::HTMLNames::mediaAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_TYPE: {
        coreSelf->setAttribute(WebCore::HTMLNames::typeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_style_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLStyleElement* self = WEBKIT_DOM_HTML_STYLE_ELEMENT(object);
    WebCore::HTMLStyleElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DISABLED: {
        g_value_set_boolean(value, coreSelf->disabled());
        break;
    }
    case PROP_SCOPED: {
#if ENABLE(STYLE_SCOPED)
        g_value_set_boolean(value, coreSelf->scoped());
#else
        WEBKIT_WARN_FEATURE_NOT_PRESENT("Style Scoped")
#endif /* ENABLE(STYLE_SCOPED) */
        break;
    }
    case PROP_MEDIA: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::mediaAttr)));
        break;
    }
    case PROP_TYPE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::typeAttr)));
        break;
    }
    case PROP_SHEET: {
        RefPtr<WebCore::StyleSheet> ptr = coreSelf->sheet();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_style_element_class_init(WebKitDOMHTMLStyleElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_style_element_set_property;
    gobjectClass->get_property = webkit_dom_html_style_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_DISABLED,
                                    g_param_spec_boolean("disabled", /* name */
                                                           "html_style_element_disabled", /* short description */
                                                           "read-write  gboolean HTMLStyleElement.disabled", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCOPED,
                                    g_param_spec_boolean("scoped", /* name */
                                                           "html_style_element_scoped", /* short description */
                                                           "read-write  gboolean HTMLStyleElement.scoped", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_MEDIA,
                                    g_param_spec_string("media", /* name */
                                                           "html_style_element_media", /* short description */
                                                           "read-write  gchar* HTMLStyleElement.media", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_TYPE,
                                    g_param_spec_string("type", /* name */
                                                           "html_style_element_type", /* short description */
                                                           "read-write  gchar* HTMLStyleElement.type", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SHEET,
                                    g_param_spec_object("sheet", /* name */
                                                           "html_style_element_sheet", /* short description */
                                                           "read-only  WebKitDOMStyleSheet* HTMLStyleElement.sheet", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_STYLE_SHEET, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_html_style_element_init(WebKitDOMHTMLStyleElement* request)
{
}

gboolean
webkit_dom_html_style_element_get_disabled(WebKitDOMHTMLStyleElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self), FALSE);
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    gboolean result = item->disabled();
    return result;
}

void
webkit_dom_html_style_element_set_disabled(WebKitDOMHTMLStyleElement* self, gboolean value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self));
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    item->setDisabled(value);
}

gboolean
webkit_dom_html_style_element_get_scoped(WebKitDOMHTMLStyleElement* self)
{
#if ENABLE(STYLE_SCOPED)
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self), FALSE);
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    gboolean result = item->scoped();
    return result;
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Style Scoped")
    return static_cast<gboolean>(0);
#endif /* ENABLE(STYLE_SCOPED) */
}

void
webkit_dom_html_style_element_set_scoped(WebKitDOMHTMLStyleElement* self, gboolean value)
{
#if ENABLE(STYLE_SCOPED)
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self));
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    item->setScoped(value);
#else
    WEBKIT_WARN_FEATURE_NOT_PRESENT("Style Scoped")
#endif /* ENABLE(STYLE_SCOPED) */
}

gchar*
webkit_dom_html_style_element_get_media(WebKitDOMHTMLStyleElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self), 0);
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::mediaAttr));
    return result;
}

void
webkit_dom_html_style_element_set_media(WebKitDOMHTMLStyleElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::mediaAttr, convertedValue);
}

WebKitDOMStyleSheet*
webkit_dom_html_style_element_get_sheet(WebKitDOMHTMLStyleElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_STYLE_ELEMENT(self), 0);
    WebCore::HTMLStyleElement* item = WebKit::core(self);
    RefPtr<WebCore::StyleSheet> gobjectResult = WTF::getPtr(item->sheet());
    return WebKit::kit(gobjectResult.get());
}

