/* event.c generated by valac 0.38.8, the Vala compiler
 * generated from event.vala, do not modify */

/* event.vala
 *
 * Copyright © 2011-2012 Collabora Ltd.
 *             By Seif Lotfy <seif@lotfy.com>
 *             By Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com>
 * Copyright © 2011 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright © 2011 Michal Hruby <michal.mhr@gmail.com>
 * Copyright © 2012 Canonical Ltd.
 *             By Siegfried-A. Gevatter <siegfried.gevatter@collabora.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <gio/gdesktopappinfo.h>
#include <stdio.h>

#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define ZEITGEIST_TYPE_EVENT (zeitgeist_event_get_type ())
#define ZEITGEIST_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEvent))
#define ZEITGEIST_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))
#define ZEITGEIST_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_EVENT))
#define ZEITGEIST_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_EVENT, ZeitgeistEventClass))

typedef struct _ZeitgeistEvent ZeitgeistEvent;
typedef struct _ZeitgeistEventClass ZeitgeistEventClass;
typedef struct _ZeitgeistEventPrivate ZeitgeistEventPrivate;

#define ZEITGEIST_TYPE_SUBJECT (zeitgeist_subject_get_type ())
#define ZEITGEIST_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubject))
#define ZEITGEIST_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))
#define ZEITGEIST_IS_SUBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_IS_SUBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SUBJECT))
#define ZEITGEIST_SUBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SUBJECT, ZeitgeistSubjectClass))

typedef struct _ZeitgeistSubject ZeitgeistSubject;
typedef struct _ZeitgeistSubjectClass ZeitgeistSubjectClass;
enum  {
	ZEITGEIST_EVENT_0_PROPERTY,
	ZEITGEIST_EVENT_ID_PROPERTY,
	ZEITGEIST_EVENT_TIMESTAMP_PROPERTY,
	ZEITGEIST_EVENT_ORIGIN_PROPERTY,
	ZEITGEIST_EVENT_ACTOR_PROPERTY,
	ZEITGEIST_EVENT_INTERPRETATION_PROPERTY,
	ZEITGEIST_EVENT_MANIFESTATION_PROPERTY,
	ZEITGEIST_EVENT_SUBJECTS_PROPERTY,
	ZEITGEIST_EVENT_PAYLOAD_PROPERTY,
	ZEITGEIST_EVENT_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_event_properties[ZEITGEIST_EVENT_NUM_PROPERTIES];
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_byte_array_unref0(var) ((var == NULL) ? NULL : (var = (g_byte_array_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_string_chunk_free0(var) ((var == NULL) ? NULL : (var = (g_string_chunk_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ZeitgeistEvent {
	GObject parent_instance;
	ZeitgeistEventPrivate * priv;
};

struct _ZeitgeistEventClass {
	GObjectClass parent_class;
};

struct _ZeitgeistEventPrivate {
	guint32 _id;
	gint64 _timestamp;
	gchar* _origin;
	const gchar* _actor;
	const gchar* _interpretation;
	const gchar* _manifestation;
	GPtrArray* _subjects;
	GByteArray* _payload;
};

typedef enum  {
	ZEITGEIST_DATA_MODEL_ERROR_INVALID_SIGNATURE,
	ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT,
	ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS
} ZeitgeistDataModelError;
#define ZEITGEIST_DATA_MODEL_ERROR zeitgeist_data_model_error_quark ()

static gpointer zeitgeist_event_parent_class = NULL;
static GStringChunk* zeitgeist_event_url_store;
static GStringChunk* zeitgeist_event_url_store = NULL;

gchar* zeitgeist_next_string_or_null (GVariantIter* iter);
gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard);
gboolean zeitgeist_utils_parse_negation (gchar* * val);
gboolean zeitgeist_utils_is_empty_string (const gchar* s);
GList* zeitgeist_symbol_get_all_parents (const gchar* symbol_uri);
gboolean zeitgeist_utils_parse_wildcard (gchar* * val);
GType zeitgeist_event_get_type (void) G_GNUC_CONST;
GType zeitgeist_subject_get_type (void) G_GNUC_CONST;
#define ZEITGEIST_EVENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZEITGEIST_TYPE_EVENT, ZeitgeistEventPrivate))
#define ZEITGEIST_EVENT_SIGNATURE "asaasay"
ZeitgeistSubject* zeitgeist_event_get_subject (ZeitgeistEvent* self, gint index);
GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self);
gint zeitgeist_event_num_subjects (ZeitgeistEvent* self);
void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
void zeitgeist_event_take_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject);
ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...);
ZeitgeistEvent* zeitgeist_event_constructv_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, va_list _vala_va_list);
void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value);
void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value);
GQuark zeitgeist_data_model_error_quark (void);
ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant, GError** error);
ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant, GError** error);
void zeitgeist_utils_assert_sig (gboolean condition, const gchar* error_message, GError** error);
#define ZEITGEIST_UTILS_SIG_EVENT "asaasay"
void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value);
void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value);
gint64 zeitgeist_timestamp_from_now (void);
ZeitgeistSubject* zeitgeist_subject_new_from_variant (GVariant* subject_variant, GError** error);
ZeitgeistSubject* zeitgeist_subject_construct_from_variant (GType object_type, GVariant* subject_variant, GError** error);
void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value);
GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self);
void zeitgeist_event_set_actor_from_app_info (ZeitgeistEvent* self, GAppInfo* info);
GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self);
guint32 zeitgeist_event_get_id (ZeitgeistEvent* self);
gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self);
const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self);
GVariant* zeitgeist_subject_to_variant (ZeitgeistSubject* self);
static GVariant* zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self, GVariant* event_variant);
void zeitgeist_event_debug_print (ZeitgeistEvent* self);
const gchar* zeitgeist_subject_get_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_interpretation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_manifestation (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_mimetype (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_text (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_uri (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_current_origin (ZeitgeistSubject* self);
const gchar* zeitgeist_subject_get_storage (ZeitgeistSubject* self);
gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event);
gboolean zeitgeist_subject_matches_template (ZeitgeistSubject* self, ZeitgeistSubject* template_subject);
ZeitgeistEvent* zeitgeist_event_new (void);
ZeitgeistEvent* zeitgeist_event_construct (GType object_type);
void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value);
static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void zeitgeist_event_finalize (GObject * obj);
static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error);
GVariant* zeitgeist_events_to_variant (GPtrArray* events);
GVariant* zeitgeist_events_get_null_event_variant (void);
GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error);


gchar* zeitgeist_next_string_or_null (GVariantIter* iter) {
	gchar* result = NULL;
	gchar* text = NULL;
	GVariantIter* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = iter;
	_tmp1_ = g_variant_iter_next_value (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_string (_tmp2_, NULL);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_variant_unref0 (_tmp2_);
	text = _tmp5_;
	_tmp6_ = text;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		result = text;
		return result;
	}
	result = NULL;
	_g_free0 (text);
	return result;
}


gboolean zeitgeist_check_field_match (const gchar* property, const gchar* template_property, gboolean is_symbol, gboolean can_wildcard) {
	gboolean result = FALSE;
	gboolean matches = FALSE;
	gboolean is_negated = FALSE;
	gchar* parsed = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_;
	matches = FALSE;
	is_negated = FALSE;
	_tmp0_ = template_property;
	_tmp1_ = g_strdup (_tmp0_);
	parsed = _tmp1_;
	_tmp2_ = parsed;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_;
		_tmp3_ = zeitgeist_utils_parse_negation (&parsed);
		is_negated = _tmp3_;
	}
	_tmp4_ = parsed;
	_tmp5_ = zeitgeist_utils_is_empty_string (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		_g_free0 (parsed);
		return result;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = parsed;
		_tmp7_ = property;
		if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
			matches = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_;
			_tmp10_ = is_symbol;
			if (_tmp10_) {
				const gchar* _tmp11_;
				_tmp11_ = property;
				_tmp9_ = _tmp11_ != NULL;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				const gchar* _tmp12_;
				GList* _tmp13_;
				GList* _tmp14_;
				const gchar* _tmp15_;
				GCompareFunc _tmp16_;
				GList* _tmp17_;
				_tmp12_ = property;
				_tmp13_ = zeitgeist_symbol_get_all_parents (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = parsed;
				_tmp16_ = g_strcmp0;
				_tmp17_ = g_list_find_custom (_tmp14_, _tmp15_, _tmp16_);
				_tmp8_ = _tmp17_ != NULL;
				_g_list_free0 (_tmp14_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				matches = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_;
				_tmp19_ = can_wildcard;
				if (_tmp19_) {
					gboolean _tmp20_;
					_tmp20_ = zeitgeist_utils_parse_wildcard (&parsed);
					_tmp18_ = _tmp20_;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_;
					_tmp22_ = property;
					if (_tmp22_ != NULL) {
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						gboolean _tmp25_;
						_tmp23_ = property;
						_tmp24_ = parsed;
						_tmp25_ = g_str_has_prefix (_tmp23_, _tmp24_);
						_tmp21_ = _tmp25_;
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						matches = TRUE;
					}
				}
			}
		}
	}
	_tmp27_ = is_negated;
	if (_tmp27_) {
		gboolean _tmp28_;
		_tmp28_ = matches;
		_tmp26_ = !_tmp28_;
	} else {
		gboolean _tmp29_;
		_tmp29_ = matches;
		_tmp26_ = _tmp29_;
	}
	result = _tmp26_;
	_g_free0 (parsed);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ZeitgeistSubject* zeitgeist_event_get_subject (ZeitgeistEvent* self, gint index) {
	ZeitgeistSubject* result = NULL;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gconstpointer _tmp2_;
	ZeitgeistSubject* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = index;
	_tmp2_ = g_ptr_array_index (_tmp0_, (guint) _tmp1_);
	_tmp3_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp2_);
	result = _tmp3_;
	return result;
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


gint zeitgeist_event_num_subjects (ZeitgeistEvent* self) {
	gint result = 0;
	GPtrArray* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = g_ptr_array_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


void zeitgeist_event_add_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	ZeitgeistSubject* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	g_ptr_array_add (_tmp0_, _tmp2_);
}


void zeitgeist_event_take_subject (ZeitgeistEvent* self, ZeitgeistSubject* subject) {
	GPtrArray* _tmp0_;
	ZeitgeistSubject* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (subject != NULL);
	_tmp0_ = self->priv->_subjects;
	_tmp1_ = subject;
	subject = NULL;
	g_ptr_array_add (_tmp0_, _tmp1_);
	_g_object_unref0 (subject);
}


ZeitgeistEvent* zeitgeist_event_constructv_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, va_list _vala_va_list) {
	ZeitgeistEvent * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	va_list subjects = {0};
	ZeitgeistSubject* subject = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = interpretation;
	zeitgeist_event_set_interpretation (self, _tmp0_);
	_tmp1_ = manifestation;
	zeitgeist_event_set_manifestation (self, _tmp1_);
	_tmp2_ = actor;
	zeitgeist_event_set_actor (self, _tmp2_);
	_tmp3_ = origin;
	zeitgeist_event_set_origin (self, _tmp3_);
	va_copy (subjects, _vala_va_list);
	while (TRUE) {
		ZeitgeistSubject* _tmp4_;
		ZeitgeistSubject* _tmp5_;
		ZeitgeistSubject* _tmp6_;
		_tmp4_ = va_arg (subjects, ZeitgeistSubject*);
		subject = _tmp4_;
		_tmp5_ = subject;
		if (!(_tmp5_ != NULL)) {
			break;
		}
		_tmp6_ = subject;
		zeitgeist_event_add_subject (self, _tmp6_);
	}
	va_end (subjects);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new_full (const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...) {
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, origin);
	return zeitgeist_event_constructv_full (ZEITGEIST_TYPE_EVENT, interpretation, manifestation, actor, origin, _vala_va_list_obj);
}


ZeitgeistEvent* zeitgeist_event_construct_full (GType object_type, const gchar* interpretation, const gchar* manifestation, const gchar* actor, const gchar* origin, ...) {
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, origin);
	return zeitgeist_event_constructv_full (object_type, interpretation, manifestation, actor, origin, _vala_va_list_obj);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	const gchar* _tmp0_;
	guint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoull (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


static gint64 int64_parse (const gchar* str) {
	gint64 result = 0LL;
	const gchar* _tmp0_;
	gint64 _tmp1_;
	g_return_val_if_fail (str != NULL, 0LL);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtoll (_tmp0_, NULL, (guint) 0);
	result = _tmp1_;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct_from_variant (GType object_type, GVariant* event_variant, GError** error) {
	ZeitgeistEvent * self = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_;
	GVariantIter* iter = NULL;
	GVariant* _tmp2_;
	GVariantIter* _tmp3_;
	GVariantIter* _tmp4_;
	gsize _tmp5_;
	GVariantIter* event_array = NULL;
	GVariantIter* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariantIter* _tmp9_;
	GVariantIter* _tmp10_;
	GVariantIter* subjects_array = NULL;
	GVariantIter* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariantIter* _tmp14_;
	GVariantIter* _tmp15_;
	GVariant* payload_variant = NULL;
	GVariantIter* _tmp16_;
	GVariant* _tmp17_;
	gsize event_props = 0UL;
	GVariantIter* _tmp18_;
	gsize _tmp19_;
	gsize _tmp20_;
	gsize _tmp22_;
	GVariantIter* _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	const gchar* _tmp26_;
	guint64 _tmp27_;
	gchar* str_timestamp = NULL;
	GVariantIter* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	GVariantIter* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GVariantIter* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GVariantIter* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gsize _tmp47_;
	guint payload_length = 0U;
	GVariant* _tmp63_;
	gsize _tmp64_;
	guint _tmp65_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (event_variant != NULL, NULL);
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	_tmp0_ = event_variant;
	_tmp1_ = g_variant_get_type_string (_tmp0_);
	zeitgeist_utils_assert_sig (g_strcmp0 (_tmp1_, "(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0, "Invalid D-Bus signature.", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = event_variant;
	_tmp3_ = g_variant_iter_new (_tmp2_);
	iter = _tmp3_;
	_tmp4_ = iter;
	_tmp5_ = g_variant_iter_n_children (_tmp4_);
	zeitgeist_utils_assert_sig (_tmp5_ >= ((gsize) 3), "Incomplete event struct.", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp6_ = iter;
	_tmp7_ = g_variant_iter_next_value (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_variant_iter_new (_tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_unref0 (_tmp8_);
	event_array = _tmp10_;
	_tmp11_ = iter;
	_tmp12_ = g_variant_iter_next_value (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_variant_iter_new (_tmp13_);
	_tmp15_ = _tmp14_;
	_g_variant_unref0 (_tmp13_);
	subjects_array = _tmp15_;
	_tmp16_ = iter;
	_tmp17_ = g_variant_iter_next_value (_tmp16_);
	payload_variant = _tmp17_;
	_tmp18_ = event_array;
	_tmp19_ = g_variant_iter_n_children (_tmp18_);
	event_props = _tmp19_;
	_tmp20_ = event_props;
	if (_tmp20_ == ((gsize) 0)) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT, "This is an empty event.");
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp22_ = event_props;
	zeitgeist_utils_assert_sig (_tmp22_ >= ((gsize) 5), "Missing event information.", &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_variant_unref0 (payload_variant);
			_g_variant_iter_free0 (subjects_array);
			_g_variant_iter_free0 (event_array);
			_g_variant_iter_free0 (iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp23_ = event_array;
	_tmp24_ = g_variant_iter_next_value (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_variant_get_string (_tmp25_, NULL);
	_tmp27_ = uint64_parse (_tmp26_);
	zeitgeist_event_set_id (self, (guint32) _tmp27_);
	_g_variant_unref0 (_tmp25_);
	_tmp28_ = event_array;
	_tmp29_ = g_variant_iter_next_value (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_variant_get_string (_tmp30_, NULL);
	_tmp32_ = g_strdup (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_variant_unref0 (_tmp30_);
	str_timestamp = _tmp33_;
	_tmp34_ = str_timestamp;
	if (g_strcmp0 (_tmp34_, "") != 0) {
		const gchar* _tmp35_;
		gint64 _tmp36_;
		_tmp35_ = str_timestamp;
		_tmp36_ = int64_parse (_tmp35_);
		zeitgeist_event_set_timestamp (self, _tmp36_);
	} else {
		gint64 _tmp37_;
		_tmp37_ = zeitgeist_timestamp_from_now ();
		zeitgeist_event_set_timestamp (self, _tmp37_);
	}
	_tmp38_ = event_array;
	_tmp39_ = zeitgeist_next_string_or_null (_tmp38_);
	_tmp40_ = _tmp39_;
	zeitgeist_event_set_interpretation (self, _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = event_array;
	_tmp42_ = zeitgeist_next_string_or_null (_tmp41_);
	_tmp43_ = _tmp42_;
	zeitgeist_event_set_manifestation (self, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = event_array;
	_tmp45_ = zeitgeist_next_string_or_null (_tmp44_);
	_tmp46_ = _tmp45_;
	zeitgeist_event_set_actor (self, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = event_props;
	if (_tmp47_ >= ((gsize) 6)) {
		GVariantIter* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		_tmp48_ = event_array;
		_tmp49_ = zeitgeist_next_string_or_null (_tmp48_);
		_tmp50_ = _tmp49_;
		zeitgeist_event_set_origin (self, _tmp50_);
		_g_free0 (_tmp50_);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp51_ = FALSE;
			_tmp51_ = TRUE;
			while (TRUE) {
				gint _tmp53_;
				GVariantIter* _tmp54_;
				gsize _tmp55_;
				GVariant* subject_variant = NULL;
				GVariantIter* _tmp56_;
				GVariant* _tmp57_;
				ZeitgeistSubject* _tmp58_ = NULL;
				GVariant* _tmp59_;
				ZeitgeistSubject* _tmp60_;
				GPtrArray* _tmp61_;
				ZeitgeistSubject* _tmp62_;
				if (!_tmp51_) {
					gint _tmp52_;
					_tmp52_ = i;
					i = _tmp52_ + 1;
				}
				_tmp51_ = FALSE;
				_tmp53_ = i;
				_tmp54_ = subjects_array;
				_tmp55_ = g_variant_iter_n_children (_tmp54_);
				if (!(((gsize) _tmp53_) < _tmp55_)) {
					break;
				}
				_tmp56_ = subjects_array;
				_tmp57_ = g_variant_iter_next_value (_tmp56_);
				subject_variant = _tmp57_;
				_tmp59_ = subject_variant;
				_tmp60_ = zeitgeist_subject_new_from_variant (_tmp59_, &_inner_error_);
				_tmp58_ = _tmp60_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						_g_object_unref0 (self);
						return NULL;
					} else {
						_g_variant_unref0 (subject_variant);
						_g_free0 (str_timestamp);
						_g_variant_unref0 (payload_variant);
						_g_variant_iter_free0 (subjects_array);
						_g_variant_iter_free0 (event_array);
						_g_variant_iter_free0 (iter);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp61_ = self->priv->_subjects;
				_tmp62_ = _tmp58_;
				_tmp58_ = NULL;
				g_ptr_array_add (_tmp61_, _tmp62_);
				_g_object_unref0 (_tmp58_);
				_g_variant_unref0 (subject_variant);
			}
		}
	}
	_tmp63_ = payload_variant;
	_tmp64_ = g_variant_n_children (_tmp63_);
	payload_length = (guint) _tmp64_;
	_tmp65_ = payload_length;
	if (_tmp65_ > ((guint) 0)) {
		guint _tmp66_;
		GByteArray* _tmp67_;
		GByteArray* _tmp68_;
		guint8* data = NULL;
		GVariant* _tmp69_;
		void* _tmp70_;
		gint data_length1;
		gint _data_size_;
		guint _tmp71_;
		gint _tmp72_;
		GByteArray* _tmp73_;
		guint8* _tmp74_;
		gint _tmp74__length1;
		_tmp66_ = payload_length;
		_tmp67_ = g_byte_array_sized_new (_tmp66_);
		_tmp68_ = _tmp67_;
		zeitgeist_event_set_payload (self, _tmp68_);
		_g_byte_array_unref0 (_tmp68_);
		_tmp69_ = payload_variant;
		_tmp70_ = g_variant_get_data (_tmp69_);
		data = (guint8*) _tmp70_;
		data_length1 = -1;
		_data_size_ = data_length1;
		_tmp71_ = payload_length;
		data_length1 = (gint) _tmp71_;
		_tmp72_ = data_length1;
		_tmp73_ = self->priv->_payload;
		_tmp74_ = data;
		_tmp74__length1 = data_length1;
		g_byte_array_append (_tmp73_, _tmp74_, _tmp74__length1);
	}
	_g_free0 (str_timestamp);
	_g_variant_unref0 (payload_variant);
	_g_variant_iter_free0 (subjects_array);
	_g_variant_iter_free0 (event_array);
	_g_variant_iter_free0 (iter);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new_from_variant (GVariant* event_variant, GError** error) {
	return zeitgeist_event_construct_from_variant (ZEITGEIST_TYPE_EVENT, event_variant, error);
}


void zeitgeist_event_set_actor_from_app_info (ZeitgeistEvent* self, GAppInfo* info) {
	GAppInfo* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info;
	_tmp1_ = g_app_info_get_id (_tmp0_);
	if (_tmp1_ != NULL) {
		GAppInfo* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = info;
		_tmp3_ = g_app_info_get_id (_tmp2_);
		_tmp4_ = g_strconcat ("application://", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		zeitgeist_event_set_actor (self, _tmp5_);
		_g_free0 (_tmp5_);
	} else {
		gchar* path = NULL;
		GAppInfo* _tmp6_;
		const gchar* _tmp11_;
		path = NULL;
		_tmp6_ = info;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, G_TYPE_DESKTOP_APP_INFO)) {
			GAppInfo* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = info;
			_tmp8_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp7_) : NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (path);
			path = _tmp10_;
		}
		_tmp11_ = path;
		if (_tmp11_ != NULL) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp12_ = path;
			_tmp13_ = g_path_get_basename (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("application://", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			zeitgeist_event_set_actor (self, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
		} else {
			GAppInfo* _tmp17_;
			const gchar* _tmp18_;
			_tmp17_ = info;
			_tmp18_ = g_app_info_get_name (_tmp17_);
			if (_tmp18_ != NULL) {
				GAppInfo* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp19_ = info;
				_tmp20_ = g_app_info_get_name (_tmp19_);
				_tmp21_ = g_strconcat ("application://", _tmp20_, NULL);
				_tmp22_ = _tmp21_;
				_tmp23_ = g_strconcat (_tmp22_, ".desktop", NULL);
				_tmp24_ = _tmp23_;
				zeitgeist_event_set_actor (self, _tmp24_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
			}
		}
		_g_free0 (path);
	}
}


static gpointer _g_byte_array_ref0 (gpointer self) {
	return self ? g_byte_array_ref (self) : NULL;
}


GVariant* zeitgeist_event_to_variant (ZeitgeistEvent* self) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	gchar* _tmp7_ = NULL;
	guint32 _tmp8_;
	GVariantBuilder* _tmp12_;
	gchar* _tmp13_ = NULL;
	gint64 _tmp14_;
	GVariantBuilder* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GVariantBuilder* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	GVariantBuilder* _tmp30_;
	const gchar* _tmp31_ = NULL;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	GVariantBuilder* _tmp36_;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_;
	GVariantBuilder* _tmp40_;
	GVariantBuilder* _tmp41_;
	GVariantBuilder* _tmp42_;
	GVariantType* _tmp43_;
	GVariantType* _tmp44_;
	GVariantBuilder* _tmp57_;
	GByteArray* _tmp58_;
	GVariant* event_variant = NULL;
	GVariantBuilder* _tmp73_;
	GVariant* _tmp74_;
	GVariant* _tmp75_;
	GVariant* _tmp76_;
	GVariant* _tmp77_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = vb;
	_tmp5_ = g_variant_type_new ("as");
	_tmp6_ = _tmp5_;
	g_variant_builder_open (_tmp4_, _tmp6_);
	_g_variant_type_free0 (_tmp6_);
	_tmp8_ = self->priv->_id;
	if (_tmp8_ == ((guint32) 0)) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp9_;
	} else {
		guint32 _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->_id;
		_tmp11_ = g_strdup_printf ("%u", _tmp10_);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = vb;
	g_variant_builder_add (_tmp12_, "s", _tmp7_, NULL);
	_tmp14_ = self->priv->_timestamp;
	if (_tmp14_ != ((gint64) 0)) {
		gint64 _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = self->priv->_timestamp;
		_tmp16_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp15_);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp16_;
	} else {
		gchar* _tmp17_;
		_tmp17_ = g_strdup ("");
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp17_;
	}
	_tmp18_ = vb;
	g_variant_builder_add (_tmp18_, "s", _tmp13_, NULL);
	_tmp20_ = zeitgeist_event_get_interpretation (self);
	_tmp21_ = _tmp20_;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		_tmp22_ = zeitgeist_event_get_interpretation (self);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_;
	} else {
		_tmp19_ = "";
	}
	_tmp24_ = vb;
	g_variant_builder_add (_tmp24_, "s", _tmp19_, NULL);
	_tmp26_ = zeitgeist_event_get_manifestation (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != NULL) {
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		_tmp28_ = zeitgeist_event_get_manifestation (self);
		_tmp29_ = _tmp28_;
		_tmp25_ = _tmp29_;
	} else {
		_tmp25_ = "";
	}
	_tmp30_ = vb;
	g_variant_builder_add (_tmp30_, "s", _tmp25_, NULL);
	_tmp32_ = zeitgeist_event_get_actor (self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = zeitgeist_event_get_actor (self);
		_tmp35_ = _tmp34_;
		_tmp31_ = _tmp35_;
	} else {
		_tmp31_ = "";
	}
	_tmp36_ = vb;
	g_variant_builder_add (_tmp36_, "s", _tmp31_, NULL);
	_tmp38_ = self->priv->_origin;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		_tmp39_ = self->priv->_origin;
		_tmp37_ = _tmp39_;
	} else {
		_tmp37_ = "";
	}
	_tmp40_ = vb;
	g_variant_builder_add (_tmp40_, "s", _tmp37_, NULL);
	_tmp41_ = vb;
	g_variant_builder_close (_tmp41_);
	_tmp42_ = vb;
	_tmp43_ = g_variant_type_new ("aas");
	_tmp44_ = _tmp43_;
	g_variant_builder_open (_tmp42_, _tmp44_);
	_g_variant_type_free0 (_tmp44_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				gint _tmp47_;
				GPtrArray* _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				GVariantBuilder* _tmp51_;
				GPtrArray* _tmp52_;
				gint _tmp53_;
				gconstpointer _tmp54_;
				GVariant* _tmp55_;
				GVariant* _tmp56_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp45_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->_subjects;
				_tmp49_ = g_ptr_array_get_length (_tmp48_);
				_tmp50_ = _tmp49_;
				if (!(_tmp47_ < _tmp50_)) {
					break;
				}
				_tmp51_ = vb;
				_tmp52_ = self->priv->_subjects;
				_tmp53_ = i;
				_tmp54_ = g_ptr_array_index (_tmp52_, (guint) _tmp53_);
				_tmp55_ = zeitgeist_subject_to_variant ((ZeitgeistSubject*) _tmp54_);
				_tmp56_ = _tmp55_;
				g_variant_builder_add_value (_tmp51_, _tmp56_);
				_g_variant_unref0 (_tmp56_);
			}
		}
	}
	_tmp57_ = vb;
	g_variant_builder_close (_tmp57_);
	_tmp58_ = self->priv->_payload;
	if (_tmp58_ != NULL) {
		GVariant* payload_variant = NULL;
		GVariantType* _tmp59_;
		GVariantType* _tmp60_;
		GByteArray* _tmp61_;
		guint8* _tmp62_;
		gint _tmp62__length1;
		GByteArray* _tmp63_;
		GByteArray* _tmp64_;
		GVariant* _tmp65_;
		GVariant* _tmp66_;
		GVariantBuilder* _tmp67_;
		GVariant* _tmp68_;
		_tmp59_ = g_variant_type_new ("ay");
		_tmp60_ = _tmp59_;
		_tmp61_ = self->priv->_payload;
		_tmp62_ = _tmp61_->data;
		_tmp62__length1 = (gint) _tmp61_->len;
		_tmp63_ = self->priv->_payload;
		_tmp64_ = _g_byte_array_ref0 (_tmp63_);
		_tmp65_ = g_variant_new_from_data (_tmp60_, _tmp62_, _tmp62__length1, FALSE, g_byte_array_unref, _tmp64_);
		g_variant_ref_sink (_tmp65_);
		_tmp66_ = _tmp65_;
		_g_variant_type_free0 (_tmp60_);
		payload_variant = _tmp66_;
		_tmp67_ = vb;
		_tmp68_ = payload_variant;
		g_variant_builder_add_value (_tmp67_, _tmp68_);
		_g_variant_unref0 (payload_variant);
	} else {
		GVariantBuilder* _tmp69_;
		GVariantType* _tmp70_;
		GVariantType* _tmp71_;
		GVariantBuilder* _tmp72_;
		_tmp69_ = vb;
		_tmp70_ = g_variant_type_new ("ay");
		_tmp71_ = _tmp70_;
		g_variant_builder_open (_tmp69_, _tmp71_);
		_g_variant_type_free0 (_tmp71_);
		_tmp72_ = vb;
		g_variant_builder_close (_tmp72_);
	}
	_tmp73_ = vb;
	_tmp74_ = g_variant_builder_end (_tmp73_);
	g_variant_ref_sink (_tmp74_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_variant_get_normal_form (_tmp75_);
	_tmp77_ = _tmp76_;
	_g_variant_unref0 (_tmp75_);
	event_variant = _tmp77_;
	result = event_variant;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp7_);
	_g_variant_builder_unref0 (vb);
	return result;
}


static GVariant* zeitgeist_event_optimize_variant_allocation (ZeitgeistEvent* self, GVariant* event_variant) {
	GVariant* result = NULL;
	guchar* data = NULL;
	GVariant* _tmp0_;
	gsize _tmp1_;
	guchar* _tmp2_;
	gint data_length1;
	gint _data_size_;
	GVariant* _tmp3_;
	guchar* _tmp4_;
	gint _tmp4__length1;
	guchar* data_copy = NULL;
	guchar* _tmp5_;
	gint _tmp5__length1;
	gint data_copy_length1;
	gint _data_copy_size_;
	GVariant* ret = NULL;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	guchar* _tmp8_;
	gint _tmp8__length1;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (event_variant != NULL, NULL);
	_tmp0_ = event_variant;
	_tmp1_ = g_variant_get_size (_tmp0_);
	_tmp2_ = g_new0 (guchar, _tmp1_);
	data = _tmp2_;
	data_length1 = _tmp1_;
	_data_size_ = data_length1;
	_tmp3_ = event_variant;
	_tmp4_ = data;
	_tmp4__length1 = data_length1;
	g_variant_store (_tmp3_, _tmp4_);
	_tmp5_ = data;
	_tmp5__length1 = data_length1;
	data_copy = _tmp5_;
	data_copy_length1 = _tmp5__length1;
	_data_copy_size_ = data_copy_length1;
	_tmp6_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp7_ = _tmp6_;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	data = NULL;
	data_length1 = 0;
	_tmp9_ = g_variant_new_from_data (_tmp7_, data_copy, data_copy_length1, TRUE, g_free, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_variant_type_free0 (_tmp7_);
	ret = _tmp10_;
	result = ret;
	data = (g_free (data), NULL);
	return result;
}


void zeitgeist_event_debug_print (ZeitgeistEvent* self) {
	FILE* _tmp0_;
	guint32 _tmp1_;
	gint64 _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GPtrArray* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GByteArray* _tmp52_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	_tmp1_ = self->priv->_id;
	_tmp2_ = self->priv->_timestamp;
	_tmp3_ = zeitgeist_event_get_actor (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_event_get_interpretation (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = zeitgeist_event_get_manifestation (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_origin;
	_tmp10_ = self->priv->_subjects;
	_tmp11_ = g_ptr_array_get_length (_tmp10_);
	_tmp12_ = _tmp11_;
	fprintf (_tmp0_, "id: %d\t" "timestamp: %" G_GINT64_FORMAT "\n" "actor: %s\n" "interpretation: %s\n" "manifestation: %s\n" "origin: %s\n" "num subjects: %d\n", _tmp1_, _tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_, _tmp12_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint _tmp15_;
				GPtrArray* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				ZeitgeistSubject* s = NULL;
				GPtrArray* _tmp19_;
				gint _tmp20_;
				gconstpointer _tmp21_;
				ZeitgeistSubject* _tmp22_;
				FILE* _tmp23_;
				gint _tmp24_;
				ZeitgeistSubject* _tmp25_;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				ZeitgeistSubject* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				ZeitgeistSubject* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				ZeitgeistSubject* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				ZeitgeistSubject* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				ZeitgeistSubject* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				ZeitgeistSubject* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				ZeitgeistSubject* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				ZeitgeistSubject* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				_tmp15_ = i;
				_tmp16_ = self->priv->_subjects;
				_tmp17_ = g_ptr_array_get_length (_tmp16_);
				_tmp18_ = _tmp17_;
				if (!(_tmp15_ < _tmp18_)) {
					break;
				}
				_tmp19_ = self->priv->_subjects;
				_tmp20_ = i;
				_tmp21_ = g_ptr_array_index (_tmp19_, (guint) _tmp20_);
				_tmp22_ = _g_object_ref0 ((ZeitgeistSubject*) _tmp21_);
				s = _tmp22_;
				_tmp23_ = stdout;
				_tmp24_ = i;
				_tmp25_ = s;
				_tmp26_ = zeitgeist_subject_get_uri (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = s;
				_tmp29_ = zeitgeist_subject_get_interpretation (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = s;
				_tmp32_ = zeitgeist_subject_get_manifestation (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = s;
				_tmp35_ = zeitgeist_subject_get_mimetype (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = s;
				_tmp38_ = zeitgeist_subject_get_origin (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = s;
				_tmp41_ = zeitgeist_subject_get_text (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = s;
				_tmp44_ = zeitgeist_subject_get_current_uri (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = s;
				_tmp47_ = zeitgeist_subject_get_current_origin (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = s;
				_tmp50_ = zeitgeist_subject_get_storage (_tmp49_);
				_tmp51_ = _tmp50_;
				fprintf (_tmp23_, "  Subject #%d:\n" "    uri: %s\n" "    interpretation: %s\n" "    manifestation: %s\n" "    mimetype: %s\n" "    origin: %s\n" "    text: %s\n" "    current_uri: %s\n" "    current_origin: %s\n" "    storage: %s\n", _tmp24_, _tmp27_, _tmp30_, _tmp33_, _tmp36_, _tmp39_, _tmp42_, _tmp45_, _tmp48_, _tmp51_);
				_g_object_unref0 (s);
			}
		}
	}
	_tmp52_ = self->priv->_payload;
	if (_tmp52_ != NULL) {
		FILE* _tmp53_;
		GByteArray* _tmp54_;
		guint _tmp55_;
		_tmp53_ = stdout;
		_tmp54_ = self->priv->_payload;
		_tmp55_ = _tmp54_->len;
		fprintf (_tmp53_, "payload: %u bytes", _tmp55_);
	} else {
		FILE* _tmp56_;
		_tmp56_ = stdout;
		fprintf (_tmp56_, "payload: (null)\n");
	}
}


gboolean zeitgeist_event_matches_template (ZeitgeistEvent* self, ZeitgeistEvent* template_event) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	ZeitgeistEvent* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ZeitgeistEvent* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ZeitgeistEvent* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean _tmp17_;
	const gchar* _tmp18_;
	ZeitgeistEvent* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	ZeitgeistEvent* _tmp22_;
	GPtrArray* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (template_event != NULL, FALSE);
	_tmp0_ = zeitgeist_event_get_interpretation (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = template_event;
	_tmp3_ = zeitgeist_event_get_interpretation (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = zeitgeist_check_field_match (_tmp1_, _tmp4_, TRUE, FALSE);
	if (!_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = zeitgeist_event_get_manifestation (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = template_event;
	_tmp9_ = zeitgeist_event_get_manifestation (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = zeitgeist_check_field_match (_tmp7_, _tmp10_, TRUE, FALSE);
	if (!_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = zeitgeist_event_get_actor (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = template_event;
	_tmp15_ = zeitgeist_event_get_actor (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = zeitgeist_check_field_match (_tmp13_, _tmp16_, FALSE, TRUE);
	if (!_tmp17_) {
		result = FALSE;
		return result;
	}
	_tmp18_ = self->priv->_origin;
	_tmp19_ = template_event;
	_tmp20_ = _tmp19_->priv->_origin;
	_tmp21_ = zeitgeist_check_field_match (_tmp18_, _tmp20_, FALSE, TRUE);
	if (!_tmp21_) {
		result = FALSE;
		return result;
	}
	_tmp22_ = template_event;
	_tmp23_ = _tmp22_->priv->_subjects;
	_tmp24_ = g_ptr_array_get_length (_tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				gint _tmp28_;
				GPtrArray* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = i;
					i = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = i;
				_tmp29_ = self->priv->_subjects;
				_tmp30_ = g_ptr_array_get_length (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!(_tmp28_ < _tmp31_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							gint _tmp34_;
							ZeitgeistEvent* _tmp35_;
							GPtrArray* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							GPtrArray* _tmp39_;
							gint _tmp40_;
							gconstpointer _tmp41_;
							ZeitgeistEvent* _tmp42_;
							GPtrArray* _tmp43_;
							gint _tmp44_;
							gconstpointer _tmp45_;
							gboolean _tmp46_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = j;
								j = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = j;
							_tmp35_ = template_event;
							_tmp36_ = _tmp35_->priv->_subjects;
							_tmp37_ = g_ptr_array_get_length (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(_tmp34_ < _tmp38_)) {
								break;
							}
							_tmp39_ = self->priv->_subjects;
							_tmp40_ = i;
							_tmp41_ = g_ptr_array_index (_tmp39_, (guint) _tmp40_);
							_tmp42_ = template_event;
							_tmp43_ = _tmp42_->priv->_subjects;
							_tmp44_ = j;
							_tmp45_ = g_ptr_array_index (_tmp43_, (guint) _tmp44_);
							_tmp46_ = zeitgeist_subject_matches_template ((ZeitgeistSubject*) _tmp41_, (ZeitgeistSubject*) _tmp45_);
							if (_tmp46_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


ZeitgeistEvent* zeitgeist_event_construct (GType object_type) {
	ZeitgeistEvent * self = NULL;
	self = (ZeitgeistEvent*) g_object_new (object_type, NULL);
	return self;
}


ZeitgeistEvent* zeitgeist_event_new (void) {
	return zeitgeist_event_construct (ZEITGEIST_TYPE_EVENT);
}


guint32 zeitgeist_event_get_id (ZeitgeistEvent* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_id (ZeitgeistEvent* self, guint32 value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_event_get_id (self) != value) {
		guint32 _tmp0_;
		_tmp0_ = value;
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ID_PROPERTY]);
	}
}


gint64 zeitgeist_event_get_timestamp (ZeitgeistEvent* self) {
	gint64 result;
	gint64 _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = self->priv->_timestamp;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_timestamp (ZeitgeistEvent* self, gint64 value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_event_get_timestamp (self) != value) {
		gint64 _tmp0_;
		_tmp0_ = value;
		self->priv->_timestamp = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_TIMESTAMP_PROPERTY]);
	}
}


const gchar* zeitgeist_event_get_origin (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_origin;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_origin (ZeitgeistEvent* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, zeitgeist_event_get_origin (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_origin);
		self->priv->_origin = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ORIGIN_PROPERTY]);
	}
}


const gchar* zeitgeist_event_get_actor (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_actor (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_actor = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_ACTOR_PROPERTY]);
}


const gchar* zeitgeist_event_get_interpretation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_interpretation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_interpretation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_interpretation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_INTERPRETATION_PROPERTY]);
}


const gchar* zeitgeist_event_get_manifestation (ZeitgeistEvent* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_manifestation;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_manifestation (ZeitgeistEvent* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		GStringChunk* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = zeitgeist_event_url_store;
		_tmp3_ = value;
		_tmp4_ = g_string_chunk_insert_const (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	self->priv->_manifestation = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_MANIFESTATION_PROPERTY]);
}


GPtrArray* zeitgeist_event_get_subjects (ZeitgeistEvent* self) {
	GPtrArray* result;
	GPtrArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_subjects;
	result = _tmp0_;
	return result;
}


static gpointer _g_ptr_array_ref0 (gpointer self) {
	return self ? g_ptr_array_ref (self) : NULL;
}


void zeitgeist_event_set_subjects (ZeitgeistEvent* self, GPtrArray* value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_event_get_subjects (self) != value) {
		GPtrArray* _tmp0_;
		GPtrArray* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_ptr_array_ref0 (_tmp0_);
		_g_ptr_array_unref0 (self->priv->_subjects);
		self->priv->_subjects = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_SUBJECTS_PROPERTY]);
	}
}


GByteArray* zeitgeist_event_get_payload (ZeitgeistEvent* self) {
	GByteArray* result;
	GByteArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_payload;
	result = _tmp0_;
	return result;
}


void zeitgeist_event_set_payload (ZeitgeistEvent* self, GByteArray* value) {
	g_return_if_fail (self != NULL);
	if (zeitgeist_event_get_payload (self) != value) {
		GByteArray* _tmp0_;
		GByteArray* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_byte_array_ref0 (_tmp0_);
		_g_byte_array_unref0 (self->priv->_payload);
		self->priv->_payload = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, zeitgeist_event_properties[ZEITGEIST_EVENT_PAYLOAD_PROPERTY]);
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static GObject * zeitgeist_event_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistEvent * self;
	GPtrArray* _tmp0_;
	GPtrArray* _tmp1_;
	parent_class = G_OBJECT_CLASS (zeitgeist_event_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp1_ = _tmp0_;
	zeitgeist_event_set_subjects (self, _tmp1_);
	_g_ptr_array_unref0 (_tmp1_);
	return obj;
}


static void zeitgeist_event_class_init (ZeitgeistEventClass * klass) {
	GStringChunk* _tmp0_;
	zeitgeist_event_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ZeitgeistEventPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_zeitgeist_event_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_zeitgeist_event_set_property;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_event_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_event_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ID_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_TIMESTAMP_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_TIMESTAMP_PROPERTY] = g_param_spec_int64 ("timestamp", "timestamp", "timestamp", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ORIGIN_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ORIGIN_PROPERTY] = g_param_spec_string ("origin", "origin", "origin", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_ACTOR_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_ACTOR_PROPERTY] = g_param_spec_string ("actor", "actor", "actor", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_INTERPRETATION_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_INTERPRETATION_PROPERTY] = g_param_spec_string ("interpretation", "interpretation", "interpretation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_MANIFESTATION_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_MANIFESTATION_PROPERTY] = g_param_spec_string ("manifestation", "manifestation", "manifestation", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_SUBJECTS_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_SUBJECTS_PROPERTY] = g_param_spec_boxed ("subjects", "subjects", "subjects", G_TYPE_PTR_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZEITGEIST_EVENT_PAYLOAD_PROPERTY, zeitgeist_event_properties[ZEITGEIST_EVENT_PAYLOAD_PROPERTY] = g_param_spec_boxed ("payload", "payload", "payload", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_string_chunk_new ((gsize) 4096);
	_g_string_chunk_free0 (zeitgeist_event_url_store);
	zeitgeist_event_url_store = _tmp0_;
}


static void zeitgeist_event_instance_init (ZeitgeistEvent * self) {
	self->priv = ZEITGEIST_EVENT_GET_PRIVATE (self);
}


static void zeitgeist_event_finalize (GObject * obj) {
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	_g_free0 (self->priv->_origin);
	_g_ptr_array_unref0 (self->priv->_subjects);
	_g_byte_array_unref0 (self->priv->_payload);
	G_OBJECT_CLASS (zeitgeist_event_parent_class)->finalize (obj);
}


/**
 * Event objects abstract Zeitgeist events
 *
 * The Event class is one of the primary elements for communicating
 * with the Zeitgeist daemon. Events serve two purposes
 * Unsurprisingly, they represent events that have happened, but they
 * can also act as templates. See also {@link Subject}.
 *
 * An event in the Zeitgeist world is characterized by two main
 * properties. "What happened", also called the interpretation, and
 * "How did it happen", also called the manifestation. Besides these
 * properties, an event also has an actor which identifies the party
 * responsible for triggering the event which in most cases will be
 * an application. Lastly there is an event timestamp and an event ID.
 * The timestamp is calculated as the number of milliseconds since the
 * Unix epoch and the event ID is a number assigned to the event by
 * the Zeitgeist engine when it's logged. These five properties are
 * collectively known as the event metadata.
 *
 * An event must also describe what it happened to. For this we have
 * event subjects. Most events have one subject, but they may also
 * have more. The metadata of the subjects are recorded at the time
 * of logging, and are encapsulated by the #Subject class. It's
 * important to understand that it's just the subject metadata at the
 * time of logging, not necessarily the subject metadata as it exists
 * right now.
 *
 * In addition to the listed properties, events may also carry a free
 * form binary payload. The usage of this is application specific and
 * is generally useless unless you have some contextual information to
 * figure out what's in it.
 *
 * A large part of the Zeitgeist query and monitoring API revolves
 * around a concept of template matching. A query is simply a list of
 * event templates that you want to look for in the log. An unset
 * property on an event template indicates that anything is allowed in
 * that field. If the property is set it indicates that the property
 * must be an exact match, unless a special operator is used.
 */
GType zeitgeist_event_get_type (void) {
	static volatile gsize zeitgeist_event_type_id__volatile = 0;
	if (g_once_init_enter (&zeitgeist_event_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistEventClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_event_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistEvent), 0, (GInstanceInitFunc) zeitgeist_event_instance_init, NULL };
		GType zeitgeist_event_type_id;
		zeitgeist_event_type_id = g_type_register_static (G_TYPE_OBJECT, "ZeitgeistEvent", &g_define_type_info, 0);
		g_once_init_leave (&zeitgeist_event_type_id__volatile, zeitgeist_event_type_id);
	}
	return zeitgeist_event_type_id__volatile;
}


static void _vala_zeitgeist_event_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID_PROPERTY:
		g_value_set_uint (value, zeitgeist_event_get_id (self));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP_PROPERTY:
		g_value_set_int64 (value, zeitgeist_event_get_timestamp (self));
		break;
		case ZEITGEIST_EVENT_ORIGIN_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_origin (self));
		break;
		case ZEITGEIST_EVENT_ACTOR_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_actor (self));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_interpretation (self));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION_PROPERTY:
		g_value_set_string (value, zeitgeist_event_get_manifestation (self));
		break;
		case ZEITGEIST_EVENT_SUBJECTS_PROPERTY:
		g_value_set_boxed (value, zeitgeist_event_get_subjects (self));
		break;
		case ZEITGEIST_EVENT_PAYLOAD_PROPERTY:
		g_value_set_boxed (value, zeitgeist_event_get_payload (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_zeitgeist_event_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ZeitgeistEvent * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZEITGEIST_TYPE_EVENT, ZeitgeistEvent);
	switch (property_id) {
		case ZEITGEIST_EVENT_ID_PROPERTY:
		zeitgeist_event_set_id (self, g_value_get_uint (value));
		break;
		case ZEITGEIST_EVENT_TIMESTAMP_PROPERTY:
		zeitgeist_event_set_timestamp (self, g_value_get_int64 (value));
		break;
		case ZEITGEIST_EVENT_ORIGIN_PROPERTY:
		zeitgeist_event_set_origin (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_ACTOR_PROPERTY:
		zeitgeist_event_set_actor (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_INTERPRETATION_PROPERTY:
		zeitgeist_event_set_interpretation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_MANIFESTATION_PROPERTY:
		zeitgeist_event_set_manifestation (self, g_value_get_string (value));
		break;
		case ZEITGEIST_EVENT_SUBJECTS_PROPERTY:
		zeitgeist_event_set_subjects (self, g_value_get_boxed (value));
		break;
		case ZEITGEIST_EVENT_PAYLOAD_PROPERTY:
		zeitgeist_event_set_payload (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


GPtrArray* zeitgeist_events_from_variant (GVariant* vevents, GError** error) {
	GPtrArray* result = NULL;
	GPtrArray* events = NULL;
	GPtrArray* _tmp0_;
	GVariant* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (vevents != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	events = _tmp0_;
	_tmp1_ = vevents;
	_tmp2_ = g_variant_get_type_string (_tmp1_);
	_vala_assert (g_strcmp0 (_tmp2_, "a(" ZEITGEIST_UTILS_SIG_EVENT ")") == 0, "vevents.get_type_string () == \"a(\"+Utils.SIG_EVENT+\")\"");
	{
		GVariantIter* _vevent_it = NULL;
		GVariant* _tmp3_;
		GVariantIter* _tmp4_;
		GVariant* vevent = NULL;
		_tmp3_ = vevents;
		_tmp4_ = g_variant_iter_new (_tmp3_);
		_vevent_it = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GVariant* _tmp6_;
			GVariant* _tmp7_;
			ZeitgeistEvent* event = NULL;
			GPtrArray* _tmp15_;
			ZeitgeistEvent* _tmp16_;
			ZeitgeistEvent* _tmp17_;
			_tmp5_ = _vevent_it;
			_tmp6_ = g_variant_iter_next_value (_tmp5_);
			_g_variant_unref0 (vevent);
			vevent = _tmp6_;
			_tmp7_ = vevent;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			event = NULL;
			{
				ZeitgeistEvent* _tmp8_ = NULL;
				GVariant* _tmp9_;
				ZeitgeistEvent* _tmp10_;
				ZeitgeistEvent* _tmp11_;
				_tmp9_ = vevent;
				_tmp10_ = zeitgeist_event_new_from_variant (_tmp9_, &_inner_error_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						goto __catch2_zeitgeist_data_model_error;
					}
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_object_unref0 (event);
				event = _tmp11_;
				_g_object_unref0 (_tmp8_);
			}
			goto __finally2;
			__catch2_zeitgeist_data_model_error:
			{
				GError* err = NULL;
				GError* _tmp12_;
				err = _inner_error_;
				_inner_error_ = NULL;
				_tmp12_ = err;
				if (!g_error_matches (_tmp12_, ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_NULL_EVENT)) {
					GError* _tmp13_;
					GError* _tmp14_;
					_tmp13_ = err;
					_tmp14_ = _g_error_copy0 (_tmp13_);
					_inner_error_ = _tmp14_;
					_g_error_free0 (err);
					goto __finally2;
				}
				_g_error_free0 (err);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					return NULL;
				} else {
					_g_object_unref0 (event);
					_g_variant_unref0 (vevent);
					_g_variant_iter_free0 (_vevent_it);
					_g_ptr_array_unref0 (events);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp15_ = events;
			_tmp16_ = event;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			g_ptr_array_add (_tmp15_, _tmp17_);
			_g_object_unref0 (event);
		}
		_g_variant_unref0 (vevent);
		_g_variant_iter_free0 (_vevent_it);
	}
	result = events;
	return result;
}


GVariant* zeitgeist_events_to_variant (GPtrArray* events) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* _tmp22_;
	GVariant* _tmp23_;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = events;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = events;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				if (((ZeitgeistEvent*) _tmp12_) != NULL) {
					GVariantBuilder* _tmp13_;
					GPtrArray* _tmp14_;
					gint _tmp15_;
					gconstpointer _tmp16_;
					GVariant* _tmp17_;
					GVariant* _tmp18_;
					_tmp13_ = vb;
					_tmp14_ = events;
					_tmp15_ = i;
					_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
					_tmp17_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp16_);
					_tmp18_ = _tmp17_;
					g_variant_builder_add_value (_tmp13_, _tmp18_);
					_g_variant_unref0 (_tmp18_);
				} else {
					GVariantBuilder* _tmp19_;
					GVariant* _tmp20_;
					GVariant* _tmp21_;
					_tmp19_ = vb;
					_tmp20_ = zeitgeist_events_get_null_event_variant ();
					_tmp21_ = _tmp20_;
					g_variant_builder_add_value (_tmp19_, _tmp21_);
					_g_variant_unref0 (_tmp21_);
				}
			}
		}
	}
	_tmp22_ = vb;
	_tmp23_ = g_variant_builder_end (_tmp22_);
	g_variant_ref_sink (_tmp23_);
	result = _tmp23_;
	_g_variant_builder_unref0 (vb);
	return result;
}


GVariant* zeitgeist_events_to_variant_with_limit (GPtrArray* events, gsize limit, GError** error) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	gsize variant_size = 0UL;
	GVariantBuilder* _tmp34_;
	GVariant* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (events != NULL, NULL);
	_tmp0_ = g_variant_type_new ("a(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	variant_size = (gsize) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				GPtrArray* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GVariant* event_variant = NULL;
				GPtrArray* _tmp10_;
				gint _tmp11_;
				gconstpointer _tmp12_;
				gsize _tmp18_;
				GVariant* _tmp19_;
				gsize _tmp20_;
				gsize _tmp21_;
				gsize _tmp22_;
				GVariantBuilder* _tmp32_;
				GVariant* _tmp33_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = events;
				_tmp8_ = g_ptr_array_get_length (_tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = events;
				_tmp11_ = i;
				_tmp12_ = g_ptr_array_index (_tmp10_, (guint) _tmp11_);
				if (((ZeitgeistEvent*) _tmp12_) != NULL) {
					GPtrArray* _tmp13_;
					gint _tmp14_;
					gconstpointer _tmp15_;
					GVariant* _tmp16_;
					_tmp13_ = events;
					_tmp14_ = i;
					_tmp15_ = g_ptr_array_index (_tmp13_, (guint) _tmp14_);
					_tmp16_ = zeitgeist_event_to_variant ((ZeitgeistEvent*) _tmp15_);
					_g_variant_unref0 (event_variant);
					event_variant = _tmp16_;
				} else {
					GVariant* _tmp17_;
					_tmp17_ = zeitgeist_events_get_null_event_variant ();
					_g_variant_unref0 (event_variant);
					event_variant = _tmp17_;
				}
				_tmp18_ = variant_size;
				_tmp19_ = event_variant;
				_tmp20_ = g_variant_get_size (_tmp19_);
				variant_size = _tmp18_ + _tmp20_;
				_tmp21_ = variant_size;
				_tmp22_ = limit;
				if (_tmp21_ > _tmp22_) {
					gsize avg_event_size = 0UL;
					gsize _tmp23_;
					gint _tmp24_;
					gchar* error_message = NULL;
					gsize _tmp25_;
					gsize _tmp26_;
					gsize _tmp27_;
					gchar* _tmp28_;
					const gchar* _tmp29_;
					const gchar* _tmp30_;
					GError* _tmp31_;
					_tmp23_ = variant_size;
					_tmp24_ = i;
					avg_event_size = _tmp23_ / (_tmp24_ + 1);
					_tmp25_ = limit;
					_tmp26_ = limit;
					_tmp27_ = avg_event_size;
					_tmp28_ = g_strdup_printf ("Query exceeded size limit of % " G_GSIZE_FORMAT "MiB (roughly ~%d events).", (_tmp25_ / 1024) / 1024, _tmp26_ / _tmp27_);
					error_message = _tmp28_;
					_tmp29_ = error_message;
					g_warning ("event.vala:461: %s", _tmp29_);
					_tmp30_ = error_message;
					_tmp31_ = g_error_new_literal (ZEITGEIST_DATA_MODEL_ERROR, ZEITGEIST_DATA_MODEL_ERROR_TOO_MANY_RESULTS, _tmp30_);
					_inner_error_ = _tmp31_;
					if (_inner_error_->domain == ZEITGEIST_DATA_MODEL_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						return NULL;
					} else {
						_g_free0 (error_message);
						_g_variant_unref0 (event_variant);
						_g_variant_builder_unref0 (vb);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_g_free0 (error_message);
				}
				_tmp32_ = vb;
				_tmp33_ = event_variant;
				g_variant_builder_add_value (_tmp32_, _tmp33_);
				_g_variant_unref0 (event_variant);
			}
		}
	}
	_tmp34_ = vb;
	_tmp35_ = g_variant_builder_end (_tmp34_);
	g_variant_ref_sink (_tmp35_);
	result = _tmp35_;
	_g_variant_builder_unref0 (vb);
	return result;
}


GVariant* zeitgeist_events_get_null_event_variant (void) {
	GVariant* result = NULL;
	GVariantBuilder* vb = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantType* _tmp6_;
	GVariantType* _tmp7_;
	GVariantType* _tmp8_;
	GVariantType* _tmp9_;
	GVariant* _tmp10_;
	_tmp0_ = g_variant_type_new ("(" ZEITGEIST_UTILS_SIG_EVENT ")");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	vb = _tmp3_;
	_tmp4_ = g_variant_type_new ("as");
	_tmp5_ = _tmp4_;
	g_variant_builder_open (vb, _tmp5_);
	_g_variant_type_free0 (_tmp5_);
	g_variant_builder_close (vb);
	_tmp6_ = g_variant_type_new ("aas");
	_tmp7_ = _tmp6_;
	g_variant_builder_open (vb, _tmp7_);
	_g_variant_type_free0 (_tmp7_);
	g_variant_builder_close (vb);
	_tmp8_ = g_variant_type_new ("ay");
	_tmp9_ = _tmp8_;
	g_variant_builder_open (vb, _tmp9_);
	_g_variant_type_free0 (_tmp9_);
	g_variant_builder_close (vb);
	_tmp10_ = g_variant_builder_end (vb);
	g_variant_ref_sink (_tmp10_);
	result = _tmp10_;
	_g_variant_builder_unref0 (vb);
	return result;
}



