//    This is part of the iostream library, providing input/output for C++.
//    Copyright (C) 1991 Per Bothner.
//
//    This library is free software; you can redistribute it and/or
//    modify it under the terms of the GNU Library General Public
//    License as published by the Free Software Foundation; either
//    version 2 of the License, or (at your option) any later version.
//
//    This library is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//    Library General Public License for more details.
//
//    You should have received a copy of the GNU Library General Public
//    License along with this library; if not, write to the Free
//    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "iostream.h"

istream& istream::getline(char* buf, int len, char delim = '\n')
{
    if (ipfx1()) {
	long count = rdbuf()->sgetline(buf, len, delim, 0);
	if (count < 0) {
	    clear(rdstate()|ios::failbit);
	    _gcount = 0;
	}
	else
	    _gcount = count;
    }
    return *this;
}

istream& istream::get(char* buf, int len, char delim = '\n')
{
    if (ipfx1()) {
	long count = rdbuf()->sgetline(buf, len, delim, -1);
	if (count < 0) {
	    clear(rdstate()|ios::failbit);
	    _gcount = 0;
	}
	else
	    _gcount = count;
    }
    return *this;
}

