/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libepubgen project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_LIBEPUBGEN_UTILS_H
#define INCLUDED_LIBEPUBGEN_UTILS_H

#ifdef DEBUG
#include <cstdio>
#endif

#include <boost/shared_ptr.hpp>

#include <librevenge-stream/librevenge-stream.h>

#ifdef _MSC_VER

typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned uint32_t;
typedef int int32_t;
typedef unsigned __int64 uint64_t;
typedef __int64 int64_t;

#else

#ifdef HAVE_CONFIG_H

#include "config.h"

#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#else

// assume that the headers are there inside LibreOffice build when no HAVE_CONFIG_H is defined
#include <stdint.h>
#include <inttypes.h>

#endif

#endif

// debug message includes source file and line number
//#define VERBOSE_DEBUG 1

// do nothing with debug messages in a release compile
#ifdef DEBUG
#ifdef VERBOSE_DEBUG
#define EPUBGEN_DEBUG_MSG(M) std::printf("%15s:%5d: ", __FILE__, __LINE__); std::printf M
#define EPUBGEN_DEBUG(M) M
#else
#define EPUBGEN_DEBUG_MSG(M) std::printf M
#define EPUBGEN_DEBUG(M) M
#endif
#else
#define EPUBGEN_DEBUG_MSG(M)
#define EPUBGEN_DEBUG(M)
#endif

#define EPUBGEN_NUM_ELEMENTS(array) (sizeof(array) / sizeof(array[0]))

namespace libepubgen
{

typedef boost::shared_ptr<librevenge::RVNGInputStream> RVNGInputStreamPtr_t;

struct EPUBGENDummyDeleter
{
  void operator()(void *) {}
};

class GenericException
{
};

} // namespace libepubgen

#endif // INCLUDED_LIBEPUBGEN_UTILS_H

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
