
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file BoxPlotWhiskerLineAttributes.h
    \\brief Definition of BoxPlotWhiskerLine Attributes class.

    This file is automatically generated.
    Do Not Edit!

*/

#include "MagRequest.h"
#include "BoxPlotWhiskerLineWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"
#include "MagicsGlobal.h"

using namespace magics;



BoxPlotWhiskerLineWrapper::BoxPlotWhiskerLineWrapper(): boxplotwhiskerline_(new BoxPlotWhiskerLine())


{


	

}
BoxPlotWhiskerLineWrapper::BoxPlotWhiskerLineWrapper(BoxPlotWhiskerLine* boxplotwhiskerline): boxplotwhiskerline_(boxplotwhiskerline)
{

	
}

BoxPlotWhiskerLineWrapper::~BoxPlotWhiskerLineWrapper()
{

}

void BoxPlotWhiskerLineWrapper::set(const MagRequest& request)
{

	

	if  (request.countValues("BOXPLOT_WHISKER_LINE_THICKNESS") ) {
		int thickness_value = request("BOXPLOT_WHISKER_LINE_THICKNESS");
		boxplotwhiskerline_->thickness_ = thickness_value;
		}
	
	if  (request.countValues("BOXPLOT_WHISKER_LINE_COLOUR") ) {
		string colour_value = request("BOXPLOT_WHISKER_LINE_COLOUR");
		boxplotwhiskerline_->colour_ = unique_ptr<Colour>(MagTranslator<string, Colour>()(colour_value));
	}
		
	
	if  (request.countValues("BOXPLOT_WHISKER_LINE_STYLE") ) {
		string style_value = request("BOXPLOT_WHISKER_LINE_STYLE");
		boxplotwhiskerline_->style_ = MagTranslator<string, LineStyle>()(style_value);
	}
		
	
}

void BoxPlotWhiskerLineWrapper::print(ostream& out)  const
{
	out << "BoxPlotWhiskerLineWrapper[]";
}




