/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var defineProperty = require( './../../define-property' );
var tic = require( '@stdlib/time/tic' );
var toc = require( '@stdlib/time/toc' );


// MAIN //

/**
* Returns a context.
*
* @private
* @param {Callback} done - callback to be invoked within snippet execution context
* @returns {Object} context
*/
function context( done ) {
	var ctx = {};

	defineProperty( ctx, 'tic', {
		'configurable': false,
		'enumerable': false,
		'writable': false,
		'value': tic
	});
	defineProperty( ctx, 'toc', {
		'configurable': false,
		'enumerable': false,
		'writable': false,
		'value': toc
	});
	defineProperty( ctx, 'done', {
		'configurable': false,
		'enumerable': false,
		'writable': false,
		'value': done
	});
	return {
		'tic': tic,
		'toc': toc,
		'done': done
	};
}


// EXPORTS //

module.exports = context;
