# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql.aio import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementVirtualNetworkRulesOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.virtual_network_rules.get(
            resource_group_name=resource_group.name,
            server_name="str",
            virtual_network_rule_name="str",
            api_version="2020-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_network_rules.begin_create_or_update(
                resource_group_name=resource_group.name,
                server_name="str",
                virtual_network_rule_name="str",
                parameters={
                    "id": "str",
                    "ignoreMissingVnetServiceEndpoint": bool,
                    "name": "str",
                    "state": "str",
                    "type": "str",
                    "virtualNetworkSubnetId": "str",
                },
                api_version="2020-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_network_rules.begin_delete(
                resource_group_name=resource_group.name,
                server_name="str",
                virtual_network_rule_name="str",
                api_version="2020-11-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_server(self, resource_group):
        response = self.client.virtual_network_rules.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2020-11-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
