# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionsRequired(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Any action that is required beyond basic workflow (approve/ reject/ disconnect)."""

    NONE = "None"
    RECREATE = "Recreate"


class AuthenticationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data plane proxy authentication mode. This property manages the authentication mode of
    request to the data plane resources.
    """

    LOCAL = "Local"
    """The local authentication mode. Users are not required to have data plane permissions if local
    authentication is not disabled."""
    PASS_THROUGH = "Pass-through"
    """The pass-through authentication mode. User identity will be passed through from ARM, requiring
    user to have data plane action permissions (Available via App Configuration Data Owner/ App
    Configuration Data Reader)."""


class CompositionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The composition type describes how the key-values within the snapshot are composed. The 'key'
    composition type ensures there are no two key-values containing the same key. The 'key_label'
    composition type ensures there are no two key-values containing the same key and label.
    """

    KEY = "Key"
    KEY_LABEL = "Key_Label"


class ConfigurationResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The resource type to check for name availability."""

    MICROSOFT_APP_CONFIGURATION_CONFIGURATION_STORES = "Microsoft.AppConfiguration/configurationStores"


class ConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private link service connection status."""

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the configuration store need to be recovered."""

    RECOVER = "Recover"
    DEFAULT = "Default"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes both an
    implicitly created identity and a set of user-assigned identities. The type 'None' will remove
    any identities.
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"


class PrivateLinkDelegation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data plane proxy private link delegation. This property manages if a request from delegated
    ARM private link is allowed when the data plane resource requires private link.
    """

    ENABLED = "Enabled"
    """ARM private endpoint is required if the resource requires private link."""
    DISABLED = "Disabled"
    """Request is denied if the resource requires private link."""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the configuration store."""

    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Control permission for data plane traffic coming from public networks while private endpoint is
    enabled.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ReplicaProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the replica."""

    CREATING = "Creating"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    FAILED = "Failed"
    CANCELED = "Canceled"


class SnapshotStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the snapshot."""

    PROVISIONING = "Provisioning"
    READY = "Ready"
    ARCHIVED = "Archived"
    FAILED = "Failed"
